PROGRAM ClkDemo;

 {This PROGRAM demonstates how to use the CLOCKS UNIT, including a
  clock object, its methods, and related FUNCTIONs and PROCEDUREs.
  Differences between CMOS and DOS clocks are shown.

  (C) Copyright 1989, Earl F. Glynn, Overland Park, KS.  Compuserve 73257,3527.
  All Rights Reserved.  This Turbo Pascal 5.5 PROGRAM may be freely distributed
  for non-commerical use.

  Several of the examples were derived from "The REXX Language" by
  M.F. Cowlishaw, Prentice Hall, 1985.}

  USES
    Clocks,
    DOS;    {FindFirst,FindNext,SearchRec,AnyFile,DOSError}

  VAR
    Clk1,Clk2,Clk3:  Clock;       {clock objects -- real time clocks}
    stamp1,stamp2 :  ClockValue;  {static clocks -- time stamps}
    stamp3,stamp4 :  ClockValue;
    stamp5        :  ClockValue;
    DirInfo       :  SearchRec;

  PROCEDURE ShowClocks;
  BEGIN
    Clk2.Start (CMOSClock);
    Clk3.Start (DOSClock);
    WRITELN ('  CMOS Clock:  ',Clk2.date('u'),' ',Clk2.time('N') );
    WRITELN ('   DOS Clock:  ',Clk3.date('u'),' ',Clk3.time('L') );
    WRITELN ('  Difference:  ',TimeDiff(Clk2.StartValue,Clk3.StartValue):8:2,
             ' second(s)');
  END {ShowClocks};

  PROCEDURE DisableInterrupts;
    INLINE ($FA);

  PROCEDURE EnableInterrupts;
    INLINE ($FB);

  PROCEDURE KillTime;
    {The following could be used for a 5-second delay, but it re-enables
     interrupts when they are disabled:

        WHILE clk1.elapsed < 5.0 DO (* nothing *);

     So,time will be wasted with a few calculations.}

    VAR
      i:  WORD;
      x:  REAL;
  BEGIN
    WRITELN ('''Kill'' some time ...');
    FOR i := 1 TO 10000 DO
      x := SQRT(i)
  END;

BEGIN
  Clk1.Start (CMOSClock);
  WRITELN ('CMOS/DOS Clock Differences');
  WRITELN ('--------------------------');
  WRITELN ('Start Clocks');
  ShowClocks;
  KillTime;
  ShowClocks;
  WRITELN ('Disable Interrupts (DOS clock will stop):');
  DisableInterrupts;
  KillTime;
  ShowClocks;
  WRITELN ('Enable Interrupts');
  EnableInterrupts;

  SetClock (1985,8,27, 16,54,22, 12, stamp1);  {These are not real-time clocks.}
  SetClock (1900,1, 1,  0, 0, 0,  0, stamp2);
  SetClock (2079,6, 5, 23,59,59, 99, stamp3);

  WRITELN ('Cowlishaw''s':52);
  WRITELN ('now':39,'REXX Book':13,'First':13,'Last':13);
  WRITELN ('Date/DateFormat Examples');
  WRITELN ('------------------------');
  WRITELN ('day this century - C':26,Clk2.Date('Century'):13,
    DateFormat('C',stamp1):13, DateFormat('C',stamp2):13,
    DateFormat('C',stamp3):13);
  WRITELN ('day this year - D':26,   Clk2.Date('Days'):13,
    DateFormat('D',stamp1):13, DateFormat('D',stamp2):13,
    DateFormat('D',stamp3):13);
  WRITELN ('dd/mm/yy - E':26,        Clk2.Date('European'):13,
    DateFormat('E',stamp1):13, DateFormat('E',stamp2):13,
    DateFormat('E',stamp3):13);
  WRITELN ('month name - M':26,      Clk2.Date('MONTH'):13,
    DateFormat('M',stamp1):13, DateFormat('M',stamp2):13,
    DateFormat('M',stamp3):13);
  WRITELN ('dd Mmm yyyy - N':26,     Clk2.Date('normal'):13,
    DateFormat('N',stamp1):13, DateFormat('N',stamp2):13,
    DateFormat('N',stamp3):13);
  WRITELN ('yy/mm/dd - O':26,        Clk2.Date('Ordered'):13,
     DateFormat('O',stamp1):13,DateFormat('O',stamp2):13,
     DateFormat('O',stamp3):13);
  WRITELN ('yyyymmdd - S':26,        Clk2.Date('standard'):13,
    DateFormat('S',stamp1):13, DateFormat('S',stamp2):13,
    DateFormat('S',stamp3):13);
  WRITELN ('mm/dd/yy - U':26,        Clk2.Date('USA'):13,
    DateFormat('U',stamp1):13, DateFormat('U',stamp2):13,
    DateFormat('U',stamp3):13);
  WRITELN ('day of week - W':26,     Clk2.Date('weekday'):13,
    DateFormat('W',stamp1):13, DateFormat('W',stamp2):13,
    DateFormat('W',stamp3):13);

  WRITELN;
  WRITELN ('Time/TimeFormat Examples');
  WRITELN ('------------------------');
  WRITELN ('hh:mmxm - C':26,             Clk2.Time('Civil'):13,
    TimeFormat('C',stamp1):13, TimeFormat('C',stamp2):13,
    TimeFormat('C',stamp3):13);
  WRITELN ('hours since midnight - H':26,Clk2.Time('Hours'):13,
    TimeFormat('h',stamp1):13, TimeFormat('h',stamp2):13,
    TimeFormat('h',stamp3):13);
  WRITELN ('hh:mm:ss.xx - L':26,         Clk2.Time('long'):13,
    TimeFormat('L',stamp1):13, TimeFormat('L',stamp2):13,
    TimeFormat('L',stamp3):13);
  WRITELN ('minutes since midnight - M', Clk2.Time('minutes'):13,
    TimeFormat('m',stamp1):13, TimeFormat('m',stamp2):13,
    TimeFormat('m',stamp3):13);
  WRITELN ('hh:mm:ss - N':26,            Clk2.Time('normal'):13,
    TimeFormat('n',stamp1):13, TimeFormat('n',stamp2):13,
    TimeFormat('n',stamp3):13);
  WRITELN ('seconds since midnight - S', Clk2.Time('seconds'):13,
    TimeFormat('s',stamp1):13, TimeFormat('s',stamp2):13,
    TimeFormat('s',stamp3):13);

  WRITELN;
  WRITELN ('Time Differences/Elapsed Time');
  WRITELN ('-----------------------------');
  WRITELN (' ':20,'seconds':12,'hh:mm:ss':16);
  WRITELN ('CMOS - DOS Clock:':20,
    TimeDiff(Clk2.StartValue,Clk3.StartValue):12:2,
    hhmmss(TimeDiff(Clk2.StartValue,Clk3.StartValue)):16);
  SetClock (1989,1, 1,  0, 0, 0,  0, stamp4);
  SetClock (1990,1, 1,  0, 0, 0,  0, stamp5);
  WRITELN ('Jan 1-Dec 31 1989:':20,TimeDiff(stamp5,stamp4):12:0,
    hhmmss(TimeDiff(stamp5,stamp4)):16);
  WRITELN ('Dec 31-Jan 1 1989:':20,TimeDiff(stamp4,stamp5):12:0,
    hhmmss(TimeDiff(stamp4,stamp5)):16);
  SetClock (1992,1, 1,  0, 0, 0,  0, stamp4);
  SetClock (1993,1, 1,  0, 0, 0,  0, stamp5);
  WRITELN ('1992 (leap year):':20,TimeDiff(stamp5,stamp4):12:0,
    hhmmss(TimeDiff(stamp5,stamp4)):16);
  SetClock (2000,1, 1,  0, 0, 0,  0, stamp5);
  WRITELN ('20th century:':20,TimeDiff(stamp5,stamp2):12:0,
    hhmmss(TimeDiff(stamp5,stamp2)):16,' (100*365 days + 24 leap days)');
  WRITELN ('Maximum Clock Range:':20,TimeDiff(stamp3,stamp2):12:0,
    hhmmss(TimeDiff(stamp3,stamp2)):16,' (January 1, 1900 midnight -');
  WRITELN ('June 5, 2079 23:59:59.99)':78);
  WRITELN ('Elapsed time:':20,Clk1.Elapsed:12:0,
    hhmmss(Clk1.Elapsed):16);

  WRITELN;
  WRITELN ('Clocks.UnPackTime');
  WRITELN ('-----------------');
  FindFirst ('*.*',AnyFile,DirInfo);
  WHILE DOSError = 0 DO BEGIN  {Note:  seconds on files are even numbers}
    Clocks.UnPackTime (DirInfo.Time, stamp5);
    WRITELN (DirInfo.Name:12,'  ',DirInfo.size:7,'  ',
      COPY(DateFormat('Weekday',stamp5),1,3),' ',
      DateFormat('USA',stamp5),' ',TimeFormat('Normal',stamp5));
    FindNext (DirInfo)
  END

END {ClkDemo}.
