program Test_Clock_and_Heap;

uses App, Objects, Menus, Drivers, Views, MsgBox, ClocHeap;

const
  cmDesk = 100;
  cmAbout = 101;

type
  TMyApp = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure Idle; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure DoAboutBox;
  end;

constructor TMyApp.Init;
begin
  inherited Init;
  { you can change here the DeskTop options }
  AddClock;
  AddHeap;
  DoAboutBox;
end;

destructor TMyApp.Done;
begin
  DumpClock;
  DumpHeap;
  inherited Done;
end;

procedure TMyApp.Idle;
begin
  inherited Idle;
  UpdateClock;
  UpdateHeap;
end;

procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(Event);
  if Event.What = evCommand then begin
    case Event.Command of
      cmDesk : hdDeskView;
      cmAbout : DoAboutBox;
    end;
    ClearEvent(Event);
  end;
end;

procedure TMyApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~T~est', hcNoContext, NewMenu(
      NewItem('~A~bout...', '', kbNoKey, cmAbout, hcNoContext,
      NewItem('~T~ry', '', kbNoKey, cmDesk, hcNoContext,
      NewLine(
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcExit,
      nil))))),
    nil)
  )));
end;

procedure TMyApp.DoAboutBox;
begin
  MessageBox(#3'Clock and Heap Test program'#13#13+
    #3'by Germano Rossi'#13#13#3'(germano@chiostro.univr.it',
    nil, mfInformation or mfOkButton);
end;

var
  TTestApp : TMyApp;

begin
  TTestApp.Init;
  TTestApp.Run;
  TTestApp.Done;
end.
