{************************************************}
{                                                }
{   CLOCHEAP                                     }
{                                                }
{************************************************}

unit ClocHeap;

{$F+,O+,S-,Q-,V-,X+}

(*
    Gadgets: clock and heap available viewer
    Modify March 18, 1994: G.Rossi (germano@chiostro.univr.it, germano@ivruniv)
    Heap and Clock as Object;
    Dialog to select options (with DlgDsn 4.0);
*)

interface

uses Dos, Objects, Views, App, Dialogs;

const
  hcVideoOptions = 5000;
  hcColorOptions = 5001;
  hcDeskOptions  = 5002;
  hcDateOptions  = 5003;
  hcSeparatorsOptions = 5004;
  DateCentury : boolean = True;

const
  roHeap  : Boolean = true;  { display Heap }
  roClock : Byte = 1; { display Time only }
  roVideo : Boolean = false; { 25 rows }
  roColor : Word = 0; { Color }
  roDate  : Word = 0; { MDY }
  roSep   : Word = 2; { '/' }

type
  PHeapView = ^THeapView;
  THeapView = object(TView)
    FreeMem : LongInt;
    constructor Init(var Bounds: TRect);
    destructor Done; virtual;
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
    procedure Update;
  end;

  PClockView = ^TClockView;
  TClockView = object(TView)
    Refresh: Byte;
    LastTime: DateTime;
    TimeStr: string[10];
    DayOfWeek                 : word;
    DateStr                   : string [ 11 ];            { dd-Mmm-yy }
    DayStr                    : string [ 3 ];                   { Ddd }
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
    function FormatTimeStr(DT: DateTime): String; virtual;
    function DateToStr(DT: DateTime): String;
    procedure Update; virtual;
  end;

procedure hdDeskView;

procedure AddHeap;
procedure DumpHeap;
procedure UpdateHeap;

procedure AddClock;
procedure DumpClock;
procedure UpdateClock;

implementation

uses Crt, Drivers, Memory;

const
  ViewHeap : PHeapView = NIL;
  Clock : PClockView = NIL;
  TmpStr : string[8] = '        ';

{$I deskv-us.src}

{------ Heap Window object ----------}

constructor THeapView.Init(var Bounds: TRect);
begin
  inherited Init(Bounds);
  FreeMem := 0;
  GrowMode := gfGrowAll;
end;

destructor THeapView.Done;
begin
  inherited Done;
end;

procedure THeapView.Draw;
var
  S: string[8];
begin
  if roHeap then begin
    FreeMem := MemAvail;
    FormatStr(S, '%8d', FreeMem);
    if FreeMem > 100000 then
      WriteStr(0, 0, S, 1)
    else if FreeMem > 50000 then
      WriteStr(0, 0, S, 2)
    else begin
      WriteStr(0, 0, S, 3);
      Sound(3000);
      Delay((50000-MemAvail) div 100);
      NoSound;
    end;
  end else begin
    WriteStr(0, 0, TmpStr, 1);
  end;
end;

function THeapView.GetPalette: PPalette;
const
  P: String[2] = #2#1;
begin
  GetPalette := @P;
end;

procedure THeapView.Update;
begin
  if (FreeMem <> MemAvail) then DrawView;
end;

{-------- ClockView Object --------}

function LeadingZero(w: Word): String;
var s: String;
begin
  Str(w:0, s);
  LeadingZero := Copy('00', 1, 2 - Length(s)) + s;
end;

constructor TClockView.Init(var Bounds: TRect);
begin
  inherited Init(Bounds);
  FillChar(LastTime, SizeOf(LastTime), #$FF);
  TimeStr := '';
  DayOfWeek := 255;
  DateStr := '';
  DayStr := '';
  Refresh := 1;
end;

procedure TClockView.Draw;
var
  B: TDrawBuffer;
  C: Byte;
begin
  C := GetColor(2);
  MoveChar(B, ' ', C, Size.X);
  case roClock of
    1 : MoveStr(B, TmpStr + #32 + TimeStr, C);
    2 : MoveStr(B, TmpStr + #32 + DateStr, C);
    3 : MoveStr(B, DateStr + #32 + TimeStr, C);
  end;
  WriteLine(0, 0, Size.X, 1, B);
end;


procedure TClockView.Update;
var
  NewTime                   : DateTime;
  Hund                      : word;
begin
  with NewTime do
    GetTime(Hour , Min , Sec , hund);
  if Abs(NewTime.Sec - LastTime.sec) < Refresh then EXIT;
  with NewTime do
    GetDate(Year, Month, Day, DayOfWeek);
  LastTime := NewTime;
  DateStr := DateToStr(LastTime);
  TimeStr := FormatTimeStr(LastTime);
  if Odd(LastTime.Sec) then
    TimeStr[6] := #32;
  DrawView;
end;

function TClockView.FormatTimeStr(DT: DateTime): String;
begin
  with DT do
    FormatTimeStr := LeadingZero(Hour)+ ':'+ LeadingZero(Min) +
      ':' + LeadingZero(Sec);
end;

function TClockView.DateToStr(DT: DateTime): String;
const Sep : string[3] = './-';
begin
  with DT do begin
    if DateCentury then
      if Year > 2000 then
        Dec(Year, 2000)
      else
        Dec(Year, 1900);
    case roDate of
      0 : DateToStr := LeadingZero(Month) + Sep[roSep] + LeadingZero(Day) +
          Sep[roSep] + LeadingZero(Year);
      1 : DateToStr := LeadingZero(Day) + Sep[roSep] + LeadingZero(Month) +
          Sep[roSep] + LeadingZero(Year);
      2 : DateToStr := LeadingZero(Year) + Sep[roSep] + LeadingZero(Month) +
          Sep[roSep] + LeadingZero(Day);
    end;
  end;
end;

{----------------------------------------------------}
procedure AddHeap;
var
  R: TRect;
begin
  if Application = NIL then EXIT;
  Application^.GetExtent(R);
  R.A.X := R.B.X - 8;
  R.A.Y := R.B.Y - 1;
  ViewHeap := New(PHeapView, Init(R));
  Application^.Insert(ViewHeap);
end;

procedure DumpHeap;
begin
  if ViewHeap = NIL then EXIT;
  ViewHeap^.Owner^.Delete(ViewHeap);
  Dispose(ViewHeap,Done);
end;

procedure UpdateHeap;
begin
  if ViewHeap = NIL then EXIT;
  ViewHeap^.Update;
end;

{----------------------------------------------------}
{ From SHAZAM II: CLOCK2.INC }
procedure AddClock;
var
  R: TRect;
begin
  if Application = NIL then EXIT;
  Application^.GetExtent(R);
  R.A.X:= R.B.X - 17;
  R.B.Y:= R.A.Y + 1;
  Clock:= New(PClockView ,Init(R));
  Application^.Insert(Clock);
end;

procedure DumpClock;
begin
  if Clock = NIL then EXIT;
  Clock^.Owner^.Delete(Clock);
  Dispose(Clock , Done);
end;

procedure UpdateClock;
begin
  if Clock = NIL then EXIT;
  Clock^.Update;
end;

{----------------------------------------------------}
procedure SetDesktop;
begin
  with DeskViewRec do begin
    if roVideo then VideoOptions := 1 else VideoOptions := 0;
    ColorOptions := roColor;
    DeskOptions := 0;
    if roClock > 0 then DeskOptions := DeskOptions or (roClock * 2);
    if roHeap then DeskOptions := DeskOptions or $01;
    DateOptions := roDate;
    SeparatorsOptions := roSep - 1;
  end;
end;

procedure LetHeapClock;
begin
  roHeap := (DeskViewRec.DeskOptions and $1) = 1;
  roClock := (DeskViewRec.DeskOptions and $06) div 2;
end;

procedure LetColor;
begin
  case roColor of
    0 : AppPalette := apColor;
    1 : AppPalette := apBlackWhite;
    2 : AppPalette := apMonochrome;
  end;
  DoneMemory;
  Application^.Redraw;
end;

procedure hdDeskView;
begin
  SetDeskTop;
  if Application^.ExecuteDialog(MakeDialog, @DeskViewRec) = cmOK then
    with DeskViewRec do begin
      LetHeapClock;
      if roVideo <> (VideoOptions = 1) then begin
        roVideo := (VideoOptions = 1);
        Application^.SetScreenMode(ScreenMode xor smFont8x8);
        LetColor;
      end;
      if ColorOptions <> roColor then begin
        roColor := ColorOptions;
        LetColor;
      end;
      if roDate <> DateOptions then roDate := DateOptions;
      if roSep <> (SeparatorsOptions + 1) then roSep := SeparatorsOptions + 1;
      UpdateHeap;
      UpdateClock;
    end;
{ ricordarsi di fare un:   ClearEvent(Event); }
end;

begin
  roVideo := (ScreenMode > 7);  { actual mode }
  roColor := AppPalette;  { actual color palette }
  SetDesktop;
end.


{************************************************}

(*   Portions Copyright

-   Turbo Vision, Turbo Pascal, original Gadgets:
      (c) 1992 by Borland International
-   the Clock outline:
      (c) 1991,92 by Johnathan J. Stein
      from Shazam II clock.inc procedures
-   the heap outline:
      (c) 1991 by Addison-Wesley (Deutschland) GmbH
      from Ertl, Machhholz, Schallmaier (1991) Turbo Pascal
      6.0 Turbo Vision: Konzepte, Programmierung,
      Anwendungen
-   the Desktop Options dialog idea:
      (c) 1993 by Que Corporation
      from Mitchell (1993) Borland(r) Pascal Developer's Guide,
      p.488
-   Dialog Design:
      (c) 1990-4 by L. David Baldwin

{************************************************}
