program CIS610_PROJECT;
{***********************************************************************}

{.$I pr1file.txt}                  {programmer's test file }



uses
  WinCrt;  { Allows Writeln, Readln, cursor movement, etc. }
  
{ This program was written by Larry Marks, Student ID # 066-50-9637, for
Professor Oscar Yang for CIS 610, Data Structures and Programming on July
10, 1994 to test the learning of the ADT and linked list technique. This
program is due on 8/3/94. This program is written in BORLAND'S PASCAL.


OBJECTIVE

The purpose of this program is to design and implement a computational
system for polynomials with various mathematical operations.

A polynomial is represented as a linked list of pairs containing an exponent and
a coefficient. In other words, the input for example, 2x^3 - 1 would be
evaluated as "2x^3 + 0x^2 + 0x^1 - 1".

This program is designed to perform the following:

1)READ a polynomial P.  This will be read from an input file using the
recommended "list of pairs format."

2)PRINT a polynomial P.

3)EVALUATE a polynomial for the value x.

4)ADD a polynomial P to a polynomial Q.

5)SUBTRACT a polynomial P from a polynomial Q.

6)MULTIPLY a polynomial P by a polynomial Q.

7)COMPUTE the N-th power of a polynomial P.

8)DIVIDE a polynomial P by a polynomial Q.  
(2 3), (0 2), (0 1), (1 0).

9)EXTRA CREDIT.  For extra credits, the following problems have to
be performed by this program:

a.function(7)above is performed
by this program.

b.the division of 2 specific polynomials is
performed.  That is, given:

D = A + B
E = A - B

Then, A=(3X^2 - 2X +1); B= (2 X^5 - 4X^3 +3)

       K= (3X^2 - 2X +1) + (2 X^5 - 4X^3 +3)
          __________________________________
           (3X^2 - 2X +1) - (2 X^5 - 4X^3 +3)


c.J = (3X^2 - 2X +1)^3

It should be noted that each of the above functions is coded
as a separate procedure within this program.

INPUT OR HOW PROGRAM IS EXECUTED?

The source of input is from a menu-driven system.  The test input for
this program is from a test file.

The data file could be viewed as linked list. This program sets up
and maintains the database. }

{********************************************************************}
{File descriptions:1. hwfile is the input text file that
should be viewed as  linked lists, that is delineated in the specifications.


What follows are the global declarations for the main_program}



{********************************************************************}


const
  FileName = 'larry.dta';  {2nd programmer file containing input linked list}
                           {Remember hwfile is output text file}

  Basex    = 'x';            {value of x variable assigned by Professor Yang
                           in problem specifications}

type
  PPolynomialNode = ^TPolynomialNode;
  TPolynomialNode = record
    Coefficient : integer;
    Basex       : char;
    Exponent    : integer;
    Next  : pointer;  {Used to link each field}
  end;


{*************************************************************}
procedure CreateNew(var Item: PPolynomialNode);
begin
 New(Item);
  Item^.Next := nil;      {nil represents empty polynomial node before
                           {polynomial processing}
  Item^.Coefficient := 0;   {Polynomial coefficient}
  Item^.Basex       := 'x';         {base x or value is assigned as x}
  Item^.Exponent    := 0;       {exponent of polynomial read}
end;
    {This procedure initializes the linked list pointers to be used
   on linked list file.}

{*************************************************************}

{The following procedure reads the linked list, and presents a user-friendly to the user
menu to the user to enter their Coefficient, basex and exponent that
relates to linked list.}

procedure GetData(var Item: PPolynomialNode);
begin
  ClrScr;
   repeat
    GotoXY(1, 1);
    Write('Enter Coefficient: ');
    Read(Item^.Coefficient);
  until (Item^.Coefficient <> 99);
  GotoXY(1, 2);
  Write('Enter Base: ');
  Writeln('Bases of -x- are only accepted');

  ReadLn(Item^.Basex);
  if (item^.Basex) = '' then
  begin
  end;
  GotoXY(1, 3);
  Write('Enter Exponent: ');
  ReadLn(Item^.Exponent);
end;
{************************************************************************}

 {The following computes the N-th power or factorial for the exponent
 part of the polynomial and passes the result to the print function}

 function factorial (exponent: integer) :integer;
          {factorial (exponent) computes n!}

 begin
      if  exponent <= 1 then
         factorial := 1
      else
          factorial := exponent * factorial(exponent - 1);
          writeln('Professor Yang asked us to replace the value of');
          writeln('the variable x with the value 3');
          writeln ('This is the N-th power of a polynomial P');
          write ('factorial', factorial(exponent));
 end; { factorial}


{*This procedure attempts to create and initialize the pointer, and assign
head to null}

procedure DoFirst(var First, Current: PPolynomialNode);
begin
  CreateNew(Current);
  GetData(Current);
  First := Current;
end;
{***********************************************************************}

procedure Print(Head: PPolynomialNode);
var
  i: Integer;
  Sum : Integer;
  exponent : Integer;

begin
  i := 1;
  ClrScr;
  while Head^.Next <> nil do begin
    GotoXY(1, i); Write('Coefficient: ', Head^.Coefficient);  {position of coefficient on file}
    GotoXY(25, i); Write('Basex: ', Head^.Basex); {position of base on file-spot 25}
    GotoXY(45, i); Write('Exponent: ', Head^.Exponent);   {position of exponent on file}

    factorial(exponent);

    Sum := Head^.Coefficient * 3 * factorial(exponent); 

    {Professor requires that the basex of x should be replaced with the number,3}

    Head := Head^.Next;
    Inc(i);
  end;
 
     GotoXY(1, i);


  ReadLn;

end;
 {***********************************************************************}

 {The following procedure is used to add a polynomial Q to a polynomial P}

 procedure add_polynomial(var Item, Prev, Current: PPolynomialNode);

 {***********************************************************************}
{The following procedure adds the linked list (P) with a polynomial
Q}


var

sum_coef : integer;

begin

  Prev := Current;
  CreateNew(Current);
  GetData(Current);

 If Item^.Exponent(Prev)  = Item^.Exponent(Current) then
     sum_coef := Item^.Coefficient(Prev) + Item^.Exponent(Current);
     Writeln(sum_coef);

  else

     Writeln(Item^.Coefficient(Prev));
   
     Writeln('This is the total of the previous and current polynomials');
     Write(Item^.Basex(Prev));
     Write(Item^.Exponent(Prev)); 

     Prev^.Next := Current;

 end; {of procedure add_polynomial}

  {***********************************************************************}

  {The following procedure is used to subtract a polynomial Q from a
  polynomial Q}

   procedure subtract_polynomial(var Prev, Current: PPolynomialNode);


   var

   dif_coef : integer;

 begin

  Prev := Current;
  CreateNew(Current);
  GetData(Current);

 If Item^.Exponent(Prev)  = Item^.Exponent(Current)
     dif_coef =: Item^.Coefficient(Prev) - Item^.Exponent(Current);


  Writeln('This is the difference between the previous and current');
  Writeln(' polynomials');

  Writeln(dif_coef);
  Write(Item^.Basex(Prev);
  Write(Item^.Exponent(Prev);  }

  Prev^.Next := Current;



 end; {of procedure subtract_polynomial}
  {***********************************************************************}

  {The following procedure is used to multiply a polynomial P from a
  polynomial P}


  procedure multiply_polynomial(var Prev, Current: PPolynomialNode);

 
  var

  mcoef : integer;
  sum_exp : integer;


  begin
   
  Prev := Current;
  CreateNew(Current);
  GetData(Current);


  mcoef   := Item^.Coefficient(Prev) * Item^.Coefficient(Current);
  sum_exp := Item^.Exponent(Prev) + Item^.Exponent(Current);

  Writeln('This is the result of the multiplication of the previous');
  Writeln(' and current polynomials');
  Writeln(mcoef);
  Write(Item.^Basex);
  Write(sum_exp);
                   
  Prev^.Next := Current;


  end; {of procedure multiply_polynomial}
   {***********************************************************************}
   {The following procedure is used to divide a polynomial P by a
   polynomial P}

  procedure divide_polynomial(var Prev, Current: PPolynomialNode);


  const

  dcoef = 0;       {used to initialize variable holding result of
                     subtracting coefficients of 2 polynomials read
                     by program}

  dexp  = 0;        { used to initialize variable holding result of
                      subtracting exponents of 2 polynomials read
                      by program}


  var

  dcoef : integer;
  dexp  : integer;

  begin

  Prev := Current;
  CreateNew(Current);
  GetData(Current);

  dcoef := Item^.Coefficient(Prev)/ Item^.Coefficient(Current);
  dexp  := Item^.Exponent(Prev) / Item^.Exponent(Current);

  Writeln('This is the result of the division of the previous');
  Writeln(' and current polynomials');

  Writeln('dcoef);
  Write('Item^.Basex', Item^.Basex);
  Write(dexp);   }

  Prev^.Next := Current;



  end; {of procedure divide_polynomial}
  {***********************************************************************}

  {This part is for extra credit!}
  procedure Extra_Credit(var Prev, Current: PPolynomialNode);


  {Part 3 of the extra credit requirements involve 2 given polynomials.
  Specifically, as follows:

  J = A^3

  K = D/E

  D = A + B
  E = A - B

  A = 3x^2 - 2x +1; B = 2x^5 - 4x^3 +3}

  const

  3coef = 0;
  3exp  = 0;
  2coef = 0;
  2exp  = 0;
  1coef = 0;
  1exp  = 0;

  DA+B_coef = 0;
  DA-B_coef = 0;


  type

  3coef : integer;
  3exp  : integer;
  2coef : integer;
  2exp  : integer;
  1coef : integer;
  1exp  : integer;

  DA+B_coef : integer;
  DA-B_coef : integer;


  begin

  Prev := Current;
  CreateNew(Current);
  GetData(Current);
  {*******************************************************************}
  {This part of the extra credit is intended to divide 2 specific
   polynomials.  These are:

   D = A + B;
   E = A - B;

   K = D/E; }



  Writeln('This is the numerator of the extra credit portion');

  {Now, let's add the 2 polynomials together, and get a result}

  If Item^.Exponent(Prev)  = Item^.Exponent(Current)
     DA+B_coef =: Item^.Coefficient(Prev) + Item^.Exponent(Current);

     Writeln('This is the total of the previous and current polynomials');
     Writeln(DA+B_coef);

     Numerator_Basex    := Item^.Basex(Prev);
     Numerator_Exponent := Item^.Exponent(Prev);

  Else
        Numerator_Coefficient := Item^.Coefficient(Prev);
        Numerator_Basex       := Item^.Basex(Prev);
        Numerator_Exponent    := Item^.Exponent(Prev);

  
        Writeln(Numerator_Coefficient);
        Write(Numerator_Basex);
        Write(Numerator_Exponent);

        Writeln(Item^.Coefficient(Current);
        Write(Item^.Basex(Current);
        Write(Item^.Exponent(Current);

  Prev^.Next := Current;

  {Now, to compute the divisor}

   If Item^.Exponent(Prev)  = Item^.Exponent(Current)
       DA-B_coef =: Item^.Coefficient(Prev) - Item^.Exponent(Current);

       Divisor_Basex    := Item^.Basex(Prev);
       Divisor_Exponent := Item^.Exponent(Prev);

       Writeln(DA-B_coef);
       Write(Divisor_Basex);
       Write(Divisor_Exponent);

   Else

       Writeln(Item^.Coefficient(Prev);
       Write(Item^.Basex(Prev);
       Write(Item^.Exponent(Prev);

       Writeln(Item^.Coefficient(Current);
       Write(Item^.Basex(Current);
       Write(Item^.Exponent(Current);


  Prev^.Next := Current;

 Writeln('Now, to display the anwer of K = D/E');


 Writeln((Numerator_Coefficient + Numerator_Basex + Numerator_Exponent +
  Coefficient(Prev) + Item^.Basex(Prev) + Item^.Exponent(Prev) +
  Item^.Coefficient(Current) + Item^.Basex(Current) + Item^.Exponent(Current))

  /


 (Divisor_Coefficient + Divisor_Basex + Divisor_Exponent +
  Coefficient(Prev) + Item^.Basex(Prev) + Item^.Exponent(Previous) +
  Item^.Coefficient(Current) + Item^.Basex(Current) + Item^.Exponent(Current)))


  {****************************************************************}
  { This part of the extra credit computes the following:
    (3x^2 - 2x +1)^3}


  If Item^.Coefficient(prev) = 3 then

         3coef =: Item^.Coefficient(Prev) *3;
         3exp  =: Item^.Exponent(Prev)    *3;

  If  Item^.Coefficient(prev) = 2 then

         2coef =: Item^.Coefficient(Prev) *3;
         2exp  =: Item^.Exponent(Prev)    *3;

  If  Item^.Coefficient(prev) = 1 then

         1coef =: Item^.Coefficient(Prev) *3;
         1exp  =: Item^.Exponent(Prev)    *3;

  Writeln(3coef);
  Write(3exp);
  Write(2coef);
  Write(2exp);
  Write(1coef);
  Write(1exp);

  end


  {***********************************************************************}

 {The following procedure is necessary since it disposes of the Previously
 assigned pointer, and frees the dynamically-assigned memory.}

procedure FreeAll(var Head: PPolynomialNode);
var
  Temp: PPolynomialNode;
begin
  while Head^.Next <> nil do begin
    Temp := Head^.Next;
    Dispose(Head);
    Head := Temp;
  end;
  Dispose(Head);
end;
{***********************************************************************}

procedure CreateNewFile(Head: PPolynomialNode);
var
  F: File of TPolynomialNode;
begin
  Assign(F, FileName);
  ReWrite(F);
  while Head^.Next <> nil do begin
    Write(F, Head^);
    Head := Head^.Next;
  end;
  Write(F, Head^);
  Close(F);
end;
{*****************************************************************}
procedure ReadFile(var First, Prev, Current: PPolynomialNode);
var
  F: File of TPolynomialNode;
begin
  Assign(F, FileName);  {assigns the filename to a file variable}
  Reset(F);             {command necessary to open file for readig}
  CreateNew(Current);   {creates new pointer}
  Read(F, Current^);    {reads first record}
  First := Current;     {if first and current record same, then user
                        {at start of linked list file processing}
  while not Eof(F) do begin
    Prev := Current;
    CreateNew(Current);
    Read(F, Current^);
    Prev^.Next := Current;
  end;
  Close(F);              {if user at end of file, then file is closed
                         and linked list comprising passenger name,
                         flight number and day of week }
end;
{*****************************************************************}

{This procedure is the main processing for Larry Marks program. }

procedure Main(var First, Prev, Current: PPolynomialNode);
var
  F      : Text;
begin
  {$I-}
  Assign (f, 'pr1file.txt'); {this file is used to contain test linked list
                             of polynomials}

  Reset(f);
  {$I+}                           {standard prog of Turbo Pascal}
  if (IOResult <> 0) then begin
    WriteLn('error Reading File');{I want to test file to see if opened}
    Halt;                         {if already opened, then file processing ends.}
  end;
  CreateNew(Current);
  ReadLn(F, Current^.Coefficient);
  ReadLn(F, Current^.Basex);
  ReadLn(F, Current^.Exponent);
  First := Current;
  while not Eof(F) do begin
    Prev := Current;
    CreateNew(Current);
    ReadLn(F, Current^.Coefficient);
    ReadLn(F, Current^.Basex);
    ReadLn(F, Current^.Exponent);

    Add_Polynomial(First, Prev, Current);
    Subtract_Polynomial(Prev, Current);
    Multiply_Polynomial(Prev, Current);
    Divide_Polynomial(Prev, Current);


    Extra_Credit(Prev, Current);
    
    Prev^.Next := Current;
  end;
  Close(F);
  Print(First);
  CreateNewFile(First);
end;
{**************************************************************}
{I decided to change the specifications somewhat in order to present}
{to the user a friendly modularized menu which contains the system}
function WriteMenu: Char;
var
  Ch: Char;
begin                                {main menu system}
  ClrScr;
  GotoXY(1, 1);
          writeln('*********************************************');
          writeln('*********************************************');
          writeln('Prof. Oscar Yang super duper polynomial system');
          writeln('*********************************************');
          writeln('*********************************************');
          writeln('linked list not exist at this time'          );
          writeln('Please wait while Professor Hao sets up list');
          writeln('node initializing next'                      );
          writeln('*************************************');
          writeln('Now, passenger loop processing begins');
          writeln('*************************************');

  WriteLn('A) Add');
  WriteLn('P) Print');
  Writeln('S) Subtract');
  Writeln('M) Multiply');
  Writeln('D) Divide');
  
  WriteLn('E) Extra Credit');

  WriteLn('X) Exit');
  repeat
    Ch := UpCase(ReadKey);    {this validation checking checks lower case,
    and changes all letters entered to upper case.}

  until Ch in ['A', 'P', 'S', 'M', 'D', 'W', 'X'];
  WriteMenu := Ch;
end;

var
  Ch: Char;
  First,
  Prev,
  Current: PPolynomialNode;

begin
  ClrScr;
  {  Main(First, Prev, Current); Use this option to read text file }
  ReadFile(First, Prev, Current);
  repeat
    Ch := WriteMenu;
    case Ch of
      'A': Add_Polynomial(First, Prev, Current);
      'P': Print(First);
      'W': CreateNewFile(First);
      'S': Subtract_Polynomial(Prev, Current);
      'M': Multiply_Polynomial(Prev, Current);
      'E': Extra_Credit(Prev, Current);
      'D': Divide_Polynomial(Prev, Current);
    end;
  until Ch = 'X';
end.
end. { main program}


                                                                                                       