program ChildWindowDemo;

{
  Program:            CHILDEMO.PAS
  Version:            1.0
  Creation Date:      December 10, 1992
  Modification Date:  December 11, 1992
  Operating System:   MS-DOS 3.x and Windows 3.1
  Hardware Required:  Windows-capable computer system
  Programming System: Turbo Pascal for Windows 1.5
  Author:             Craig Boyd
  Ownership:          Released to the public domain


  About This Program

  Demonstrates one way of keeping a child window nailed down to a specific
  area within a parent window.  This type of routine could be used to set
  up a toolbar or a status bar.

  The demo creates three child windows, one at the top of the parent
  window and two at the bottom.  The parent window's client is also
  resized so that it is not overlapped by the child windows.

  What's the point of this program?  Hell, I don't know.  I was just
  fooling around with the idea and wanted to see how it could be done.
  You can use this code as you see fit, but don't blame me if you find
  any bugs! ;-)

  Have fun!


  Update History

  update    ver   description (author)
  -------   ---   -----------
  9212.10   0.0   Work begun. (CSB)
  9212.11   1.0   First release. (CSB)
}

{$R-,W-,X+}

uses
  Strings,
  WinTypes,
  WinProcs,
  WObjects,
  Win31;

{-- Global Declarations -------------------------------------------------}

const
  AppName    : pchar = 'SizeTest';
  AppTitle   : pchar = 'Child Window Demo';

type
  TTestApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PChildWindow = ^TChildWindow;
  TChildWindow = object(TWindow)
    HiColor,
    ShColor,
    BkColor : TColorRef;
    Brush   : HBrush;
    constructor Init(AParent : PWindowsObject; AName : PChar);
    destructor Done; virtual;
    function GetClassName : pchar; virtual;
    procedure GetWindowClass(var WndClass : tWndClass); virtual;
    procedure Paint(paintDC : HDC; var PaintInfo : TPaintStruct); virtual;
  end;

  PClientWindow = ^TClientWindow;
  TClientWindow = object(TWindow)
    constructor Init(AParent : PWindowsObject; AName : PChar);
    function GetClassName : pchar; virtual;
    procedure Paint(paintDC : HDC; var PaintInfo : TPaintStruct); virtual;
  end;

  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    Client      : PClientWindow;
    Child1,
    Child2,
    Child3      : PChildWindow;
    ChildHeight,
    MinHeight   : integer;
    constructor Init(AParent : PWindowsObject; AName : PChar);
    procedure SetupWindow; virtual;
    function GetClassName : pchar; virtual;
    procedure WMGetMinMaxInfo(var Msg : TMessage);
      virtual wm_First + wm_GetMinMaxInfo;
    procedure WMSize(var Msg : TMessage);
      virtual wm_First + wm_Size;
  end;

{-- TMyWindow Methods ---------------------------------------------------}

constructor TMyWindow.Init;
  begin
    TWindow.Init(AParent,AName);
    Client := new(PClientWindow,Init(@Self,'Client'));
    Child1 := new(PChildWindow,Init(@Self,'Child 1'));
    Child2 := new(PChildWindow,Init(@Self,'Child 2'));
    Child3 := new(PChildWindow,Init(@Self,'Child 3'));
    ChildHeight := 24;
    MinHeight := ChildHeight * 4;
  end { TMyWindow.Init };

procedure TMyWindow.SetupWindow;
  var
    CX,
    CY,
    X,
    Y  : integer;
  begin
    TWindow.SetupWindow;
    {
      Make our window about 1/4 the size of the screen and center it.
    }
    CX := GetSystemMetrics(SM_CXScreen) div 2;
    CY := GetSystemMetrics(SM_CYScreen) div 3;
    X := (GetSystemMetrics(SM_CXScreen) - CX) div 2;
    Y := (GetSystemMetrics(SM_CYScreen) - CY) div 2;
    SetWindowPos(HWindow,0,X,Y,CX,CY,swp_NoZOrder);
 end { TMyWindow.SetupWindow };

function TMyWindow.GetClassName;
  begin
    GetClassName := AppName;
  end { TMyWindow.GetClassName };

procedure TMyWindow.WMGetMinMaxInfo;
{
  Make sure that when our window is resized it's always tall enough to
  keep the child windows and the client area visible.
}
  begin
    with Msg do begin
      PMinMaxInfo(lParam)^.ptMinTrackSize.Y := MinHeight;
      Result := 0;
    end;
  end { TMyWindow.WMGetMinMaxInfo };

procedure TMyWindow.WMSize;
{
  If our window is resized we must also resize and repaint the child
  windows.  We can do it all with three MoveWindow calls.
}
  begin
    with Msg do begin
      MoveWindow(Client^.HWindow,0,ChildHeight,lParamLo,lParamHi-(ChildHeight * 2)-1,true);
      MoveWindow(Child1^.HWindow,0,0,lParamLo,ChildHeight,true);
      MoveWindow(Child2^.HWindow,0,lParamHi-ChildHeight,lParamLo div 2,ChildHeight,true);
      MoveWindow(Child3^.HWindow,lParamLo div 2,lParamHi-ChildHeight,lParamLo div 2,ChildHeight,true);
      Result := 0;
    end;
  end { TMyWindow.WMSize };

{-- TChildWindow Methods ------------------------------------------------}

constructor TChildWindow.Init;
  begin
    TWindow.Init(AParent,AName);
    with Attr do
      Style := ws_Child or ws_Visible;
    {
      Setup three color values to use when drawing our 3-D border.
      BkColor is the normal window background, HiColor is the color for
      highlights, and ShColor is the color for shadows.

      We also make a brush with BkColor.  We'll use it to paint the window
      background and to give text the proper background color in our Paint
      method. 
    }
    HiColor := RGB(255,255,255);
    BkColor := RGB(192,192,192);
    ShColor := RGB(128,128,128);
    Brush := CreateSolidBrush(BkColor);
  end { TChildWindow.Init };

destructor TChildWindow.Done;
  begin
    {
      Always delete any objects we create.
    }
    DeleteObject(Brush);
    TWindow.Done;
  end { TChildWindow.Done };

function TChildWindow.GetClassName;
  begin
    GetClassName := 'Child';
  end { TChildWindow.GetClassName };

procedure TChildWindow.GetWindowClass;
  begin
    TWindow.GetWindowClass(WndClass);
    {
      Set the background color.
    }
    WndClass.hbrBackground := Brush;
  end { TChildWindow.GetWindowClass };

procedure TChildWindow.Paint;
  var
    OldBkColor : TColorRef;
    Pen,
    OldPen     : HPen;
    R          : TRect;
    Extent     : longint;
    X,
    Y          : integer;
  begin
    {
      Just for fun, let's draw a fancy 3-D border around the window.
      This lets you see clearly that the window has been resized to
      fit within the parent window.
    }
    GetClientRect(HWindow,R);
    Pen := CreatePen(ps_Solid,1,HiColor);          { draw the highlights }
    OldPen := SelectObject(paintDC,Pen);
    MoveTo(paintDC,0,R.Bottom-2);
    LineTo(paintDC,0,0);
    LineTo(paintDC,R.Right-1,0);
    MoveTo(paintDC,R.Right-3,3);
    LineTo(paintDC,R.Right-3,R.Bottom-3);
    LineTo(paintDC,2,R.Bottom-3);
    SelectObject(paintDC,OldPen);
    DeleteObject(Pen);
    Pen := CreatePen(ps_Solid,1,ShColor);             { draw the shadows }
    OldPen := SelectObject(paintDC,Pen);
    MoveTo(paintDC,2,R.Bottom-4);
    LineTo(paintDC,2,2);
    LineTo(paintDC,R.Right-3,2);
    MoveTo(paintDC,R.Right-1,1);
    LineTo(paintDC,R.Right-1,R.Bottom-1);
    LineTo(paintDC,0,R.Bottom-1);
    SelectObject(paintDC,OldPen);
    DeleteObject(Pen);
    {
      Paint the window title centered in the window.
      Don't forget to use the proper background color.
    }
    Extent := GetTextExtent(paintDC,Attr.Title,strlen(Attr.Title));
    X := ((R.Right - R.Left) - loword(Extent)) div 2;
    Y := ((R.Bottom - R.Top) - hiword(Extent)) div 2;
    OldBkColor := SetBkColor(paintDC,BkColor);
    TextOut(paintDC,X,Y,Attr.Title,strlen(Attr.Title));
    SetBkColor(paintDC,OldBkColor);
  end { TChildWindow.Paint };

{-- TClientWindow Methods -----------------------------------------------}

constructor TClientWindow.Init;
  begin
    TWindow.Init(AParent,AName);
    with Attr do
      Style := ws_Child or ws_Visible;
  end { TClientWindow.Init };

function TClientWindow.GetClassName;
  begin
    GetClassName := 'Client';
  end { TClientWindow.GetClassName };

procedure TClientWindow.Paint;
  var
    R      : TRect;
    Extent : longint;
    X,
    Y      : integer;
  begin
    {
      Draw an "x" that fills the client rect.
    }
    GetClientRect(Hwindow,R);
    MoveTo(PaintDC,R.Left,R.Top);
    LineTo(PaintDC,R.Right,R.Bottom);
    MoveTo(PaintDC,R.Right,R.Top);
    LineTo(PaintDC,R.Left,R.Bottom);
    {
      Paint the window title centered in the window.
    }
    Extent := GetTextExtent(paintDC,Attr.Title,strlen(Attr.Title));
    X := ((R.Right - R.Left) - loword(Extent)) div 2;
    Y := ((R.Bottom - R.Top) - hiword(Extent)) div 2;
    TextOut(paintDC,X,Y,Attr.Title,strlen(Attr.Title));
  end { TClientWindow.Paint };

{-- TTestApp Methods ----------------------------------------------------}

procedure TTestApp.InitMainWindow;
  begin
    MainWindow := New(PMyWindow,Init(nil,AppTitle));
  end { TTestApp.InitMainWindow };

{-- Main Program --------------------------------------------------------}

var
  TestApp : TTestApp;

begin
  TestApp.Init(AppName);
  TestApp.Run;
  TestApp.Done;
end.
