{
 test program for GetMemDos.
 allocates 10000 and 100000 byte blocks from DOS,
   checks memavail and maxavail, and shows the DOS memory allocation chain
}

uses
  dos, opdos, opstring, chain;
var
  p : pointer;

procedure showmcbs;

  type
    mcbptr = ^mcb;
    mcb =
      record
        id : char;
        psp : word;
        len : word;
      end;
  var
    curmcb : mcbptr;

  function GetStartMCBSeg : Word;
  var
    reg : registers;
  begin
    reg.ah := $52;
    MsDos(reg);
    GetStartMCBSeg := MemW[reg.es:(reg.bx-2)];
  end;

  procedure dumpmcb(m : mcbptr);
  var
    env : word;
    par : word;
    mseg : word;
    erec : envrec;
  begin
   {ID mcb  psp  par  env  len  COMMAND}
   {M ssss pppp pppp eeee llllll fffff}
    with m^ do begin
      env := memw[psp:$2C];
      par := memw[psp:$16];
      mseg := seg(m^);
      write(id, ' ',
            hexw(mseg), ' ',
            hexw(psp), ' ',
            hexw(par), ' ',
            hexw(env), ' ',
            (longint(16)*len):6, ' ',
            ((par = psp) and (mseg+1 = psp)):5
           );
      if (psp > 8) and (mseg+1 = env) then begin
        erec.envseg := env;
        erec.envlen := memw[env:3];
        erec.envptr := nil;
        write(' ', stlocase(getprogramstr(erec)));
      end;
      writeln;
    end;
  end;

begin
  writeln('ID mcb  psp  par  env  len  command');
  curmcb := ptr(getstartmcbseg, 0);
  dumpmcb(curmcb);
  repeat
    curmcb := ptr(seg(curmcb^)+curmcb^.len+1, 0);
    dumpmcb(curmcb);
  until curmcb^.id = 'Z';
end;

begin
  writeln('memavail ', memavail);
  writeln('maxavail ', maxavail);
  getmemdos(p, 10000);
  writeln('dos ptr ', hexptr(p));
  getmemdos(p, 100000);
  writeln('dos ptr ', hexptr(p));
  writeln('memavail ', memavail);
  writeln('maxavail ', maxavail);
  showmcbs;
end.
