{*******************************************************
              CGEN Program

 This program is a simple Turbo Vision application used
 for unit color palette development. It can be used from
 the IDE or as an executable. The only difference is
 when used from the IDE it can be recompiled with the
 code for the color palette being developed.

              Paul Warren
     HomeGrown Software Development
   (c) 1992 Langley British Columbia.
            (604) 271-4224

 CREDIT WHERE CREDIT IS DUE: The demo windows are from
 the Borland supplied TVGUID10.PAS supplied with Turbo
 Pascal v 6.0. I have very slightly modified COLORSEL.PAS
 to provide access to the ColorItemList^.Count field so
 this unit is provided but you must leave Borlands copy-
 right intact. The MkUnit unit is modified code from
 Abacus's PCT.PAS supplied with their Turbo Vision Toolkit
 and only the TPU is provided here.

 You will need all the Turbo Vision standard units to
 compile but since this program is for Turbo Vision
 Development anyway anyone who uses it will have
 version 6.0 so this should be no hardship.

 BUGS: There is only one that I know of and I would
 appreciate a fix if anyone finds it. When the listbox
 and collection is instantiated in the Demo Dialog type
 a 76 byte chunk of heap gets gobbled up and doesn't
 come back. I think it has to do with the PString types
 instantiated but a DisposeStr call screws everything
 up. It doesn't cause any real problems however.

 LIMITATIONS: I have written this for color monitors
 and there are no monochrome palettes created so you can't
 Toggle the colors with a monochrome monitor. This would
 be pretty easy to change if you want. If you are using
 a monochrome monitor you coul put the statement
 ShowMarkers := true; in the TMyApp.Init method to use
 the COLORSEL.PAS monoselect type.

 USING THE NEW PALETTES: After creating your new
 palette you simply include the unit in your program
 and write an TApplication.GetPalette method similar
 to the one in this application.
********************************************************}

program cgen;

{$X+}
{$M 8192,0,655360}

uses
  Dos, Objects, Drivers, Memory, Views, Menus, Dialogs, MsgBox, App,
  Gadgets, ColorGen, Color, MKUnit, HelpFile, ColHelp;

const
  { Command constants }
  FileToRead        = 'COLOR.DEF';
  MaxLines          = 50;
  WinCount: Integer =   0;
  cmFileOpen        = 100;
  cmNewWin          = 101;
  cmToggle          = 102;
  cmASCII           = 1002;
  cmHex             = 1003;
  cmCalendar        = 1004;
  cmAsciiTab        = 1005;
  cmColors          = 1006;

var
  { Global variables }
  LineCount: Integer;
  Lines: array[0..MaxLines - 1] of PString;

type
  { TApplication type }
  TMyApp = object(TApplication)
    Clock: PClockView;
    Heap: PHeapView;
    constructor Init;
    function GetPalette: PPalette; virtual;
    procedure GetEvent(var Event: TEvent); virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure Idle; virtual;
    procedure InitStatusLine; virtual;
    procedure NewWindow;
  end;

  { Window interior delclaration }
  PInterior = ^TInterior;
  TInterior = object(TScroller)
    constructor Init(var Bounds: TRect; AHScrollBar,
      AVScrollBar: PScrollBar);
    procedure Draw; virtual;
  end;

  { Window declaration }
  PDemoWindow = ^TDemoWindow;
  TDemoWindow = object(TWindow)
    RInterior, LInterior: PInterior;
    constructor Init(Bounds: TRect; WinTitle: String; WindowNo: Word; Color: integer);
    function MakeInterior(Bounds: TRect; Left: Boolean): PInterior;
    procedure SizeLimits(var Min, Max: TPoint); virtual;
  end;

  { An object using the TDialog InfoPane palette entry }
  PPane = ^TPane;
  TPane = object(TView)
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
    function GetPalette: PPalette; virtual;
  end;

  { A dialog containing examples of all standard objects
  normally included in Dialogs }
  PDemoDialog = ^TDemoDialog;
  TDemoDialog = object(TDialog)
    Coll: PCollection;
    List: PListBox;
    Pane: PPane;
    constructor Init;
    destructor Done; virtual;
  end;

  { An extension to the Borland supplied HeapView. Has a GetPalette
  method to map onto different palette entries }
  PXHeapView = ^TXHeapView;
  TXHeapView = object(THeapView)
    function GetPalette: PPalette; virtual;
  end;

  { An extension to the Borland supplied ClockView. Has a GetPalette
  method to map onto different palette entries }
  PXClockView = ^TXClockView;
  TXClockView = object(TClockView)
    function GetPalette: PPalette; virtual;
  end;

{ TXHelpWindow }

  PXHelpWindow = ^TXHelpWindow;
  TXHelpWindow = object(THelpWindow)
    function GetPalette: PPalette; virtual;
  end;

  { Record type for Dialog data }
  TDlgRec1 = record
    { Input with history }
    STR1  : string[20];
    { CheckBoxes }
    BOX13  : word;
    { RadioButtons }
    BOX12  : word;
  end;

const
  { Color string for TPane type. Maps onto 30th Dialog
  palette entry. }
  CInfoPane = #30;

var
  { More global variables }
  DlgRec1 : TDlgRec1;
  UseOwnColors: boolean;

{ Finds .HLP file for help screens }
function CalcHelpName: PathStr;
var
  EXEName: PathStr;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
begin
  if Lo(DosVersion) >= 3 then EXEName := ParamStr(0)
  else EXEName := FSearch('CGEN.EXE', GetEnv('PATH'));
  FSplit(EXEName, Dir, Name, Ext);
  if Dir[Length(Dir)] = '\' then Dec(Dir[0]);
  CalcHelpName := FSearch('COLHELP.HLP', Dir);
end;

{ Reads a file into a collection for display }
procedure ReadFile;
var
  F: Text;
  S: String;
begin
  LineCount := 0;
  Assign(F, FileToRead);
  {$I-}
  Reset(F);
  {$I+}
  if IOResult <> 0 then
  begin
    Writeln('Cannot open ', FileToRead);
    Halt(1);
  end;
  while not Eof(F) and (LineCount < MaxLines) do
  begin
    Readln(F, S);
    Lines[LineCount] := NewStr(S);
    Inc(LineCount);
  end;
  Close(F);
end;

{ Closes file and disposes of collection when done }
procedure DoneFile;
var
  I: Integer;
begin
  for I := 0 to LineCount - 1 do
    if Lines[I] <> nil then DisposeStr(Lines[i]);
end;

function TXHelpWindow.GetPalette: PPalette;
const
  P: String[10] = #16#17#18#19#20#21#22#18#25#26;
begin
  GetPalette := @P;
end;

{ TInterior }
constructor TInterior.Init(var Bounds: TRect; AHScrollBar,
  AVScrollBar: PScrollBar);
begin
  TScroller.Init(Bounds, AHScrollBar, AVScrollBar);
  Options := Options or ofFramed;
  SetLimit(128, LineCount);
end;

procedure TInterior.Draw;
var
  Color: Byte;
  I, Y: Integer;
  B: TDrawBuffer;
begin
  Color := GetColor(1);
  for Y := 0 to Size.Y - 1 do
  begin
    MoveChar(B, ' ', Color, Size.X);
    i := Delta.Y + Y;
    if (I < LineCount) and (Lines[I] <> nil) then
      MoveStr(B, Copy(Lines[I]^, Delta.X + 1, Size.X), Color);
    WriteLine(0, Y, Size.X, 1, B);
  end;
end;

{ TDemoWindow }
constructor TDemoWindow.Init(Bounds: TRect; WinTitle: String;
  WindowNo: Word; Color: integer);
var
  S: string[3];
  R: TRect;
begin
  Str(WindowNo, S);
  TWindow.Init(Bounds, WinTitle + ' ' + S, wnNoNumber);
  if Color = 1 then Palette := wpBlueWindow;
  if Color = 2 then Palette := wpCyanWindow;
  if Color = 3 then Palette := wpGrayWindow;
  GetExtent(Bounds);
  R.Assign(Bounds.A.X, Bounds.A.Y, Bounds.B.X div 2 + 1, Bounds.B.Y);
  LInterior := MakeInterior(R, True);
  LInterior^.GrowMode := gfGrowHiY;
  Insert(Linterior);
  R.Assign(Bounds.B.X div 2, Bounds.A.Y, Bounds.B.X, Bounds.B.Y);
  RInterior := MakeInterior(R,False);
  RInterior^.GrowMode := gfGrowHiX + gfGrowHiY;
  Insert(RInterior);
end;

function TDemoWindow.MakeInterior(Bounds: TRect; Left: Boolean): PInterior;
var
  HScrollBar, VScrollBar: PScrollBar;
  R: TRect;
begin
  R.Assign(Bounds.B.X - 1, Bounds.A.Y + 1, Bounds.B.X, Bounds.B.Y - 1);
  VScrollBar := New(PScrollBar, Init(R));
  VScrollBar^.Options := VScrollBar^.Options or ofPostProcess;
  if Left then VScrollBar^.GrowMode := gfGrowHiY;
  Insert(VScrollBar);
  R.Assign(Bounds.A.X + 2, Bounds.B.Y - 1, Bounds.B.X - 2, Bounds.B.Y);
  HScrollBar := New(PScrollBar, Init(R));
  HScrollBar^.Options := HScrollBar^.Options or ofPostProcess;
  if Left then HScrollBar^.GrowMode := gfGrowHiY + gfGrowLoY;
  Insert(HScrollBar);
  Bounds.Grow(-1, -1);
  MakeInterior := New(PInterior, Init(Bounds, HScrollBar, VScrollBar));
end;

procedure TDemoWindow.SizeLimits(var Min, Max: TPoint);
var R: TRect;
begin
  TWindow.SizeLimits(Min, Max);
  Min.X := LInterior^.Size.X + 9;
end;

{ TPane type }
constructor TPane.Init(var Bounds: TRect);
begin
  TView.Init(Bounds);
  EventMask := EventMask or evBroadcast;
end;

procedure TPane.Draw;
var
  B: TDrawBuffer;
  Color: Word;
  i: integer;
begin
  Color := GetColor(1);
  MoveChar(B, ' ', Color, Size.X*2);
  i := 0;
  while i < Size.X*Size.Y do begin
    MoveStr(B[i], 'InfoPane', Color);
    Inc(i, Length(' InfoPane '));
  end;
  WriteBuf(0, 0, Size.X, 2, B);
end;

function TPane.GetPalette: PPalette;
const
  P: String[Length(CInfoPane)] = CInfoPane;
begin
  GetPalette := @P;
end;

{ TXHeapView type }
function TXHeapView.GetPalette: PPalette;
const
  P: String[2] = #3#4;
begin
  GetPalette := @P;
end;

{ TXClockView type }
function TXClockView.GetPalette: PPalette;
const
  P: String[2] = #3#4;
begin
  GetPalette := @P;
end;

{ TDemoDialog type }
constructor TDemoDialog.Init;
var
  R : TRect;
  V : PView;
  Control: PInputLine;
  SB: PScrollBar;
  i: integer;
  S: PString;
begin
  with DlgRec1 do begin
    STR1 := 'Test';
    BOX13 := $1;
    BOX12 := 0;
  end;

  R.Assign(3,3,37,20);
  TDialog.Init(R,'Dialog 1');

  R.Assign(2,1,2+Length('******** Static Text ********'),2);
  Insert(New(PStaticText,Init(R,'******** Static Text ********')));

  R.Assign(2,3,21,4);
  Control := New(PInputLine,Init(R,20));
  Insert(Control);
  R.Assign(2,2,21,3);
  Insert(New(PLabel,Init(R,'~I~nput/history',Control)));
  R.Assign(21,3,24,4);
  Insert(New(PHistory, Init(R, Control, 10)));

  R.Assign(2,5,24,7);
  V:=New(PCheckBoxes,Init(R,
     NewSItem('~O~ption...',
     NewSItem('Op~t~ion...',
    nil))));
  Insert(V);
  R.Assign(2,4,24,5);
  Insert(New(PLabel,Init(R,'Check~B~oxes',V)));

  R.Assign(2,8,24,10);
  V:=New(PRadiobuttons,Init(R,
     NewSItem('~O~ption...',
     NewSItem('Op~t~ion...',
    nil))));
  Insert(V);
  R.Assign(2,7,24,8);
  Insert(New(PLabel,Init(R,'~R~adioButtons',V)));

  R.Assign(2,11,24,13);
  Pane := New(PPane,Init(R));
  Insert(Pane);

  R.Assign(2,14,12,16);
  Insert(New(PButton,Init(R,'~O~k',cmOK,bfDefault)));

  R.Assign(14,14,24,16);
  Insert(New(PButton,Init(R,'~C~ancel',cmCancel,bfNormal)));

  SetData(DlgRec1);

  R.Assign(31, 3, 32, 16);
  SB := New(PScrollBar, Init(R));
  Insert(SB);
  R.Assign(25,3,31,16);
  List := New(PListBox, Init(R, 1, SB));
  Insert(List);
  R.Assign(25,2,31,3);
  Insert(New(PLabel,Init(R,'~L~ist',List)));

  Coll := New(PCollection, Init(11, 0));
  S := NewStr('test');
  { BUG HERE ?????? }
  for i := 0 to 10 do begin
    Coll^.Insert(S);
  end;
  List^.SetRange(Coll^.Count);
  List^.NewList(Coll);

  SelectNext(false);
end;

destructor TDemoDialog.Done;
begin
  if List <> nil then Dispose(List, Done);
  if Pane <> nil then Dispose(Pane, Done);
  TDialog.Done;
end;

{ TMyApp }
constructor TMyApp.Init;
var
  R: TRect;
  I: Integer;
  FileName: PathStr;
begin
  TApplication.Init;
  RegisterObjects;
  RegisterViews;
  RegisterMenus;
  RegisterDialogs;
  RegisterApp;
  RegisterHelpFile;

  GetExtent(R);
  R.A.X := R.B.X - 9; R.B.Y := R.A.Y + 1;
  Clock := New(PXClockView, Init(R));
  Insert(Clock);

  GetExtent(R);
  Dec(R.B.X);
  R.A.X := R.B.X - 9; R.A.Y := R.B.Y - 1;
  Heap := New(PXHeapView, Init(R));
  Insert(Heap);
end;

function TMyApp.GetPalette: PPalette;
const
  CNewColor = CColor;
  CNewBlackWhite = CBlackWhite;
  CNewMonochrome = CMonochrome;
  P: array[apColor..apMonochrome] of string[Length(CNewColor)] =
    (CNewColor, CNewBlackWhite, CNewMonochrome);
begin
  if UseOwnColors and (ScreenMode = 3) then
  GetPalette := @NewColors
  else GetPalette := @P[AppPalette];
end;

procedure TMyApp.GetEvent(var Event: TEvent);
var
  W: PWindow;
  HFile: PHelpFile;
  HelpStrm: PDosStream;
const
  HelpInUse: Boolean = False;
begin
  TApplication.GetEvent(Event);
  case Event.What of
    evCommand:
      if (Event.Command = cmHelp) and not HelpInUse then
      begin
        HelpInUse := True;
        HelpStrm := New(PDosStream, Init(CalcHelpName, stOpenRead));
        HFile := New(PHelpFile, Init(HelpStrm));
        if HelpStrm^.Status <> stOk then
        begin
          MessageBox('Could not open help file.', nil, mfError + mfOkButton);
          Dispose(HFile, Done);
        end
        else
        begin
          W := New(PXHelpWindow,Init(HFile, GetHelpCtx));
          if ValidView(W) <> nil then
          begin
            ExecView(W);
            Dispose(W, Done);
          end;
          ClearEvent(Event);
        end;
        HelpInUse := False;
      end;
    evMouseDown:
      if Event.Buttons <> 1 then Event.What := evNothing;
  end;
end;

procedure TMyApp.HandleEvent(var Event: TEvent);

procedure Colors;
var
  D: PCol_Gen;
begin
  D := New(PCol_Gen, Init);
  D^.HelpCtx := hcNoContext;
  if ValidView(D) <> nil then
  begin
    D^.SetData(Application^.GetPalette^);
    if Desktop^.ExecView(D) <> cmCancel then
    begin
      Application^.GetPalette^ := D^.Pal;
      DoneMemory;  { Dispose all group buffers }
      ReDraw;      { Redraw application with new palette }
    end;
    Dispose(D, Done);
  end;
end;

procedure ToggleColors;
begin
  if UseOwnColors = true then
  UseOwnColors := false
  else UseOwnColors := true;
  Application^.GetPalette;
  DoneMemory;  { Dispose all group buffers }
  ReDraw;      { Redraw application with new palette }
end;

begin
  TApplication.HandleEvent(Event);
  if Event.What = evCommand then
  begin
    case Event.Command of
      cmNewWin: NewWindow;
      cmColors: Colors;
      cmToggle: ToggleColors;
      cmASCII: ASCIIUnit;
      cmHex: HexUnit;
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TMyApp.Idle;
var
  Count: integer;

procedure IsTileable(P: PView); far;
begin
  Inc(Count);
end;

begin
  TApplication.Idle;
  Clock^.Update;
  Heap^.Update;
  Count := 0;
  if ScreenMode <> 3 then DisableCommands([cmToggle]);
  Desktop^.ForEach(@IsTileable);
  if Count <> 1 then
    DisableCommands([cmNewWin])
  else
    EnableCommands([cmNewWin]);
end;

procedure TMyApp.InitMenuBar;
var R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~O~bjects', hcNoContext, NewMenu(
      NewItem('~I~nsert objects', 'F3', kbF3, cmNewWin, hcNoContext,
      nil)),
    NewSubMenu('~C~olors', hcNoContext, NewMenu(
      NewItem('~C~olors...', '', kbNoKey, cmColors, hcNoContext,
      NewItem('~T~oggle', 'F2', kbF2, cmToggle, hcNoContext,
      NewLine(
      NewItem('~A~SCII unit', 'Alt-A', kbAltA, cmASCII, hcNoContext,
      NewItem('~H~ex unit', 'Alt-H', kbAltH, cmHex, hcNoContext,
      nil)))))),
    NewSubMenu('~W~indow', hcNoContext, NewMenu(
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
      NewItem('~P~revious', 'Shift-F6', kbShiftF6, cmPrev, hcNoContext,
      NewItem('~S~ize/Move', 'Ctrl-F5', kbCtrlF5, cmResize, hcNoContext,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
      nil))))),
    nil))
  ))));
end;

procedure TMyApp.InitStatusLine;
var R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~F1~ Help', kbF1, cmHelp,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
      nil)))),
    nil)
  ));
end;

procedure TMyApp.NewWindow;
var
  Window: PDemoWindow;
  D: PDemoDialog;
  R: TRect;
  i: integer;
begin
  WinCount := 0;
  Randomize;
  D := New(PDemoDialog, Init);
  Desktop^.Insert(D);
  for i := 1 to 3 do begin
    Inc(WinCount);
    R.Assign(0, 0, 25, 8);
    R.Move(Random(34), Random(11));
    Window := New(PDemoWindow, Init(R, 'Demo Window', WinCount, i));
    DeskTop^.Insert(Window);
  end;
end;

var
  MyApp: TMyApp;

begin
  UseOwnColors := false;
  ReadFile;
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
  DoneFile;
end.
