program RecordS;

uses
  MMSystem,
  WinCrt;
function RecordSound(MMSecs: LongInt): LongInt;
var
  DeviceID: Word;
  Return: LongInt;
  MciOpen: TMCI_Open_Parms;
  MciRecord: TMCI_Record_Parms;
  MciPlay: TMCI_Play_Parms;
  MciSave: TMCI_SaveParms;
  Result: LongInt;
  Flags: Word;

begin
  MciOpen.lpstrDeviceType := 'waveaudio';
  MciOpen.lpstrElementName := '';
  Flags := Mci_Open_Element or Mci_Open_Type;
  Result := MciSendCommand(0, MCI_OPEN, Flags, LongInt(@MciOpen));
  DeviceID := MciOpen.wDeviceId;

  WriteLn('Record');
  MciRecord.dwTo := MMSecs;
  Flags := Mci_To or Mci_Wait;
  Result := MciSendCommand(DeviceID, Mci_Record, Flags, LongInt(@MciRecord));

  WriteLn('Stop');
  mciPlay.dwFrom := 0;
  Flags := Mci_From or Mci_Wait;
  MciSendCommand(DeviceId, Mci_Play, Flags, LongInt(@MciPlay));


  mciSave.lpfileName := 'MyWave.Wav';
  Flags := MCI_Save_File or Mci_Wait;
  Result := MciSendCommand(DeviceID, MCI_Save, Flags, LongInt(@MciSave));

  MciSendCommand(DeviceID, Mci_Close, 0, LongInt(nil));

end;


begin
  WriteLn('Hello');
  RecordSound(10000);
  WriteLn('GoodBye');
end.