Program ButtonTest;
{***************************************************************************}
{*  Buttons.pas  by Daniel Thomas (CIS: 72301,2164)                        *}
{*                                                                         *}
{*    This code is hereby donated to tbe Public Domain.  Have fun!         *}
{*                                                                         *}
{*  Test program for the Buttons unit.  See that unit for details.         *}
{***************************************************************************}

USES WinTypes,WinProcs,WObjects,Buttons;

{$R ButnTest.res}

Const
  id_Button1 = 201;
  id_Button2 = 202;

Type
  tButtonTest=object(tApplication)
    procedure InitMainWindow; virtual;
  end;

  pMainWindow=^tMainWindow;
  tMainWindow=object(tWindow)
    Button1 : pSingleBitmapButton;
    Button2 : pMultiBitmapButton;
    Button1Enabled,
    Button2Enabled : bool;

    Constructor Init(aParent: pWindowsObject; aTitle: pChar);
    Procedure GetWindowClass(var WndClass :tWndClass); virtual;
    Function GetClassName: pChar; virtual;
    Procedure wmDrawItem(var Msg:tMessage);virtual wm_First+wm_DrawItem;
    Procedure bnButton1(var msg: tMessage); virtual id_first+id_Button1;
    Procedure bnButton2(var msg: tMessage); virtual id_first+id_Button2;
  end;

Constructor tMainWindow.Init(aParent: pWindowsObject; aTitle: pChar);

begin
  TWindow.Init(aParent,aTitle);
  Button1 := new(pSingleBitmapButton,Init(@self,id_Button1,20,20,false,'BN1'));
  Button2 := new(pMultiBitmapButton,Init(@self,id_Button2,200,20,false,
                 'MultiButtonUp','MultiButtonDown','MultiButtonDis'));
  Button1Enabled := true;
  Button2Enabled := true;
end; {Init}

PROCEDURE tMainWindow.GetWindowClass(var WndClass: tWndClass);

begin
  TWindow.GetWindowClass(WndClass);
  WndClass.lpszMenuName := 'ButtonTestMenu';
end; {GetWindowClass}

FUNCTION tMainWindow.GetClassName: pChar;

begin
  GetClassName := 'ButtonTest';
end; {GetClassName}

Procedure tMainWindow.wmDrawItem(var Msg:tMessage);

begin
  with pDrawItemStruct(Msg.lParam)^ do
    case CtlType of
        odt_Button:
          case CtlID of
              id_Button1 : Button1^.DrawItem(Msg);
              id_Button2 : Button2^.DrawItem(Msg);
          end;
    end;
end; {wmDrawItem}

Procedure tMainWindow.bnButton1(var msg: tMessage);

begin
  MessageBox(hWindow,'Button 1 clicked - will now either enable or disable the other button','ButtonTest',mb_Ok);
  Button2Enabled := not Button2Enabled;
  EnableWindow(Button2^.hWindow,Button2Enabled);
end; {bnButton1}

Procedure tMainWindow.bnButton2(var msg: tMessage);

begin
  MessageBox(hWindow,'Button 2 clicked - will now either enable or disable the other button','ButtonTest',mb_Ok);
  Button1Enabled := not Button1Enabled;
  EnableWindow(Button1^.hWindow,Button1Enabled);
end; {bnButton2}

Procedure tButtonTest.InitMainWindow;

begin
  MainWindow := new(pMainWindow,init(nil,'ButtonTest'));
end; {InitMainWindow}

Var
  wButtonTest: tButtonTest;

BEGIN
  wButtonTest.Init('ButtonTest');
  wButtonTest.Run;
  wButtonTest.Done;
END.
