PROGRAM ChopPCBoardDIRListings;
USES Dos;
CONST
     ProgData = 'BUSTX- Free DOS utility: Xevious ALLFILES.LST separator.';
     ProgDat2 = 'V1.00: July 14, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';

     Usage = 'Usage:  BUSTX source_file (must be in current directory)';

     File_Header = '====';
     PgHd = '508-875-3618';
     PgNo = 'Page Number:';
     PgHe = 'Created by FILELIST';
     FFeed = '';
     LSpace = '                                     ';
VAR
   ValidLine                : Boolean;
   InFilePath               : PathStr;
   InFileDir                : DirStr;
   InFileName               : NameStr;
   InFileExt                : ExtStr;
   HeaderCount              : Integer;
   Line_Current             : String[80];
   OutFileName              : String[8];
   OutFileExt               : String[3];
   OutFileName_Ext          : String[12];
   Source_File,Dest_File    : Text;

PROCEDURE GetNewOutFileExt;
VAR
   OutFileInc,ErrCode : Integer;
BEGIN
     Val(OutFileExt,OutFileInc,ErrCode);
     OutFileInc := Succ(OutFileInc);
     Str(OutFileInc,OutFileExt);
     WHILE Length(OutFileExt) < 3 DO
          OutFileExt := '0' + OutFileExt;
END;

PROCEDURE OpenOutFile;
BEGIN
     OutFileName_Ext := OutFileName + '.' + OutFileExt;
     Assign(Dest_File,OutFileName_Ext);
     Rewrite(Dest_File);
END;

PROCEDURE GetValidLine;
BEGIN
     ValidLine := False;
     WHILE ValidLine = False DO
     BEGIN
          ReadLn(Source_File,Line_Current);
          ValidLine := True;

      IF (Pos(PgHd,Line_Current) <> 0)
      OR (Pos(PgHe,Line_Current) <> 0)
      OR (Pos(PgNo,Line_Current) = 1)
      OR (Pos(FFeed,Line_Current) = 1) THEN
             ValidLine := False;

      IF (Pos(LSpace,Line_Current) = 1)
      OR (Line_Current = '') THEN
             ValidLine := False;

      IF (Length(Line_Current) = 32)
     AND (Pos('byte',Line_Current) = 0) THEN
             ValidLine := False;

      IF (Length(Line_Current) < 34)
     AND (Pos('byte',Line_Current) <> 0) THEN
             ValidLine := False;

          IF Eof(Source_File) THEN
             BEGIN
                  ValidLine := True;
                  HeaderCount := 3;
             END;
     END;
     IF Pos(File_Header,Line_Current) = 1 THEN
        HeaderCount := Succ(HeaderCount);
END;

BEGIN
     Writeln(ProgData);
     Writeln(ProgDat2);
     Writeln;
     If ParamCount <> 1 THEN Begin
        Writeln(Usage);
        Halt;
     End;

     InFilePath := ParamStr(1);
     Assign(Source_File,InFilePath);
{$I-} Reset(Source_File); {$I+}                         {Check if file exists.}
     IF (IOResult <> 0) THEN                            {If it                }
     BEGIN                                              {   doesn't, then     }
         Writeln('Unable to open "', InFilePath, '".'); { quit with message.  }
         Halt;
     END;


     FSplit(InFilePath, InFileDir, InFileName, InFileExt);
     OutFileName := InFileName;   {Using same name, but different extensions.}
     OutFileExt := '001';
     OpenOutFile;
     Writeln('Writing ',OutFileName_Ext);
     HeaderCount := 0;
     GetValidLine;

     WHILE NOT Eof(Source_File) DO
     BEGIN
          IF HeaderCount = 3 THEN
             BEGIN
                  GetNewOutFileExt;
                  OpenOutFile;
                  Writeln('Writing ',OutFileName_Ext);
                  HeaderCount := 1;
             END;

          WHILE HeaderCount <> 3 DO
          BEGIN
               WriteLn(Dest_File,Line_Current);
               GetValidLine;
          END;
          Close(Dest_File);
     END;
     Close(Source_File);
     Writeln('Done!');
END.
