Unit B_Arrays;

{Unit to demonstrate correct method of obtaining useable descendants}
{of the Generic BufferedArray Object.}

INTERFACE

Uses BuffAray;

Type
  BufferedIntArray = Object (BufferedArray)

                   Procedure Init (NumElements : LongInt;
                                   MaxBuffSize : LongInt; FileName : String);
                   Procedure Load (FileName : String; MaxBuffSize : LongInt);

                   {NOTE: Performing a LOAD should ONLY be done as a DIRECT}
                   {      substitution for performing an INIT operation}
                   {      Of course, CREATE should be used first.}


                   Procedure Accept (I : Integer; Index : LongInt);
                   Procedure Retrieve (Var I : Integer; Index : LongInt);
                   Procedure Copy (Var From : BufferedIntArray);

(* ***** These Methods need no redefinition
         copied here only for clarity

                   Procedure Create;
                   Procedure Destroy;
                   Procedure Store;

                   {NOTE: Performing a STORE has the same effect as}
                   {      performing a DESTROY, accept the data is}
                   {      saved in the filename given when performing INIT}

           {FileNames May be up to 65 characters long, and may conist
            of Directory and Path information as well as name and extension.
            To Load, BufferedAray MUST be ONLY CREATEd (or DESTROYed)}

                   Procedure Swap (I,J : LongInt);
                   Function MaxSize : LongInt;
                   Function ElemSize : Word;
  ***** *)

                End; {BufferedIntArray}

  BufferedRealArray = Object (BufferedArray)

                   Procedure Init (NumElements : LongInt;
                                   MaxBuffSize : LongInt; FileName : String);
                   Procedure Load (FileName : String; MaxBuffSize : LongInt);
                   Procedure Accept (I : Real; Index : LongInt);
                   Procedure Retrieve (Var I : Real; Index : LongInt);
                   Procedure Copy (Var From : BufferedRealArray);

                End; {BufferedRealArray}

IMPLEMENTATION

Procedure BufferedIntArray.Init (NumElements : LongInt;
                              MaxBuffSize : LongInt; FileName : String);
Begin
  BufferedArray.Init (NumElements,SizeOf(Integer),MaxBuffSize,FileName)
End;

Procedure BufferedIntArray.Load (FileName : String; MaxBuffSize : LongInt);
Begin
  BufferedArray.Load (FileName,SizeOf(Integer),MaxBuffSize)
End;

Procedure BufferedIntArray.Accept (I : Integer; Index : LongInt);
Var
  Temp : Integer;
Begin
  Temp := I;
  BufferedArray.Accept (Temp,Index,SizeOf(Integer))
End;

Procedure BufferedIntArray.Retrieve (Var I : Integer; Index : LongInt);
Begin
  BufferedArray.Retrieve (I,Index,SizeOf(Integer))
End;

Procedure BufferedIntArray.Copy (Var From : BufferedIntArray);
Begin
  BufferedArray.Copy (From)
End;

(*************************************************************************)
Procedure BufferedRealArray.Init (NumElements : LongInt;
                              MaxBuffSize : LongInt; FileName : String);
Begin
  BufferedArray.Init (NumElements,SizeOf(Real),MaxBuffSize,FileName)
End;

Procedure BufferedRealArray.Load (FileName : String; MaxBuffSize : LongInt);
Begin
  BufferedArray.Load (FileName,SizeOf(Real),MaxBuffSize)
End;

Procedure BufferedRealArray.Accept (I : Real; Index : LongInt);
Var
  Temp : Real;
Begin
  Temp := I;
  BufferedArray.Accept (Temp,Index,SizeOf(Real))
End;

Procedure BufferedRealArray.Retrieve (Var I : Real; Index : LongInt);
Begin
  BufferedArray.Retrieve (I,Index,SizeOf(Real))
End;

Procedure BufferedRealArray.Copy (Var From : BufferedRealArray);
Begin
  BufferedArray.Copy (From)
End;

(*************************************************************************)

BEGIN
END.
