Program Test_NDimensional_BufferedArrays;

Uses Crt,BD2Array,BD3Array,BD4Array;

Const
  MaxBuff  = 0;   {Force Maximum available Buffer size}
  MaxOne   = 24;
  MaxTwo   = 25;
  MaxThree = 26;
  MaxFour  = 2;

Var
  I,J,K,L : LongInt;
  Value   : Integer;
  RealVal : Real;
  Space2  : BD2_IntArray;
  Space3  : BD3_IntArray;
  Space4  : BD4_IntArray;
  Space5  : BD3_RealArray;

Begin
  ClrScr;
  WriteLn ('2 Dimensional BufferedArray (Integers) Test');
  WriteLn ('Before Initialization Memory Available = ',MemAvail);
  Space2.Init (MaxOne,MaxTwo,MaxBuff,'test.dat');
  WriteLn ('After Initialization Memory Available = ',MemAvail);
  WriteLn ('OverHead for 2D BufferedArray = ',SizeOf(Space2),' Bytes');
  WriteLn;
  WriteLn ('Allocated ',Space2.MaxSize,' Elements');
  Value := 0;
  For I := 0 to Space2.MaxIndex(1) do
    For J := 0 to Space2.MaxIndex(2) do
      Begin
        Value := Value + 1;
        GoToXY (1,10);
        WriteLn ('Assigning Element ',I:4,J:4);
        Space2.Accept (I,J,Value)
      End;

  Space2.Store;
  Space2.Load ('test.dat',MaxOne,MaxTwo,MaxBuff);

  For I := 0 to Space2.MaxIndex(1) do
    For J := 0 to Space2.MaxIndex(2) do
      Begin
        GoToXY (1,12);
        Write ('Retrieving Element ',I:4,J:4,'  Value is : ');
        Space2.Retrieve (I,J,Value);
        WriteLn (Value:7)
      End;
  WriteLn;
  Write ('Press <Enter>/<Return> to Continue...');
  ReadLn;
  Space2.Destroy;

  ClrScr;
  WriteLn ('3 Dimensional BufferedArray (Integers) Test');
  WriteLn ('Before Initialization Memory Available = ',MemAvail);
  Space3.Init (MaxOne,MaxTwo,MaxThree,MaxBuff,'test.dat');
  WriteLn ('After Initialization Memory Available = ',MemAvail);
  WriteLn ('OverHead for 3D BufferedArray = ',SizeOf(Space3),' Bytes');
  WriteLn;
  WriteLn ('Allocated ',Space3.MaxSize,' Elements');
  Value := 0;
  For I := 0 to Space3.MaxIndex(1) do
    For J := 0 to Space3.MaxIndex(2) do
      For K := 0 to Space3.MaxIndex(3) do
        Begin
          Value := Value + 1;
          GoToXY (1,10);
          WriteLn ('Assigning Element ',I:4,J:4,K:4);
          Space3.Accept (I,J,K,Value)
        End;

  Space3.Store;
  Space3.Load ('test.dat',MaxOne,MaxTwo,MaxThree,MaxBuff);

  For I := 0 to Space3.MaxIndex(1) do
    For J := 0 to Space3.MaxIndex(2) do
      For K := 0 to Space3.MaxIndex(3) do
        Begin
          GoToXY (1,12);
          Write ('Retrieving Element ',I:4,J:4,K:4,'  Value is : ');
          Space3.Retrieve (I,J,K,Value);
          WriteLn (Value:7)
        End;
  WriteLn;
  Write ('Press <Enter>/<Return> to Continue...');
  ReadLn;
  Space3.Destroy;

  ClrScr;
  WriteLn ('3 Dimensional BufferedArray (Reals) Test');
  WriteLn ('Before Initialization Memory Available = ',MemAvail);
  Space5.Init (MaxOne,MaxTwo,MaxThree,MaxBuff,'test.dat');
  WriteLn ('After Initialization Memory Available = ',MemAvail);
  WriteLn ('OverHead for 3D BufferedArray = ',SizeOf(Space5),' Bytes');
  WriteLn;
  WriteLn ('Allocated ',Space5.MaxSize,' Elements');
  Value := 0;
  For I := 0 to Space5.MaxIndex(1) do
    For J := 0 to Space5.MaxIndex(2) do
      For K := 0 to Space5.MaxIndex(3) do
        Begin
          Value := Value + 1;
          GoToXY (1,10);
          WriteLn ('Assigning Element ',I:4,J:4,K:4);
          RealVal := Value;
          Space5.Accept (I,J,K,RealVal)
        End;

  Space5.Store;
  Space5.Load ('test.dat',MaxOne,MaxTwo,MaxThree,MaxBuff);

  For I := 0 to Space5.MaxIndex(1) do
    For J := 0 to Space5.MaxIndex(2) do
      For K := 0 to Space5.MaxIndex(3) do
        Begin
          GoToXY (1,12);
          Write ('Retrieving Element ',I:4,J:4,K:4,'  Value is : ');
          Space5.Retrieve (I,J,K,RealVal);
          WriteLn (RealVal:7:2)
        End;
  WriteLn;
  Write ('Press <Enter>/<Return> to Continue...');
  ReadLn;
  Space5.Destroy;

  ClrScr;

  {NOTE: Due to the nature of the BufferedArray Object, greatest efficiency
         is achieved by accessing in "reverse order" as is incorporated in
         the 4-Dimensional example below.  This is increasingly true as the
         total number of elements increases.  This access order minimizes
         internal buffer flushing and reloading for "sequential" access, and
         promises no benefit at all for random accessing of such arrays.}

  WriteLn ('4 Dimensional BufferedArray (Integers) Test');
  WriteLn ('Before Initialization Memory Available = ',MemAvail);
  Space4.Init (MaxOne,MaxTwo,MaxThree,MaxFour,MaxBuff,'test.dat');
  WriteLn ('After Initialization Memory Available = ',MemAvail);
  WriteLn ('OverHead for 4D BufferedArray = ',SizeOf(Space4),' Bytes');
  WriteLn;
  WriteLn ('Allocated ',Space4.MaxSize,' Elements');
  WriteLn;
  WriteLn ('"Reverse-Order" Accessing for greatest efficiency');
  Value := 0;
  Writeln (Space4.MaxIndex(4));
  For I := 0 to Space4.MaxIndex(4) do
    For J := 0 to Space4.MaxIndex(3) do
      For K := 0 to Space4.MaxIndex(2) do
        For L := 0 to Space4.MaxIndex(1) do
          Begin
            Value := Value + 1;
            GoToXY (1,10);
            WriteLn ('Assigning Element ',L:4,K:4,J:4,I:4);
            Space4.Accept (L,K,J,I,Value)
          End;

  Space4.Store;
  Space4.Load ('test.dat',MaxOne,MaxTwo,MaxThree,MaxFour,MaxBuff);

  For I := 0 to Space4.MaxIndex(4) do
    For J := 0 to Space4.MaxIndex(3) do
      For K := 0 to Space4.MaxIndex(2) do
        For L := 0 to Space4.MaxIndex(1) do
          Begin
            GoToXY (1,12);
            Write ('Retrieving Element ',L:4,K:4,J:4,I:4,'  Value is : ');
            Space4.Retrieve (L,K,J,I,Value);
            WriteLn (Value:7)
          End;
  WriteLn;
  Write ('Press <Enter>/<Return> to Continue...');
  ReadLn;
  Space4.Destroy

End.