Unit BD3Array;  {Useable 3-Dimensional BufferedArrays}
{$R-}

INTERFACE
Uses BD3_Max;

Type
  BD3_IntArray = Object (D3_BufferedArray)

                   Procedure Init (Max1,Max2,Max3,MaxBuffSize : LongInt;
                                  FileName : String);

                   { BD3_xxxArrays are indexed 0..Max1-1, 0..Max2-1, 0..Max3-1}

                   Procedure Load (FileName : String;
                                   Max1,Max2,Max3,MaxBuffSize : LongInt);

                   Procedure Accept (X,Y,Z : LongInt; I : Integer);

                   Procedure Retrieve (X,Y,Z : LongInt; Var I : Integer);

                   {NOTE: There is no reason why Retrieve could not be}
                   {redefined as a function for atomic types such as Integer}

                   Procedure Copy (From : BD3_IntArray);
                              {Target *MUST* already be initialized}
                              {to the EXACT same parameters as From}
                              {this will save checking for sufficient}
                              {available Memory!}

(* no redefinition needed

                   Procedure Store;

                   Procedure Swap (X1,Y1,Z1,X2,Y2,Z2 : LongInt);
                              {Swap the 1 and 2 Element}

                   Function MaxIndex (Index : Byte) : LongInt;
                                     {Return the Max legal Index}
                                     {for the Indexth Dimension}

                   Function MaxSize : LongInt;
                                      {Report Number of Array Elements}
                   Function ElemSize : Word;  {Report Element Size}
                   Procedure Destroy;
*)
          End; {BD3_IntArray}

  BD3_RealArray = Object (D3_BufferedArray)

                   Procedure Init (Max1,Max2,Max3,MaxBuffSize : LongInt;
                                  FileName : String);

                   Procedure Load (FileName : String;
                                   Max1,Max2,Max3,MaxBuffSize : LongInt);

                   Procedure Accept (X,Y,Z : LongInt; I : Real);

                   Procedure Retrieve (X,Y,Z : LongInt; Var I : Real);

                   Procedure Copy (From : BD3_RealArray);

          End; {BD3_RealArray}

IMPLEMENTATION

Uses BND_Max;  {Obtain the definition of the DimensionPtr Type}

Procedure BD3_IntArray.Init;
{NOTE: If ANY of the Max's is zero, ND_MAX.INIT will attempt}
{to determine and allocate the maximum possible index.  If all}
{are zero, then the largest possible evenly-indexed array will be allocated}
{There is a POSSIBILITY of allocation errors if less than all are}
{zero, but such errors will be detected and reported}
Var
  Temp : DimensionPtr;
  I    : Byte;
Begin
  I := 0;
  GetMem (Temp,3*SizeOf(LongInt));
  Temp^[I] := Max1; I := 1;  {Have to fool the compiler, even}
  Temp^[I] := Max2; I := 2;  {with Range-checking off!!}
  Temp^[I] := Max3;
  D3_BufferedArray.Init (Temp,SizeOf(Integer),MaxBuffSize,FileName);
  FreeMem (Temp,3*SizeOf(LongInt));
End;

Procedure BD3_IntArray.Load;
Var
  Temp : DimensionPtr;
  I    : Byte;
Begin
  I := 0;
  GetMem (Temp,3*SizeOf(LongInt));
  Temp^[I] := Max1; I := 1;  {Have to fool the compiler, even}
  Temp^[I] := Max2; I := 2;  {with Range-checking off!!}
  Temp^[I] := Max3;
  D3_BufferedArray.Load (FileName,SizeOf(Integer),MaxBuffSize,3,Temp);
  FreeMem (Temp,3*SizeOf(LongInt));
End;

Procedure BD3_IntArray.Accept (X,Y,Z : LongInt; I : Integer);
Var
  Temp : Integer;
Begin
  Temp := I;
  D3_BufferedArray.Accept (X,Y,Z,Temp,SizeOf(Integer))
End;

Procedure BD3_IntArray.Retrieve (X,Y,Z : LongInt; Var I : Integer);
Var
  Temp : Integer;
Begin
  D3_BufferedArray.Retrieve (X,Y,Z,Temp,SizeOf(Integer));
  I := Temp
End;

Procedure BD3_IntArray.Copy (From : BD3_IntArray);
{Redefined purely for type-checking}
Begin
  D3_BufferedArray.Copy (From)
End;

{**********************************************************************}

Procedure BD3_RealArray.Init;
Var
  Temp : DimensionPtr;
  I    : Byte;
Begin
  I := 0;
  GetMem (Temp,3*SizeOf(LongInt));
  Temp^[I] := Max1; I := 1;  {Have to fool the compiler, even}
  Temp^[I] := Max2; I := 2;  {with Range-checking off!!}
  Temp^[I] := Max3;
  D3_BufferedArray.Init (Temp,SizeOf(Real),MaxBuffSize,FileName);
  FreeMem (Temp,3*SizeOf(LongInt));
End;

Procedure BD3_RealArray.Load;
Var
  Temp : DimensionPtr;
  I    : Byte;
Begin
  I := 0;
  GetMem (Temp,3*SizeOf(LongInt));
  Temp^[I] := Max1; I := 1;  {Have to fool the compiler, even}
  Temp^[I] := Max2; I := 2;  {with Range-checking off!!}
  Temp^[I] := Max3;
  D3_BufferedArray.Load (FileName,SizeOf(Real),MaxBuffSize,3,Temp);
  FreeMem (Temp,3*SizeOf(LongInt));
End;

Procedure BD3_RealArray.Accept (X,Y,Z : LongInt; I : Real);
Var
  Temp : Real;
Begin
  Temp := I;
  D3_BufferedArray.Accept (X,Y,Z,Temp,SizeOf(Real))
End;

Procedure BD3_RealArray.Retrieve (X,Y,Z : LongInt; Var I : Real);
Var
  Temp : Real;
Begin
  D3_BufferedArray.Retrieve (X,Y,Z,Temp,SizeOf(Real));
  I := Temp
End;

Procedure BD3_RealArray.Copy (From : BD3_RealArray);
Begin
  D3_BufferedArray.Copy (From)
End;

BEGIN
END.