Unit BD2Array;  {Useable 2-Dimensional BufferedArrays}
{$R-}

INTERFACE
Uses BD2_Max;

Type
  BD2_IntArray = Object (D2_BufferedArray)

                   Procedure Init (Max1,Max2,MaxBuffSize : LongInt;
                                  FileName : String);

                   { BD2_xxxArrays are indexed 0..Max1-1, 0..Max2-1}

                   Procedure Load (FileName : String;
                                   Max1,Max2,MaxBuffSize : LongInt);

                   Procedure Accept (X,Y : LongInt; I : Integer);

                   Procedure Retrieve (X,Y : LongInt; Var I : Integer);

                   {NOTE: There is no reason why Retrieve could not be}
                   {redefined as a function for atomic types such as Integer}

                   Procedure Copy (From : BD2_IntArray);
                              {Target *MUST* already be initialized}
                              {to the EXACT same parameters as From}
                              {this will save checking for sufficient}
                              {available Memory!}

(* no redefinition needed

                   Procedure Store;

                   Procedure Swap (X1,Y1,X2,Y2 : LongInt);
                              {Swap the 1 and 2 Element}

                   Function MaxIndex (Index : Byte) : LongInt;
                                     {Return the Max legal Index}
                                     {for the Indexth Dimension}

                   Function MaxSize : LongInt;
                                      {Report Number of Array Elements}
                   Function ElemSize : Word;  {Report Element Size}
                   Procedure Destroy;
*)
          End; {BD2_IntArray}

IMPLEMENTATION

Uses BND_Max;  {Obtain the definition of the DimensionPtr Type}

Procedure BD2_IntArray.Init;
{NOTE: If ANY of the Max's is zero, ND_MAX.INIT will attempt}
{to determine and allocate the maximum possible index.  If all}
{are zero, then the largest possible evenly-indexed array will be allocated}
{There is a POSSIBILITY of allocation errors if less than all are}
{zero, but such errors will be detected and reported}
Var
  Temp : DimensionPtr;
  I    : Byte;
Begin
  I := 0;
  GetMem (Temp,2*SizeOf(LongInt));
  Temp^[I] := Max1; I := 1;  {Have to fool the compiler, even}
  Temp^[I] := Max2;          {with Range-checking off!!}
  D2_BufferedArray.Init (Temp,SizeOf(Integer),MaxBuffSize,FileName);
  FreeMem (Temp,2*SizeOf(LongInt));
End;

Procedure BD2_IntArray.Load;
Var
  Temp : DimensionPtr;
  I    : Byte;
Begin
  I := 0;
  GetMem (Temp,2*SizeOf(LongInt));
  Temp^[I] := Max1; I := 1;  {Have to fool the compiler, even}
  Temp^[I] := Max2;          {with Range-checking off!!}
  D2_BufferedArray.Load (FileName,SizeOf(Integer),MaxBuffSize,2,Temp);
  FreeMem (Temp,2*SizeOf(LongInt));
End;

Procedure BD2_IntArray.Accept (X,Y : LongInt; I : Integer);
Var
  Temp : Integer;
Begin
  Temp := I;
  D2_BufferedArray.Accept (X,Y,Temp,SizeOf(Integer))
End;

Procedure BD2_IntArray.Retrieve (X,Y : LongInt; Var I : Integer);
Var
  Temp : Integer;
Begin
  D2_BufferedArray.Retrieve (X,Y,Temp,SizeOf(Integer));
  I := Temp
End;

Procedure BD2_IntArray.Copy (From : BD2_IntArray);
{Redefined purely for type-checking}
Begin
  D2_BufferedArray.Copy (From)
End;

BEGIN
END.