Unit TpwBtr;  
{*****************************************************************}
{Unit for Windows Btrieve to be called by Turbo Pascal For Windows}          

{This unit defines 3 Btrieve functions which can be called from   }
{Windows, 1 for initializing either the local DLL or the requestor}
{DLL, 1 for clearing an instance of Btrieve, and 1 for making     }
{standard Btrieve operation calls.                                }
                                                       
{While you can make calls to the DLL functions directly, this unit}
{can help make your Windows Btrieve calls look like those in Dos. }
{If you choose to make direct calls to the DLL, just use the      }
{external function definitions given in the implementation section}
{below.                                                           }

{NOTE: This interface is a BETA version. Due to the demand for    }
{for this document, it has not been through the normal testing    }
{procedures. Please report any problems to Novell Technical       }
{Support via Netwire on Compuserve (Account # 76701,171) or via   }
{FAX (# 512-345-7478)                                             }

{*****************************************************************}


Interface
  {**********************************************************}
  {These are the Btrieve functions called by your application}
  {**********************************************************}

  {Standard Btrieve Operation Call}
  Function Btrv(    Operation : integer;
                var PositionBlock,
                    DataBuffer;
                var DataLen : word;
                var KeyBuffer;
                    KeyNumber     : byte): integer;
 
  {Initializes the local DLL}
  Function BtrvInit(Var InitializationString): Integer;

  {Stops this instance of Btrieve}
  Function BtrvStop: Integer;

  {This function is currently not supported. You initialize brequest.exe
   when you load it before loading Windows. Therefore, there is no need
   to initialize the WBTRCALL.DLL requestor from your Windows application.
   Separate initialization for each task using the requestor may be supported
   at a later time.}
   
  Function BRqShellInit(Var InitializationString): Integer;

Implementation
  {**********************************************************}
  {Define all of the actual WBTRCALL.DLL functions           }
  {**********************************************************}

  {Standard Btrieve Operation Call}
  Function Btrcall (  Operation: integer;
		  var posblk,
                      databuf;
                  var datalen   : word;
                  var keybuf;
		      keylen    :  byte;
		      keynum    :  byte): integer; far;
                       external 'WBTRCALL'  index 1;


  {This is a dummy function. It currently serves no purpose}
  Function WBShellInit(Var InitializationString): Integer; far;
                       external 'WBTRCALL'  index 2;

  {Initializes the local DLL}
  Function WBtrvInit(Var IntializationString): Integer;  far;
                       external 'WBTRCALL'  index 3;

  {Clears all internal Btrieve tables for this process}
  Function WBtrvStop: Integer;  far;
                       external 'WBTRCALL'  index 4;

  {This function is currently not supported. You initialize brequest.exe
   when you load it before loading windows. Therefore, there is no need
   to initialize the WBTRCALL.DLL requestor from your Windows application}
  Function WBRqShellInit(Var InitializationString): Integer; far;
                       external 'WBTRCALL'  index 5;



  {**********************************************************}
  {Now define the functions which call the DLL               }
  {**********************************************************}

  {Standard Btrieve Operation Call}
  Function Btrv (   Operation   : integer;
                var PositionBlock,
                    DataBuffer;
                var DataLen     : word;
                var KeyBuffer;
                    KeyNumber   : byte): integer;
  Var
    KeyLen: Byte;

  Begin
    KeyLen:= 255;                       {maximum key length}
    Btrv := BtrCall(Operation,  PositionBlock,  DataBuffer,
                    DataLen,    KeyBuffer,      KeyLen,
                    KeyNumber);
  End; {Btrv}

 
  {Initializes the local DLL}
  Function BtrvInit (Var InitializationString): Integer;
  Begin
    BtrvInit := WBtrvInit (InitializationString);
  End; {End BtrvInit}


  {Stops this instance of Btrieve}
  Function BtrvStop: Integer;
  Begin
    BtrvStop:= WBtrvStop;
  End; {End BtrvStop}


  {Initializes the requestor DLL}
  Function BRqShellInit(Var InitializationString): Integer;
  Begin
    BRqShellInit:= WBRqShellInit(InitializationString);
  End; {End BRqShellInit}

 
Begin
End.

