PROGRAM Create1;              { (C) 1993 John C. Leon    last updated 6/8/93 }

{
Creates an arbitrarily structured empty Btrieve file of record length 38 with
3 keys.  This file, which you must name EXAMPLE when you run this program,
will be used by the EXAMPLE1 and EXAMPLE2 programs.  The keys are interpreted 
by the EXAMPLE1 and EXAMPLE2 programs as follows:

   Key 0: 20 positions, an LString (Pascal string), representing LAST NAME
   Key 1: 10 positions, an LString (Pascal string), representing FIRST NAME
   Key 2:  8 positions, a Float (which when sized to 8 positions is an IEEE
                                 double, and can be used directly as such in
                                 Pascal or C/C+), representing Salary

Illustrates the use of PFileSpecObj in the BTP unit to greatly assist in
setting up the filespec in memory required for the CreateFile function.  See
CREATE2.PAS for sample code using the CreateFile function with an alternate
collating sequence and an owner name, and for sample code for adding
supplemental indexes.
}

{$IFDEF production} {$D-,R-,L-,S-} {$ENDIF}

USES
   BTP;

VAR
   Counter,
   Counter1   : integer;
   MyFileSpec : PFileSpecObj;
   MyFileName : string;

BEGIN
   if not IsBtrieveLoaded then
      begin
      writeln;
      writeln('Please load Btrieve before running this program.');
      halt(1);
      end;

   write('Enter name of file to create: ');
   readln(MyFileName);
   if MyFileName = '' then
      begin
      writeln('No filename entered...aborting');
      halt(2);
      end;

   {Setup the file specs as: record length  38,
                             page size     512,
                             # keys          3,
                             file flags      0,
                             pre-allocation  0 }

   {MyFileSpec internally puts all parameters into a properly formatted
    memory buffer, accessible as MyFileSpec^.Specs}

   MyFileSpec := new(PFileSpecObj, Init(38, 512, 3, 0, 0,
                     NewKeySpec(11, 20, Duplicates or Modifiable or ExtType,
                                BLString,
                     NewKeySpec(1, 10, Duplicates or Modifiable or ExtType,
                                BLString,
                     NewKeySpec(31, 8, Duplicates or Modifiable or ExtType,
                                BFloat,
                                nil)))));

   BStatus := CreateFile(MyFileName, MyFileSpec^.Specs, '', '', 0);
                              {                         |   |   | }
                              { no alt coll sequence    -   |   | }
                              { no owner name               -   | }
                              { owner name access               - }
   
   dispose(MyFileSpec, Done);
   
   if BStatus <> 0 then
     writeln('Error creating file.  Status = ', BStatus)
     else
     begin
     for Counter := 1 to length(MyFileName) do
        MyFileName[Counter] := upcase(MyFileName[Counter]);
     writeln('File ', MyFileName, ' created successfully.');
     end;
END.
