PROGRAM Stats;                 { (C) 1993 John C. Leon   last updated 6/8/93 }

{
This program will report stats on ANY Btrieve file; it is intended to provide
the same functionality (and then some) of the "BUTIL -STAT" function.  Just
supply the name of any valid Btrieve file on the command line, followed by an
owner name if the file requires one.
}

{$IFDEF production} {$D-,R-,L-,S-} {$ENDIF}

USES
   BTP;  

CONST
   HasDescKey      : boolean = false;
   HasSupplemental : boolean = false;
   PriorSegmented  : boolean = false;
   KeyCount        : integer = 0;

TYPE
   PStatFile   = ^TStatFile;
   TStatFile   = object(BFile)
                    KeyType: string;
                    procedure SetKeyType(KFlags: integer; EType: byte);
                    end;

VAR
   StatFile       : PStatFile;
   StatFileName,
   OwnerName,
   KeyType, TempS,
   S1, S2         : string;
   Counter        : integer;

procedure TStatFile.SetKeyType(KFlags: integer; EType: byte);
begin
if (KFlags and Binary) = Binary then
   KeyType := 'Unsigned'
   else
   begin
   case EType of
       0: KeyType := 'String  ';
       1: KeyType := 'Integer ';
       2: KeyType := 'Float   ';
       3: KeyType := 'Date    ';
       4: KeyType := 'Time    ';
       5: KeyType := 'Decimal ';
       6: KeyType := 'Money   ';
       7: KeyType := 'Logical ';
       8: KeyType := 'Numeric ';
       9: KeyType := 'Bfloat  ';
      10: KeyType := 'Lstring ';
      11: KeyType := 'Zstring ';
      14: KeyType := 'Unsigned';
      15: KeyType := 'AutoInc ';
      end;
   end;
end;

procedure PrintNotices;
begin
   writeln;
   writeln('BTP Stats - Version 2.0 - (C) 1993 John C. Leon.  All Rights Reserved.');
   writeln;
   writeln('File stats for ', StatFileName);
   writeln;
end;


procedure DoFileStatLine;
begin
   if length(S1) < 37 then
      for Counter := length(S1) to 37 do
         S1 := S1 + ' ';
   writeln(S1, S2);
end;

procedure PrintFileHeaderStats;
begin
   with StatFile^ do
   begin
      str(Specs.RecLen, TempS);
      S1 :=('Record length    = ' + TempS);
      S2 := 'Variable Length  = ';
      if (Specs.FileFlags and VarLength) = VarLength then
         begin
         S2 := S2 + 'Yes  Free Space = ';
         case (Specs.FileFlags SHR 6) of          {get to free threshold bits}
            0: S2 := S2 + 'N/A';              {not created w/a threshold flag}
            1: S2 := S2 + '10%';              {if Specs.FileFlags and 64 = 64}
            2: S2 := S2 + '20%';            {if Specs.FileFlags and 128 = 128}
            3: S2 := S2 + '30%';            {if Specs.FileFlags and 192 = 192}
            end;
         end
         else
         S2 := S2 + 'No';
      DoFileStatLine;
      str(Specs.NumKeys, TempS);
      S1 := 'Number keys/segs = ' + TempS + ' / ';
      str(NumSegs, TempS);
      S1 := S1 + TempS;
      S2 := 'Blank Truncation = ';
      if (Specs.FileFlags and BlankTrunc) = BlankTrunc then
         S2 := S2 + 'Yes' else S2 := S2 + 'No';
      DoFileStatLine;
      str(Specs.UnusedPgs, TempS);
      S1 := 'Unused pages     = ' + TempS;
      S2 := 'Preallocation    = ';
      if (Specs.FileFlags and PreAllocate) = PreAllocate then
         begin
         str(Specs.PreAlloc, TempS);
         S2 := S2 + 'Yes  Pages = ' + TempS;
         end
         else
         S2 := S2 + 'No ';
      DoFileStatLine;
      str(Specs.PageSize, TempS);
      S1 := 'Page size        = ' + TempS;
      S2 := 'Data Compression = ';
      if (Specs.FileFlags and DataComp) = DataComp then
         S2 := S2 + 'Yes' else S2 := S2 + 'No';
      DoFileStatLine;
      str(NumRecs, TempS);
      S1 := 'Number records   = ' + TempS;
      S2 := 'Key Only File    = ';
      if (Specs.FileFlags and KeyOnly) = KeyOnly then
         S2 := S2 + 'Yes' else S2 := S2 + 'No';
      DoFileStatLine;
   end;
end;

procedure PrintFileSegmentStats;
begin
   with StatFile^ do
   begin
      writeln;
      write('Key  Position  Length  Duplicates  Modifiable   Type    ');
      writeln('Null    Total');
      writeln;

      for Counter := 1 to NumSegs do
         with Specs.KeyArray[Counter-1] do
            begin
            write(KeyCount:3);
            if (KeyFlags and Supplemental) = Supplemental then
               begin
               write('S');
               HasSupplemental := true;
               end
               else
               write(' ');
            write(KeyPos:7, KeyLen:8, '        ');
            if (KeyFlags and Segmented) = Segmented then
               PriorSegmented := true
               else
               PriorSegmented := false;
            if ((KeyFlags and Segmented) <> Segmented) and
               (PriorSegmented = false) then inc(KeyCount);
            if (KeyFlags and Duplicates) = Duplicates then
               write('Yes') else write(' No');
            if (KeyFlags and Modifiable) = Modifiable then
               write('         Yes   ') else write('         No    ');
            SetKeyType(KeyFlags, ExtKeyType);
            if (KeyFlags and AltCol) = AltCol then
               write(' *', KeyType) else write('  ', KeyType);
            if (KeyFlags and Descending) = Descending then
               begin
               write(' <');
               HasDescKey := true;
               end
               else
               write('  ');
            if (KeyFlags and Null) = Null then
               write(NullValue) else write('--');
            write(NumUnique: 10);
            writeln;
            if ((Counter = 10) and (Counter < NumSegs)) then
               begin
               writeln;
               writeln('-- press Enter to continue');
               readln; writeln;
               end;
            end;                           {with Specs.KeyArray[Counter-1] do}

      if HasAltCol then
         begin
         writeln;
         write('* Alternate Collating Sequence is: ');
         for Counter := 1 to 8 do
            write(AltColName[Counter]);
         end;

      if HasDescKey then
         begin
         writeln;
         write('< Indicates descending key segment');
         end;

      if HasSupplemental then
         begin
         writeln;
         write('S Indicates supplemental key');
         end;

      writeln;

   end;
end;


BEGIN

   if IsBtrieveLoaded = false then
      begin
      writeln('Please load Btrieve before running this program.');
      halt(1);
      end;

   {get filename to act on and store it in uppercase}
   if (paramcount < 1) then
      begin
      writeln;
      writeln('USAGE: STATS filename <owner name>');
      writeln('       A filename is required.  The optional owner name is');
      writeln('       required only if the file itself requires one.');
      halt(2);
      end;

   StatFileName := paramstr(1);
   for Counter := 1 to length(StatFileName) do
      StatFileName[Counter] := upcase(StatFileName[Counter]);

   OwnerName := '';
   if paramcount >= 2 then
      OwnerName := paramstr(2);

   {open the file in read only mode}
   StatFile := new(PStatFile, Init(StatFileName, ReadOnly, OwnerName));

   if BStatus <> 0 then
      begin
      dispose(StatFile, Done);
      writeln('Error opening Btrieve file.  Program terminated.');
      writeln('Status code: ', BStatus);
      if BStatus = 51 then
         begin
         writeln;
         writeln('File appears to require an owner name for access, OR');
         writeln('the owner name you provided is incorrect, OR');
         writeln('you provided an owner name when none is needed.');
         writeln('Remember that owner names are case sensitive!');
         end;
      halt(3);
      end;

   StatFile^.Close;       {We have the stats encapsulated, so close the file.}
   PrintNotices;          {Display copyright and Btrieve file name.}
   PrintFileHeaderStats;
   PrintFileSegmentStats;
   dispose(StatFile, Done);

END.
