{$B-} { Short circuit boolean evaluation }
{$I-} { I/O checking    OFF   }
{$R-} { Range checking  OFF   }
{$S-} { Stack checking  OFF   }
{$V-} { Var-str check   OFF   }

{==========================================================================

    Display status information for B Plus Protocol

    This Unit contains routines for displaying various status items.
    They are called from BPLUS.PAS.

    Author:       Russ Ranshaw, CompuServe Incorporated

    Ownership:    Public Domain

    Created:      19 Apr 88

History:
        19-Sep-88    RWR
                     - Added ST_Display_Time_of_Day.

        01-Jun-88    RWR
                     - Added ST_Time_String function.

        09-Jun-88    RWR
                     - Added PWINDOW usage to save the screen contents
                     - Added "gingerbread" to the status window

=========================================================================}
UNIT BPStatus ;

INTERFACE

USES
  Dos,
  Cursors,
  Crt ;

CONST
  UnitVersion           = '1.03';
  UnitVerDate           = '19 Sep 88';
  Abort_Key             = 27;              { ESC }

TYPE
  STStringType          = string [255];
  STItemType            = (STUpDow, STFile, STType, STMsg, STPrompt,
                           STComRead, STComSent, STDataRead, STDataSent,
                           STDowSize, STUplSize, STDowRem, STUplRem,
                           STComRate, STDataRate, STRemTime, STElapsed,
			   STPacRead, STPacSent, STErrRead, STErrSent);

{ Initialize the Status Display }
PROCEDURE ST_Initialize;

{ Display a Status String }
PROCEDURE ST_Display_String (Item : STItemType; S : STStringType);

{ Convert Seconds to HH:MM:SS as a string }
FUNCTION ST_Time_String (Seconds: LongInt) : STStringType;

{ Display a Numeric Value }
PROCEDURE ST_Display_Value (Item : STItemType; Value : longint);

{ Display the Time of Day }
PROCEDURE ST_Display_Time_of_Day;

{ Terminate the Status Window }
PROCEDURE ST_Terminate;

{ Test if user wishes to abort the transfer }
FUNCTION ST_Check_Abort : Boolean;

{ Display a prompt and get a string }
PROCEDURE ST_Prompt (Prompt_String : STStringType; var Prompt_Return : STStringType);

{ Display a prompt and get a Yes/No "hot key" response }
PROCEDURE ST_Yes_or_No (Prompt_String : STStringType; var Prompt_Return : char);

{==================================================================}

IMPLEMENTATION

{$L Pwindow}
Type
  BufferType = ARRAY[1..4000] OF BYTE;


{$F+}
Procedure WGet(x, y, w, h: byte; VAR buffer: buffertype); external;
Procedure WPut(x, y, w, h: byte; VAR buffer: buffertype); external;
{$F-}


CONST
           { Window border graphics }
  Ch_Top_Left     = $c9; {}
  Ch_Bottom_Left  = $c8; {}
  Ch_Top_Right    = $bb; {}
  Ch_Bottom_Right = $bc; {}
  Ch_Vertical     = $ba; {}
  Ch_Horizontal   = $cd; {}
  Ch_Left_T       = $cc; {}
  Ch_Right_T      = $b9; {}

  Window_Position = 9;    { Top row of status window }
  Window_Height   = 12;   { Number of rows in status window }

  ItemInfo  : Array [STItemType, 0..3] of Byte =
                     ({ X   Y width  color }
                      (10,  2, 15, LightCyan),         { STUpDow }
                      (35,  2, 15, LightCyan),         { STFile  }
                      (26,  2, 8, LightCyan),          { STType  }
                      (20, 10, 50, Yellow),            { STMsg   }
                      ( 3, 11, 50, Yellow),            { STPrompt }
                                         { Numeric Fields }
                      (15,  5, 8, Brown),              { STComRead  }
                      (15,  6, 8, LightGreen),         { STComSent  }
                      (25,  5, 8, Brown),              { STDataRead }
                      (25,  6, 8, LightGreen),         { STDataSent }
                      (35,  5, 8, Brown),              { STDowSize  }
                      (35,  6, 8, LightGreen),         { STUplSize  }
                      (45,  5, 8, Brown),              { STDowRem   }
                      (45,  6, 8, LightGreen),         { STUplRem   }
                      (15,  7, 8, LightMagenta),       { STComRate  }
                      (25,  7, 8, LightMagenta),       { STDataRate }
                      (45,  8, 8, LightMagenta),       { STRemTime  }
                      (15,  8, 8, LightMagenta),       { STElapsed  }
                      (55,  5, 8, Brown),              { STPacRead  }
                      (55,  6, 8, LightGreen),         { STPacSent  }
                      (65,  5, 5, 134),                { STErrRead  }
                      (65,  6, 5, 138)                 { STErrSent  }
                     );

VAR
  Status_Enabled : Boolean;
  W_Min, W_Max, Orig_X, Orig_Y : Word;
  Orig_Attr : Word;
  Buffer: BufferType;

PROCEDURE ST_Initialize;
var
  i : word;

begin
  W_Min  := WindMin;
  W_Max  := WindMax;
  Orig_X := WhereX;
  Orig_Y := WhereY;
  Orig_Attr := TextAttr;
  MakeCursor (NoCursor);

  WGet (1, Window_Position, 80, Window_Height, Buffer);
  Window (1, Window_Position, 80, Window_Position + Window_Height);
  ClrScr;

  { Draw the border }
  GoToXY (1, 1);
  TextColor (Cyan);
  Write (char (Ch_Top_Left));
  for i := 1 to 78 do Write (char (Ch_Horizontal));
  Writeln (char (CH_Top_Right));
  GoToXY (1, 2);
  Write (char (Ch_Vertical));
  GoToXY (80, 2); Write (char (Ch_Vertical));
  GoToXY (1, 3);
  Write (char (Ch_Left_T));
  for i := 1 to 78 do Write (char (Ch_Horizontal));
  Write (char (Ch_Right_T));
  for i := 4 to Window_Height - 1 do
    begin
      GoToXY (1, i);
      Write (char (Ch_Vertical));
      GoToXY (80, i);
      Write (char (Ch_Vertical));
    end;
  GoToXY (1, Window_Height);
  Write (char (Ch_Bottom_Left));
  For i := 1 to 78 do Write (char (Ch_Horizontal));
  Write (char (Ch_Bottom_Right));
  GoToXY (1, 9);
  Write (char (Ch_Left_T));
  For i := 1 to 78 do Write (char (Ch_Horizontal));
  Write (char (Ch_Right_T));

  TextColor (LightGray);
  Status_Enabled := true;
  GoToXY (ItemInfo [STDataRead, 0], ItemInfo [STDataRead, 1] - 1);
  Write ('    Data');
  GoToXY (ItemInfo [STComRead, 0], ItemInfo [STComRead, 1] - 1);
  Write ('    Port');
  GoToXY (ItemInfo [STComRead, 0] - 6, ItemInfo [STComRead, 1]);
  Write ('Read');
  GoToXY (ItemInfo [STComSent, 0] - 6, ItemInfo [STComSent, 1]);
  Write ('Sent');
  GoToXY (ItemInfo [STComRate, 0] - 6, ItemInfo [STComRate, 1]);
  Write ('Rate');
  GoToXY (ItemInfo [STComRate, 0] - 6, ItemInfo [STElapsed, 1]);
  Write ('Time');
  GoToXY (ItemInfo [STDowSize, 0], ItemInfo [STDowSize, 1] - 1);
  Write ('    File');
  GoToXY (ItemInfo [STDowRem, 0], ItemInfo [STDowRem, 1] - 1);
  Write ('Remaining');
  GoToXY (ItemInfo [STPacRead, 0], ItemInfo [STPacRead, 1] - 1);
  Write (' Packets');
  GoToXY (ItemInfo [STErrRead, 0], ItemInfo [STErrRead, 1] - 1);
  Write ('Errors');
  TextAttr := Orig_Attr;

end;    { ST_Initialize }

PROCEDURE ST_Display_String (Item: STItemType; S : STStringType);
var
  i, n  : integer;
  x, y, sx, sy, sta : byte;

begin
  if not Status_Enabled
  then exit;

  sx := WhereX; sy := WhereY; sta := TextAttr;
  x := ItemInfo [Item, 0];
  y := ItemInfo [Item, 1];
  n := ItemInfo [Item, 2];
  TextColor (ItemInfo [Item, 3]);
  GoToXY (x, y);
  for i := 1 to n do write (' ');     { Clear the field }
  GoToXY (x, y);
  Write (S);

  TextAttr := sta;

  if Item <> STPrompt
  then GoToXY (sx, sy);
end;    { ST_Display_String }

FUNCTION ST_Time_String (Seconds : LongInt) : STStringType;
VAR
  Hrs, Mins, Secs : word;
  TmpStr : STStringType;
  ValStr : STStringType;

begin
      Hrs     := Seconds div 3600;
      Seconds := Seconds mod 3600;
      Mins    := Seconds div 60;
      Seconds := Seconds mod 60;
      Str (Hrs : 2, ValStr);

      if Hrs = 0
      then TmpStr := '   '
      else TmpStr := ConCat (ValStr, ':');

      if (Hrs <> 0) and (Mins < 10)
      then
        begin
          Str (Mins : 1, ValStr);
          TmpStr := ConCat (TmpStr, '0', ValStr);
        end
      else
        begin
          Str (Mins : 2, ValStr);
          TmpStr := ConCat (TmpStr, ValStr);
        end;

      if Seconds < 10
      then
        begin
          Str (Seconds : 1, ValStr);
          ST_Time_String := ConCat (TmpStr, ':0', ValStr);
        end
      else
        begin
          Str (Seconds : 2, ValStr);
          ST_Time_String := ConCat (TmpStr, ':', ValStr);
        end;

end;

PROCEDURE ST_Display_Value (Item : STItemType; Value : longint);
var
  i, n  : integer;
  x, y, sx, sy, sta : byte;

begin
  if not Status_Enabled
  then exit;

  sx := WhereX; sy := WhereY; sta := TextAttr;

  x := ItemInfo [Item, 0];
  y := ItemInfo [Item, 1];
  n := ItemInfo [Item, 2];
  TextColor (ItemInfo [Item, 3]);
  GoToXY (x, y);

  if (Item <> STRemTime) and (Item <> STElapsed)
  then Write (Value : n)
  else
    begin
    Write (ST_Time_String (Value));
    end;

  TextAttr := sta;
  GoToXY (sx, sy);
end;    { ST_Display_Value }

PROCEDURE ST_Display_Time_of_Day;
Var
  Hours,
  Minutes,
  Seconds,
  Sec100         : Word;
  sx, sy, sta    : Byte;
  W_Min, W_Max   : Word;
  DisplaySeconds : LongInt;
begin
  sx := WhereX; sy := WhereY; sta := TextAttr;
  W_Min  := WindMin;
  W_Max  := WindMax;
  GetTime (Hours, Minutes, Seconds, Sec100);
  DisplaySeconds := (Hours*60 + Minutes)*60 + Seconds;
  TextColor (Yellow);

  Window (1, 1, 80, 1);
  GoToXY (72, 1);
  Write (ST_Time_String (DisplaySeconds));
  Window (Lo (W_Min) + 1, Hi (W_Min) + 1, Lo (W_Max) + 1, Hi (W_Max) + 1);
  TextAttr := sta;
  GoToXY (sx, sy);
end;

PROCEDURE ST_Terminate;
begin
  if not Status_Enabled
  then exit;

  Status_Enabled := false;
  Window (Lo (W_Min) + 1, Hi (W_Min) + 1, Lo (W_Max) + 1, Hi (W_Max) + 1);
  WPut (1, Window_Position, 80, Window_Height, Buffer);
  GoToXY (Orig_X, Orig_Y);
  TextAttr := Orig_Attr;
  MakeCursor (RestoreCursor);
end;

FUNCTION ST_Check_Abort : Boolean;
var
  ch : char;

begin
  ST_Check_Abort := false;

  if KeyPressed
  then
    begin
    ch := ReadKey;

    if ch = char (Abort_Key)
    then ST_Check_Abort := true;
    end;
end;    { ST_Check_Abort }

PROCEDURE ST_Prompt (Prompt_String : STStringType; var Prompt_Return : STStringType);
var
  sx, sy : byte;

begin
  sx := WhereX; sy := WhereY;
  ST_Display_String (STPrompt, Prompt_String);
  ReadLn (Prompt_Return);
  ST_Display_String (STPrompt, ' ');
  GoToXY (sx, sy);
end;    { ST_Prompt }

PROCEDURE ST_Yes_or_No (Prompt_String : STStringType; var Prompt_Return : char);
var
  sx, sy : byte;

begin
  sx := WhereX; sy := WhereY;
  ST_Display_String (STPrompt, Prompt_String);
  Prompt_Return := UpCase (ReadKey);
  Write (Prompt_Return);
  Delay (1000);
  ST_Display_String (STPrompt, ' ');
  GoToXY (sx, sy);
end;    { ST_Yes_or_No }

{==========================================================================}
{                         U N I T    B O D Y                               }
{==========================================================================}

begin
  Status_Enabled := false;
end.
