{
  This short example demonstrate some of the basic principles
  of Windows API programming. The goal is to show you how
  to write programs that do not use OWL, but which instead
  rely strictly on the Windows API.

  There are two key portions of this program. The first loads
  a bitmap and then destroys it when it is done.

}
program BmpPnt3;
{$R BMPPNT3}

uses WinTypes, WinProcs, Win31;

const
  AppName = 'BMPPNT3';

const
  idm_About = 100;
  id_Switch = 201;

var
  PaintBitMap: HBitMap;
  NormalPaint: Boolean;

function About(Dialog: HWnd; Message, WParam: Word;
  LParam: Longint): Bool; export;
begin
  About := True;
  case Message of

    wm_InitDialog:
      Exit;
    wm_Command:
      if (WParam = id_Ok) or (WParam = id_Cancel) then
      begin
        EndDialog(Dialog, 1);
        Exit;
      end;
  end;
  About := False;
end;

function WindowProc(Window: HWnd; Message, WParam: Word;
  LParam: Longint): Longint; export;
var
  AboutProc: TFarProc;
  PaintStruct: TPaintStruct;
  DC, MemDC: HDC;
  OldBitMap: HBitMap;
  R: TRect;

begin
  WindowProc := 0;
  case Message of

    wm_Create: begin
      PaintBitMap := LoadBitMap(HInstance, 'Splash2');
      NormalPaint := False;
    end;

    wm_Paint: begin
      DC := BeginPaint(Window, PaintStruct);
      GetClientRect(Window, R);
      MemDC := CreateCompatibleDC(DC);
      OldBitMap := SelectObject(MemDC, PaintBitMap);
      if NormalPaint then
        BitBlt(DC, 0, 0, 64, 64, MemDC, 0, 0, SRCCopy)
      else
        StretchBlt(DC, 0, 0, R.Right, R.Bottom, MemDC, 0, 0, 64, 64, SRCCopy);
      SelectObject(MemDC, OldBitMap);
      DeleteDC(MemDC);
      EndPaint(Window, PaintStruct);
   end;

    wm_Command: begin
      case (WParam) of
        idm_About: begin
          AboutProc := MakeProcInstance(@About, HInstance);
          DialogBox(HInstance, 'AboutBox', Window, AboutProc);
          FreeProcInstance(AboutProc);
          Exit;
        end;

        id_Switch: begin
          if NormalPaint then NormalPaint := False
          else NormalPaint := True;
          InvalidateRect(Window, nil, True);
        end;
      end;
    end;

    wm_Size: begin
      InvalidateRect(Window, nil, True);
    end;

    wm_Destroy: begin
      DeleteObject(PaintBitMap);
      PostQuitMessage(0);
      Exit;
    end;
  end;
  WindowProc := DefWindowProc(Window, Message, WParam, LParam);
end;

procedure WinMain;
var
  Window: HWnd;
  Message: TMsg;
const
  WindowClass: TWndClass = (
    style: 0;
    lpfnWndProc: @WindowProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hInstance: 0;
    hIcon: 0;
    hCursor: 0;
    hbrBackground: 0;
    lpszMenuName: 'GENERIC';
    lpszClassName: AppName);
begin
  if HPrevInst = 0 then
  begin
    WindowClass.HInstance := HInstance;
    WindowClass.hIcon := LoadIcon(0, idi_Application);
    WindowClass.hCursor := LoadCursor(0, idc_Arrow);
    WindowClass.hbrBackground := GetStockObject(white_Brush);
    if not RegisterClass(WindowClass) then Halt(255);
  end;
  Window := CreateWindow(
    AppName,
    'Standard Paint Example using API',
    ws_OverLappedWindow,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    cw_UseDefault,
    0,
    0,
    HInstance,
    nil);
  ShowWindow(Window, CmdShow);
  UpdateWindow(Window);
  while GetMessage(Message, 0, 0, 0) do
  begin
    TranslateMessage(Message);
    DispatchMessage(Message);
  end;
  Halt(Message.wParam);
end;

begin
  WinMain;
end.
