Program Bmp;
{&R-}

{ This bitmap display example source is original written by:
 Ralph Smith, clySmic software [76156,164] or [76376,3150]

 copy bitdll.dll to your windows system directory!

 Bitdll.DLL may only be used for private purposes
 Any commercial use of Bitdll.DLL must be registered
 to Jan Dekkers CIS 72130,353

 To view gif / pcx / or bmp rem out one of the:

  hDIBRes :=ReadGifFile('clown.gif');
  hDIBRes :=ReadPCXFile('watch.pcx');
  hDIBRes :=ReadbitmapFile('256color.bmp');

 in the procedure SETUPWINDOW


 The jpeg dll is not included in this zip file.}


Uses
  Win31, WinTypes,WinProcs, WinDos,Objects, OWindows, ODialogs,
  OStdDlgs,OMemory, solimage;


Const
  Factor : Real = 2.0;


Type
  PBitmapInfoHeader = ^TBitmapInfoHeader;     { Ptr to Win 3.0 DIB header }
  PBitmapCoreHeader = ^TBitmapCoreHeader;     { Ptr to OS/2 1.x DIB header }


{ --- Utility Procedures --- }

Procedure Calc_DIB_Data(DIBPtr : PBitmapInfoHeader;
                        Var ColorTableEntries : Integer;
                        Var DIBImageBits : Pointer);

Var
  InfoSize : LongInt;
  BitCount,RGBSize : Integer;

Begin
  { Init }
  BitCount := 0;
  RGBSize := 0;

  { Get the size of the DIB's info header }
  InfoSize := DIBPtr^.biSize;

  If InfoSize = SizeOf(TBitmapCoreHeader)
    Then Begin
           { OS/2 1.x style-DIB, so cast to use TBitmapCoreHeader (OS/2
             header) type;
             BitCount is number of bits per pixel }
           BitCount := PBitmapCoreHeader(DIBPtr)^.bcBitCount;

           { 24-bit color has no palette, otherwise get size of color
             table in bytes }
           If BitCount <> 24
             Then Begin
                    RGBSize := (1 Shl BitCount) * SizeOf(TRGBTriple);
                    ColorTableEntries := 1 Shl BitCount;
                  End;
         End
    Else Begin
           { Win 3.0 style-DIB with TBitmapInfoHeader; if structure large
             enough to hold the biClrUsed field, use it to get size of color
             table }
           If InfoSize >= 36
             Then Begin
                    RGBSize := DIBPtr^.biClrUsed * SizeOf(TRGBQuad);
                    ColorTableEntries := DIBPtr^.biClrUsed;
                  End;

           { If RGBSize is still 0, bec. structure wasn't 36 bytes, or
             biClrUsed was zero, calc. RGBSize based on the BitCount (bits
             per pixel) field }
           If RGBSize = 0
             Then Begin
                    BitCount := DIBPtr^.biBitCount;

                    RGBSize := (1 Shl BitCount) * SizeOf(TRGBQuad);
                    ColorTableEntries := 1 Shl BitCount;
                  End;
         End;

  { Return pointer to the data bits of the image, which start after the
    header and color table }
  DIBImageBits := Pointer(LongInt(DIBPtr) + InfoSize + RGBSize);

End {Calc_DIB_Data};

{---------------------------------------------------}

{ --- App/Win Object declarations --- }

Type
  TSolBMP = Object(TApplication)
                  Procedure InitMainWindow; Virtual;
                End;

  PBlitWindow = ^BlitWindow;
  BlitWindow = Object(TWindow)
                 hPal : HPalette;          { The window's logical palette }
                 hFridgeBmp : HBitmap;
                 hDIBRes : THandle;
                 ImageBitsPtr,DIBPtr : Pointer;

                 Procedure SetupWindow;
                   Virtual;

                 Destructor Done;
                   Virtual;

                 Procedure Paint(PaintDC : HDC; Var PaintInfo : TPaintStruct);
                   Virtual;

                 Procedure WMQueryNewPalette(Var Msg : TMessage);
                   Virtual wm_First + wm_QueryNewPalette;

                 Procedure WMPaletteChanged(Var Msg : TMessage);
                   Virtual wm_First + wm_PaletteChanged;


                 Procedure WMRButtonDown(Var Msg : TMessage);
                   Virtual wm_First + wm_RButtonDown;

               End;

{---------------------------------------------------}

{ --- App Methods --- }

Procedure TSolBMP.InitMainWindow;

Begin
  MainWindow := New(PBlitWindow,Init(Nil,'GIF/BMP/PCX/JPG 8-Bit Bitmap DLL Example'));
End {InitMainWindow};

{---------------------------------------------------}

{ --- Window Methods --- }

Procedure BlitWindow.SetupWindow;

Var
  LogPalPtr : PLogPalette;
  PalSize : Word;
  DC : HDC;
  i,ColorTableEntries : Integer;
  hOldPal : HPalette;


Begin
  TWindow.SetupWindow;
  hDIBRes :=ReadGifFile('clown.GIF');
  {hDIBRes :=ReadPCXFile('watch.pcx');}
  {hDIBRes :=ReadbitmapFile('256color.bmp');}

  (*{hDIBRes :=ReadJPGFile('');}  Jpeg DLL is not included in this zip*)

  DIBPtr := GlobalLock(hDIBRes);

  { Calculate addresses of data within the DIB }
  Calc_DIB_Data(DIBPtr,ColorTableEntries,ImageBitsPtr);


  { Create palette table for "ColorTableEntries" entries (1 is
    incl. in TLogPalette definition) }
  PalSize := SizeOf(TLogPalette) + Pred(ColorTableEntries) *
             SizeOf(TPaletteEntry);

  { Fill in palette information }
  LogPalPtr := MemAlloc(PalSize);                  { Allocate memory }
  LogPalPtr^.palVersion := $0300;                  { Win 3.00 palette }
  LogPalPtr^.palNumEntries := ColorTableEntries;   { # of entries }

  { Fill palette table with DIB's color table }
  For i := 0 to Pred(ColorTableEntries) Do
    With LogPalPtr^,TBitmapInfo(DIBPtr^) Do
    Begin
      palPalEntry[i].peRed   := bmiColors[i].rgbRed;
      palPalEntry[i].peGreen := bmiColors[i].rgbGreen;
      palPalEntry[i].peBlue  := bmiColors[i].rgbBlue;
      palPalEntry[i].peFlags := 0;
    End;

  { Create actual palette, receive handle }
  hPal := CreatePalette(LogPalPtr^);

  { Delete our palette table, Win has palette now }
  FreeMem(LogPalPtr,PalSize);


  { Create bitmap from DIB, receive handle.  Note: we must realize the
    palette of the bitmap before we call CreateDIBitmap to get the correct
    colors }
  DC := GetDC(HWindow);
  hOldPal := SelectPalette(DC,hPal,False);
  RealizePalette(DC);

  hFridgeBmp := CreateDIBitmap(DC,
                               TBitmapInfoHeader(DIBPtr^),
                               cbm_Init,
                               ImageBitsPtr,
                               TBitmapInfo(DIBPtr^),
                               dib_RGB_Colors);

  SelectPalette(DC,hOldPal,False);
  ReleaseDC(HWindow,DC);
  GlobalUnlock(hDIBRes);
End {SetupWindow};

{---------------------------------------------------}

Destructor BlitWindow.Done;

Begin
  DeleteObject(hFridgeBmp);
  DeleteObject(hPal);

  TWindow.Done;
End {Done};

{---------------------------------------------------}

Procedure BlitWindow.Paint(PaintDC : HDC; Var PaintInfo : TPaintStruct);

Var
  OldBitmap : HBitmap;
  MemDC : HDC;
  BitmapSize : TPoint;
  BmpInfo : TBitmap;
  hOldPal : HPalette;

Begin
  { Realize our palette }
  hOldPal := SelectPalette(PaintDC,hPal,False);
  RealizePalette(PaintDC);

  { Create a memory DC and select our bmp into it }
  MemDC := CreateCompatibleDC(PaintDC);
  OldBitmap := SelectObject(MemDC,hFridgeBmp);

  { Get the bmp's size }
  GetObject(hFridgeBmp,SizeOf(TBitmap),@BmpInfo);
  BitmapSize.x := BmpInfo.bmWidth;
  BitmapSize.y := BmpInfo.bmHeight;

  { Blit the bmp }
  BitBlt(PaintDC,0,0,BitmapSize.x,BitmapSize.y,MemDC,0,0,srcCopy);

  { Get rid of the memory DC }
  SelectObject(MemDC,OldBitmap);
  DeleteDC(MemDC);

  SelectPalette(PaintDC,hOldPal,False);

End {Paint};

{---------------------------------------------------}

Procedure BlitWindow.WMQueryNewPalette(Var Msg : TMessage);

Var
  PalDC : HDC;

Begin
  PalDC := GetDC(HWindow);
  SelectPalette(PalDC,hPal,False);

  If (RealizePalette(PalDC) > 0)
    Then Begin
           ReleaseDC(HWindow,PalDC);
           InvalidateRect(HWindow,Nil,True);
         End
    Else ReleaseDC(HWindow,PalDC);
End {WMQueryNewPalette};

{---------------------------------------------------}

Procedure BlitWindow.WMPaletteChanged(Var Msg : TMessage);

Var
  PalDC : HDC;

Begin
  If Msg.wParam <> HWindow
    Then Begin
           PalDC := GetDC(HWindow);
           SelectPalette(PalDC,hPal,False);

           If (RealizePalette(PalDC) > 0)
             Then InvalidateRect(HWindow,Nil,False);

           ReleaseDC(HWindow,PalDC);
         End;
End {WMPaletteChanged};

{---------------------------------------------------}


{---------------------------------------------------}

Procedure BlitWindow.WMRButtonDown(Var Msg : TMessage);

Begin
  If Factor > 1.0
    Then Begin
           Factor := Factor - 0.5;
           InvalidateRect(HWindow,Nil,True);
         End;
End {WMRButtonDown};

{---------------------------------------------------}

{ --- Main --- }

Var
  SolBMP : TSolBMP;

Begin
  SolBMP.Init('');
  SolBMP.Run;
  SolBMP.Done;
End.


