// wsbtest.cpp
#include<windows.h>
#include"winapp.h"
#include"stdwin.h"
#include<string.h>
#include"winsb.h"

class WSBTest : public WinAppStdWindow
    {
    static WinClass wc;
    WinScrollBar HScroll, VScroll;

    public:
        static long FAR PASCAL WndProc(HWND hWnd,
            unsigned iMsg, WORD wParam, LONG lParam);
        WSBTest(WinApp *myApp, char *winname) :
            WinAppStdWindow(myApp, &wc, winname)
            {
                // insert calls to change window class info here
            if(GetClassName() == NULL)
                {
                SetClassName("WSBTest");
                SetClassWinProc(WSBTest::WndProc);
                }
            }

        void Paint(void)
            {
            PAINTSTRUCT ps;
            HDC hdc = BeginPaint(GetHandle(), &ps);

            DispMessage(hdc);

            EndPaint(GetHandle(), &ps);
            }

        void Display(void)
            {
            Window::Display();

            HScroll.Init(GetHandle(),SB_HORZ,0,512);
            VScroll.Init(GetHandle(),SB_VERT,0L,20000);
            HScroll.SetPageScroll(4);
            VScroll.SetPageScroll(25);
            HDC hdc = GetDC(GetHandle());
            DispMessage(hdc);
            ReleaseDC(GetHandle(),hdc);
            }

        void WinScroll(unsigned msg, WORD wParam, LONG lParam);
        void DispMessage(HDC hdc);
    };

WinClass WSBTest::wc;

void WSBTest::WinScroll(unsigned msg, WORD wParam, LONG lParam)
    {
    HDC hDC = GetDC(GetHandle());

    switch(msg)
        {
        case WM_HSCROLL:
            HScroll.ScrollUpdate(wParam, lParam);
            break;
        case WM_VSCROLL:
            VScroll.ScrollUpdate(wParam, lParam);
            break;
        }
    DispMessage(hDC);
    ReleaseDC(GetHandle(),hDC);
    }

void WSBTest::DispMessage(HDC hdc)
    {
    char buf[80];
    char *fmt = "  %s: Current=%05d Minimum=%05d Maximum=%05d    ";

    wsprintf((LPSTR)buf,(LPSTR)fmt,(LPSTR)"    VERTICAL",
        VScroll.GetCurPos(),
        VScroll.GetMinPos(),
        VScroll.GetMaxPos());
    TextOut(hdc,0,0,(LPSTR)buf,strlen(buf));

    wsprintf((LPSTR)buf,(LPSTR)fmt,(LPSTR)"HORIZONTAL",
        HScroll.GetCurPos(),
        HScroll.GetMinPos(),
        HScroll.GetMaxPos());
    TextOut(hdc,0,40,(LPSTR)buf,strlen(buf));
    }


long FAR PASCAL _export WSBTest::WndProc(HWND hWnd, unsigned message,
    WORD wParam, LONG lParam)
    {
    WSBTest *pWSBTest = (WSBTest *)GetPointer(hWnd);

    switch(message)
        {
        case WM_CREATE:                         // insert the pointer
            pWSBTest = (WSBTest *)((LPCREATESTRUCT)lParam)->lpCreateParams;
            SetPointer(hWnd, pWSBTest);
            break;

        case WM_PAINT:
            pWSBTest->Paint();                   // call Paint method
            break;

        case WM_CLOSE:
            DestroyWindow(hWnd);
            break;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        case WM_HSCROLL:
        case WM_VSCROLL:
            pWSBTest->WinScroll(message, wParam, lParam);
            break;

        default:
            return DefWindowProc(hWnd, message, wParam, lParam);
        }
    }

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine,
                    int nCmdShow)
    {
        // create an instance of WinApp and initialize it
    WinApp MyApp(hInstance, hPrevInstance, lpszCmdLine, nCmdShow);

        // create an instance of WSBTest for MyApp with winname, "Hello!"
    WSBTest MyWin(&MyApp, "Scroll-Bar Test Window");
    MyWin.Display();                    // open the window

    return MyApp.MessageLoop();         // process any messages
    }

