/* BGI256 DEMO FOR TURBO C                         */
/* From the command line: tcc testbgi graphics.lib */

#ifdef __TINY__
#error DEMO will not run in the tiny model.
#endif

#include <dos.h>
#include <math.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <graphics.h>

int GraphDriver;  /* The Graphics device driver  */
int GraphMode;    /* The Graphics mode value     */
int ErrorCode;    /* Reports any graphics errors */

void Initialize(void);
void Report(void);
void Pause(void);
int  gprintf(int *xloc, int *yloc, char *fmt, ... );
int huge detectVESA(void);


/* *** here we go *** */
int main()
{
  Initialize();   /* Initialize Graphics mode */
  Report();       /* Tell the world what we found */
  Pause();        /* Give em a change to see it */
  closegraph();   /* Go home */
  return(0);
}

int huge detectVESA(void)
{  return(2); }

/* Initialize the graphics system and report any errors occur. */
void Initialize(void)
{
  GraphDriver = installuserdriver("bgi256v2",detectVESA);
  if (grOk != graphresult() )
  {
    printf("Error installing VESA driver");
    exit(1);
  }
  GraphDriver = DETECT;
  initgraph( &GraphDriver, &GraphMode, "" );
  ErrorCode = graphresult();
  if (ErrorCode != grOk)             /* Check if error occured */
  {
    printf(" Graphics System Error: %s\n",grapherrormsg(ErrorCode));
    exit(1);
  }
}


void Report(void)
{
  char *driver, *mode;
  int x, y;
  x = 10;
  y = 4;
  driver = getdrivername();
  mode = getmodename(GraphMode);
  gprintf(&x,&y,"Graphics device   : %-20s (%d)",driver,GraphDriver);
  gprintf(&x,&y,"Graphics mode     : %-20s (%d)",mode,GraphMode);
  gprintf(&x,&y,"Screen resolution : %d x %d",getmaxx(),getmaxy());
  gprintf(&x,&y,"Colors available  : %d",getmaxcolor()+1);
}


/*GPRINTF: Used like PRINTF except the output is sent to the */
/*screen in graphics mode at the specified co-ordinate.	     */
int gprintf( int *xloc, int *yloc, char *fmt, ... )
{
  va_list  argptr;			/* Argument list pointer        */
  char str[140];			/* Buffer to build sting into   */
  int cnt;				/* Result of SPRINTF for return */
  va_start( argptr, format );		/* Initialize va_ functions     */
  cnt = vsprintf( str, fmt, argptr );	/* prints string to buffer      */
  outtextxy( *xloc, *yloc, str );	/* Send string in graphics mode */
  *yloc += textheight( "H" ) + 2;       /* Advance to next line         */
  va_end( argptr );			/* Close va_ functions          */
  return( cnt );			/* Return the conversion count  */
}


void Pause(void)
{
  getch();
  closegraph();
}


