{$R-,S-,I-}

program Fmt;
  {-Simple formatting program to demonstrate BDISK unit}

uses
{$IFDEF Windows}
  WinCrt,
{$ENDIF}
  BDisk;

const
  ESC = #27;
  CR = #13;

type
  CharSet = set of Char;

var
  DLet : Char;
  DTyp : Char;
  Verf : Char;
  GLet : Char;
  DNum : Byte;
  Status : Byte;
  VStr : VolumeStr;

const
  DriveTypeName : array[DriveType] of string[5] =
    ('other', '360K', '1.2M', '720K', '1.44M');

{$IFNDEF Windows}
  function ReadKey : Char; assembler;
    {-Low budget readkey routine}
  asm
    xor ah,ah
    int 16h
  end;
{$ENDIF}

  function GetKey(Prompt : String; OKSet : CharSet) : Char;
    {-Get and return a key in the OKSet}
  var
    Ch : Char;
  begin
    Write(Prompt);
    repeat
      Ch := Upcase(ReadKey);
      if Ch = ESC then begin
        WriteLn;
        Halt;
      end;
    until (Ch in OKSet);
    if Ch <> CR then
      Write(Ch);
    WriteLn;
    GetKey := Ch;
  end;

  function AbortFunc(Track, MaxTrack : Byte; Kind : Byte) : Boolean; far;
    {-Display formatting status. Could check for abort here too}
  begin
    case Kind of
      0 : {Format beginning}
        Write('Formatting     ');
      1 : {Formatting track}
        Write(^H^H^H^H, ((Track*100) div MaxTrack):3, '%');
      2 : {Verifying track}
        Write(^H, 'V');
      3 : {Writing boot and FAT}
        Write(^H^H^H^H^H^H^H^H^H^H^H^H^H^H^H, 'Writing boot and FAT');
      4 : {Format ending}
        begin
          Write(^H^H^H^H^H^H^H^H^H^H^H^H^H^H^H^H^H^H^H^H);
          {Track returns final status code in this case}
          if Track = 0 then
            WriteLn('Formatted successfully')
          else
            WriteLn('Format failed: ', GetStatusStr(Track));
        end;
    end;
    AbortFunc := False;
  end;

begin
  WriteLn('Floppy Formatter: <Esc> to exit');

  {Get formatting parameters}
  DLet := GetKey('Drive to format? (A or B): ', ['A'..'B']);
  DTyp := GetKey('Disk type? (1=360K, 2=1.2M, 3=720K, 4=1.44M): ', ['1'..'4']);
  Verf := GetKey('Verify? (Y or N) ', ['N', 'Y']);
  Write('Volume label? ');
  ReadLn(VStr);
  GLet := GetKey('Insert disk and press <Enter> ', [#13]);

  {Compute drive number}
  DNum := Byte(DLet)-Byte('A');

  WriteLn('Drive type is ', DriveTypeName[GetDriveType(DNum)]);

  Status := FormatDisk(DNum,                    {drive number}
                       Byte(DTyp)-Byte('0'),    {format type}
                       (Verf = 'Y'),            {verify?}
                       0,                       {max bad sectors, 0 -> no limit}
                       VStr,                    {volume label}
                       AbortFunc);              {abort function}
  {AbortFunc reports the status}
end.
