{$R+,S+,I+,D+,F-,V-,B-,N-,L- }
{$M $1000,65535,327680 }
{
  ** TBakLPT Program  **
  ** by Richard S. Sadowsky      CIS [74017,1670]
  ** 8/3/88
  ** version .6
  ** Copyright 1988, Richard S. Sadowsky

  This program is designed as a test and example of the BakLPT unit.
  This program sends some lines to the printer, then begins writing
  astericks to the screen while it prints in the background.  Pressing any
  key will will cause the main block to exit.  This triggers the BakLPT
  ExitProc, which Closes the Lst device.  If unprinted characters remain
  in the buffer, the standard Error handler in BakLPTST is called to ask
  the user what to do.
}
program TestBakLpt;

uses TPCrt,BakLpt,BakLptStandard;

var
  S                : String;
  X,Y              : Byte;
  I                : Word;

const
  Count            : LongInt = 0;

begin
  if not BakLPTInstalled then begin   { make sure ISRs are installed }
    WriteLn('ISRs not initialized.');
    Halt
  end;

  { make sure Queueing system initialized OK.  Would fail if insufficient }
  { heap space for Queue buffers and ISR stacks }
  if QueError <> 0 then begin
    WriteLn('Queue Error ',QueError);
    Halt
  end;
(*
  QueUserExitFunc := @QueExit; { set the que exit function.  this function }
                               { gets called when the Lst file is closed   }
                               { and unprinted characters remain in the    }
                               { queue buffer.  When QueExit returns TRUE, }
                               { the program may terminate. Note how       }
                               { QueExit waits for queue to empty before   }
                               { exiting if user does not wish to abort.   }
  QueUserErrorFunc:= @QueErrFunc;
*)
  S := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%^&*()]{};<>,.';
  Write('Line ==> ');
  X := WhereX;
  Y := WhereY;
  repeat
    Inc(Count);
    GotoXY(X,Y);
    Write(Count);
    WriteLn(Lst,'Line ',Count:2,': ',S);
  until (QueError <> 0) or (BakError <> 0) or (QBI > 800);
  if (QueError <> 0) or (BakError <> 0) then begin
    WriteLn('Queue Error ',QueError);
    WriteLn('BakError    ',BakError);
    Halt
  end;

  { won't get here until all the characters have been printer }

  while (not keypressed) and (BakError = 0) do begin
    clrscr;
    WriteLn('====> Press any key to try to quit <====');
    for I := 1 to 1920 do Write('*');
  end; {while}
  if BakError <> 0 then begin
    WriteLn;
    WriteLn('BakError    ',BakError);
  end
  else
    if ReadKey = ' ' then ; { clear keystroke }
  WriteLn;
end.
