{$R-,S-,I-,D+,V-}
{
  ** BakLPTStandard Unit **
  ** by Richard S. Sadowsky      CIS [74017,1670]
  ** 8/3/88
  ** version .6
  ** Copyright 1988, Richard S. Sadowsky

  This unit provides standard UserErrorFunc and UserExitFunc functions to
  BakLPT.  These are rough drafts at this point.

}
unit BakLPTStandard;

interface

uses DOS,TPCrt,TPInt,TPTSR,TPString,BakLPT;

function QueExit : Boolean;

function QueErrFunc : Boolean;

implementation

const
  Ex_X             = 17;
  Er_X             = 27;
  Ex_X1            = 15;
  Ex_Y1            = 8;
  Ex_X2            = 65;
  Ex_Y2            = 16;
  Er_X1            = 25;
  Er_Y1            = 7;
  Er_X2            = 55;
  Er_Y2            = 17;
  Ex_Att           = $70;
  Er_Att           = $0F;
  SCREENBUFSIZE    = 4000;
  ERROR_STACK_SIZE = 2048;

var
  Error_Handle     : Byte;
  ExWPtr,
  ErWPtr           : Pointer;
  ErrorStack       : Array[1..ERROR_STACK_SIZE] of Byte;

procedure ExitDrawWindow(Remove : Boolean);

begin
  if Remove then
    RestoreWindow(Ex_X1,Ex_Y1,Ex_X2,Ex_Y2,TRUE,ExWPtr)
  else begin
    if SaveWindow(Ex_X1,Ex_Y1,Ex_X2,Ex_Y2,TRUE,ExWPtr) then ;
    FrameWindow(Ex_X1,Ex_Y1,Ex_X2,Ex_Y2,EX_Att,Ex_Att,'');
    ScrollWindowUp(Succ(Ex_X1),Succ(Ex_Y1),Pred(Ex_X2),Pred(Ex_Y2),
                   Pred(Ex_Y2-Ex_Y1));
  end;
end;

procedure ErrorDrawWindow(Remove : Boolean);

begin
  if Remove then
    RestoreWindow(Er_X1,Er_Y1,Er_X2,Er_Y2,FALSE,ErWPtr)
  else begin
    if SaveWindow(Er_X1,Er_Y1,Er_X2,Er_Y2,FALSE,ErWPtr) then ;
    FrameWindow(Er_X1,Er_Y1,Er_X2,Er_Y2,Er_Att,Er_Att,'');
    ScrollWindowUp(Succ(Er_X1),Succ(Er_Y1),Pred(Er_X2),Pred(Er_Y2),
                   Pred(Er_Y2-Er_Y1));
  end;

end;

function WordToStr(W : Word) : String;

var
  S                : String;

begin
  Str(W,S);
  WordToStr := S
end;

function QueExit : Boolean;

var
  Ch               : Char;
  S                : String[80];
  Y                : Byte;

begin
  ExitDrawWindow(FALSE);
  S := 'There are ' + WordToStr(QBI - QOutPtr) +
       ' characters left in Queue Buffer.';
  Y := Ex_Y1 + 2;
  FastWrite(S,Y,Ex_X,TextAttr);
  S := 'Halt printing and Quit (Y or N)?';
  Inc(Y);
  FastWrite(S,Y,Ex_X,TextAttr);
  repeat
    Ch := UpCase(ReadKey);
  until Ch in ['Y','N'];
  if Ch = 'N' then begin
    Inc(Y);
    FastWrite('Waiting for Queue to empty...',Y,Ex_X,TextAttr);
    TICKS_TO_WAIT := 1;  { print every clock tick (this speeds up the }
                         { printing considerably).  }
    CHARS_PER := 160;    { stuff twice as many chars out per interval }
    repeat
    until (QBI - QOutPtr) = 0; { wait until queue is empty }
    Inc(Y);
    FastWrite('Queue emptied - Press Any Key',Y,Ex_X,TextAttr);
    Ch := ReadKey;
  end;
  ExitDrawWindow(TRUE);
  QueExit := TRUE;
end;

function QueErrFunc : Boolean;
{ this is being called from a hardware ISR, so be gentle! }

begin
  InterruptsOff;
  QuePause := TRUE;
  InterruptsOn;
  SetPopTicker(Error_Handle,360);
  QueErrFunc := FALSE;
end;

{$F+}
procedure ErrorHandler(Regs : Registers);

var
  Y,RetByte        : Byte;
  Ch               : Char;
  AbortOp          : Boolean;

begin
  ErrorDrawWindow(FALSE);
  repeat
    Y := Er_Y1 + 2;
    FastWrite('Printer error '+HexW(BakError),Y,Er_X,TextAttr);
    Inc(Y);
    FastWrite('Prepare printer then',Y,Er_X,TextAttr);
    Inc(Y);
    FastWrite('Press any key to retry',Y,Er_X,TextAttr);
    Inc(Y);
    FastWrite('(Esc to Quit)',Y,Er_X,TextAttr);
    Sound(110); Delay(800); NoSound;
    Ch := ReadKey;
    AbortOp := Ch = ^[;
    if AbortOp then
      ResetQueue(TRUE)
    else
      RetByte := DoInt17(PrtQue^[QOutPtr],QTextRec(Lst).LPTNo);
  until AbortOp or (RetByte and $10 <> 0);
  if not AbortOp then BakError := 0;
  QuePause := FALSE;
  ErrorDrawWindow(TRUE);
end;

{$F-}
begin
  if BakLPTInstalled then begin
    GetMem(ErWPtr,SCREENBUFSIZE);

    { set the que exit function.  this function gets called when the Lst  }
    { file is closed and unprinted characters remain in the queue buffer. }
    { When QueExit returns TRUE, the program may terminate. Note how      }
    { QueExit waits for queue to empty before exiting if user does not    }
    { wish to abort.   }
    QueUserExitFunc := @QueExit;

    QueUserErrorFunc:= @QueErrFunc;
    if not DefinePopProc(Error_Handle,@ErrorHandler,
                         @ErrorStack[ERROR_STACK_SIZE]) then ;
    PopupsOn;
  end
end.
