
(*
 * (C) 1987 Samuel H. Smith, 26-apr-87 (rev. 12-Dec-87)
 *
 * This program is provided courtesy of:
 *         The Tool Shop
 *         Phoenix, Az
 *         (602) 279-2673
 *
 * This program uses many of the building-blocks in the Tool Shop Library,
 * which is available for download from the Tool Shop.   
 *
 *
 * Disclaimer
 * ----------
 *
 * This software is completely FREE.   I ask only for your comments,
 * suggestions and bug reports.   If you modify this program, I would
 * appreciate a copy of the new source code.   Please don't delete my
 * name from the program.
 *
 * I cannot be responsible for any damages resulting from the use or mis-
 * use of this program!
 *
 * If you have any questions, bugs, or suggestions, please contact me at
 * The Tool Shop,  (602) 279-2673.
 *
 * Enjoy!     Samuel H. Smith
 *
 *)

{$UNDEF DEBUGGING}             (* #define to enable ALPHA test code *) 

{$V-}    {Relax string typing}
{$R-}    {Range checking off}
{$B-}    {Boolean complete evaluation on}
{$S-}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 10000,45000,65000} {minstack,minheap,maxheap}
{$T+,D+}

program ArcTV;

Uses
  Dos,
  MiniCrt,
  Printer,
  Mdosio,
  Tools,
  CInput;


{$DEFINE IN_ARCTV}
{$define DISABLE_EXTRACT}


const

{$ifdef DISABLE_EXTRACT}
   whoami      = 'Archive Text Viewer';
{$else}
   whoami      = 'Archive Text View/Extract';
{$endif}

   version     = 'v2.67, 04/12/88';
   comfile     = 'ARCTV';
   scratchfile = 'SCRATCH.ARC';


const
   option = '';
   expert = true;
   dump_user: boolean = false;
   carrier_lost = '<lost>';

type
   user_rec = record
        pagelen: integer;
   end;

const
   user: user_rec = (pagelen:23);
   o_logoff = 'x'; 
   o_offok = 'x'; 
   o_offerr = 'x';
   red = ''; green = ''; yellow=''; blue='';
   magenta=''; cyan=''; white=''; gray='';
   graphics = false;

procedure make_log_entry(s:string;
                         f:boolean);
begin 
   if f then writeln(s);
end;

procedure uninit_com; begin end;


{$i promsgs.INC}   (* message/more processing *)
{$i prounsq.INT}   (* view archive text files - interface *)
{$i prounsq.INC}   (* view archive text files - implementation *)


(*
 * main program
 *
 *)

var
   i,j:    integer;
   par:    anystring;
   time:   real;

begin
   assign(stdout,'');
   rewrite(stdout);

   time := get_time;
   linenum := 1;

   if paramcount = 0 then
   begin
      newline;
      displn(whoami+',  '+version);
      displn('Courtesy of:  S.H.Smith  and  The Tool Shop BBS,  (602) 279-2673.');
      newline;
      displn('Usage:  arctv FILE[.arc] ... FILE  [<IN] [>OUT]');
      halt;
   end;

   for i := 1 to paramcount do
   begin
      par := paramstr(i);

      if pos('.',par) = 0 then
         par := par + '.ARC';

      for j := 1 to length(par) do
         if par[j] = '/' then
            par[j] := '\';

      getfiles(par,filetable,filecount);

      for j := 1 to filecount do
      begin
         newline;
         displn('Archive: '+filetable[j]^);
         linenum := 1;
         view_archive_text(filetable[j]^);
      end;
   end;

   time := get_time - time;
   if time > 240.0 then
   begin
      newline;
      displn(whoami+',  '+version);
      displn('Courtesy of:  S.H.Smith  and  The Tool Shop BBS,  (602) 279-2673.');
      newline;
   end;
end.

