
{$i prodef.inc}

unit CInput;

interface

Uses
  Dos,
  MiniCrt,
  Tools;

var
   linenum: integer;

procedure disp(msg:  longstring);
procedure newline;
procedure displn(msg:  longstring);
procedure input(var line:  longstring;
                maxlen:    integer);


implementation

var
   stdout: text;


(* ------------------------------------------------------------ *)
procedure disp(msg:  longstring);
begin
   write(stdout,msg);
end;

procedure newline;
begin
   flush(stdout);
   disp(^M^J);
   inc(linenum);
end;

procedure displn(msg:  longstring);
begin
   disp(msg);
   newline;
end;


(* ------------------------------------------------------------ *)
procedure input(var line:  longstring;
                maxlen:    integer);
var
   c:     char;

begin
   linenum := 1;
   line := '';

   repeat
      flush(stdout);
      c := readkey;

      case c of
         ' '..#126:
            if maxlen = 0 then
            begin
               line := c;
               disp(c);
               c := ^M;    {automatic CR}
            end
            else

            if LEN(line) < maxlen then
            begin
               if (wherex > 78) then
                  newline;

               CONCAT_CHAR(line,c);
               disp(c);
            end
            else
               disp(^G^X^H' '^H);

         ^H,#127:
            if LEN(line) > 0 then
            begin
               dec(line[0]);
               disp(^H' '^H);
            end
            else
               disp(^G);

         ^M:   ;

         ^C:   halt(88);

        else            {echo ^X with invalid inputs; might stop
                         an external protocol driver that is stuck}
           disp(^X^H' '^H);

      end;

   until (c = ^M);

end;


begin
   assign(stdout,'');
   rewrite(stdout);
end.

