{
Turbo Pascal ANSI Drivers
Version 1.12
Copyright (c) 1990 by Not So Serious Software

Original concept by Ian Silver
Design and implementation by Kevin Dean

Kevin Dean
Fairview Mall P.O. Box 55074
1800 Sheppard Avenue East
Willowdale, Ontario
CANADA    M2J 5B9
CompuServe ID: 76336,3114
}


{ This program demonstrates simple text I/O using the ANSICON console unit }
program DemoANSICON;


uses
  ANSI, ANSICON;


var
  Name : string[20];
  BoxColor, DataColor, BkgndColor : byte;


{***}
procedure UpdateCursorPos;

var
  CurX, CurY, OldAttr : byte;

begin
CurX := WhereX;
CurY := WhereY;
OldAttr := TextAttr;

TextAttr := DataColor;
GotoXY(50, 13);
Write('(', CurX : 2, ',', CurY : 2, ')');

TextAttr := OldAttr;
GotoXY(CurX, CurY)
end;


{***}
procedure DrawBox;

var
  I : byte;

begin
TextAttr := BoxColor;

GotoXY(23, 9);
UpdateCursorPos;
Write('');

for I := 24 to 57 do
  begin
  UpdateCursorPos;
  Write('')
  end;

UpdateCursorPos;
Write('');

for I := 10 to 15 do
  begin
  GotoXY(58, I);
  UpdateCursorPos;
  Write('')
  end;

GotoXY(58, 16);
UpdateCursorPos;
Write('');

for I := 57 downto 24 do
  begin
  GotoXY(I, 16);
  UpdateCursorPos;
  Write('')
  end;

GotoXY(23, 16);
UpdateCursorPos;
Write('');

for I := 15 downto 10 do
  begin
  GotoXY(23, I);
  UpdateCursorPos;
  Write('')
  end
end;


{***}
procedure RunDemo;

begin
Randomize;

repeat
  BoxColor := Random(256);

  DrawBox;

  DataColor := Random(256);
  BkgndColor := Random(256);

  TextAttr := BkgndColor;
  GotoXY(24, 10);
  UpdateCursorPos;
  Write(' Your name:                       ');
  UpdateCursorPos;

  TextAttr := DataColor;
  GotoXY(36, 10);
  UpdateCursorPos;
  Write(Name);
  UpdateCursorPos;

  TextAttr := BkgndColor;
  GotoXY(24, 11);
  UpdateCursorPos;
  Write(' Box color:       Data color:     ');
  UpdateCursorPos;

  TextAttr := DataColor;
  GotoXY(36, 11);
  UpdateCursorPos;
  Write(BoxColor : 3);
  UpdateCursorPos;
  GotoXY(54, 11);
  UpdateCursorPos;
  Write(DataColor : 3);
  UpdateCursorPos;

  TextAttr := BkgndColor;
  GotoXY(24, 12);
  UpdateCursorPos;
  Write(' Background color:                ');
  UpdateCursorPos;

  TextAttr := DataColor;
  GotoXY(43, 12);
  UpdateCursorPos;
  Write(BkgndColor : 3);
  UpdateCursorPos;

  TextAttr := BkgndColor;
  GotoXY(24, 13);
  UpdateCursorPos;
  Write(' Current cursor position:         ');
  UpdateCursorPos;

  TextAttr := BkgndColor;
  GotoXY(24, 14);
  UpdateCursorPos;
  Write('                                  ');
  UpdateCursorPos;

  TextAttr := BkgndColor;
  GotoXY(24, 15);
  UpdateCursorPos;
  Write(' Press any key to end demo.       ');
  UpdateCursorPos;

  Delay(250)
until KeyPressed
end;


{***}
begin
{ It is very important to make an explicit call to either GotoXY or ClrScr at }
{ the start of your program.  If you do not do so, the internal cursor        }
{ position management will be unpredictable.                                  }
ClrScr;

WriteLn('This program demonstrates simple I/O using the ANSI and ANSI console');
WriteLn('units.  Among the features demonstrated are screen control, cursor');
WriteLn('control, text attribute control, input and output, and the delay');
WriteLn('counter.');
WriteLn;
Write('What is your name (maximum 20 characters)? ');
ReadLn(Name);

RunDemo
end.