unit rgaAMG;

interface

uses printer,crt,dos,defAMG;

var
	keycnt : word;
	querybefovr, delaftarc : boolean;
    ProFilTyp : word;
	CmntFileName : PathStr;
    CmntFile: file;
	TextDOSName, ArcDOSName : string[12];

procedure EncodFile;
procedure DecodFile;
procedure DecodBlock;
procedure WriteTextBlock;

implementation


function RelPath(p : PathStr) : PathStr;
var
	i : word;
    s : pathstr;
begin
	s := p;
    if s[2] = ':' then
    	delete(s,1,2);
	while length(s) > 0 do
	begin
		if (s[1] = '.') or (s[1] = '\') then
			delete(s,1,1)
		else
			break;
	end;
    RelPath := s;
end;

procedure FindStrMax; assembler;
label
    e3,e4,qt,nl,sl;

    asm
        mov		es,FrsBuf_seg
        mov		bx,word ptr es:[bx]
        mov		keycnt,3000

sl:     cmp		bx,ns2
		jnb		qt

        mov		LastWordPos,bx
        mov		es,TextBuf_seg
        mov		si,BstLen
        cmp		al,byte ptr es:[bx + si]
        jne     nl

        mov		si,TextByteCnt
        mov		cx,si
        sub		cx,bx
        mov     dx,TextBlock
        sub		dx,si
        cmp		cx,dx
        jbe		e3
        mov		cx,dx

e3:		mov		di,bx
        mov		dx,si
        sub		dx,di
        push	ds
        mov		ds,TextBuf_seg
        cld
		rep		cmpsb
        pop		ds
		je		e4
		dec		di

e4:     sub		di,bx

        cmp		di,2
        jbe		nl

        cmp		di,BstLen
		jna		nl

@gs:    mov		BstPos,dx
        mov		BstLen,di
        mov		bx,TextByteCnt
        mov		al,byte ptr es:[bx + di]

nl:     dec		keycnt
		jz		qt
		mov		si,LastWordPos
		mov		es,NxtBuflw_seg
        mov		bl,byte ptr es:[si]
		mov		es,NxtBufhg_seg
        mov		bh,byte ptr es:[si]
		jmp		sl

qt:		mov		es,TextBuf_seg
		mov		di,TextByteCnt
        cmp  	al,byte ptr es:[di - 1]
        jne		@lrc
        mov		cx,TextBlock
        sub		cx,TextByteCnt
        cld
        rep		scasb
        je		@is
        dec		di

@is:	sub		di,TextByteCnt
		cmp		di,BstLen
        jb		@lrc
        mov		BstLen,di
        mov		BstPos,1

@lrc:   cmp		BstLen,2
		ja		@ou
        mov		es,TextBuf_seg
        mov		di,TextByteCnt
        mov		dx,di
        mov		ax,word ptr es:[di]
        sub		di,2
        mov     cx,MaxLen2
        std

@lll:   repne	scasb
		jcxz	@ou
        cmp		ah,es:[di + 2]
        jne		@lll
		sub		dx,di
        dec		dx
        mov		BstPos,dx
        mov		BstLen,2

@ou:
end;



procedure FindStrNormal; assembler;
label
    e3,e4,qt,nl,sl;

    asm
        mov		es,FrsBuf_seg
        mov		bx,word ptr es:[bx]
        mov		keycnt,50

sl:     cmp		bx,ns2
		jnb		qt

        mov		LastWordPos,bx
        mov		es,TextBuf_seg
        mov		si,BstLen
        cmp		al,byte ptr es:[bx + si]
        jne     nl

        mov		si,TextByteCnt
        mov		cx,si
        sub		cx,bx
        mov     dx,TextBlock
        sub		dx,si
        cmp		cx,dx
        jbe		e3
        mov		cx,dx

e3:		mov		di,bx
        mov		dx,si
        sub		dx,di
        push	ds
        mov		ds,TextBuf_seg
        cld
		rep		cmpsb
        pop		ds
		je		e4
		dec		di

e4:     sub		di,bx

        cmp		di,2
        jbe		nl

        cmp		di,BstLen
		jna		nl

@gs:    mov		BstPos,dx
        mov		BstLen,di
        mov		bx,TextByteCnt
        mov		al,byte ptr es:[bx + di]

nl:     dec		keycnt
		jz		qt
		mov		si,LastWordPos
		mov		es,NxtBuflw_seg
        mov		bl,byte ptr es:[si]
		mov		es,NxtBufhg_seg
        mov		bh,byte ptr es:[si]
		jmp		sl

qt:		mov		es,TextBuf_seg
		mov		di,TextByteCnt
        cmp  	al,byte ptr es:[di - 1]
        jne		@lrc
        mov		cx,TextBlock
        sub		cx,TextByteCnt
        cld
        rep		scasb
        je		@is
        dec		di

@is:	sub		di,TextByteCnt
		cmp		di,BstLen
        jb		@lrc
        mov		BstLen,di
        mov		BstPos,1

@lrc:   cmp		BstLen,2
		ja		@ou
        mov		es,TextBuf_seg
        mov		di,TextByteCnt
        mov		dx,di
        mov		ax,word ptr es:[di]
        sub		di,2
        mov     cx,MaxLen2
        std

@lll:   repne	scasb
		jcxz	@ou
        cmp		ah,es:[di + 2]
        jne		@lll
		sub		dx,di
        dec		dx
        mov		BstPos,dx
        mov		BstLen,2

@ou:
end;



procedure MakeEncPosTree;
begin
	move(FreqPos,Node,64);
    CreateTree32;
    GenTree32;
    move(HufChr,PosHufVal,64);
    move(ChrLen,PosHufLen,64);

    i := 31;
    while (ChrLen[i] = 0) and (i <> $ffff) do
    	dec(i);
    MaxPos := i + 1;
    if MaxPos > 0 then
    begin
	    MinBtsPos := 255;
		for i := 0 to MaxPos - 1 do
	    begin
    	    if ChrLen[i] > 0 then
	    		if ChrLen[i] < MinBtsPos then
    	    		MinBtsPos := ChrLen[i];
	    end;
    	dec(MinBtsPos);
    end;
end;


procedure MakeDecPosTree;
begin
    if MaxPos > 0 then
    begin
		Move(PosHufLen,ChrLen,64);
        GenTree32;
	    FillChar(Poslson,128,255);
    	FillChar(Posrson,128,255);

     asm
     	xor		bx,bx
        mov		PosTopTree,2

@sl:	cmp     word ptr [ChrLen + bx],0
		je		@nl
        xor		si,si
        mov		ax,word ptr [HufChr + bx]
        mov		cx,word ptr [ChrLen + bx]
        mov		dx,1

@isl:   test	ax,dx
        jz		@rs
        cmp		cx,1
        ja		@lne
     	mov		ax,bx
        shr		ax,1
        or		ax,$8000
        mov		word ptr [Poslson + si],ax
        jmp		@nl

@lne:   mov		di,word ptr [Poslson + si]
        cmp		di,$ffff
        jb		@inl
        mov		di,PosTopTree
        add		PosTopTree,2
		mov		word ptr [Poslson + si],di
        jmp		@inl

@rs:    cmp		cx,1
        ja		@rne
     	mov		ax,bx
        shr		ax,1
        or		ax,$8000
        mov		word ptr [Posrson + si],ax
        jmp		@nl

@rne:   mov		di,word ptr [Posrson + si]
        cmp		di,$ffff
        jb		@inl
        mov		di,PosTopTree
        add		PosTopTree,2
		mov		word ptr [Posrson + si],di

@inl:   mov		si,di
   		shl		dx,1
        loop	@isl

@nl:	add		bx,2
		cmp		bx,64
        jb		@sl
    end;
    end;
end;


procedure MakeEncBigSgnTree;
begin
	move(FreqBigSgn,Node,1024);

    Createtree290;
    Gentree290;


    move(HufChr,BigSgnHufVal,1024);
    move(ChrLen,BigSgnHufLen,1024);

    i := 255;
    while (ChrLen[i] = 0) and (i <> $ffff) do
    	dec(i);
    MaxBigSgn := i + 1;
    if MaxBigSgn > 0 then
    begin
	    MinBtsBigSgn := 255;
		for i := 0 to MaxBigSgn - 1  do
	    begin
    	    if ChrLen[i] > 0 then
	    		if ChrLen[i] < MinBtsBigSgn then
    	    		MinBtsBigSgn := ChrLen[i];
	    end;
    	dec(MinBtsBigSgn);
    end;

    i := 511;
    while (ChrLen[i] = 0) and (i <> 255) do
    	dec(i);
    MaxLen := i - 255;
    if MaxLen > 0 then
    begin
	    MinBtsLen := 255;
		for i := 256 to 255 + MaxLen do
	    begin
    	    if ChrLen[i] > 0 then
	    		if ChrLen[i] < MinBtsLen then
    	    		MinBtsLen := ChrLen[i];
	    end;
    	dec(MinBtsLen);
    end;
end;

procedure MakeEncLtlSgnTree;
begin
    if MaxBigSgn > 0 then
    begin
	    for i := 0 to MaxBigSgn - 1 do
    	begin
        	if BigSgnHufLen[i] > 0 then
	    		inc(FreqLtlSgn[BigSgnHufLen[i] - MinBtsBigSgn])
	        else
    	    	inc(FreqLtlSgn[0]);
	    end;
    end;

    if MaxLen > 0 then
    begin
	    for i := 256 to 255 + MaxLen do
    	begin
        	if BigSgnHufLen[i] > 0 then
	    		inc(FreqLtlSgn[BigSgnHufLen[i] - MinBtsLen])
	        else
    	    	inc(FreqLtlSgn[0]);
	    end;
    end;

    if MaxPos > 0 then
    begin
	    for i := 0 to MaxPos - 1 do
    	begin
        	if PosHufLen[i] > 0 then
	    		inc(FreqLtlSgn[PosHufLen[i] - MinBtsPos])
	        else
    	    	inc(FreqLtlSgn[0]);
	    end;
    end;

    Move(FreqLtlSgn,Node,32);
    CreateTree16;
    GenTree16;
    move(HufChr,LtlSgnHufVal,32);
    move(ChrLen,LtlSgnHufLen,32);
end;


procedure MakeDecLtlSgnTree;
begin
     move(LtlSgnHufLen,ChrLen,32);
     GenTree16;
     FillChar(LtlSgnlson,64,255);
     FillChar(LtlSgnrson,64,255);

     asm
     	xor		bx,bx
        mov		LtlSgnTopTree,2

@sl:	cmp     word ptr [ChrLen + bx],0
		je		@nl
        xor		si,si
        mov		ax,word ptr [HufChr + bx]
        mov		cx,word ptr [ChrLen + bx]
        mov		dx,1

@isl:   test	ax,dx
        jz		@rs
        cmp		cx,1
        ja		@lne
     	mov		ax,bx
        shr		ax,1
        or		ax,$8000
        mov		word ptr [LtlSgnlson + si],ax
        jmp		@nl

@lne:   mov		di,word ptr [LtlSgnlson + si]
        cmp		di,$ffff
        jb		@inl
        mov		di,LtlSgnTopTree
        add		LtlSgnTopTree,2
		mov		word ptr [LtlSgnlson + si],di
        jmp		@inl

@rs:    cmp		cx,1
        ja		@rne
     	mov		ax,bx
        shr		ax,1
        or		ax,$8000
        mov		word ptr [LtlSgnrson + si],ax
        jmp		@nl

@rne:   mov		di,word ptr [LtlSgnrson + si]
        cmp		di,$ffff
        jb		@inl
        mov		di,LtlSgnTopTree
        add		LtlSgnTopTree,2
		mov		word ptr [LtlSgnrson + si],di

@inl:   mov		si,di
   		shl		dx,1
        loop	@isl

@nl:	add		bx,2
		cmp		bx,32
        jb		@sl
    end;

end;



procedure MakeDecBigSgnTree;
begin
     move(BigSgnHufLen,ChrLen,1024);
     Gentree290;
     FillChar(BigSgnlson,2048,255);
     FillChar(BigSgnrson,2048,255);

     asm
     	xor		bx,bx
        mov		BigSgnTopTree,2

@sl:	cmp     word ptr [ChrLen + bx],0
		je		@nl
        xor		si,si
        mov		ax,word ptr [HufChr + bx]
        mov		cx,word ptr [ChrLen + bx]
        mov		dx,1

@isl:   test	ax,dx
        jz		@rs
        cmp		cx,1
        ja		@lne
     	mov		ax,bx
        shr		ax,1
        or		ax,$8000
        mov		word ptr [BigSgnlson + si],ax
        jmp		@nl

@lne:   mov		di,word ptr [BigSgnlson + si]
        cmp		di,$ffff
        jb		@inl
        mov		di,BigSgnTopTree
        add		BigSgnTopTree,2
		mov		word ptr [BigSgnlson + si],di
        jmp		@inl

@rs:    cmp		cx,1
        ja		@rne
     	mov		ax,bx
        shr		ax,1
        or		ax,$8000
        mov		word ptr [BigSgnrson + si],ax
        jmp		@nl

@rne:   mov		di,word ptr [BigSgnrson + si]
        cmp		di,$ffff
        jb		@inl
        mov		di,BigSgnTopTree
        add		BigSgnTopTree,2
		mov		word ptr [BigSgnrson + si],di

@inl:   mov		si,di
   		shl		dx,1
        loop	@isl

@nl:	add		bx,2
		cmp		bx,288*2
        jb		@sl
    end;
end;



procedure  EncodLtlSgnTree; assembler;
asm

		{ Ltl Sgn Tree }

        mov		di,30
@l1:	cmp		word ptr [LtlSgnHufLen + di],0
		jne		@aa
        sub		di,2
        jmp		@l1

@aa:    mov     bx,CmprByteCnt
        mov		cx,CmprBitCnt
        mov		es,CmprBuf_seg
        mov		ax,di
        shr		ax,1
        shl		ax,cl
        or		es:[bx],al
        add		cx,4
        cmp		cx,7
        jna		@k1
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx


@k1:	mov		si,0

@u1:    mov		ax,word ptr [LtlSgnHufLen + si]
        shl		ax,cl
        or		es:[bx],al
        add		cx,4
        cmp		cx,7
        jna		@y1
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx

@y1:	add		si,2
		cmp		si,di
        jna		@u1

        mov		CmprBitCnt,cx
        mov		CmprByteCnt,bx
end;


procedure EncodLenTree; assembler;
asm

     { Coding  Len Tree Var }

	    mov     bx,CmprByteCnt
        mov		cx,CmprBitCnt
        mov		es,CmprBuf_seg


        mov		ax,MaxLen
        shl		ax,cl
        or		es:[bx],al
        add		cx,6
        cmp		cx,7
        jna		@k0
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx

@k0:	cmp		MaxLen,0
		je      @qt
	    mov		ax,MinBtsLen
        shl		ax,cl
        or		es:[bx],al
        add		cx,4
        cmp		cx,7
        jna		@k1
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx


        { Len Tree }

@k1:    mov		di,MaxLen
        shl		di,1
        mov		mx,di
		mov		i,0
        xor		di,di

@h1:    mov		di,word ptr [BigSgnHufLen + 512 + di]
        cmp		di,0
        je		@nn
		sub		di,MinBtsLen
        shl		di,1

@nn:    mov		ax,word ptr [LtlSgnHufVal + di]
        mov		si,word ptr [LtlSgnHufLen + di]

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		es:[bx],al
        inc		bx
        push	cx
        mov		cx,8
        shr		ax,cl
        or 		es:[bx],al
        pop		cx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		es:[bx],al
        add		cx,si
        cmp		cx,7
        jna		@nc7
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx


@nc7:   add		i,2
        mov		di,i
        cmp		di,mx
        jb      @h1


@qt:	mov		CmprBitCnt,cx
        mov		CmprByteCnt,bx

end;


procedure EncodPosTree; assembler;
asm

     { Coding  Pos Tree Var }

	    mov     bx,CmprByteCnt
        mov		cx,CmprBitCnt
        mov		es,CmprBuf_seg


        mov		ax,MaxPos
        shl		ax,cl
        or		es:[bx],al
        add		cx,6
        cmp		cx,7
        jna		@k0
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx

@k0:    cmp		MaxPos,0
		je		@qt
		mov		ax,MinBtsPos
        shl		ax,cl
        or		es:[bx],al
        add		cx,4
        cmp		cx,7
        jna		@k1
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx


        { Pos Tree }

@k1:    mov		di,MaxPos
        shl		di,1
        mov		mx,di
		mov		i,0
        xor		di,di

@h1:    mov		di,word ptr [PosHufLen + di]
        cmp		di,0
        je		@nn
		sub		di,MinBtsPos
        shl		di,1

@nn:    mov		ax,word ptr [LtlSgnHufVal + di]
        mov		si,word ptr [LtlSgnHufLen + di]

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		es:[bx],al
        inc		bx
        push	cx
        mov		cx,8
        shr		ax,cl
        or 		es:[bx],al
        pop		cx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		es:[bx],al
        add		cx,si
        cmp		cx,7
        jna		@nc7
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx


@nc7:   add		i,2
        mov		di,i
        cmp		di,mx
        jb      @h1

@qt:	mov		CmprBitCnt,cx
        mov		CmprByteCnt,bx

end;


procedure EncodBigSgnTree; assembler;
asm

     { Coding  BigSgn Tree Var }

	    mov     bx,CmprByteCnt
        mov		cx,CmprBitCnt
        mov		es,CmprBuf_seg


        mov		ax,MaxBigSgn
        mov		di,ax
        shl		ax,cl
        or		es:[bx],al
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        mov		cx,dx
        mov		ax,di
        mov		al,ah
        xor		ah,ah
        shl		ax,cl
        or		es:[bx],al
        add		cx,1
        cmp		cx,7
        jna		@k0
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx

@k0:    cmp		MaxBigSgn,0
		je 		@qt
		mov		ax,MinBtsBigSgn
        shl		ax,cl
        or		es:[bx],al
        add		cx,4
        cmp		cx,7
        jna		@k1
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx


        { BigSgn Tree }

@k1:    mov		di,MaxBigSgn
        shl		di,1
        mov		mx,di
		mov		i,0
        xor		di,di

@h1:    mov		di,word ptr [BigSgnHufLen + di]
        cmp		di,0
        je		@nn
		sub		di,MinBtsBigSgn
        shl		di,1

@nn:    mov		ax,word ptr [LtlSgnHufVal + di]
        mov		si,word ptr [LtlSgnHufLen + di]

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		es:[bx],al
        inc		bx
        push	cx
        mov		cx,8
        shr		ax,cl
        or 		es:[bx],al
        pop		cx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		es:[bx],al
        add		cx,si
        cmp		cx,7
        jna		@nc7
        mov		dx,cx
        mov		cx,8
        inc		bx
        shr		ax,cl
        or		es:[bx],al
        sub		dx,8
        mov		cx,dx


@nc7:   add		i,2
        mov		di,i
        cmp		di,mx
        jb      @h1

@qt:	mov		CmprBitCnt,cx
        mov		CmprByteCnt,bx

end;





procedure DecodLtlSgnTree; assembler;
asm

        { Read LtlSgn Tree }

        xor		dx,dx
        mov		cx,4
        mov		es,CmprBuf_seg
        mov		si,CmprByteCnt
        mov		al,CmprBitMsk
        mov		ah,8

@@1:	shr		dx,1
		test	es:[si],al
        je		@@2
        or		dl,ah
@@2:    shl		al,1
		test	al,0ffh
		jne		@@3
        mov		al,1
		inc		si

@@3:	loop	@@1

		mov		di,dx
        inc		di
        xor		bx,bx

@g0:    xor		dx,dx
		mov		cx,4
@g1:	shr		dx,1
		test	es:[si],al
        je		@g2
        or		dl,8
@g2:    shl		al,1
		test	al,0ffh
		jne		@g3
        mov		al,1
		inc		si

@g3:	loop	@g1
		mov		word ptr [LtlSgnHufLen + bx],dx
        add		bx,2
        dec		di
        jne		@g0

		mov		CmprBitMsk,al
        mov		CmprByteCnt,si

end;

procedure DecodLenTree; assembler;
asm
        { Read Len Var }

        mov		es,CmprBuf_seg
        mov		si,CmprByteCnt
        mov		al,CmprBitMsk

	    xor		dx,dx
		mov		cx,6
@g1:	shr		dx,1
		test	es:[si],al
        je		@g2
        or		dl,32
@g2:    shl		al,1
		jnz		@g3
        mov		al,1
		inc		si

@g3:	loop	@g1
		cmp		dx,0
        je		@qt
		mov		MaxLen,dx

	    xor		dx,dx
		mov		cx,4
@r1:	shr		dx,1
		test	es:[si],al
        je		@r2
        or		dl,8
@r2:    shl		al,1
		jnz		@r3
        mov		al,1
		inc		si

@r3:	loop	@r1
		mov		MinBtsLen,dx

		{ Len Tree }

    	mov		i,0

@nl:	mov		bx,0

@t5:    test	es:[si],al
        jz		@rs
        mov		bx,word ptr [LtlSgnlson + bx]
        jmp		@t6

@rs:	mov		bx,word ptr [LtlSgnrson + bx]

@t6:    shl		al,1
		jnz		@t7
        mov		al,1
		inc		si

@t7:    cmp		bx,$8000
		jb		@t5

        mov		dx,bx
        and		dx,$7fff
		cmp		dx,0
        je		@nn
		add		dx,MinBtsLen
@nn:    mov		bx,i
        shl		bx,1
        mov		word ptr [BigSgnHufLen + 512 + bx],dx
        inc		i
        mov		bx,i
        cmp		bx,MaxLen
        jb		@nl

@qt:	mov		CmprBitMsk,al
		mov		CmprByteCnt,si
end;

procedure DecodPosTree; assembler;
asm
        { Read Pos Var }

        mov		es,CmprBuf_seg
        mov		si,CmprByteCnt
        mov		al,CmprBitMsk

	    xor		dx,dx
		mov		cx,6
@g1:	shr		dx,1
		test	es:[si],al
        je		@g2
        or		dl,32
@g2:    shl		al,1
		jnz		@g3
        mov		al,1
		inc		si

@g3:	loop	@g1
        cmp		dx,0
        je		@qt
		mov		MaxPos,dx

	    xor		dx,dx
		mov		cx,4
@r1:	shr		dx,1
		test	es:[si],al
        je		@r2
        or		dl,8
@r2:    shl		al,1
		jnz		@r3
        mov		al,1
		inc		si

@r3:	loop	@r1
		mov		MinBtsPos,dx

		{ Pos Tree }

    	mov		i,0

@nl:	mov		bx,0

@t5:    test	es:[si],al
        jz		@rs
        mov		bx,word ptr [LtlSgnlson + bx]
        jmp		@t6

@rs:	mov		bx,word ptr [LtlSgnrson + bx]

@t6:    shl		al,1
		jnz		@t7
        mov		al,1
		inc		si

@t7:    cmp		bx,$8000
		jb		@t5

        mov		dx,bx
        and		dx,$7fff
		cmp		dx,0
        je		@nn
		add		dx,MinBtsPos
@nn:    mov		bx,i
        shl		bx,1
        mov		word ptr [PosHufLen + bx],dx
        inc		i
        mov		bx,i
        cmp		bx,MaxPos
        jb		@nl

@qt:	mov		CmprBitMsk,al
		mov		CmprByteCnt,si
end;


procedure DecodBigSgnTree; assembler;
asm
        { Read BigSgn Var }

        mov		es,CmprBuf_seg
        mov		si,CmprByteCnt
        mov		al,CmprBitMsk

	    xor		dx,dx
		mov		cx,9
@g1:	shr		dx,1
		test	es:[si],al
        je		@g2
        or		dx,256
@g2:    shl		al,1
		jne		@g3
        mov		al,1
		inc		si

@g3:	loop	@g1

        cmp		dx,0
        je		@qt
		mov		MaxBigSgn,dx

	    xor		dx,dx
		mov		cx,4
@r1:	shr		dx,1
		test	es:[si],al
        je		@r2
        or		dl,8
@r2:    shl		al,1
		test	al,0ffh
		jne		@r3
        mov		al,1
		inc		si

@r3:	loop	@r1
		mov		MinBtsBigSgn,dx

		{ BigSgn Tree }

    	mov		i,0

@nl:	mov		bx,0

@t5:    test	es:[si],al
        jz		@rs
        mov		bx,word ptr [LtlSgnlson + bx]
        jmp		@t6

@rs:	mov		bx,word ptr [LtlSgnrson + bx]

@t6:    shl		al,1
		jnz		@t7
        mov		al,1
		inc		si

@t7:    cmp		bx,$8000
		jb		@t5

        mov		dx,bx
        and		dx,$7fff
		cmp		dx,0
        je		@nn
		add		dx,MinBtsBigSgn
@nn:    mov		bx,i
        shl		bx,1
        mov		word ptr [BigSgnHufLen + bx],dx
        inc		i
        mov		bx,i
        cmp		bx,MaxBigSgn
        jb		@nl

@qt:	mov		CmprBitMsk,al
		mov		CmprByteCnt,si
end;



procedure ShowCnt;
begin
	gotoxy(40,wherey);
    write(TextByteCnt - ns);
end;

procedure InsertKey; assembler;
asm
		mov		dx,TextByteCnt
	    sub		dx,3
        mov		si,KeyPtr

@sl:	cmp		si,dx
		ja		@qt
        mov		es,TextBuf_seg
        mov		bx,word ptr es:[si]
        add     bl,byte ptr es:[si + 2]
        xor		bl,bh
        shl		bx,1
	    mov		es,FrsBuf_seg
        mov		ax,word ptr es:[bx]
        mov     word ptr es:[bx],si
		mov		es,NxtBuflw_seg
        mov		byte ptr es:[si],al
		mov		es,NxtBufhg_seg
        mov		byte ptr es:[si],ah
		inc		si
        jmp		@sl

@qt:	mov		KeyPtr,si
end;

procedure EncodBlockMax;
label
	e1,e2,e3,e4,e5,bb,eb,ichr,z1,eo,ee,
	wchr,wstr,outchr,ochr;
begin
    StrCnt := 0; StrPtr := 0;
    LstBeg := 0;
    CmprBitMsk := 1; CmprBitCnt := 0;

    FillChar(FreqPos,64,0);
    FillChar(FreqBigSgn,580,0);
    FillChar(FreqLtlSgn,32,0);

    TextByteCnt := ns;

	asm
bb:     call	InsertKey
		mov		es,TextBuf_seg
		mov		si,TextByteCnt
        mov		bx,word ptr es:[si]
        mov		al,bl
        add     bl,byte ptr es:[si + 2]
        xor		bl,bh
        shl		bx,1
		cmp		si,TextBlock
        jnb		eb
        mov		BstLen,0

        cmp		StrCnt,5999
        jnb		ichr

		call   	FindStrMax

		sub		BstLen,2
        jb		@nsh

        sub		BstPos,1
        cmp		LstBeg,0
        je		@ann
        mov		ax,LstBeg
        inc		ax
        cmp		ax,TextByteCnt
        ja		@gps
        mov		ax,LstLen
        cmp		ax,BstLen
        jnb		@gps

@gcs:   mov		es,TextBuf_seg
		mov		si,TextByteCnt
        dec		si
        mov		bl,es:[si]
        xor		bh,bh
        shl		bx,1
        inc		word ptr [FreqBigSgn + bx]
        mov		si,StrCnt
        shl		si,1
        mov		dx,BstPos
        mov		word ptr [PosBuf + si],dx
        call	RngPos
        inc		word ptr [FreqPos + di]
        mov		dx,BstLen
        mov		word ptr [LenBuf + si],dx
        call	RngLen
        inc		word ptr [FreqBigSgn + 512 + di]
        mov		ax,TextByteCnt
        mov		word ptr [BegBuf + si],ax
		add		ax,BstLen
        add		ax,2
        mov     TextByteCnt,ax
	    inc		StrCnt
		mov		LstBeg,0
		jmp		bb

@nsh:	cmp		LstBeg,0
		jne		@gps


ichr:   mov		es,TextBuf_seg
		mov		si,TextByteCnt
        mov		bl,es:[si]
        xor		bh,bh
        shl		bx,1
        inc		word ptr [FreqBigSgn + bx]
		inc		TextByteCnt
		mov		LstBeg,0
        jmp		bb

@gps:
        mov		si,StrCnt
        shl		si,1
        mov		dx,LstPos
        mov		word ptr [PosBuf + si],dx
        call	RngPos
        inc		word ptr [FreqPos + di]
        mov		dx,LstLen
        mov		word ptr [LenBuf + si],dx
        call	RngLen
        inc		word ptr [FreqBigSgn + 512 + di]
        mov		ax,TextByteCnt
        dec		ax
        mov		word ptr [BegBuf + si],ax
		add		ax,LstLen
        add		ax,2
        mov     TextByteCnt,ax
	    inc		StrCnt
		mov		LstBeg,0
		jmp		bb

@ann:	mov		ax,BstPos
		mov		LstPos,ax
        mov		ax,BstLen
        mov		LstLen,ax
        mov		ax,TextByteCnt
        mov		LstBeg,ax
        inc		TextByteCnt
        jmp		bb

eb:
	end;

{    FillChar(CmprBuf^,ns,0);}
	asm
    	mov		es,CmprBuf_seg
        xor		di,di
        xor		ax,ax
        mov		cx,ns05
        cld
        rep 	stosw
        stosb
    end;



    MakeEncBigSgnTree;
    MakeEncPosTree;
    MakeEncLtlSgnTree;
    EncodLtlSgnTree;
	EncodPosTree;
    EncodLenTree;
   	EncodBigSgnTree;


    TextByteCnt := ns;
    asm

        { Coding Data }

        mov		si,StrCnt
        shl		si,1
        mov		word ptr [BegBuf + si],$ffff
        xor		si,si
        mov		ax,word ptr [BegBuf + si]
        mov		NextStrBeg,ax
        mov		bx,CmprByteCnt
        mov		cx,CmprBitCnt

@nlp:	mov		si,TextByteCnt
		cmp		si,TextBlock
		jnb		eo

        cmp		si,NextStrBeg
        jne		ochr

        call	EncodStr

        mov		ax,BstLen
        inc		ax
        inc		ax
        add		TextByteCnt,ax
        inc		StrPtr
		mov		di,StrPtr
        shl		di,1
		mov		ax,word ptr [BegBuf + di]
        mov		NextStrBeg,ax
        jmp     @nlp


ochr:	call	EncodChrHuf
        inc		TextByteCnt
        jmp		@nlp


eo:
		mov		CmprByteCnt,bx
        mov		CmprBitCnt,cx
    end;


end;


procedure EncodBlockNormal;
label
	e1,e2,e3,e4,e5,bb,eb,ichr,z1,eo,ee,
	wchr,wstr,outchr,ochr;
begin
    StrCnt := 0; StrPtr := 0;
    CmprBitMsk := 1; CmprBitCnt := 0;
    FillChar(FreqPos,64,0);
    FillChar(FreqBigSgn,580,0);
    FillChar(FreqLtlSgn,32,0);

    TextByteCnt := ns;

	asm
bb:     call	InsertKey
		mov		es,TextBuf_seg
		mov		si,TextByteCnt
        mov		bx,word ptr es:[si]
        mov		al,bl
        add     bl,byte ptr es:[si + 2]
        xor		bl,bh
        shl		bx,1
		cmp		si,TextBlock
        jnb		eb
        mov		BstLen,0

        cmp		StrCnt,5999
        jnb		ichr


		call   	FindStrNormal


{        call	viewcnt}

		sub		BstLen,2
        jb		ichr

        sub		BstPos,1
        mov		si,StrCnt
        shl		si,1
        mov		dx,BstPos
        mov		word ptr [PosBuf + si],dx
        call	RngPos
        inc		word ptr [FreqPos + di]
        mov		dx,BstLen
        mov		word ptr [LenBuf + si],dx
        call	RngLen
        inc		word ptr [FreqBigSgn + 512 + di]
        mov		ax,TextByteCnt
        mov		word ptr [BegBuf + si],ax
		add		ax,BstLen
        add		ax,2
        mov     TextByteCnt,ax
	    inc		StrCnt
		jmp		bb


ichr:   mov		es,TextBuf_seg
		mov		si,TextByteCnt
        mov		bl,es:[si]
        xor		bh,bh
        shl		bx,1
        inc		word ptr [FreqBigSgn + bx]
		inc		TextByteCnt
        jmp		bb

eb:
	end;

{    FillChar(CmprBuf^,ns,0);}
	asm
    	mov		es,CmprBuf_seg
        xor		di,di
        xor		ax,ax
        mov		cx,ns05
        cld
        rep 	stosw
        stosb
    end;


    MakeEncBigSgnTree;
    MakeEncPosTree;
    MakeEncLtlSgnTree;
    EncodLtlSgnTree;
	EncodPosTree;
    EncodLenTree;
   	EncodBigSgnTree;


    TextByteCnt := ns;
    asm

        { Coding Data }

        mov		si,StrCnt
        shl		si,1
        mov		word ptr [BegBuf + si],$ffff
        xor		si,si
        mov		ax,word ptr [BegBuf + si]
        mov		NextStrBeg,ax
        mov		bx,CmprByteCnt
        mov		cx,CmprBitCnt

@nlp:	mov		si,TextByteCnt
		cmp		si,TextBlock
		jnb		eo

        cmp		si,NextStrBeg
        jne		ochr

        call	EncodStr

        mov		ax,BstLen
        inc		ax
        inc		ax
        add		TextByteCnt,ax
        inc		StrPtr
		mov		di,StrPtr
        shl		di,1
		mov		ax,word ptr [BegBuf + di]
        mov		NextStrBeg,ax
        jmp     @nlp


ochr:	call	EncodChrHuf
        inc		TextByteCnt
        jmp		@nlp


eo:
		mov		CmprByteCnt,bx
        mov		CmprBitCnt,cx
    end;
end;


procedure EncodBlockLessMem;
label
	e1,e2,e3,e4,e5,bb,eb,ichr,z1,eo,ee,
	wchr,wstr,outchr,ochr;
begin
    StrCnt := 0; StrPtr := 0;
    CmprBitMsk := 1; CmprBitCnt := 0;

    FillChar(FreqPos,64,0);
    FillChar(FreqBigSgn,580,0);
    FillChar(FreqLtlSgn,32,0);

    TextByteCnt := ns;

	asm
		mov		es,TextBuf_seg

bb:
		mov		si,TextByteCnt
        mov		bx,word ptr es:[si]
        mov		ax,bx
        add		bl,byte ptr es:[si + 2]
        xor		bl,bh
        shl		bx,1
		cmp		si,TextBlock
        jnb		eb

        mov		es,FrsBuf_seg
        mov		bx,word ptr es:[bx]
        mov		es,TextBuf_seg

	    cmp		bx,ns2
		jnb		ichr

        cmp		ax,word ptr es:[bx]
        jne     ichr

        cmp		StrCnt,5999
        jnb		ichr

        mov		cx,si
        sub		cx,bx
        mov     dx,TextBlock
        sub		dx,si
        cmp		cx,dx
        jbe		@ee3
        mov		cx,dx

@ee3:	mov		di,bx
        mov		dx,si
        sub		dx,di
        push	ds
        mov		ds,TextBuf_seg
        cld
		rep		cmpsb
        pop		ds
		je		@ee4
		dec		di

@ee4:   sub		di,bx

        mov		si,TextByteCnt
        cmp		ax,word ptr es:[si - 1]
        jne		@nr

		mov		di,si
        mov		cx,TextBlock
        sub		cx,di
        cld
        rep		scasb
        je		@is
        dec		di

@is:	sub		di,TextByteCnt
		mov		dx,1

@nr:	sub		di,2
        jna		ichr
        mov		cx,di

        dec		dx
        mov		si,StrCnt
        shl		si,1
        mov		word ptr [PosBuf + si],dx
        call	RngPos
        inc		word ptr [FreqPos + di]
        mov		dx,cx
        mov		word ptr [LenBuf + si],cx
        call	RngLen
        inc		word ptr [FreqBigSgn + 512 + di]
        mov		ax,TextByteCnt
        mov		word ptr [BegBuf + si],ax
        mov		si,ax
        add		cx,2
		add		ax,cx
        mov     TextByteCnt,ax
	    inc		StrCnt
        mov		es,FrsBuf_seg
        push	ds
        mov		ds,TextBuf_seg
        sub		si,3
@sh:
        mov		bx,word ptr [si]
        add     bl,byte ptr [si + 2]
        xor		bl,bh
        shl		bx,1
        mov     word ptr es:[bx],si
		inc		si
        loop	@sh
        pop		ds
        mov		es,TextBuf_seg
        jmp		bb


ichr:
        mov		bl,al
        xor		bh,bh
        shl		bx,1
        inc		word ptr [FreqBigSgn + bx]
        sub		si,3
        mov		bx,word ptr es:[si]
        add     bl,byte ptr es:[si + 2]
        xor		bl,bh
        shl		bx,1
        mov		es,FrsBuf_seg
        mov     word ptr es:[bx],si
        mov		es,TextBuf_seg
		inc		TextByteCnt
        jmp		bb

eb:
	end;


{    FillChar(CmprBuf^,ns,0);}
	asm
    	mov		es,CmprBuf_seg
        xor		di,di
        xor		ax,ax
        mov		cx,ns05
        cld
        rep 	stosw
        stosb
    end;


    MakeEncBigSgnTree;
    MakeEncPosTree;
    MakeEncLtlSgnTree;
    EncodLtlSgnTree;
	EncodPosTree;
    EncodLenTree;
   	EncodBigSgnTree;

    TextByteCnt := ns;
    asm

        { Coding Data }

        mov		si,StrCnt
        shl		si,1
        mov		word ptr [BegBuf + si],$ffff
        xor		si,si
        mov		ax,word ptr [BegBuf + si]
        mov		NextStrBeg,ax
        mov		bx,CmprByteCnt
        mov		cx,CmprBitCnt

@nlp:	mov		si,TextByteCnt
		cmp		si,TextBlock
		jnb		eo

        cmp		si,NextStrBeg
        jne		ochr

        call	EncodStr

        mov		ax,BstLen
        inc		ax
        inc		ax
        add		TextByteCnt,ax
        inc		StrPtr
		mov		di,StrPtr
        shl		di,1
		mov		ax,word ptr [BegBuf + di]
        mov		NextStrBeg,ax
        jmp     @nlp


ochr:	call	EncodChrHuf
        inc		TextByteCnt
        jmp		@nlp


eo:
		mov		CmprByteCnt,bx
        mov		CmprBitCnt,cx
    end;

end;



procedure EncodBlockFast;
label
	e1,e2,e3,e4,e5,bb,eb,ichr,z1,eo,ee,
	wchr,wstr,outchr,ochr;
begin
    StrCnt := 0; StrPtr := 0;
    CmprBitMsk := 1; CmprBitCnt := 0;

    FillChar(FreqPos,64,0);
    FillChar(FreqBigSgn,580,0);
    FillChar(FreqLtlSgn,32,0);

    TextByteCnt := ns;

	asm
		mov		es,TextBuf_seg

bb:
		mov		si,TextByteCnt
        mov		bx,word ptr es:[si]
        mov		ax,bx
        add		bl,byte ptr es:[si + 2]
        xor		bl,bh
        shl		bx,1
		cmp		si,TextBlock
        jnb		eb

        mov		es,FrsBuf_seg
        mov		bx,word ptr es:[bx]
        mov		es,TextBuf_seg

	    cmp		bx,ns2
		jnb		ichr

        cmp		ax,word ptr es:[bx]
        jne     ichr

        cmp		StrCnt,5999
        jnb		ichr

        mov		cx,si
        sub		cx,bx
        mov     dx,TextBlock
        sub		dx,si
        cmp		cx,dx
        jbe		@ee3
        mov		cx,dx

@ee3:	mov		di,bx
        mov		dx,si
        sub		dx,di
        push	ds
        mov		ds,TextBuf_seg
        cld
		rep		cmpsb
        pop		ds
		je		@ee4
		dec		di

@ee4:   sub		di,bx

        mov		si,TextByteCnt
        cmp		ax,word ptr es:[si - 1]
        jne		@nr

		mov		di,si
        mov		cx,TextBlock
        sub		cx,di
        cld
        rep		scasb
        je		@is
        dec		di

@is:	sub		di,TextByteCnt
		mov		dx,1

@nr:	sub		di,2
        jna		ichr
        mov		cx,di

        dec		dx
        mov		si,StrCnt
        shl		si,1
        mov		word ptr [PosBuf + si],dx
		mov		es,NxtBufhg_seg
        mov		bx,dx
        mov		bl,byte ptr es:[bx]
        xor		bh,bh
        inc		word ptr [FreqPos + bx]
        mov		bx,cx
        mov		word ptr [LenBuf + si],cx
        mov		es,NxtBuflw_seg
        mov		bl,byte ptr es:[bx]
        xor		bh,bh
        inc		word ptr [FreqBigSgn + 512 + bx]
        mov		ax,TextByteCnt
        mov		word ptr [BegBuf + si],ax
        mov		si,ax
        add		cx,2
		add		ax,cx
        mov     TextByteCnt,ax
	    inc		StrCnt
        mov		es,FrsBuf_seg
        push	ds
        mov		ds,TextBuf_seg
        sub		si,3
@sh:
        mov		bx,word ptr [si]
        add     bl,byte ptr [si + 2]
        xor		bl,bh
        shl		bx,1
        mov     word ptr es:[bx],si
		inc		si
        loop	@sh
        pop		ds
        mov		es,TextBuf_seg
        jmp		bb


ichr:
        mov		bl,al
        xor		bh,bh
        shl		bx,1
        inc		word ptr [FreqBigSgn + bx]
        sub		si,3
        mov		bx,word ptr es:[si]
        add     bl,byte ptr es:[si + 2]
        xor		bl,bh
        shl		bx,1
        mov		es,FrsBuf_seg
        mov     word ptr es:[bx],si
        mov		es,TextBuf_seg
		inc		TextByteCnt
        jmp		bb

eb:
	end;

{    FillChar(CmprBuf^,ns,0);}
	asm
    	mov		es,CmprBuf_seg
        xor		di,di
        xor		ax,ax
        mov		cx,ns05
        cld
        rep 	stosw
        stosb
    end;


    MakeEncBigSgnTree;
    MakeEncPosTree;
    MakeEncLtlSgnTree;
    EncodLtlSgnTree;
	EncodPosTree;
    EncodLenTree;
   	EncodBigSgnTree;

    TextByteCnt := ns;
    asm

        { Coding Data }

        mov		si,StrCnt
        shl		si,1
        mov		word ptr [BegBuf + si],$ffff
        xor		si,si
        mov		ax,word ptr [BegBuf + si]
        mov		NextStrBeg,ax
        mov		bx,CmprByteCnt
        mov		cx,CmprBitCnt

@nlp:
		mov		si,TextByteCnt
		cmp		si,TextBlock
		jnb		eo

        cmp		bx,ns_6
        jnb		@oe

        cmp		si,NextStrBeg
        jne		ochr

 		call	EncodStrFast

        mov		ax,BstLen
        inc		ax
        inc		ax
        add		TextByteCnt,ax
        inc		StrPtr
		mov		di,StrPtr
        shl		di,1
		mov		ax,word ptr [BegBuf + di]
        mov		NextStrBeg,ax
        jmp     @nlp

@nn:
        jmp		@nlp


ochr:	call	EncodChrHuf
        inc		TextByteCnt
        jmp		@nlp

@oe:	mov		bx,ns

eo:
		mov		CmprByteCnt,bx
        mov		CmprBitCnt,cx
    end;

end;


procedure EncodBlockSuperFast;
label
	e1,e2,e3,e4,e5,bb,eb,ichr,z1,eo,ee,
	wchr,wstr,outchr,ochr;
begin
    StrCnt := 0; StrPtr := 0;
    CmprBitMsk := 1; CmprBitCnt := 0;
{    FillChar(CmprBuf^,ns,0);}
	asm
    	mov		es,CmprBuf_seg
        xor		di,di
        xor		ax,ax
        mov		cx,ns05
        cld
        rep 	stosw
        stosb
    end;

    TextByteCnt := ns;

	asm
		mov		es,TextBuf_seg

bb:
        cmp		CmprByteCnt,ns_6
        jnb		@oe

		mov		si,TextByteCnt
        mov		bx,word ptr es:[si]
        mov		ax,bx
        add		bl,byte ptr es:[si + 2]
        xor		bl,bh
        shl		bx,1
		cmp		si,TextBlock
        jnb		eb

        mov		es,FrsBuf_seg
        mov		bx,word ptr es:[bx]
        mov		es,TextBuf_seg

	    cmp		bx,ns2
		jnb		ichr

        cmp		ax,word ptr es:[bx]
        jne     ichr

        mov		cx,si
        sub		cx,bx
        mov     dx,TextBlock
        sub		dx,si
        cmp		cx,dx
        jbe		@ee3
        mov		cx,dx

@ee3:	mov		di,bx
        mov		dx,si
        sub		dx,di
        push	ds
        mov		ds,TextBuf_seg
        cld
		rep		cmpsb
        pop		ds
		je		@ee4
		dec		di

@ee4:   sub		di,bx

        mov		si,TextByteCnt
        cmp		ax,word ptr es:[si - 1]
        jne		@nr

		mov		di,si
        mov		cx,TextBlock
        sub		cx,di
        cld
        rep		scasb
        je		@is
        dec		di

@is:	sub		di,TextByteCnt
		mov		dx,1

@nr:	sub		di,2
        jna		ichr
        mov		BstLen,di

        dec		dx
        mov		BstPos,dx

        call	EncodStrSuperFast

        mov		si,TextByteCnt
        mov		cx,BstLen
        inc		cx
        inc		cx
		add		TextByteCnt,cx
        mov		es,FrsBuf_seg
        push	ds
        mov		ds,TextBuf_seg
        sub		si,3
@sh:
        mov		bx,word ptr [si]
        add     bl,byte ptr [si + 2]
        xor		bl,bh
        shl		bx,1
        mov     word ptr es:[bx],si
		inc		si
        loop	@sh
        pop		ds
        mov		es,TextBuf_seg
        jmp		bb


ichr:
        xor		ah,ah
        shl		ax,1
        mov		si,TextByteCnt
        sub		si,3
        mov		bx,word ptr es:[si]
        add     bl,byte ptr es:[si + 2]
        xor		bl,bh
        shl		bx,1
        mov		es,FrsBuf_seg
        mov     word ptr es:[bx],si
        mov		bx,ax
    	mov		ax,word ptr [BigSgnHufVal + bx]
        mov		si,word ptr [BigSgnHufLen + bx]
		mov		es,CmprBuf_seg
		mov		bx,CmprByteCnt
        mov		cx,CmprBitCnt

        cmp		si,8
        jna     @sl
        mov		dx,ax
        xor		ah,ah
        shl		ax,cl
        or		word ptr es:[bx],ax
        inc		bx
        sub		si,8
        mov		al,dh
        xor		ah,ah

@sl:    shl		ax,cl
		or		word ptr es:[bx],ax
        add		cx,si
        cmp		cx,7
        jna		@nc7
        and		cx,7
        inc		bx

@nc7:
		mov		CmprByteCnt,bx
        mov		CmprBitCnt,cx

        mov		es,TextBuf_seg
		inc		TextByteCnt
        jmp		bb

@oe:	mov		CmprByteCnt,ns

eb:
	end;

end;


procedure DecodBlock;
label
	e3, e4, e7, c_f_s, c_f_c,
    bdb,edb,decord,wchr,wstr,
    z1,z2,z3,z5,z6,z7,
    c1,c2,c3,x1,x2,x3;

begin
	TextByteCnt := ns; StrCnt := 0;
	CmprBitMsk := 1; CmprBitCnt := 0;

	FillChar(PosHufLen,64,0);
    FillChar(BigSgnHufLen,1024,0);
    FillChar(LtlSgnHufLen,32,0);


    DecodLtlSgnTree;
   	MakeDecLtlSgnTree;
    DecodPosTree;
    DecodLenTree;
    DecodBigSgnTree;
    MakeDecPosTree;
   	MakeDecBigSgnTree;

    asm
bdb:	mov		ax,TextByteCnt
        cmp		ax,TextBlock
        jnb		edb

        call	DecodChrHuf
        cmp		dx,255
        ja		@dstr

        mov		es,TextBuf_seg
        mov		si,TextByteCnt
        mov		es:[si],dl
        inc		TextByteCnt
        jmp		bdb

@dstr:	sub		dx,256
		call	DecodStr
        jmp		bdb

edb:
    end;

end;


procedure DecodBlockFixed;
label
	e3, e4, e7, c_f_s, c_f_c,
    bdb,edb,decord,wchr,wstr,
    z1,z2,z3,z5,z6,z7,
    c1,c2,c3,x1,x2,x3;

begin
	TextByteCnt := ns; StrCnt := 0;
	CmprBitMsk := 1; CmprBitCnt := 0;


    asm
bdb:	mov		ax,TextByteCnt
        cmp		ax,TextBlock
        jnb		edb

        call	DecodChrHuf
        cmp		dx,255
        ja		@dstr

        mov		es,TextBuf_seg
        mov		si,TextByteCnt
        mov		es:[si],dl
        inc		TextByteCnt
        jmp		bdb

@dstr:	sub		dx,256
		call	DecodStr
        jmp		bdb

edb:
    end;
end;



procedure WriteTextBlock;
begin
    if BlockType = txt then
    begin
    	asm
        	mov		cx,TextBlock
			xor		di,di
            mov		si,ns
            mov		es,TextBuf_seg
            push	ds
            mov		ds,TextBuf_seg

            cld
    @sl:	lodsb
    		stosb
            cmp		al,13
            jne		@nl
            mov		al,10
            stosb
    @nl:	loop	@sl
    		pop		ds
            mov		OrgBlock,di
    	end;
        if not TstInt then
        begin
		    BlockWrite(temparc,TextBuf^,OrgBlock,NmbWriten);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	        if OrgBlock <> NmbWriten then DiskFull;
        end;

	    asm
    	xor  	si,si
        xor		bx,bx
        mov		es,TextBuf_seg
        mov		cx,OrgBlock
@cc:    mov     al,es:[si]
		xor		byte ptr [crc + bx],al
        inc		si
        inc		bx
        and		bx,3
        loop	@cc
		end;
    end
    else
    begin
        if not TstInt then
        begin
		    BlockWrite(TempArc,TextBuf^[ns],TextBlock,NmbWriten);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    	    if TextBlock <> NmbWriten then DiskFull;
        end;
        OrgBlock := TextBlock;

	    asm
    	mov  	si,ns
        xor		bx,bx
        mov		es,TextBuf_seg
        mov		cx,OrgBlock
@rr:    mov     al,es:[si]
		xor		byte ptr [crc + bx],al
        inc		si
        inc		bx
        and		bx,3
        loop	@rr
		end;
    end;

end;


procedure ReadTextBlock;
begin
    BlockRead(TextFile,PosBuf,ns-3,OrgBlock);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    asm
                xor		ah,ah
            	mov		cx,OrgBlock
                mov		si,offset [PosBuf]
                mov		di,ns
                mov     es,TextBuf_seg
                push	ds

                cld
        @sl:	lodsb
                stosb
        		cmp		al,13
                jne		@jm
                cmp		byte ptr [si],10
                je		@nlf
                mov		ah,1
                jmp		@ol

        @nlf:	inc		si
        		dec		cx
                jcxz	@ol

        @jm:	loop	@sl

        @ol:	pop		ds
                mov		TextBlock,di
                mov		a,ah
    end;
    if  a = 0 then
    begin
    	BlockType := txt;
    end
    else
    begin
		BlockType := rnd;
   	    move(PosBuf,TextBuf^[ns],OrgBlock);
        TextBlock := OrgBlock + ns;
    end;
    asm
    	mov		si,offset [PosBuf]
        xor		bx,bx
        xor		ah,ah
        mov		cx,OrgBlock
@cc:    mov     al,[si]
		xor		byte ptr [crc + bx],al
        inc		si
        inc		bx
        and		bx,3
        or		ah,al
        loop	@cc
        mov		a,ah
	end;
    if a < 128 then
    	MaxLen2 := 0
    else
    	MaxLen2 := 126;
end;

procedure ReadTextBlockFast;
begin
    BlockRead(TextFile,TextBuf^[ns],ns-3,OrgBlock);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	BlockType := rnd;
    TextBlock := OrgBlock + ns;

    asm
    	mov  	si,ns
        xor		bx,bx
        mov		es,TextBuf_seg
        mov		cx,OrgBlock
@cc:    mov     al,es:[si]
		xor		byte ptr [crc + bx],al
        inc		si
        inc		bl
        and		bl,3
        loop	@cc
	end;
   	MaxLen2 := 0
end;


procedure ChangeVolume;
var
	c : char;
begin
    inc(vlmcnt);
   	if vlmcnt = 1000 then vlmcnt := 1;
   	str(vlmcnt:3,s);
    for i := 1 to length(s) do if s[i] = ' ' then s[i] := '0';
    arcname := APath +  AName + '.' + s;

    dosx := wherex; dosy := wherey;
    while true do
    begin
	    sound(400);delay(100);nosound;
    	BottomLine('Enter next volume ' + arcname + '      Enter to continue ',lightred + blink);
	    repeat
    		c := WaitKey;
	   	until (ord(c) = 13) or (ord(c) = 27);
        if ord(c) = 27 then
        begin
        	broken := true;
            exit;
        end;

    	ADiskFree := diskfree(ADrive);
        if DosError <> 0 then halt(1);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
        if ADiskFree > 20000 then break;
	end;
  	BottomLine('                                                                ',black);
    window(2,3,79,18); textbackground(blue); textcolor(white);
	showcursor; gotoxy(dosx,dosy);

    assign(temparc,arcname);
	rewrite(temparc,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    FillChar(ArcHeader[4],8,0);
	BlockWrite(temparc,ArcHeader[0],12,NmbWriten);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    if NmbWriten <> 12 then DiskFull;
    FileHdrPos := filepos(temparc);
    FileHeader[32] := 0;
	FileHeader[33] := 0;
	FileHeader[34] := 0;
	BlockWrite(temparc,FileHeader,35,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    if NmbRead <> 35 then DiskFull;
	FileHdrLen := 35;
end;


procedure EncodFile;
var
	WritenBytes : word;

begin
{    FillChar(TextBuf^,ns2,0);}
	asm
    	mov		es,TextBuf_seg
        xor		di,di
        xor		ax,ax
        mov		cx,ns
        cld
        rep 	stosw
    end;
    seek(temparc,filesize(temparc));
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    FileHdrPos := filepos(temparc);
    FillChar(FileHeader,35,0);
    FileHeader[0] := $94; FileHeader[1] := $1C;
    fsplit(textname,FPath,FName,FExt);
    FPath := RelPath(FPath);
    Delete(FExt,1,1);
    for i := 1 to length(FName) do
  		FileHeader[20 + i] := ord(FName[i]);
	for i := 1 to length(FExt) do
	   	FileHeader[28 + i] := ord(FExt[i]);

    PathLen := length(Fpath);
	FileCmntLen := 0;
    FileHeader[32] := PathLen;
	FileHeader[33] := lo(FileCmntLen);
	FileHeader[34] := hi(FileCmntLen);

    FileHdrLen := 35 + FileCmntLen + PathLen;

    if mltplvlm then
    begin
    	if ADiskFree <= FileHdrLen then
        begin
        	close(temparc);
        	ChangeVolume;
		    CmprFileCnt := 0;
        end;
    end;

	BlockWrite(temparc,FileHeader,35,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    if NmbRead <> 35 then DiskFull;
    AdiskFree := ADiskFree - 35;

    if PathLen > 0 then
    begin
    	BlockWrite(temparc,FPath[1],PathLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    if NmbRead <> PathLen then DiskFull;
        ADiskFree := ADiskFree - PathLen;
    end;
	if FileCmntLen > 0 then
    begin
   		BlockWrite(temparc,CmprBuf^,FileCmntLen,NmbRead);
		myiorslt:=ioresult; if myiorslt <>  0 then io_error;
	    if NmbRead <> FileCmntLen then DiskFull;
        ADiskFree := ADiskFree - PathLen;
	end;

    assign(textfile,textname);
    GetFAttr(textfile,Attr);
    FileHeader[14] := lo(Attr);
    filemode := 0;
  	reset(textfile,1);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    TextFilesize := filesize(TextFile);
   	Move(TextFileSize,FileHeader[6],4);
	GetFTime(textfile,Time);
    Move(Time,FileHeader[10],4);
	FileHeader[15] := 0;
    if FixedTree then
    	FileHeader[15] := FileHeader[15] or 8;

    TextFileCnt := 0;
    CmprFileCnt := 0;

    FillChar(crc,4,0);
    KeyPtr := ns;

	writeln(''); write(textname);

    while not eof(TextFile) do
    begin
    	if KeyPtr = 0 then
        begin
{	        Move(TextBuf^[ns],TextBuf^,ns);}
			asm
            	mov     es,TextBuf_seg
                push	ds
                mov		ds,TextBuf_seg
                xor  	di,di
                mov		si,ns
                cld
                mov		cx,ns05
                rep		movsw
                movsb
                pop		ds
            end;
		end;

        CmprByteCnt := 3;

        case method of
        	SuperFastCompr: begin
                                ReadTextBlockFast;
						        TextBuf^[ns-1] := 0;
                                InitHashFast;
								EncodBlockSuperFast;
                            end;

        	FastCompr     : begin
                                ReadTextBlockFast;
						        TextBuf^[ns-1] := 0;
                                InitHashFast;
								EncodBlockFast;
                            end;

        	LessMemCompr  : begin
                                ReadTextBlockFast;
						        TextBuf^[ns-1] := 0;
                                InitHashFast;
								EncodBlockLessMem;
                            end;

	        NormalCompr   : begin;
                                ReadTextBlock;
						        TextBuf^[ns-1] := 0;
                                InitHash;
								EncodBlockNormal;
                            end;

    	    MaxCompr      : begin;
                                ReadTextBlock;
						        TextBuf^[ns-1] := 0;
                                InitHash;
								EncodBlockMax;
                            end;
        end;


       	if broken then exit;

		TextBlock := TextBlock - ns;
        BlockHeader := 0;

    	if CmprByteCnt < TextBlock  then
	    begin
	        CmprBuf^[1] := lo(TextBlock);
    	    CmprBuf^[2] := hi(TextBlock);
            BlockHeader := BlockHeader or 1;
            BlockHeader := BlockHeader or (BlockType shl 1);
            CmprBuf^[0] := BlockHeader;
            CmprByteCnt := CmprByteCnt + 1;
		end
	    else
	    begin
            CmprBuf^[0] := BlockHeader;
	        CmprBuf^[1] := lo(OrgBlock);
    	    CmprBuf^[2] := hi(OrgBlock);
            seek(TextFile, filepos(TextFile) - OrgBlock);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		    BlockRead(TextFile,CmprBuf^[3],OrgBlock,NmbRead);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
			CmprByteCnt := OrgBlock + 3;
		end;


       	if mltplvlm then
        begin
            if ADiskFree < CmprByteCnt then
            begin
			   	BlockWrite(temparc,CmprBuf^,ADiskFree,WritenBytes);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		        CmprFileCnt := CmprFIleCnt + WritenBytes;
				CmprFileSize := CmprFileCnt + FileHdrLen;
   				Move(CmprFileSize,FileHeader[2],4);
			    Seek(temparc,FileHdrPos);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
				FileHeader[15] := FileHeader[15] or 1;
	   			BlockWrite(temparc,FileHeader,35,NmbRead);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    	        close(temparc);
			    if ioresult <> 0 then io_error;
                ChangeVolume;
            	if broken then exit;

			    FileHeader[15] := 2;
				CmprFileCnt := CmprByteCnt - WritenBytes;
	            BlockWrite(temparc,CmprBuf^[WritenBytes],CmprFileCnt,NmbWriten);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
                ADiskFree := ADiskFree - CmprFileCnt;
            end
            else
            begin
			   	BlockWrite(temparc,CmprBuf^,CmprByteCnt,NmbWriten);
				myiorslt:=ioresult; if myiorslt <>  0 then io_error;
			    if NmbWriten <> CmprByteCnt then DiskFull;
		        CmprFileCnt := CmprFIleCnt + CmprByteCnt;
        		ADiskFree := ADiskFree - CmprByteCnt;
                if ADiskFree < 4 then
                begin
					CmprFileSize := CmprFileCnt + FileHdrLen;
   					Move(CmprFileSize,FileHeader[2],4);
				    Seek(temparc,FileHdrPos);
					myiorslt:=ioresult; if myiorslt <>  0 then io_error;
					FileHeader[15] := FileHeader[15] or 1;
		   			BlockWrite(temparc,FileHeader,35,NmbRead);
					myiorslt:=ioresult; if myiorslt <>  0 then io_error;
				    if NmbRead <> 35 then DiskFull;
    		        close(temparc);
				    if ioresult <> 0 then io_error;
                	ChangeVolume;
	            	if broken then exit;
				    FileHeader[15] := 2;
					CmprFileCnt := 0;
    			end;
            end;
        end
        else
        begin
		   	BlockWrite(temparc,CmprBuf^,CmprByteCnt,NmbWriten);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
		    if NmbWriten <> CmprByteCnt then DiskFull;
       		ADiskFree := ADiskFree - CmprByteCnt;
	        CmprFileCnt := CmprFIleCnt + CmprByteCnt;
        end;
        TextFileCnt := TextFileCnt + OrgBlock;
        procbytes := procbytes + OrgBlock;
        dosx := wherex; dosy := wherey; window(1,1,80,25);
        textbackground(cyan); textcolor(white);
	    gotoxy(69,21);write(procbytes);
    	i := trunc(41 * procbytes / selbytes);
        if i > 41 then i := 41;
        s := ''; for j := 1 to i do s := s + '';
        gotoxy(20,21); textcolor(yellow); write(s);
        window(2,3,79,18); gotoxy(dosx,dosy);
        textbackground(blue); textcolor(white);
        if PressEsc then
        begin
        	broken := true;
            exit;
        end;
        KeyPtr := 0;
	end;
	CmprFileSize := CmprFileCnt + FileHdrLen;
	Move(CmprFileSize,FileHeader[2],4);
    if length(password) > 0 then
    begin
    	FileHeader[15] := FileHeader[15] or 4;
    	crc := crc xor pass;
    end;
    Move(crc,FileHeader[17],4);
    Seek(temparc,FileHdrPos);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    BlockWrite(temparc,FileHeader,35,NmbRead);
	myiorslt:=ioresult; if myiorslt <>  0 then io_error;
    if NmbRead <> 35 then DiskFull;
   	close(textfile);
    if ioresult <> 0 then io_error;
    if length(textname) < 38 then
	    gotoxy(40,wherey)
    else
    	gotoxy(65,wherey);
    if TextFileSize = 0 then
    	s := '0.000'
    else
	    str((CmprFileCnt)/(TextFileSize) : 4 : 3,s);
    write(' Ratio: ',s);
    inc(procfiles);
    dosx := wherex; dosy := wherey; window(1,1,80,25);
    textbackground(cyan); textcolor(white);
    gotoxy(69,20);write(procfiles);
    window(2,3,79,18); gotoxy(dosx,dosy);
    textbackground(blue); textcolor(white);
end;



procedure DecodFile;
var
	c: char;
    ReadBytes : word;

begin
    if (FileHeader[15] and 8) <> 0 then
    begin
    	FixedTree := true;
        InitFixedTreeDecod;
    end
    else
    	FixedTree := false;

    FillChar(TextBuf^,ns2,0);

    CmprByteCnt := ns;
    FillChar(crc,4,0);

    while TextFileCnt < TextFileSize do
    begin

    	Move(CmprBuf^[CmprByteCnt],CmprBuf^,ns - CmprByteCnt);
        trycnt := 5; cfp := filepos(arcfile);
        while trycnt > 0 do
        begin
		    BlockRead(arcfile,CmprBuf^[ns - CmprByteCnt],CmprByteCnt,ReadBytes);
			myiorslt:=ioresult;
            if myiorslt = 0 then
            	break;
            dec(trycnt);
            seek(arcfile,cfp);
        end;
		if myiorslt <>  0 then io_error;


        if (ReadBytes < CmprByteCnt) and (filebecont) then
        begin
            close(arcfile);
		    if ioresult <> 0 then io_error;
            s := AExt;
            delete(s,1,1);
            val(s,vlmcnt,i);
            if i <> 0 then
               vlmcnt := 1
            else
               inc(vlmcnt);
           	str(vlmcnt:3,s);
            for i := 1 to length(s) do if s[i] = ' ' then s[i] := '0';
            AExt := '.' + s;
            arcname := APath +  AName + AExt;

	        dosx := wherex; dosy := wherey;
            repeat
	   	        sound(400);delay(100);nosound;
	            BottomLine('Enter next volume ' + arcname + ' and press Enter to continue!', lightred + blink);
				repeat
                	c := WaitKey;
	           	until (ord(c) = 13) or (ord(c) = 27);
                if ord(c) = 27 then
                begin
                	broken := true;
                    exit;
                end;
				findfirst(arcname,archive,sr);
			until DosError = 0;
		  	BottomLine('                                                                ',black);
			window(2,3,79,18); textbackground(blue); textcolor(white);
			showcursor; gotoxy(dosx,dosy);

            assign(arcfile,arcname);
		    filemode := 0;
            reset(arcfile,1);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            ArcSize := filesize(arcfile);
            BlockRead(arcfile,ArcHeader,12,i);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
            fileinarc := filepos(arcfile);
            BlockRead(arcfile,FileHeader,35,i);
			myiorslt:=ioresult; if myiorslt <>  0 then io_error;
			Move(FileHeader[2],CmprFileSize,4);
	        if (FileHeader[15] and 1) <> 0 then filebecont := true else filebecont := false;
            if (FileHeader[0] <> $94) or (FileHeader[1] <> $1C) then
            begin
            	MessageWin('Structure of ' + arcname + ' is damaged');
                broken := true;
                exit;
            end;
	        trycnt := 5; cfp := filepos(arcfile);
    	    while trycnt > 0 do
        	begin
            	BlockRead(arcfile,CmprBuf^[ns - CmprByteCnt + ReadBytes],CmprByteCnt - ReadBytes,NmbRead);
				myiorslt:=ioresult;
    	        if myiorslt = 0 then
        	    	break;
            	dec(trycnt);
	            seek(arcfile,cfp);
    	    end;
			if myiorslt <>  0 then io_error;
		end;
    	CmprByteCnt := 3;
        BlockHeader := CmprBuf^[0];
        TextBlock := CmprBuf^[1]; i := CmprBuf^[2]; TextBlock := TextBlock + 256 * i;
        Move(TextBuf^[ns],TextBuf^,ns);
        TextBuf^[ns-1] := 0;
        BlockType := (BlockHeader shr 1) and 1;

	    if BlockHeader = 0 then
    	begin
            Move(CmprBuf^[3],TextBuf^[ns],TextBlock);
	        CmprByteCnt := TextBlock + 3;
            OrgBlock := TextBlock;
    	end
	    else
    	begin
   			TextBlock := TextBlock + ns;

            if FixedTree then
            	DecodBlockFixed
            else
	           	DecodBlock;


            CmprByteCnt := CmprByteCnt + 1;
    	    TextBlock := TextBlock - ns;
    	end;
        WriteTextBlock;
        TextFileCnt := TextFileCnt + OrgBlock;
        procbytes := procbytes + OrgBlock;
		dosx := wherex; dosy := wherey; window(1,1,80,25);
	    textbackground(cyan); textcolor(white);
	    gotoxy(69,21);write(procbytes);
    	i := trunc(41 * procbytes / selbytes);
        if i > 41 then i := 41;
        s := ''; for j := 1 to i do s := s + '';
        textcolor(yellow); gotoxy(20,21); write(s);
        window(2,3,79,18); gotoxy(dosx,dosy);
	    textbackground(blue); textcolor(white);
        if PressEsc then
        begin
        	broken := true;
            exit;
        end;
	end;
    inc(procfiles);
    dosx := wherex; dosy := wherey; window(1,1,80,25);
    textbackground(cyan); textcolor(white);
    gotoxy(69,20);write(procfiles);
    window(2,3,79,18); gotoxy(dosx,dosy);
    textbackground(blue); textcolor(white);
end;

begin
end.