Program Assignment_2;
Uses
  Crt;

Const
  Dims = 9;                       { Maximum Number of coefficents to use }

Type
  Matrix = Array[1..Dims, 1..Dims] of real;  { Type for a Matrix          }
  Vector = Array[1..Dims] of real;           { Type for a Vector (column) }
  Row    = Array[1..Dims] of Integer;        { Type for a Row    (vector) }

{---------------------------------------------------------------------------}

Procedure LUD (Var A: Matrix; Var C:vector; var X: Vector; N: Integer);
   {*************************************************}
   {**      Globally defined types                 **}
   {*************************************************}
   {**  Matrix =  a 2-d Real Array                 **}
   {**  Vector =  a 1-d Real Array                 **}
   {**  Row    =  a 1-d Integer Array              **}
   {*************************************************}
   {**     Definition of Variables Used            **}
   {*************************************************}
   {**  N   = number of equations                  **}
   {**  A[] = Matrix of Coefficients               **}
   {**  C[] = Right hand side vector               **}
   {**  X[] = Unknowns                             **}
   {**  O[] = Order Vector                         **}
   {**  S[] = Scale Vector                         **}
   {*************************************************}

  Procedure Order(Var S: Vector; A: Matrix; Var O: Row;  N: Integer);
  Var
    i, j: Integer;
  Begin
    for i:= 1 to N do                  { Sort the rows of the matrix }
    Begin
      O[i]:= i;
      S[i]:= Abs(A[i,1]);
      for j:= 2 to N do
      Begin
        if Abs(A[i,j]) > S[i] Then
          S[i]:= Abs(A[i,j]);
      end; { for j }
    end; { for i }
  end; { Procedure Order }

  Procedure Pivot(Var S: Vector; A: Matrix; Var O: Row; j,N: Integer);
  Var
    ii: Integer;
    Pivot, Idum, dum: Integer;
    big, dummy: Real;

  Begin
    pivot:= j;
    big:= Abs(A[O[j],j]/S[O[j]]);
    for ii:= j+1 to N do
    Begin
      dummy:= Abs(A[O[ii],j]/S[O[ii]]);
      if (dummy > big) then
      Begin
        big:= dummy;
        pivot:= ii;
      end;
    end;
    idum:= O[pivot];
    O[pivot]:= O[j];
    O[j]:= idum;
  end; { Procedure pivot }

  Procedure Decmp(S: Vector; Var A: Matrix; Var O: Row; N: Integer);
  Var
    r, i, j, k: Integer;
    Sum, Dummy: Real;

  Begin
    j:= 1;
    Pivot(S, A, O, j, N);
    for j:= 2 to N do
    Begin
      A[O[1],j]:= A[O[1],j]/A[O[1],1];
    end;
    for j:= 2 to N-1 do
    Begin
      for i:= j to N do
      begin
        Sum:= 0.0;
        for k:= 1 to j-1 do
        Begin
          Sum:= Sum + A[O[i],k]*A[O[k],j];
        end;  { for k }
        A[O[i],j]:= A[O[i],j] - Sum;
      end; { for i }
    Pivot(S,A,O,j,N);
    for K:= j+1 to N do
    Begin
      Sum:= 0.0;
      for i:= 1 to J-1 do
      Begin
        Sum:= Sum + A[O[j],i]*A[O[i],k];
      end;  { for i }
      A[O[j],k]:=(A[O[j],k]-Sum)/A[O[j],j];
    end;
  end;
  Sum:= 0.0;
  for k:= 1 to N-1 do
  Begin
    Sum:= A[O[N],k]*A[O[k],N]+Sum;
  end;
  A[O[N],N]:= A[O[N],N] - Sum;
  end; { procedure Decomp }

  Procedure Solve(A: Matrix; C: Vector; Var X: Vector; O: Row; N: Integer);
  Var
    Sum: Real;
    i, j: Integer;

  Begin
    X[1]:= C[O[1]]/A[O[1],1];
    for i:= 2 to N do
    begin
      Sum:= 0.0;
      For j:= 1 to i-1 do
      Begin
        Sum:= Sum + A[O[i],j]*X[j];
      end;
      X[i]:= (C[O[i]]-Sum)/A[O[i],i];
    end; { for i }
    for i:= N-1 downto 1 do
    Begin
      Sum:= 0.0;
      for j:= i+1 to N do
      Begin
        Sum:= Sum+A[O[i],j]*X[j];
      end;
      X[i]:= X[i] - Sum;
    end; { for i }
  end; { Procedure Solve }

  { end of local procedures for LUd procedure }

  Var
    S: Vector;
    O: Row;

  Begin  { Procedure Lud }
    Order(S,A,O,N);
    Decmp(S,A,O,N);
    Solve(A,C,X,O,N);
  end;  { Procedure Lud }

{---------------------------------------------------------------------------}
  Function Power( Base:real; exponent: Integer): real;
  {  Turbo Pacal has no Power function built in.                       }
  {  This function will raise a base number to a Whole number exponent }

  Var
    I: Integer;
    temp: Real;

  Begin
    temp:=1;
    for i:= 1 to Exponent do
      temp:= temp*base;
    Power:= temp;
  end;

{---------------------------------------------------------------------------}
  Procedure MatrixMult( A, B: Matrix; M, N: Integer; Var C: Matrix);
  Var
    i, j, k: Integer;

    begin
    for k:= 1 to N do     { Output col Number }
    Begin
      for j:= 1 to N do   { OutPut  Number, Input Column }
      Begin
        for i:= 1 to M do { Input Row }
        begin
          C[k,j]:= C[k,j] + A[i,j]*B[i,k];
        end;
      end;
    end;
  end;

{---------------------------------------------------------------------------}
  Procedure MatrixbyVector(A:Matrix; B:Vector; N:Integer; Var C:Vector);
  Var
    i, j: Integer;
    Begin
      for j:= 1 to N do
        for i:= 1 to N do
          C[j]:= C[j] + A[i,j]*B[i];
    end;

{===========================================================================}
{***************************************************************************}
{**                 Begining of main Program Block                        **}
{***************************************************************************}
Var
  F: Text;
  S: String;

   Data: Array[1..2, 1..1000] of real;   { Array to hold input data       }
  XSums: Array[0..2*Dims-2] of real;     { Precalculated x sums array     }
  YSums: Array[1..Dims] of real;         { Precalculated y, and y*x array }

  Q, A: Matrix;                          { Matrix's for use in regression }
  Z, C, B, LastC: Vector;                { Vectors for use in regression  }

  NN, MaxXOrd, MaxYOrd: Integer;         { Sizing variables               }


  i, j, k: Integer;                      { Looping variables              }
  Coeffs: Integer;                       { Current number of coefficents  }
  X, Y, Ybar, Ycalc, Delta: Real;        { Variables Data maninipulation  }
  St, Sr, Syx, LastSt, r2, r: Real;      { Variables for fit quality      }
  LastCorrel, LastSr, LastSyx: Real;     { Holders for Previous values    }
  Tol: Real;                             { Tolerance for stopping         }
  Done: boolean;                         { Solution Flag                  }


BEGIN
  S:= 'PROJECT2.DAT';                    { Set the name of data file      }
  Tol:= 0.00001;                         { Set the stopping Tolerance     }
  ClrScr;                                { Start with a fresh Screen      }

  MaxXOrd:= (Dims-1)*2;                  { Set size of XSums Vector       }
  MaxYOrd:= Dims-1;                      { Set size of YSums Vector       }

  for j:= 1 to MaxXOrd do
    XSums[j]:=0.0;                       { Initialize XSums Vector        }
  for k:= 1 to MaxYOrd do
    YSums[k]:= 0.0;                      { Initialize YSums Vector        }

  Assign(F, s);                          { Associate file name to file }
{$I-}                                    { variable }
  Reset(F);
{$I+}
  if IOResult <> 0 then
  Begin
    Writeln('********  Error the file ', S, ' was not found *********');
    Writeln;
    Writeln('     The input file must be named PROJECT2.DAT ');
    Halt(1);
  end;

  Readln(F, NN);      { See how many x,y pairs are to be read in         }
  XSums[0]:= NN;      { X[0] is actually number of data points           }
  Ybar:=0.0;          { This will allow a single loop to fill the matrix }

  for I:= 1 to NN do
  begin                                  { note index number is the exponent}
    Readln(F, Data[1,i], Data[2,i]);     { Begin reading in data pairs      }
    XSums[1]:= XSums[1] + Data[1,i];     { sum x's and y's outside j-loop   }
    YSums[1]:= YSums[1] + Data[2,i];     { to save a function call to power }
    for j:= 2 to MaxXOrd do              { calculate higher orders          }
      XSums[j]:= XSums[j] + Power(Data[1,i], j);
    for j:= 2 to MaxYord+1 do
      YSums[j]:= YSums[j] + Data[2,i]*Power(Data[1,i], j-1);
  end; { for n }
  Ybar:= YSums[1]/nn;                    { calculate the average y for later}
  close(f);                              { done with the work file          }

 { Prepare matrices for solution, Note [A] is equal to [A]t since it is a   }
 { symetric Matrix.  The Matrix is set for the largest number of coeffcients}
 { The XSums and YSums are precalculated for use in assembling the A matrix }
 { Even if all orders are unused, this method reduces the amount of time    }
 { spent regenerating the lower order data sets.                            }

  Done:= false;                          { Start off on the right foot      }
  LastCorrel:=0.0;                       { No last pass yet                 }
  r:= -0.001;
  Coeffs:=1;
  While Not Done do
  begin
    Coeffs:= Coeffs+1;                   { Increment the coefficent number  }
    LastCorrel:= R;                      { Save the last passes correlation }

    for i:=1 to Dims do                  { Reinitalize Arrays               }
      Begin
        B[i]:=0.0;
        C[i]:=0.0;
        Z[i]:=0.0;
      for j:=1 to dims do
      Begin
        A[i,j]:= 0.0;
        Q[i,j]:= 0.0;
      end;
    end;

    for i:= 1 to Coeffs do         { Build Matrix.  using XSums and YSums    }
      for j:= 1 to Coeffs do       { as mentioned above.  This requires only }
        A[i,j]:= XSums[i+j-2];     { reletivly few operations to set up the  }
                                   { for each pass.                          }
    for i:= 1 to Coeffs do         { Build Vector in a similar manner.       }
      B[i]:= YSums[i];

    MatrixMult( A, A, coeffs, coeffs, Q);  { do the multiplication }
    MatrixByVector( A, B, coeffs, Z);
    LUd(Q, Z, C, coeffs);                  { Find the c vector }

    Sr:= 0.0;                           { See how well we did this pass }
    St:= 0.0;
    for i:= 1 to NN do
    Begin
      ycalc:=0.0;
      for j:= 1 to Coeffs do
        ycalc:= Ycalc + c[j]*(Power(Data[1,i],j-1));
      Delta:= Data[2,i]-Ycalc;
      Sr:= Sr + Delta*Delta;
      St:= St + (Data[2,i]-Ybar)*(Data[2,i]-Ybar);
    end;
    Syx:= Sqrt(Sr/(NN-Coeffs));
    r2:= Abs(st-sr)/st;
    r:= Sqrt(R2);
                                         { Report on how well we did  }

    Write('For ', Coeffs, ' Coefficents:   ');
    Write('  Syx= ', Syx:10:5);
    WriteLn('  R=',  r:5:5);
    for i:=1 to coeffs do
      Write('a', i, '=', C[i]:5:5,' ');
    Writeln;
    Writeln;

    if lastcorrel > r     then done:= true;  { See if were Done }
    if Coeffs = dims      then done:= true;
    if R-LastCorrel < Tol then done:= true;
    if not done then
    begin                                    { If not save the last run }
      for i:= 1 to Coeffs do                 { since we will need it    }
      begin
        LastC[i]:= C[i];
        LastSr:= Sr;
        LastSt:= St;
        LastSyx:= Syx;
      end;
    end;
  end;
    Writeln('*****************************************************************');
    WriteLn('******              Solution found is as follows           ******');
    Writeln('*****************************************************************');
    WriteLn;
    Write('  f(x)= ', LastC[1]:5:5);
    if LastC[2] >= 0.0 then Write('+');
    Write(LastC[2]:5:5, '*x');
    for i:= 3 to coeffs-1 do
    Begin
      if LastC[i] >= 0.0 then Write('+');
      Write( LastC[i]:5:5, '*x^', i-1);
    end;

    WriteLn;
    WriteLn;
    WriteLn('     Standard error of Estimate: ', LastSyx:5:5);
    WriteLn('        Correlation Coefficient: ', LastCorrel:5:5);
    Writeln;

end.



