// Borland ObjectVision -- (C) Copyright 1991 by Borland International

/*
    Build OVLOOPS.DLL with commands such as these:

        bcc -c -ml -WDE -Ic:\bc\include ovloops.c
        tlink -Twd -c -Lc:\bc\lib c0dl ovloops,ovloops,, cwinl cl import,ovloops
        rc ovloops.dll
*/

#include <windows.h>

typedef LPSTR FAR PASCAL OVCALLBACK_GET           ( LPSTR );
typedef void  FAR PASCAL OVCALLBACK_PUT           ( LPSTR, LPSTR );
typedef LPSTR FAR PASCAL OVCALLBACK_EXECUTESTRING ( LPSTR, LPSTR, unsigned,
    unsigned );


/******************************************************************************
*
* name          SelfRegister -- Register all of the functions of this DLL
*
* arguments     1.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*
* return        Zero
*
* register      @REGISTER("@REGISTER_OVLOOPS","In","","ovloops.dll",
*                   "SelfRegister",1)
*
******************************************************************************/

int FAR PASCAL _export SelfRegister( OVCALLBACK_EXECUTESTRING lpfnCallBack )
{
    (void)(*lpfnCallBack)(
        "@REGISTER(\"@WHILELOOP\",\"ICCn\",\"\"\"ConditionExpression\"\","
            "\"\"ActionExpression\"\"\",\"ovloops.dll\",\"iWhileLoop\",1)"
        , 0, 0, 0 );
    (void)(*lpfnCallBack)(
        "@REGISTER(\"@WHILEFIELD\",\"JCCwx\",\"\"\"ConditionField\"\","
            "\"\"EventField\"\"\",\"ovloops.dll\",\"lWhileField\",1)"
        , 0, 0, 0 );
    (void)(*lpfnCallBack)(
        "@REGISTER(\"@EXECUTE\",\"CCnF\",\"\"\"CommandToExecute\"\"\","
            "\"ovloops.dll\",\"szExecuteString\",1)"
        , 0, 0, 0 );
    return 0;
}

/******************************************************************************
*
* name          iWhileLoop -- While function using ExecuteString callback
*
* description   You can use this function to implement an @WHILELOOP in OV.
*               Link error reporting is disabled during both condition and
*               action execution.
*
* arguments     1.  LPSTR szCondition -- the condition expression
*               2.  LPSTR szAction -- the action expression
*               3.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*
* return        Zero (an int)
*
* register      @REGISTER("@WHILELOOP","ICCn",
*                   """ConditionExpression"",""ActionExpression""",
*                   "ovloops.dll","iWhileLoop",1)
*
******************************************************************************/

int FAR PASCAL _export iWhileLoop(
    LPSTR szCondition,
    LPSTR szAction,
    OVCALLBACK_EXECUTESTRING lpfnCallBack )
{
    char sBuf[10];
    char * szConditionResult;

    szConditionResult = (*lpfnCallBack)( szCondition, sBuf, sizeof(sBuf), 1 );
    while ( szConditionResult && !lstrcmpi(szConditionResult,"Yes") )
    {
        (void)(*lpfnCallBack)( szAction, (LPSTR)0, 0, 1 );
        szConditionResult = (*lpfnCallBack)( szCondition, sBuf,
                                                 sizeof(sBuf), 1 );
    }
    return 0;
}

/******************************************************************************
*
* name          lWhileField --  While function using only Get & Put callbacks
*
* description   You can use this function to implement an @WHILEFIELD in OV.
*
* arguments     1.  LPSTR szConditionField
*               2.  LPSTR szEventField
*               3.  OVCALLBACK_PUT lpfnPutCallBack
*               4.  OVCALLBACK_GET lpfnGetCallBack
*
* return        unsigned long -- the number of times through the loop
*
* register      @REGISTER("@WHILEFIELD","JCCwx","""ConditionField"",
*                   ""EventField""","ovloops.dll","lWhileField",1)
*
******************************************************************************/

unsigned long FAR PASCAL _export lWhileField(
    LPSTR szConditionField,
    LPSTR szEventField,
    OVCALLBACK_PUT lpfnPutCallBack,
    OVCALLBACK_GET lpfnGetCallBack  )
{
    char far * szCondition;
    char far * szEvent;
    char sNumber[20];
    unsigned long lLoop;

    szCondition = (*lpfnGetCallBack)( szConditionField );
    szEvent = (*lpfnGetCallBack)( szEventField );
    if ( szCondition == 0 || szEvent == 0 )
    {
        // One of the fields doesn't exists. Don't event try because
        // the while would loop forever.
        lLoop = 0;
    }
    else
    {
        lLoop = 0;
        while ( lstrcmpi(szCondition,"No") )
        {
            lLoop++;
            sprintf(sNumber,"%ld",lLoop);
            if ( lLoop == 1 && !lstrcmpi(szEvent,sNumber) )
            {
                lstrcpy( sNumber, "0" ); // To ensure we get a change event
            }
            (*lpfnPutCallBack)( (LPSTR)szEventField, (LPSTR)sNumber );
            szCondition = (*lpfnGetCallBack)( szConditionField );
        }
    }
    return lLoop;
}

/******************************************************************************
*
* name          szExecuteString -- Send a command string to OV for execution
*
* description   Use this function to send a command to OV for execution.
*
* arguments     1.  LPSTR szCommand  -- the command to execute
*               2.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*               3.  LPSTR sAnswerBuffer -- place for the answer
*
* return        LPSTR -- result string
*
* register      @REGISTER("@EXECUTE","CCnF","""CommandToExecute""",
*                   "ovloops.dll","szExecuteString",1)
*
******************************************************************************/

LPSTR FAR PASCAL _export szExecuteString(
    LPSTR szCommand,
    OVCALLBACK_EXECUTESTRING lpfnCallBack,
    LPSTR sAnswerBuf )
{
    LPSTR szResult;
    szResult = (*lpfnCallBack)( szCommand, sAnswerBuf, 4096, 0 );
    if ( !szResult )
    {
        szResult = ""; // Return something
    }
    return szResult;
}

// ------------------------------------------------------------------- //
//                                                                     //
//   Every DLL has an entry point LibMain and an exit point WEP        //
//                                                                     //
// ------------------------------------------------------------------- //

// Turn off "Parameter never used" warning
#pragma argsused

int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSegment,
                        WORD wHeapSize, LPSTR lpszCmdLine )
{
    // The startup code for the DLL initializes the local heap (if
    // there is one) with a call to LocalInit which locks the data
    // segment.
    if ( wHeapSize != 0 )
        UnlockData( 0 );
    return 1;   // Indicate that the DLL was initialized successfully.
}

// Turn off "Parameter never used" warning
#pragma argsused

int FAR PASCAL WEP ( int bSystemExit )
{
    return 1;
}

