#include <windows.h>
#include <stdio.h>
#include <commdlg.h>
#include <bwcc.h>
#include <string.h>
#include <dir.h>
#include <stdlib.h>
#include <io.h>
#include <mmsystem.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>

typedef LPSTR FAR PASCAL OVCALLBACK_GET           ( LPSTR );
typedef VOID  FAR PASCAL OVCALLBACK_PUT           ( LPSTR, LPSTR );
typedef LPSTR FAR PASCAL OVCALLBACK_EXECUTESTRING ( LPSTR, LPSTR, unsigned,
	unsigned );
typedef VOID  FAR PASCAL OVCALLBACK_RESET         ( LPSTR );
typedef VOID  FAR PASCAL OVCALLBACK_SETCURRENTROW ( int, int );
typedef int   FAR PASCAL OVCALLBACK_GETCURRENTROW ( int );
typedef int   FAR PASCAL OVCALLBACK_GETLASTROW    ( int );
typedef int   FAR PASCAL OVCALLBACK_ISCOLUMN      ( LPSTR );

typedef struct {
    WORD pspInt20;            /* Int 20h instruction             */
    WORD pspNextParagraph;    /* segment addr. of next paragraph */
    BYTE res1;                /* reserved                        */
    BYTE pspDispatcher[5];    /* long call to MS-DOS             */
    DWORD pspTerminateVector; /* termination address (Int 22h)   */
    DWORD pspControlCVector;  /* addr of CTRL+C (Int 23h)        */
    DWORD pspCritErrorVector; /* addr of Crit-Error (Int 24h)    */
    WORD res2[11];            /* reserved                        */
    WORD pspEnvironment;      /* segment address of environment  */
    WORD res3[23];            /* reserved                        */
    BYTE pspFCB_1[16];        /* default FCB #1                  */
    BYTE pspFCB_2[16];        /* default FCB #2                  */
	DWORD res4;               /* reserved                        */
    BYTE pspCommandTail[128]; /* command tail (also default DTA) */
} PSP, FAR* LPSP;

// ObjectVisionFormClass extra bytes struct
typedef struct FormItem
{
	LONG l1;
	LONG l2;
	LONG l3;
	HANDLE h1;
	unsigned u1;
	LONG l4;
	unsigned u2;
	LPSTR FormName; //using form name
	LONG  l5;
	LONG  l6;
	LONG  l7;
} FormItem;

BOOL breakFlag, breakAllFlag;
FILE *source, *dest;


/******************************************************************************
*
* name          SelfRegister -- Register all of the functions of this DLL
*
* arguments     1.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*
* return        Zero
*
* register      @REGISTER("@REGISTER_FUNCTIONS","In","","function.dll",
*                   "SelfRegister",1)
*
******************************************************************************/

int FAR PASCAL _export SelfRegister(
	OVCALLBACK_EXECUTESTRING lpfnCallBack )
{
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@While\",\"ICCn\",\"\"\"Condition\"\",\"\"Command\"\"\","
		"\"function.dll\",\"iWhileLoop\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Until\",\"ICCn\",\"\"\"Condition\"\",\"\"Command\"\"\","
		"\"function.dll\",\"iUntilLoop\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Loop\",\"IICn\",\"Loop Count,\"\"Command\"\"\","
		"\"function.dll\",\"iLoop\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@For\",\"ICBBBCFnw\","
		"\"\"\"Loop Field\"\",Start,Stop,Increment,\"\"Command\"\"\","
		"\"function.dll\",\"iFor\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Break\",\"I\",\"\","
		"\"function.dll\",\"iBreak\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@BreakAll\",\"I\",\"\","
		"\"function.dll\",\"iBreakAll\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Execute\",\"CCnF\",\"\"\"Command\"\"\","
		"\"function.dll\",\"szExecuteString\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@MessageBeep\",\"II\",\"Beep Type\","
		"\"function.dll\",\"iMessageBeep\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Play\",\"AC\",\"\"\"File.wav\"\"\","
		"\"function.dll\",\"iPlayWav\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@MessageBox\",\"ICCIIIy\","
		"\"\"\"Box Title\"\",\"\"Text\"\",Buttons,Default Button,Icon\","
		"\"function.dll\",\"iMessageBox\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Maximize\",\"Iy\",\"\","
		"\"function.dll\",\"iMaximize\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@MaximizeForm\",\"II\",\"Form Handle\","
		"\"function.dll\",\"iMaximizeForm\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@RestoreWindow\",\"Iy\",\"\","
		"\"function.dll\",\"iRestoreWindow\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@RestoreForm\",\"II\",\"Form Handle\","
		"\"function.dll\",\"iRestoreForm\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Minimize\",\"Iy\",\"\","
		"\"function.dll\",\"iMinimize\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@HideWindow\",\"Iy\",\"\","
		"\"function.dll\",\"iHideWindow\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@HideForm\",\"II\",\"Form Handle\","
		"\"function.dll\",\"iHideForm\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@ShowWindow\",\"Iy\",\"\","
		"\"function.dll\",\"iShowWindow\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@ShowForm\",\"II\",\"Form Handle\","
		"\"function.dll\",\"iShowForm\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@MoveWindow\",\"AIIIIy\",\"Left,Top,Width,Height\","
		"\"function.dll\",\"iMoveWindow\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@MoveForm\",\"AIIIII\",\"Form Handle,Left,Top,Width,Height\","
		"\"function.dll\",\"iMoveForm\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetWindowPos\",\"ACCCCFny\","
		"\"\"\"Left\"\",\"\"Top\"\",\"\"Width\"\",\"\"Height\"\"\","
		"\"function.dll\",\"iGetWindowPos\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetFormPos\",\"AICCCCFn\","
		"\"Form Handle,\"\"Left\"\",\"\"Top\"\",\"\"Width\"\",\"\"Height\"\"\","
		"\"function.dll\",\"iGetFormPos\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetINIValue\",\"CCCCCF\","
		"\"\"\"File.ini\"\",\"\"Section\"\",\"\"Entry\"\",\"\"Default\"\"\","
		"\"function.dll\",\"szGetINIValue\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@SetINIValue\",\"ACCCC\","
		"\"\"\"File.ini\"\",\"\"Section\"\",\"\"Entry\"\",\"\"Value\"\"\","
		"\"function.dll\",\"szSetINIValue\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetFileName\",\"CyCCCFF\","
		"\"\"\"BoxTitle\"\",\"\"Description|Filter|...\"\",\"\"Default Ext\"\"\","
		"\"function.dll\",\"szOpenFileName\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetMultipleFileNames\",\"CyCCCFF\","
		"\"\"\"BoxTitle\"\",\"\"Description|Filter|...\"\",\"\"Default Ext\"\"\","
		"\"function.dll\",\"szMultipleFileNames\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetSaveFileName\",\"CyCCCFF\","
		"\"\"\"BoxTitle\"\",\"\"Description|Filter|...\"\",\"\"Default Ext\"\"\","
		"\"function.dll\",\"szSaveFileName\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@PrintDlg\",\"Ay\", \"\","
		"\"function.dll\",\"iPrintDlg\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@PrinterSetup\",\"Ay\", \"\","
		"\"function.dll\",\"iPrintSetup\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@ChangeDir\",\"AC\", \"\"\"Directory\"\"\","
		"\"function.dll\",\"iChangeDir\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetCurrDir\",\"CF\", \"\","
		"\"function.dll\",\"szGetCurrDir\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@ChangeDrive\",\"AC\", \"\"\"Drive\"\"\","
		"\"function.dll\",\"iChangeDrive\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetCurrDrive\",\"CF\", \"\","
		"\"function.dll\",\"szGetCurrDrive\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@CreateDir\",\"AC\", \"\"\"Directory\"\"\","
		"\"function.dll\",\"iCreateDir\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@RemoveDir\",\"AC\", \"\"\"Directory\"\"\","
		"\"function.dll\",\"iRemoveDir\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@DirExist\",\"AC\", \"\"\"Dir Name\"\"\","
		"\"function.dll\",\"iDirExist\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@FileExist\",\"AC\", \"\"\"File Name\"\"\","
		"\"function.dll\",\"iFileExist\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@RemoveFile\",\"AC\", \"\"\"File Name\"\"\","
		"\"function.dll\",\"iRemoveFile\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@MoveFile\",\"ACC\", \"\"\"Old Name\"\",\"\"New Name\"\"\","
		"\"function.dll\",\"iMoveFile\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@CopyFile\",\"ACCF\", \"\"\"Source File\"\",\"\"Dest File\"\"\","
		"\"function.dll\",\"iCopyFile\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetEnv\",\"CC\", \"\"\"Variable Name\"\"\","
		"\"function.dll\",\"szGetEnvVar\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@DumpTable\",\"ICCCAFFFnxwy\","
		"\"\"\"Table Name\"\",\"\"File Name\"\",\"\"Variables\"\",Delete?\","
		"\"function.dll\",\"iDumpTable\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@LoadTable\",\"ICCCFFFnwy\","
		"\"\"\"Table Name\"\",\"\"File Name\"\",\"\"Variables\"\"\","
		"\"function.dll\",\"iLoadTable\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@ResetOverride\",\"ACv\", \"\"\"Field Name\"\"\","
		"\"function.dll\",\"iResetOverride\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@ResetCalculated\",\"ACu\", \"\"\"Field Name\"\"\","
		"\"function.dll\",\"iResetCalculated\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@IsEmpty\",\"ACx\",\"\"\"Field Name\"\"\","
		"\"function.dll\",\"iIsEmpty\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@IsZero\",\"ACx\",\"\"\"Field Name\"\"\","
		"\"function.dll\",\"iIsZero\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@IsTableColumn\",\"ACr\", \"\"\"Field Name\"\"\","
		"\"function.dll\",\"iIsTableColumn\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetCurrentRow\",\"ICro\", \"\"\"Column Name\"\"\","
		"\"function.dll\",\"iGetCurrentRow\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetLastRow\",\"ICrq\", \"\"\"Column Name\"\"\","
		"\"function.dll\",\"iGetLastRow\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@SetCurrentRow\",\"ICIrs\", \"\"\"Column Name\"\",Row\","
		"\"function.dll\",\"iSetCurrentRow\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Reboot\",\"I\",\"\","
		"\"function.dll\",\"iReboot\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@RestartWindows\",\"I\",\"\","
		"\"function.dll\",\"iRestartWindows\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@ExitWindows\",\"I\",\"\","
		"\"function.dll\",\"iExitWindows\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Randomize\",\"I\",\"\","
		"\"function.dll\",\"iRandomize\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Random\",\"II\",\"Range\","
		"\"function.dll\",\"iRandom\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetCommandLine\",\"CF\", \"\","
		"\"function.dll\",\"szCommandLine\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@HighlightAll\",\"I\",\"\","
		"\"function.dll\",\"iHighlightAll\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@Highlight\",\"III\",\"Start,End\","
		"\"function.dll\",\"iHighlight\",1)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@GetFormHandle\",\"IyC\",\"\"\"Form Name\"\"\","
		"\"function.dll\",\"iGetFormHandle\",0)"
		, 0, 0, 0 );
	(void)(*lpfnCallBack)(
		"@REGISTER(\"@UpdateWindow\",\"Iy\",\"\","
		"\"function.dll\",\"iUpdateWindow\",0)"
		, 0, 0, 0 );
	return 0;
}

/******************************************************************************
*
* name          iWhileLoop -- While function using ExecuteString callback
*
* description   Use this function to execute a command or commands while a
*               specified condition is true.
*               Link error reporting is disabled during both condition and
*               action execution.
*
* arguments     1.  LPSTR szCondition -- the condition expression
*               2.  LPSTR szAction -- the action expression
*               3.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*
* return        Zero (an int)
*
* register      @REGISTER("@While","ICCn","""Condition"",""Command""",
*                   "function.dll","iWhileLoop",1)
*
******************************************************************************/

int FAR PASCAL _export iWhileLoop(
	LPSTR szCondition,
	LPSTR szAction,
	OVCALLBACK_EXECUTESTRING lpfnCallBack )
{
    int loopCounter = 1;
	char sBuf[10];
	char * szConditionResult;

	szConditionResult = (*lpfnCallBack)( szCondition, sBuf, sizeof(sBuf), 1 );
	while ( szConditionResult && !lstrcmpi(szConditionResult,"Yes") )
	{
		breakFlag = FALSE;
        breakAllFlag = FALSE;
		(void)(*lpfnCallBack)( szAction, (LPSTR)0, 0, 1 );
		szConditionResult = (*lpfnCallBack)( szCondition, sBuf, sizeof(sBuf), 1 );
        loopCounter++;
		if (breakFlag || breakAllFlag)
		{
            breakFlag = FALSE;
			break;
        }
	}
	return --loopCounter;
}

/******************************************************************************
*
* name          iUntilLoop -- Do Until function using ExecuteString callback
*
* description   Use this function to execute a command or commands until a
*               specified condition is true.
*               Link error reporting is disabled during both condition and
*               action execution.
*
* arguments     1.  LPSTR szCondition -- the condition expression
*               2.  LPSTR szAction -- the action expression
*               3.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*
* return        Zero (an int)
*
* register      @REGISTER("@Until","ICCn","""Condition"",""Command""",
*                   "function.dll","iUntilLoop",1)
*
******************************************************************************/

int FAR PASCAL _export iUntilLoop(
	LPSTR szCondition,
	LPSTR szAction,
	OVCALLBACK_EXECUTESTRING lpfnCallBack )
{
	int loopCounter = 1;
	char sBuf[10];
	char * szConditionResult;

	do
	{
		breakFlag = FALSE;
        breakAllFlag = FALSE;
		(void)(*lpfnCallBack)( szAction, (LPSTR)0, 0, 1 );
		szConditionResult = (*lpfnCallBack)( szCondition, sBuf, sizeof(sBuf), 1 );
        loopCounter++;
		if (breakFlag || breakAllFlag)
		{
            breakFlag = FALSE;
			break;
        }
	} while (szConditionResult && !lstrcmpi(szConditionResult,"No"));

	return --loopCounter;
}

/******************************************************************************
*
* name          iLoop -- Loop a set number of times
*
* description   Use this function to execute a command or commands a
*				specified number of times.
*               Link error reporting is disabled during both condition and
*               action execution.
*
* arguments     1.  int loopCount -- number of times to loop
*               2.  LPSTR szAction -- command(s) to execute
*               3.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*
* return        int -- number of times actually looped
*
* register      @REGISTER("@Loop","ICCn","Loop Count,""Command""",
*                   "function.dll","iLoop",0)
*
******************************************************************************/

int FAR PASCAL _export iLoop(
	int loopCount,
	LPSTR szAction,
	OVCALLBACK_EXECUTESTRING lpfnCallBack )
{
    int loopCounter;
	char sBuf[10];

	loopCounter = 1;
	while (loopCounter <= loopCount)
	{
		breakFlag = FALSE;
        breakAllFlag = FALSE;
		(void)(*lpfnCallBack)( szAction, (LPSTR)0, 0, 1 );
		loopCounter++;
		if (breakFlag || breakAllFlag)
		{
            breakFlag = FALSE;
			break;
        }
	}
	return --loopCounter;
}

/******************************************************************************
*
* name          iFor -- FOR loop
*
* description   Use this function to execute a FOR loop
*               Link error reporting is disabled during both condition and
*               action execution.
*
* arguments     1.  LPSTR -- name of variable to store loop counter
*				2.	double -- starting value for loop counter
*				3.	double -- ending value for loop counter
*				4.	double -- increment value for loop counter  
*               5.  LPSTR -- command(s) to execute
*
* return        int -- number of times actually looped
*
* register      @REGISTER("@For","ICBBBCFnw",
*					"""Loop Field"",Start,Stop,Increment,""Command""",
*                   "function.dll","iFor",0)
*
******************************************************************************/

int FAR PASCAL _export iFor(
	LPSTR loopField,
	double start,
	double stop,
    double increment,
	LPSTR szAction,
    LPSTR initCommand,
	OVCALLBACK_EXECUTESTRING lpfnCallBack,
	OVCALLBACK_PUT lpfnPut )
{
	int loopCounter, direction;
	char sBuf[50];
    double loopVar = start;

	if (increment >= 0) direction = 1;
    else direction = -1;

    sprintf (initCommand, "@ASSIGN(%s,%lf)", loopField, start);
	(void)(*lpfnCallBack)(initCommand, (LPSTR)0, 0, 1 );

	loopCounter = 1;
	while (direction == 1 ? loopVar <= stop : loopVar >= stop)
	{
		breakFlag = FALSE;
        breakAllFlag = FALSE;
		(void)(*lpfnCallBack)( szAction, (LPSTR)0, 0, 1 );
		loopCounter++;
		loopVar += increment;

		sprintf(sBuf, "%lf", loopVar);
		(*lpfnPut)((LPSTR)loopField, (LPSTR)sBuf);

		if (breakFlag || breakAllFlag)
		{
            breakFlag = FALSE;
			break;
        }
	}
	return --loopCounter;
}

/******************************************************************************
*
* name          iBreak -- Terminates a loop
*
* description   Use this function to within a loop to terminate the loop
*
* arguments     none
*
* return        zero (0)
*
* register      @REGISTER("@Break","I","",
*                   "function.dll","iBreak",1)
*
******************************************************************************/

int FAR PASCAL _export iBreak()
{
	breakFlag = TRUE;
	return 0;
}

/******************************************************************************
*
* name          iBreakAll -- Terminates all loops currently in progress
*
* description   Use this function to within a loop to terminate all loops in
*				progress
*
* arguments     none
*
* return        zero (0)
*
* register      @REGISTER("@BreakAll","I","",
*                   "function.dll","iBreakAll",1)
*
******************************************************************************/

int FAR PASCAL _export iBreakAll()
{
	breakAllFlag = TRUE;
	return 0;
}

/******************************************************************************
*
* name          szExecuteString -- Send a command string to OV for execution
*
* description   Use this function to send a command to OV for execution.
*
* arguments     1.  LPSTR szCommand  -- the command to execute
*               2.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*               3.  LPSTR sAnswerBuffer -- place for the answer
*
* return        LPSTR -- result string
*
* register      @REGISTER("@Execute","CCnF","""Command""",
*                   "function.dll","szExecuteString",1)
*
******************************************************************************/

LPSTR FAR PASCAL _export szExecuteString(
	LPSTR szCommand,
	OVCALLBACK_EXECUTESTRING lpfnCallBack,
	LPSTR sAnswerBuf )
{
	LPSTR szResult;
	szResult = (*lpfnCallBack)( szCommand, sAnswerBuf, 4096, 0 );
	if ( !szResult )
	{
		szResult = ""; // Return something
	}
	return szResult;
}

/******************************************************************************
*
* name          MessageBeep -- Calls the Windows MessageBeep function
*
* description   Use this function to use the various Beep sounds set up
*               in the Control Panel 
*
* arguments     1.  int BeepSelect -- selects beep sound (see documentation)
*
* return        zero (0)
*
* register      @REGISTER("@MessageBeep","II","BeepType",
*                   "function.dll","iMessageBeep",1)
*
******************************************************************************/

int FAR PASCAL _export iMessageBeep(
	int BeepSelect )
{
	switch (BeepSelect)
	{
		case 0: 
			MessageBeep(MB_OK);
			break;
		case 1:
			MessageBeep(MB_ICONHAND);
			break;
		case 2:
			MessageBeep(MB_ICONQUESTION);
			break;
		case 3:
			MessageBeep(MB_ICONEXCLAMATION);
			break;
		case 4:
			MessageBeep(MB_ICONASTERISK);
			break;
		default:
			MessageBeep(-1);
			break;
	}
	return 0;
}

/******************************************************************************
*
* name          iPlayWav -- Play a WAV sound file
*
* description   Use this function to play a sound cantained in a WAV file
*
* arguments     1.  LPSTR -- name of file to play
*
* return        None
*
* register      @REGISTER("@Execute","AC","""File.wav""",
*                   "function.dll","iPlayWav",1)
*
******************************************************************************/

int FAR PASCAL _export iPlayWav(
	LPSTR szWavFile )
{
	sndPlaySound (szWavFile, SND_SYNC);
	return 0;
}

/******************************************************************************
*
* name          MessageBox -- Calls the Windows MessageBox function
*
* description   Use this function to create various types of standard message
*               boxes
*
* arguments     1.  LPSTR boxTitle -- title of message box
*               2.  LPSTR boxText -- text of message
*               3.  int buttons -- buttons to create (see documentation)
*               4.  int defaultButton -- number of default button (1, 2, or 3)
*               5.  int icon -- number of icon to display (see documentation)
*               6.  HWND HWindow -- handle of parent window     
*
* return        int -- Number of button that was pushed (1-3).
*
* register      @REGISTER("@MessageBox","ICCIIIy",
*               """Box Title"",""Text"",Buttons,Default Button,Icon",
*               "function.dll","iMessageBox",1)"
*
******************************************************************************/

int FAR PASCAL _export iMessageBox(
	LPSTR boxTitle,
	LPSTR boxText,
	int buttons,
	int defaultButton,
	int icon,
	HWND HWindow )
{
	int flags;

	flags = 0;
	switch (buttons)
	{
		case 0: 
			flags |= MB_OK;
			break;
		case 1:
			flags |= MB_OKCANCEL;
			break;
		case 2:
			flags |= MB_RETRYCANCEL;
			break;
		case 3:
			flags |= MB_YESNO;
			break;
		case 4:
			flags |= MB_YESNOCANCEL;
			break;
		case 5:
			flags |= MB_ABORTRETRYIGNORE;
			break;
		default:
			flags |= MB_OK;
			break;
	}
	switch (icon)
	{
		case 1:
			flags |= MB_ICONHAND;
			break;
		case 2:
			flags |= MB_ICONQUESTION;
			break;
		case 3:
			flags |= MB_ICONEXCLAMATION;
			break;
		case 4:
			flags |= MB_ICONASTERISK;
			break;
	}
	switch (defaultButton)
	{
		case 1:
			flags |= MB_DEFBUTTON1;
			break;
		case 2:
			flags |= MB_DEFBUTTON2;
			break;
		case 3:
			flags |= MB_DEFBUTTON3;
			break;
		default:
			flags |= MB_DEFBUTTON1;
			break;
	}
	return BWCCMessageBox(HWindow, boxText, boxTitle, flags);
}

/******************************************************************************
*
* name          iMaximize -- Maximizes the OV Window
*
* description   Use this function to maximize the main OV window
*
* arguments     none
*
* return        zero (0)
*
* register      @REGISTER("@Maximize","Iy","",
*                   "function.dll","iMaximize",1)
*
******************************************************************************/

int FAR PASCAL _export iMaximize(
	HWND HWindow )
{
	ShowWindow(HWindow, SW_SHOWMAXIMIZED);
	return 0;
}

/******************************************************************************
*
* name          iMaximizeForm -- Maximizes an OV form
*
* description   Use this function to maximize an OV form
*
* arguments     1.  int -- Form handle from @GetFormHandle
*
* return        zero (0)
*
* register      @REGISTER("@MaximizeForm","II","Form Handle",
*                   "function.dll","iMaximizeForm",1)
*
******************************************************************************/

int FAR PASCAL _export iMaximizeForm(
	int formHandle )
{
	ShowWindow(formHandle, SW_SHOWMAXIMIZED);
	return 0;
}

/******************************************************************************
*
* name          iRestoreWindow -- Restores the OV Window after being maximized
*				or minimized
*
* description   Use this function to restore the main OV window after being 
*				maximized or minimized
*
* arguments     none
*
* return        zero (0)
*
* register      @REGISTER("@RestoreWindow","Iy","",
*                   "function.dll","iRestoreWindow",1)
*
******************************************************************************/

int FAR PASCAL _export iRestoreWindow(
	HWND HWindow )
{
	ShowWindow(HWindow, SW_RESTORE);
	return 0;
}

/******************************************************************************
*
* name          iRestoreForm -- Restores an OV form after being maximized
*
* description   Use this function to restore an OV form after being maximized
*
* arguments     1.  int -- Form handle from @GetFormHandle
*
* return        zero (0)
*
* register      @REGISTER("@RestoreForm","II","Form Handle",
*                   "function.dll","iRestoreForm",1)
*
******************************************************************************/

int FAR PASCAL _export iRestoreForm(
	int formHandle )
{
	ShowWindow(formHandle, SW_RESTORE);
	return 0;
}

/******************************************************************************
*
* name          iMinimize -- Minimizes the main OV window
*
* description   Use this function to minimize the main OV window
*
* arguments     none
*
* return        zero (0)
*
* register      @REGISTER("@Minimize","Iy","",
*                   "function.dll","iMinimize",1)
*
******************************************************************************/

int FAR PASCAL _export iMinimize(
	HWND HWindow )
{
	ShowWindow(HWindow, SW_SHOWMINIMIZED);
	return 0;
}

/******************************************************************************
*
* name          iHideWindow -- Hides the main OV window
*
* description   Use this function to hide the main OV window
*
* arguments     none
*
* return        zero (0)
*
* register      @REGISTER("@HideWindow","Iy","",
*                   "function.dll","iHideWindow",1)
*
******************************************************************************/

int FAR PASCAL _export iHideWindow(
	HWND HWindow )
{
	ShowWindow(HWindow, SW_HIDE);
	return 0;
}

/******************************************************************************
*
* name          iHideForm -- Hides an OV form
*
* description   Use this function to hide an OV form without closing it
*
* arguments     1.  int -- Handle of form from @GetFormHandle
*
* return        zero (0)
*
* register      @REGISTER("@HideForm","II","Form Handle",
*                   "function.dll","iHideForm",1)
*
******************************************************************************/

int FAR PASCAL _export iHideForm(
	int formHandle )
{
	ShowWindow(formHandle, SW_HIDE);
	return 0;
}

/******************************************************************************
*
* name          iShowWindow -- Shows the main OV window after it has been hidden
*
* description   Use this function to Show the main OV window after it has been
*				hidden
*
* arguments     none
*
* return        zero (0)
*
* register      @REGISTER("@ShowWindow","Iy","",
*                   "function.dll","iShowWindow",1)
*
******************************************************************************/

int FAR PASCAL _export iShowWindow(
	HWND HWindow )
{
	ShowWindow(HWindow, SW_SHOW);
	return 0;
}

/******************************************************************************
*
* name          iShowForm -- Shows an OV form after it has been hidden
*
* description   Use this function to Show an OV form after it has been hidden
*
* arguments     1.  int -- Handle of form from @GetFormHandle
*
* return        zero (0)
*
* register      @REGISTER("@ShowForm","II","Form Handle",
*                   "function.dll","iShowForm",1)
*
******************************************************************************/

int FAR PASCAL _export iShowForm(
	int formHandle )
{
	ShowWindow(formHandle, SW_SHOW);
	return 0;
}

/******************************************************************************
*
* name          iMoveWindow -- Moves the OV Window to the specified coordinates
*
* description   Use this function to move or resize the main OV window
*
* arguments     1.  int -- X-coordinate of upper left corner of window
*               2.  int -- Y-coordinate of upper left corner of window
*               3.  int -- Width of window
*               4.  int -- Height of window
*               5.  HWND -- Handle of window     
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@MoveWindow","AIIIIy","Left,Top,Width,Height",
*                   "function.dll","iMoveWindow",1)
*
******************************************************************************/

int FAR PASCAL _export iMoveWindow(
	int X,
	int Y,
	int W,
	int H,
	HWND HWindow )
{
	ShowWindow(HWindow, SW_SHOWNORMAL);
	if (MoveWindow(HWindow, X, Y, W, H, TRUE))
		return FALSE;
	else
		return TRUE;
}

/******************************************************************************
*
* name          iMoveForm -- Moves an OV form to the specified coordinates
*
* description   Use this function to move or resize an OV form
*
* arguments		1.  int -- handle of form from @GetFormHandle
*				2.  int -- X-coordinate of upper left corner of form
*               3.  int -- Y-coordinate of upper left corner of form
*               4.  int -- Width of form
*               5.  int -- Height of form
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@MoveForm","AIIIII","Form Handle,Left,Top,Width,Height",
*                   "function.dll","iMoveForm",1)
*
******************************************************************************/

int FAR PASCAL _export iMoveForm(
    int formHandle,
	int X,
	int Y,
	int W,
	int H )
{
	ShowWindow(formHandle, SW_SHOWNORMAL);
	if (MoveWindow(formHandle, X, Y, W, H, TRUE))
		return FALSE;
	else
		return TRUE;
}

/******************************************************************************
*
* name          iGetWindowPos -- Gets the current window coordinates of the
*               main OV window
*
* description   Use this function to find the coordinates of the main OV window.
*               The left, top, width, and height coordinates will be returned
*               in the variables with the names passed.
*
* arguments     1.  LPSTR -- Name of variable for X-coordinate of upper left
*                   corner of window
*               2.  LPSTR -- Name of variable for Y-coordinate of upper left
*                   corner of window
*               3.  LPSTR -- Name of variable for Width of window
*               4.  LPSTR -- Name of variable for Height of window
*               5.  OVCALLBACK_EXECUTESTRING -- callback fn
*               6.  HWND -- Handle of window
*
* return        0
*
* register      @REGISTER("@GetWindowPos","ACCCCFny","Left,Top,Width,Height",
*                   "function.dll","iGetWindowPos",1)
*
******************************************************************************/

int FAR PASCAL _export iGetWindowPos(
	LPSTR X,
	LPSTR Y,
	LPSTR W,
	LPSTR H,
	LPSTR command,
	OVCALLBACK_EXECUTESTRING lpfnCallBack,
	HWND HWindow )
{
	RECT windowRect;

	windowRect.top = 0;
	windowRect.left = 0;
	windowRect.right = 0;
	windowRect.bottom = 0;
	GetWindowRect(HWindow, &windowRect);
	wsprintf (command, "@ASSIGN(%s,%i)\0", X, windowRect.top);
	(void)(*lpfnCallBack)(command, 0, 0, 1 );
	wsprintf (command, "@ASSIGN(%s,%i)\0", Y, windowRect.left);
	(void)(*lpfnCallBack)(command, 0, 0, 1 );
	wsprintf (command, "@ASSIGN(%s,%i)\0", W, windowRect.right - windowRect.left);
	(void)(*lpfnCallBack)(command, 0, 0, 1 );
	wsprintf (command, "@ASSIGN(%s,%i)\0", H, windowRect.bottom - windowRect.top);
	(void)(*lpfnCallBack)(command, 0, 0, 1 );
	return 0;
}

/******************************************************************************
*
* name          iGetFormPos -- Gets the coordinates of a form
*
* description   Use this function to find the coordinates of a form.
*               The left, top, width, and height coordinates will be returned
*               in the variables with the names passed.
*
* arguments     1.	int -- Handle of form from @GetFormHandle
*				2.  LPSTR -- Name of variable for X-coordinate of upper left
*                   corner of window
*               3.  LPSTR -- Name of variable for Y-coordinate of upper left
*                   corner of window
*               4.  LPSTR -- Name of variable for Width of window
*               5.  LPSTR -- Name of variable for Height of window
*               6.  OVCALLBACK_EXECUTESTRING -- callback fn
*
* return        0
*
* register      @REGISTER("@GetFormPos","AICCCCFn",
*					"Form Handle,""Left"",""Top"",""Width"",""Height""",
*                   "function.dll","iGetFormPos",1)
*
******************************************************************************/

int FAR PASCAL _export iGetFormPos(
    int formHandle,
	LPSTR X,
	LPSTR Y,
	LPSTR W,
	LPSTR H,
	LPSTR command,
	OVCALLBACK_EXECUTESTRING lpfnCallBack )
{
	RECT windowRect;

	windowRect.top = 0;
	windowRect.left = 0;
	windowRect.right = 0;
	windowRect.bottom = 0;
	GetWindowRect(formHandle, &windowRect);
	wsprintf (command, "@ASSIGN(%s,%i)\0", X, windowRect.top);
	(void)(*lpfnCallBack)(command, 0, 0, 1 );
	wsprintf (command, "@ASSIGN(%s,%i)\0", Y, windowRect.left);
	(void)(*lpfnCallBack)(command, 0, 0, 1 );
	wsprintf (command, "@ASSIGN(%s,%i)\0", W, windowRect.right - windowRect.left);
	(void)(*lpfnCallBack)(command, 0, 0, 1 );
	wsprintf (command, "@ASSIGN(%s,%i)\0", H, windowRect.bottom - windowRect.top);
	(void)(*lpfnCallBack)(command, 0, 0, 1 );
	return 0;
}

/******************************************************************************
*
* name          szGetINIValue -- Get a value from an INI file
*
* description   Use this function to get a value from an INI file
*
* arguments     1.  LPSTR szFilename -- name of INI file
*               2.  LPSTR szSection -- name of INI section
*               3.  LPSTR szEntry -- name of INI entry
*               4.  LPSTR szDefault -- default value for entry if none exists
*               5.  LPSTR szReturnBuffer -- buffer for return value
*
* return        LPSTR -- result string
*
* register      @REGISTER("@GetINIValue","CCCCCF",
*                   """File.ini"",""Section"",""Entry"",""Default""",
*                   "function.dll","szGetINIValue",0)
*
******************************************************************************/

LPSTR FAR PASCAL _export szGetINIValue(
	LPSTR szFilename,
	LPSTR szSection,
	LPSTR szEntry,
	LPSTR szDefault,
	LPSTR szReturnBuffer )
{
	GetPrivateProfileString(szSection, szEntry,
		szDefault, szReturnBuffer, 
		4096, szFilename );
	return szReturnBuffer;
}

/******************************************************************************
*
* name          szSetINIValue -- Set a value in an INI file
*
* description   Use this function to set a value in an INI file
*
* arguments     1.  LPSTR szFilename -- name of INI file
*               2.  LPSTR szSection -- name of INI section
*               3.  LPSTR szEntry -- name of INI entry
*               4.  LPSTR szString -- value to set for entry
*
* return        BOOL -- Yes if successful
*
* register      @REGISTER("@SetINIValue","ACCCC",
*                   """File.ini"",""Section"",""Entry"",""Value""",
*                   "function.dll","szSetINIValue",1)
*
******************************************************************************/

BOOL FAR PASCAL _export szSetINIValue(
	LPSTR szFilename,
	LPSTR szSection,
	LPSTR szEntry,
	LPSTR szString )
{
	return WritePrivateProfileString(szSection, szEntry,
		szString, szFilename);
}

/******************************************************************************
*
* name          szOpenFileName -- creates a File Open dialog box 
*
* description   Use this function to get a disk file name to open
*
* arguments     1.  HWND HWindow -- Handle of main window
*               2.  LPSTR szTitle -- title of dialog box
*               3.  LPSTR szFilter -- filter/description list
*               4.  LPSTR szDefExt -- Default extension to be provide for user
*               3.  LPSTR szFile -- file name returned to program
*
* return        LPSTR -- name of file selected or NULL
*
* register      @REGISTER("@GetFileName","CyCCCFF",
*                   """BoxTitle"",""Description|Filter|..."",""Default Ext""",
*                   "function.dll","szOpenFileName",1)
*
******************************************************************************/

LPSTR FAR PASCAL _export szOpenFileName(
	HWND HWindow,
	LPSTR szTitle,
	LPSTR szFilter,
	LPSTR szDefExt,
	LPSTR szFile,
	LPSTR szWorkFilter )
{
	OPENFILENAME lpofn;  // initialization data structure
	LPSTR filterEnd, filterPos;

	*szFile = '\0';

	lstrcpy(szWorkFilter, szFilter);
	filterEnd = szWorkFilter + lstrlen(szWorkFilter);
	for (filterPos = szWorkFilter; filterPos <= filterEnd; filterPos++)
		if (*filterPos == '|') *filterPos = '\0';

	lpofn.lStructSize = sizeof(OPENFILENAME);
	lpofn.hwndOwner = HWindow;
	lpofn.hInstance = 0;
	lpofn.lpstrFilter = (LPCSTR)szWorkFilter;
	lpofn.lpstrCustomFilter = NULL;
	lpofn.nMaxCustFilter = 0;
	lpofn.nFilterIndex = 1;
	lpofn.lpstrFile = (LPSTR)szFile;
	lpofn.nMaxFile = 128;
	lpofn.lpstrFileTitle = NULL;
	lpofn.nMaxFileTitle = 0;
	lpofn.lpstrInitialDir = NULL;
	lpofn.lpstrTitle = (LPCSTR)szTitle;
	lpofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_READONLY;
	lpofn.nFileOffset = 0;
	lpofn.nFileExtension = 0;
	lpofn.lpstrDefExt = szDefExt;
	lpofn.lCustData = NULL;
	lpofn.lpfnHook = NULL;
	lpofn.lpTemplateName = NULL;

	GetOpenFileName(&lpofn);

	return szFile;
}

/******************************************************************************
*
* name          szMultipleFileNames -- creates a File Open dialog box that
*                   allows the user to select multiple file names 
*
* description   Use this function to get multiple disk file names
*
* arguments     1.  HWND HWindow -- Handle of main window
*               2.  LPSTR szTitle -- title of dialog box
*               3.  LPSTR szFilter -- filter/description list
*               4.  LPSTR szDefExt -- Default extension to be provide for user
*               3.  LPSTR szFile -- file name returned to program
*
* return        LPSTR -- name of file selected or NULL
*
* register      @REGISTER("@GetMultipleFileNames","CyCCCFF",
*                   """BoxTitle"",""Description|Filter|..."",""Default Ext""",
*                   "function.dll","szMultipleFileNames",1)
*
******************************************************************************/

LPSTR FAR PASCAL _export szMultipleFileNames(
	HWND HWindow,
	LPSTR szTitle,
	LPSTR szFilter,
	LPSTR szDefExt,
	LPSTR szFile,
	LPSTR szWorkFilter )
{
	OPENFILENAME lpofn;  // initialization data structure
	LPSTR filterEnd, filterPos;

	*szFile = '\0';

	lstrcpy(szWorkFilter, szFilter);
	filterEnd = szWorkFilter + lstrlen(szWorkFilter);
	for (filterPos = szWorkFilter; filterPos <= filterEnd; filterPos++)
		if (*filterPos == '|') *filterPos = '\0';

	lpofn.lStructSize = sizeof(OPENFILENAME);
	lpofn.hwndOwner = HWindow;
	lpofn.hInstance = 0;
	lpofn.lpstrFilter = (LPCSTR)szWorkFilter;
	lpofn.lpstrCustomFilter = NULL;
	lpofn.nMaxCustFilter = 0;
	lpofn.nFilterIndex = 1;
	lpofn.lpstrFile = (LPSTR)szFile;
	lpofn.nMaxFile = 128;
	lpofn.lpstrFileTitle = NULL;
	lpofn.nMaxFileTitle = 0;
	lpofn.lpstrInitialDir = NULL;
	lpofn.lpstrTitle = (LPCSTR)szTitle;
	lpofn.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_READONLY | OFN_ALLOWMULTISELECT;
	lpofn.nFileOffset = 0;
	lpofn.nFileExtension = 0;
	lpofn.lpstrDefExt = szDefExt;
	lpofn.lCustData = NULL;
	lpofn.lpfnHook = NULL;
	lpofn.lpTemplateName = NULL;

	GetOpenFileName(&lpofn);

	return szFile;
}

/******************************************************************************
*
* name          szSaveFileName -- creates a File Save As dialog box 
*
* description   Use this function to get a disk file name to save
*
* arguments     1.  HWND HWindow -- Handle of main window
*               1.  LPSTR szTitle -- title of dialog box
*               2.  LPSTR szFilter -- filter/description list
*               3.  LPSTR szDefExt -- default extension to be supplied for user
*               4.  LPSTR szFile -- file name returned to program
*
* return        LPSTR -- name of file selected or NULL
*
* register      @REGISTER("@GetSaveFileName","CyCCCFF",
*                   """BoxTitle"",""Description|Filter|..."",""Default Ext""",
*                   "function.dll","szSaveFileName",1)
*
******************************************************************************/

LPSTR FAR PASCAL _export szSaveFileName(
	HWND HWindow,
	LPSTR szTitle,
	LPSTR szFilter,
	LPSTR szDefExt,
	LPSTR szFile,
	LPSTR szWorkFilter )
{
	OPENFILENAME lpofn;  // initialization data structure
	LPSTR filterEnd, filterPos;

	*szFile = '\0';

	lstrcpy(szWorkFilter, szFilter);
	filterEnd = szWorkFilter + lstrlen(szWorkFilter);
	for (filterPos = szWorkFilter; filterPos <= filterEnd; filterPos++)
		if (*filterPos == '|') *filterPos = '\0';

	lpofn.lStructSize = sizeof(OPENFILENAME);
	lpofn.hwndOwner = HWindow;
	lpofn.hInstance = 0;
	lpofn.lpstrFilter = (LPCSTR)szWorkFilter;
	lpofn.lpstrCustomFilter = NULL;
	lpofn.nMaxCustFilter = 0;
	lpofn.nFilterIndex = 1;
	lpofn.lpstrFile = (LPSTR)szFile;
	lpofn.nMaxFile = 128;
	lpofn.lpstrFileTitle = NULL;
	lpofn.nMaxFileTitle = 0;
	lpofn.lpstrInitialDir = NULL;
	lpofn.lpstrTitle = (LPCSTR)szTitle;
	lpofn.Flags = OFN_HIDEREADONLY;
	lpofn.nFileOffset = 0;
	lpofn.nFileExtension = 0;
	lpofn.lpstrDefExt = szDefExt;
	lpofn.lCustData = NULL;
	lpofn.lpfnHook = NULL;
	lpofn.lpTemplateName = NULL;

	GetSaveFileName(&lpofn);

	return szFile;
}

/******************************************************************************
*
* name          iPrintDlg -- Executes the Common Dialog Print dialog box
*
* description   Use this function to execute a print dialog box
*
* arguments     None
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@PrintDlg","Ay", "",
*                   "function.dll","iPrintDlg",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iPrintDlg(
	HWND HWindow )
{
	PRINTDLG lppd;   // initialization data structure

	lppd.lStructSize = sizeof(PRINTDLG);
	lppd.hwndOwner = HWindow;
	lppd.hDevMode = NULL;
	lppd.hDevNames = NULL;
	lppd.hDC = NULL;
	lppd.Flags = PD_NOPAGENUMS | PD_NOSELECTION;
	lppd.nFromPage = 0xffff;
	lppd.nToPage = 0xffff;
	lppd.nMinPage = 0;
	lppd.nMaxPage = 0;
	lppd.nCopies = 1;
	lppd.hInstance = NULL;
	lppd.lCustData = NULL;
	lppd.lpfnPrintHook = NULL;
	lppd.lpfnSetupHook = NULL;
	lppd.lpPrintTemplateName = NULL;
	lppd.lpSetupTemplateName = NULL;
	lppd.hPrintTemplate = NULL;
	lppd.hSetupTemplate = NULL;

	return (PrintDlg(&lppd));
}

/******************************************************************************
*
* name          iPrintSetup -- Executes the Common Dialog Printer Setup dialog box
*
* description   Use this function to execute a printer setup dialog box
*
* arguments     None
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@PrinterSetup","Ay", "",
*                   "function.dll","iPrintSetup",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iPrintSetup(
	HWND HWindow )
{
	PRINTDLG lppd;   // initialization data structure

	lppd.lStructSize = sizeof(PRINTDLG);
	lppd.hwndOwner = HWindow;
	lppd.hDevMode = NULL;
	lppd.hDevNames = NULL;
	lppd.hDC = NULL;
	lppd.Flags = PD_NOPAGENUMS | PD_NOSELECTION | PD_PRINTSETUP;
	lppd.nFromPage = 0xffff;
	lppd.nToPage = 0xffff;
	lppd.nMinPage = 0;
	lppd.nMaxPage = 0;
	lppd.nCopies = 1;
	lppd.hInstance = NULL;
	lppd.lCustData = NULL;
	lppd.lpfnPrintHook = NULL;
	lppd.lpfnSetupHook = NULL;
	lppd.lpPrintTemplateName = NULL;
	lppd.lpSetupTemplateName = NULL;
	lppd.hPrintTemplate = NULL;
	lppd.hSetupTemplate = NULL;

	return PrintDlg(&lppd);
}

/******************************************************************************
*
* name          iChangeDir -- Changes the current directory
*
* description   Use this function to change the current directory
*
* arguments     1.  LPSTR -- Name of directory to change to 
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@ChangeDir","AC", """Directory""",
*                   "function.dll","iChangeDir",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iChangeDir(
	LPSTR Directory )
{
	return chdir(Directory);
}

/******************************************************************************
*
* name          szGetCurrDir -- Returns the current directory
*
* description   Use this function to retrieve the current directory name
*
* arguments     None 
*
* return        LPSTR -- Name of current directory
*
* register      @REGISTER("@GetCurrDir","CF", "",
*                   "function.dll","iGetCurrDir",0)
*
******************************************************************************/

LPSTR FAR PASCAL _export szGetCurrDir(
	LPSTR Directory )
{
	getcurdir(0, Directory);
	return Directory;
}

/******************************************************************************
*
* name          iChangeDrive -- Changes the current drive
*
* description   Use this function to change the current drive
*
* arguments     1.  LPSTR -- Name of drive to change to 
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@ChangeDrive","AC", """Drive""",
*                   "function.dll","iChangeDrive",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iChangeDrive(
	LPSTR Drive )
{
	return setdisk(toupper(*Drive) - 'A');
}

/******************************************************************************
*
* name          szGetCurrDrive -- Returns the current drive
*
* description   Use this function to retrieve the current drive name
*
* arguments     None 
*
* return        LPSTR -- Name of current drive
*
* register      @REGISTER("@GetCurrDrive","CF", "",
*                   "function.dll","iGetCurrDrive",0)
*
******************************************************************************/

LPSTR FAR PASCAL _export szGetCurrDrive(
	LPSTR Directory )
{
	int dirNum;

	dirNum = getdisk();
	*Directory = 'A' + dirNum;
	*(Directory + 1) = ':';
	*(Directory + 2) = '\0';
	return Directory;
}

/******************************************************************************
*
* name          iCreateDir -- Creates a new directory
*
* description   Use this function to create a new directory
*
* arguments     1.  LPSTR -- Name of directory to create 
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@CreateDir","AC", """Directory""",
*                   "function.dll","iCreateDir",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iCreateDir(
	LPSTR Directory )
{
	return mkdir(Directory);
}

/******************************************************************************
*
* name          iRemoveDir -- Removes a directory
*
* description   Use this function to remove a directory
*
* arguments     1.  LPSTR -- Name of directory to remove 
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@RemoveDir","AC", """Directory""",
*                   "function.dll","iRemoveDir",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iRemoveDir(
	LPSTR Directory )
{
	return rmdir(Directory);
}

/******************************************************************************
*
* name          iDirExist -- Checks for the existance of a directory
*
* description   Use this function to check whether a directory exists
*
* arguments     1.  LPSTR -- Name of directory to check
*
* return        BOOL -- TRUE if directory exists
*
* register      @REGISTER("@DirExist","AC", """Directory Name""",
*                   "function.dll","iDirExist",0)
*
******************************************************************************/

BOOL FAR PASCAL _export iDirExist(
	LPSTR DirName )
{
	struct ffblk ffblk;
	return !findfirst(DirName, &ffblk, FA_DIREC);
}

/******************************************************************************
*
* name          iFileExist -- Checks for the existance of a file
*
* description   Use this function to check whether a file exists
*
* arguments     1.  LPSTR -- Name of file to check
*
* return        BOOL -- TRUE if file exists
*
* register      @REGISTER("@FileExist","AC", """File Name""",
*                   "function.dll","iFileExist",0)
*
******************************************************************************/

BOOL FAR PASCAL _export iFileExist(
	LPSTR FileName )
{
	struct ffblk ffblk;
	return !findfirst(FileName, &ffblk, 0);
}

/******************************************************************************
*
* name          iRemoveFile -- Removes a file
*
* description   Use this function to remove a file
*
* arguments     1.  LPSTR -- Name of file to remove 
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@RemoveFile","AC", """File Name""",
*                   "function.dll","iRemoveFile",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iRemoveFile(
	LPSTR FileName )
{
	return remove (FileName);
}

/******************************************************************************
*
* name          iMoveFile -- Moves or renames a file
*
* description   Use this function to move or rename a file
*
* arguments     1.  LPSTR -- Name of file to move
*               2.  LPSTR -- New name of file
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@MoveFile","ACC", """Old Name"",""New Name""",
*                   "function.dll","iMoveFile",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iMoveFile(
	LPSTR OldName,
	LPSTR NewName )
{
	return rename (OldName, NewName);
}

/******************************************************************************
*
* name          iCopyFile -- Copies a file
*
* description   Use this function to copy a file
*
* arguments     1.  LPSTR -- Name of file to copy
*               2.  LPSTR -- Name of new file
*
* return        BOOL -- FALSE if successful
*
* register      @REGISTER("@CopyFile","ACCF", """Source File"",""Dest File""",
*                   "function.dll","iCopyFile",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iCopyFile(
	LPSTR SourceFile,
	LPSTR DestFile,
	LPSTR buffer )
{
	struct ftime ft;
	size_t chars;

	source = fopen (SourceFile, "rb");
	dest = fopen (DestFile, "wb");

	if (source == NULL || dest == NULL)
		return -1;

	getftime(fileno(source), &ft);

	while ((chars = fread (buffer, 1, 4096, source)) != 0)
		fwrite (buffer, 1, chars, dest);

	setftime(fileno(dest), &ft);
	fclose (source);
	return fclose (dest);
}

/******************************************************************************
*
* name          szGetEnvVar -- Returns the value of a DOS environment variable
*
* description   Use this function to retrieve the value of an environment variable
*
* arguments     1.  LPSTR -- Name of variable to retrieve
*
* return        LPSTR -- Value of variable
*
* register      @REGISTER("@GetEnv","CC", """Variable Name""",
*                   "function.dll","iGetEnvVar",0)
*
******************************************************************************/

LPSTR FAR PASCAL _export szGetEnvVar(
	LPSTR Variable )
{
	return getenv(Variable);
}

/******************************************************************************
*
* name          iDumpTable -- Dumps a table into an ASCII file
*
* description   Use this function to dump a table into an ASCII file
*
* arguments     1.  LPSTR -- Name of table to dump
*               2.  LPSTR -- File name to dump to
*               3.  LPSTR -- Variables to dump
*               4.  BOOL -- Delete records from database after dumping
*               5.  LPSTR -- Output record buffer
*               6.  LPSTR -- Work space for field list
*               7.  OVCALLBACK_EXECUTESTRING -- callback fn
*               8.  OVCALLBACK_GET -- function to get OV variable
*               9.  OVCALLBACK_PUT -- function to put OV variable
*				10. HWND -- Handle of OV window
*
* requirements      
*
* return        int -- Number of records dumped
*
* register      @REGISTER("@DumpTable","ICCCAFFFnxwy",
*                   """Table Name"",""File Name"",""Variables"",Delete?",
*                   "function.dll","iDumpTable",1)
*
******************************************************************************/

int FAR PASCAL _export iDumpTable(
	LPSTR tableName,
	LPSTR fileName,
	LPSTR fieldList,
	int deleteFlag,
	LPSTR output,
	LPSTR command,
	LPSTR workSpace,
	OVCALLBACK_EXECUTESTRING lpfnCallBack,
	OVCALLBACK_GET lpfnGet,
	OVCALLBACK_PUT lpfnPut,
	HWND HWindow )
{
	int fieldCount = 0, recCount = 0, delRecCount = 0, i = 0;
	char result[11], recCountBuf[20];
	LPSTR field[15];

	FILE *dest;

	// use "workSpace" for a work space so that _fstrtok doesn't alter OV's internal
	// value passed to the "fieldList" parameter.
	lstrcpy (workSpace, fieldList);
	field[fieldCount] = _fstrtok(workSpace, ",");
	while (field[fieldCount] != NULL)
	{
		fieldCount++;
		field[fieldCount] = _fstrtok(NULL, ",");
	}

	dest = fopen (fileName, "w");
	if (dest == NULL)
	{
        wsprintf(command, "@MESSAGE(\"Unable to open file %s in @DumpTable function.", fileName);
		(void)(*lpfnCallBack)(command, (LPSTR)result, 10, 1 );
		return 0;
    }

	wsprintf(command, "@TOP(\"%s\")", tableName);
	(void)(*lpfnCallBack)(command, (LPSTR)result, 10, 1 );

	wsprintf(command, "@NEXT(\"%s\")", tableName);
	while (lstrcmp(result, "Yes") == 0)
	{
		for (i = 0; i < fieldCount; i++)
		{
			lstrcat (output, (*lpfnGet)(field[i]));
			lstrcat (output, "|");
		}
		lstrcpy (&output[lstrlen(output) - 1], "\n");
		fputs (output, dest);
		recCount++;
		sprintf(recCountBuf, "%i", recCount);
		(*lpfnPut)((LPSTR)"Records Dumped", (LPSTR)recCountBuf);
		UpdateWindow(HWindow);
		*output = '\0';

		(void)(*lpfnCallBack)(command, (LPSTR)result, 10, 1 );
	}
	fclose (dest);

	if (deleteFlag)
	{
		wsprintf(command, "@TOP(\"%s\")", tableName);
		(void)(*lpfnCallBack)(command, (LPSTR)result, 10, 1 );

		while (lstrcmp(result, "Yes") == 0)
		{
			wsprintf(command, "@DELETE(\"%s\")", tableName);
			(void)(*lpfnCallBack)(command, (LPSTR)result, 10, 1 );
			wsprintf(command, "@TOP(\"%s\")", tableName);
			(void)(*lpfnCallBack)(command, (LPSTR)result, 10, 1 );

            delRecCount++;
			sprintf(recCountBuf, "%i", delRecCount);
			(*lpfnPut)((LPSTR)"Records Deleted", (LPSTR)recCountBuf);
            UpdateWindow(HWindow);
		}
	}

	return recCount;
}

/******************************************************************************
*
* name          iLoadTable -- Loads a database table from an ASCII file
*
* description   Use this function to load records from an ASCII file
*
* arguments     1.  LPSTR -- Name of table to load into
*               2.  LPSTR -- File name to load from
*               3.  LPSTR -- Variables to load
*               4.  LPSTR -- Input record buffer
*               5.  LPSTR -- Work space for field list
*               6.  OVCALLBACK_EXECUTESTRING -- callback fn
*               7.  OVCALLBACK_PUT -- function to set OV variable
*				8.  HWND -- Handle of OV window
*
* requirements      
*
* return        int -- Number of records loaded
*
* register      @REGISTER("@LoadTable","ICCCFFFnwy",
*                   """Table Name"",""File Name"",""Variables""",
*                   "function.dll","iLoadTable",1)
*
******************************************************************************/

int FAR PASCAL _export iLoadTable(
	LPSTR tableName,
	LPSTR fileName,
	LPSTR fieldList,
	LPSTR input,
	LPSTR command,
	LPSTR workSpace,
	OVCALLBACK_EXECUTESTRING lpfnCallBack,
	OVCALLBACK_PUT lpfnPut,
	HWND HWindow )
{
	int fieldCount = 0, recCount = 0, i = 0;
	char result[11], recCountBuf[20];
	LPSTR field[15];

	FILE *source;

    UpdateWindow(HWindow);

	// use "workSpace" for a work space so that _fstrtok doesn't alter OV's internal
	// value passed to the "fieldList" parameter.
	lstrcpy (workSpace, fieldList);
	field[fieldCount] = _fstrtok(workSpace, ",");
	while (field[fieldCount] != NULL)
	{
		// perform ASSIGN to ensure that field exists before calling lpfnPut
		wsprintf (command, "@ASSIGN(%s,\" \")", field[fieldCount]);
		(void)(*lpfnCallBack)(command, (LPSTR)result, 10, 1 );
		fieldCount++;
		field[fieldCount] = _fstrtok(NULL, ",");
	}

	source = fopen (fileName, "r");
	if (source == NULL)
	{
        wsprintf(command, "@MESSAGE(\"Unable to open file %s in @LoadTable function.", fileName);
		(void)(*lpfnCallBack)(command, (LPSTR)result, 10, 1 );
		return 0;
    }

	wsprintf(command, "@INSERT(\"%s\")", tableName);
	while (fgets(input, 4096, source) != NULL)
	{
		char *value, *pinput;

		for (i = 0, value = input, pinput = input; i < fieldCount; i++)
		{
			if (*pinput == '\0')
				break;
			while (*pinput != '|' && *pinput != '\n' && *pinput != '\0')
            	pinput++;
            *pinput = '\0';
			(*lpfnPut)((LPSTR)field[i], (LPSTR)value);
			pinput++;
			value = pinput;
		}
		recCount++;
		sprintf(recCountBuf, "%i", recCount);
		(*lpfnPut)((LPSTR)"Records Loaded", (LPSTR)recCountBuf);
		UpdateWindow(HWindow);
		if (i < fieldCount)
		{
			char message[50];

			wsprintf (message, "Load aborted: error reading record #%i "
				"(%i of %i fields read).", recCount, i, fieldCount);
			wsprintf (command, "@MESSAGE(\"%s\")", message);
			(void)(*lpfnCallBack)(command, (LPSTR)result, 10, 1 );
			break;
		}
		(void)(*lpfnCallBack)(command, (LPSTR)result, 10, 1 );
	}
	fclose (source);

	return recCount;
}

/******************************************************************************
*
* name          iResetOverride -- Resets the override flag for a field
*
* description   Use this function to keep a field from being grayed when
*               it has been changed by the user
*
* arguments     1.  LPSTR -- Name of field to override
*               2.  OVCALLBACK_RESET -- OV Callback function 
*
* return        None
*
* register      @REGISTER("@ResetOverride","ACu", """Field Name""",
*                   "function.dll","iResetOverride",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iResetOverride(
	LPSTR field,
	OVCALLBACK_RESET lpfnReset )
{
	(*lpfnReset)(field);
	return 0;
}

/******************************************************************************
*
* name          iResetCalculated -- Resets the Calculated flag for a field
*
* description   Use this function to keep a field from being grayed when
*               it has been changed by the user
*
* arguments     1.  LPSTR -- Name of field to override
*               2.  OVCALLBACK_RESET -- OV Callback function 
*
* return        None
*
* register      @REGISTER("@ResetCalculated","ACv", """Field Name""",
*                   "function.dll","iResetCalculated",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iResetCalculated(
	LPSTR field,
	OVCALLBACK_RESET lpfnReset )
{
	(*lpfnReset)(field);
	return 0;
}

/******************************************************************************
*
* name          iIsEmpty -- Checks whether a field is blank
*
* description   Use this function to check whether the user has entered a value
*               into a field.  This function is equivalent to
*				@OR(@ISBLANK(Field),Field="").
*
* arguments     1.  LPSTR -- Name of field to check
*
* return        BOOL -- Yes if field is empty
*
* register      @REGISTER("@IsEmpty","ACx", """Field Name""",
*                   "function.dll","iIsEmpty",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iIsEmpty(
	LPSTR field,
	OVCALLBACK_GET lpfnGet )
{
	char *testField;

    testField = (*lpfnGet)(field);
	return (testField == 0 || *testField == '\0');
}

/******************************************************************************
*
* name          iIsZero -- Checks whether a field is blank or 0
*
* description   Use this function to check whether the user has entered a value
*               into a field.  This function is equivalent to
*				@OR(@ISBLANK(Field),Field="",Field="0").
*
* arguments     1.  LPSTR -- Name of field to check
*
* return        BOOL -- Yes if field is zero
*
* register      @REGISTER("@IsZero","ACx", """Field Name""",
*                   "function.dll","iIsZero",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iIsZero(
	LPSTR field,
	OVCALLBACK_GET lpfnGet )
{
	char *testField;

	testField = (*lpfnGet)(field);
	return (testField == 0 ||
		*testField == '\0' ||
		(*testField == '0' && *(testField + 1) == '\0'));
}

/******************************************************************************
*
* name          iIsTableColumn -- Checks whether a given field is a table column
*
* description   Use this function to find out whether a given field is a column
*               in a table
*
* arguments     1.  LPSTR -- Name of column
*               2.  OVCALLBACK_ISCOLUMN -- OV Callback function
*
* return        BOOL -- Yes if the field is a column
*
* register      @REGISTER("@IsTableColumn","ACr", """Field Name""",
*                   "function.dll","iIsTableColumn",0)
*
******************************************************************************/

BOOL FAR PASCAL _export iIsTableColumn(
	LPSTR field,
	OVCALLBACK_ISCOLUMN lpfnIsColumn )
{
	return (*lpfnIsColumn)(field);
}

/******************************************************************************
*
* name          iGetCurrentRow -- Returns the row number of the given table column
*
* description   Use this function to find out which row of a table is being
*               accessed
*
* arguments     1.  LPSTR -- Name of column
*               2.  OVCALLBACK_ISCOLUMN -- OV Callback function
*               3.  OVCALLBACK_GETCURRENTROW -- OV Callback function 
*
* return        int -- Number of row (0 = error)
*
* register      @REGISTER("@GetCurrentRow","ICro", """Column Name""",
*                   "function.dll","iGetCurrentRow",0)
*
******************************************************************************/

BOOL FAR PASCAL _export iGetCurrentRow(
	LPSTR field,
	OVCALLBACK_ISCOLUMN lpfnIsColumn,
	OVCALLBACK_GETCURRENTROW lpfnGetRow )
{
	int tableHandle;

	tableHandle = (*lpfnIsColumn)(field); 
	if (tableHandle)
		return (*lpfnGetRow)(tableHandle);
	else
		return 0;
}

/******************************************************************************
*
* name          iGetLastRow -- Returns the last row number of the given table column
*
* description   Use this function to find out how many rows are in a table
*
* arguments     1.  LPSTR -- Name of column
*               2.  OVCALLBACK_ISCOLUMN -- OV Callback function
*               3.  OVCALLBACK_GETLASTROW -- OV Callback function 
*
* return        int -- Number of row (0 = error)
*
* register      @REGISTER("@GetLastRow","ICrq", """Column Name""",
*                   "function.dll","iGetLastRow",0)
*
******************************************************************************/

BOOL FAR PASCAL _export iGetLastRow(
	LPSTR field,
	OVCALLBACK_ISCOLUMN lpfnIsColumn,
	OVCALLBACK_GETLASTROW lpfnGetLastRow )
{
	int tableHandle;

	tableHandle = (*lpfnIsColumn)(field); 
	if (tableHandle)
		return (*lpfnGetLastRow)(tableHandle);
	else
		return 0;
}

/******************************************************************************
*
* name          iSetCurrentRow -- Sets the current table row for the given column
*
* description   Use this function to set the current table row
*
* arguments     1.  LPSTR -- Name of column
*               2.  int -- Row number
*               3.  OVCALLBACK_ISCOLUMN -- OV Callback function
*               4.  OVCALLBACK_SETCURRENTROW -- OV Callback function 
*
* return        none
*
* register      @REGISTER("@SetCurrentRow","ICIrs", """Column Name"",Row",
*                   "function.dll","iSetCurrentRow",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iSetCurrentRow(
	LPSTR field,
	int row,
	OVCALLBACK_ISCOLUMN lpfnIsColumn,
	OVCALLBACK_SETCURRENTROW lpfnSetRow )
{
	int tableHandle;

	tableHandle = (*lpfnIsColumn)(field); 
	if (tableHandle)
		(*lpfnSetRow)(tableHandle, row);
	return 0;
}

/******************************************************************************
*
* name          iReboot -- Reboots the computer
*
* description   Use this function to reboot the computer
*
* arguments     none
*
* return        none
*
* register      @REGISTER("@Reboot","I", "",
*                   "function.dll","iReboot",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iReboot()
{
    ExitWindows(EW_REBOOTSYSTEM, 0);
	return 0;
}

/******************************************************************************
*
* name          iRestartWindows -- Exits and restarts Windows
*
* description   Use this function to exit and restart Windows
*
* arguments     none
*
* return        none
*
* register      @REGISTER("@RestartWindows","I", "",
*                   "function.dll","iRestartWindows",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iRestartWindows()
{
	ExitWindows(EW_RESTARTWINDOWS, 0);
	return 0;
}

/******************************************************************************
*
* name          iExitWindows -- Exits Windows
*
* description   Use this function to exit Windows
*
* arguments     none
*
* return        none
*
* register      @REGISTER("@ExitWindows","I", "",
*                   "function.dll","iExitWindows",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iExitWindows()
{
	ExitWindows(0, 0);
	return 0;
}

/******************************************************************************
*
* name          iRandomize -- Initialize the random number generator
*
* description   Use this function to initialize the random number generator
*				before using @Random
*
* arguments     none
*
* return        none
*
* register      @REGISTER("@Randomize","I", "",
*                   "function.dll","iRandomize",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iRandomize()
{
    randomize();
	return 0;
}

/******************************************************************************
*
* name          iRandom -- Returns a random number
*
* description   Use this function to generate a pseudo-random integer
*
* arguments     1.	int -- Maximum number to be returned 
*
* return        int -- Random integer generated
*
* register      @REGISTER("@Random","II", "",
*                   "function.dll","iRandom",0)
*
******************************************************************************/

BOOL FAR PASCAL _export iRandom(
	int max )
{
	return rand() % (max + 1);
}

/******************************************************************************
*
* name          szCommandLine -- Returns the command line used to start the
*				program
*
* description   Use this function to get the command line or any parameters
*
* arguments     1.	LPSTR -- buffer for return value 
*
* return        LPSTR -- command line
*
* register      @REGISTER("@GetCommandLine","CF", "",
*                   "function.dll","szCommandLine",0)
*
******************************************************************************/

LPSTR FAR PASCAL _export szCommandLine(
	LPSTR buffer )
{
    LPSP lpsp = (LPSP) MAKELP(GetCurrentPDB(), 0);

	lstrcpy (buffer, lpsp->pspCommandTail);
	lstrcpy (buffer, buffer + 1);

	return buffer;
}

/******************************************************************************
*
* name          iHighlightAll -- Highlights (selects) all characters in a field  
*
* description   Use this function to select all characters in an edit field
*
* arguments     none
*
* return        none
*
* register      @REGISTER("@HighlightAll","I", "",
*                   "function.dll","iHighlightAll",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iHighlightAll()
{
    HWND HWindow;
    char name[6];
    HWindow = GetFocus();
    GetClassName(HWindow,(LPSTR)name,sizeof(name));
    if (!lstrcmp(name, "Edit")){
	    SendMessage(HWindow, EM_SETSEL, 0, MAKELONG(0, -1));
    }
	return 0;
}

/******************************************************************************
*
* name          iHighlight -- Highlights (selects) characters in a field  
*
* description   Use this function to select characters in an edit field
*
* arguments     1. int -- starting position
*               2. int -- ending position
*
* return        none
*
* register      @REGISTER("@Highlight","III", "Start,End",
*                   "function.dll","iHighlight",1)
*
******************************************************************************/

BOOL FAR PASCAL _export iHighlight(
	int start,
    int end )
{
    HWND HWindow;
    char name[6];
    HWindow = GetFocus();
    GetClassName(HWindow,(LPSTR)name,sizeof(name));
    if (!lstrcmp(name, "Edit")){
	    SendMessage(HWindow, EM_SETSEL, 0, MAKELONG(start, end));
    }
	return 0;
}

/******************************************************************************
*
* name          iGetForm -- Gets the handle of a form  
*
* description   Use this function to get the Window handle of a form
*
* arguments     1. HWND -- handle of main OV window
*               2. LPSTR -- name of form
*
* return        HWND -- handle of form window
*
* register      @REGISTER("@GetFormHandle","IyC", """Form Name""",
*                   "function.dll","iGetFormHandle",0)
*
******************************************************************************/

HWND FAR PASCAL _export iGetFormHandle(
	HWND hwndOV,
	LPSTR pszFormName )
{
	HWND hwndOVMainChild = GetWindow( hwndOV, GW_CHILD );
	HWND hwndLastChild = GetWindow( hwndOVMainChild, GW_HWNDLAST );
	FormItem Self;
	char szCaption[80];
	char szClass[40];
	int  pass = 0;

	do
	{
		if( pass )
			hwndOVMainChild = GetWindow( hwndOVMainChild, GW_HWNDNEXT );
		GetClassName( hwndOVMainChild, szClass, 39 );
		if( !strcmp( szClass, "ObjectVisionFormClass" ) ||
			!strcmp( szClass, "ObjectVisionFormClassR" ) )
		{
			Self = *((FormItem *)GetWindowLong( hwndOVMainChild, 2 ));
			if( !strcmp( pszFormName, Self.FormName ) )
				return( hwndOVMainChild );
		}
		pass = 1;
	} while( hwndLastChild && hwndOVMainChild != hwndLastChild );
	return( NULL );
}

/******************************************************************************
*
* name          iUpdateWindow -- Paints the OV window  
*
* description   Use this function to refresh the OV window
*
* arguments     1. HWND -- handle of main OV window
*
* return        HWND -- handle of form window
*
* register      @REGISTER("@UpdateWindow","Iy","",
*                   "function.dll","iUpdateWindow",0)
*
******************************************************************************/

int FAR PASCAL _export iUpdateWindow(
	HWND hwndOV)
{
	UpdateWindow(hwndOV);
	return 0;
}

#pragma argsused

int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSegment,
						WORD wHeapSize, LPSTR lpszCmdLine )
{
	if ( wHeapSize != 0 )
		UnlockData( 0 );
	return 1;
}

#pragma argsused

int FAR PASCAL WEP ( int bSystemExit )
{
	return 1;
}
