// Borland ObjectVision -- (C) Copyright 1991 by Borland International

// The callback functions ObjectVision passes to you will fit one of these:
typedef LPSTR FAR PASCAL OVCALLBACK_GET           ( LPSTR );
typedef void  FAR PASCAL OVCALLBACK_RESET         ( LPSTR );
typedef void  FAR PASCAL OVCALLBACK_PUT           ( LPSTR, LPSTR );
typedef int   FAR PASCAL OVCALLBACK_ISCOLUMN      ( LPSTR );
typedef void  FAR PASCAL OVCALLBACK_SETCURRENTROW ( int, int );
typedef int   FAR PASCAL OVCALLBACK_GETCURRENTROW ( int );
typedef void  FAR PASCAL OVCALLBACK_SETLINKROW    ( int, int );
typedef int   FAR PASCAL OVCALLBACK_GETLASTROW    ( int );
typedef LPSTR FAR PASCAL OVCALLBACK_NEXTCOL       ( int, LPSTR );
typedef LPSTR FAR PASCAL OVCALLBACK_EXECUTESTRING ( LPSTR, LPSTR, unsigned,
    unsigned );

// The description of each OV callback functions follows:

/******************************************************************************
*
* name          DllCallBack_Get -- Fetch the value of an OV field
*
* description   Call this function to get the string form of an OV
*               field's value.
*
*               The memory pointed to by the return pointer is
*               deallocated when you return to OV so make yourself a
*               copy if you need the value to persist.
*
* arg letter    x
*
* prototype     LPSTR FAR PASCAL _export DllCallBack_Get( LPSTR );
*
* arguments     1.  LPSTR lpszFieldName -- the name of the field (any case)
*
* return        Value of the field, or NULL if field does not exists
*
******************************************************************************/

/******************************************************************************
*
* name          DllCallBack_Put -- Assign a value to an OV field
*
* description   Call this function to assign a value to an OV field.
*               Truth maintenance is done (the values of dependent
*               fields will change) before OV returns to you.  Automatic
*               data type conversion is done, e.g., numbers and dates
*               are recognized and converted to the appropriate data
*               type.  If the field doesn't exists, nothing happens.
*
* arg letter    w
*
* prototype     void FAR PASCAL _export DllCallBack_Put( LPSTR, LPSTR );
*
* arguments     1.  LPSTR lpszFieldName -- the name of the field (any case)
*               2.  LPSTR lpszValue -- the value to assign to the field
*
* return        None
*
******************************************************************************/

/******************************************************************************
*
* name          DllCallBack_ResetOverride -- Reset a field's override bit
*
* description   Call this function to reset a field's override bit.  If
*               the field doesn't exists, nothing happens.
*
* arg letter    v
*
* prototype     void FAR PASCAL _export DllCallBack_ResetOverride( LPSTR );
*
* arguments 1.  LPSTR lpszFieldName -- the name of the field (any case)
*
* return        None
*
******************************************************************************/

/******************************************************************************
*
* name          DllCallBack_ResetCalculated -- Reset a field's calculated bit
*
* description   Call this function to reset a field's calculated bit.
*               If the field doesn't exists, nothing happens.
*
* arg letter    u
*
* prototype     void FAR PASCAL _export DllCallBack_ResetCalculated( LPSTR );
*
* arguments     1.  LPSTR lpszFieldName -- the name of the field (any case)
*
* return        None
*
******************************************************************************/

/******************************************************************************
*
* name          DllCallBack_ExecuteString -- Execute an OV expression
*
* description   Call this function to execute an OV expression.  If the
*               expression is a multi-line expression, include each line
*               in square brackets.  The result of a multi-line
*               expression is the result of the execution of the last
*               line.  If you don't care what the result is just pass a
*               NULL as the place for the answer.  If you don't want
*               link errors to be reported during execution of the
*               expression, pass a non-zero value as
*               uDisableErrorReports.
*
* arg letter    n
*
* prototype     LPSTR FAR PASCAL _export DllCallBack_ExecuteString( LPSTR,
*                   LPSTR, unsigned, unsigned );
*
* arguments     1.  LPSTR lpszString -- the expression to execute
*               2.  LPSTR lpBuf -- place for the answer, or NULL
*               3.  unsigned uBufSize -- size of the answer place
*               4.  unsigned uDisableErrorReports -- suppress error reporting
*
* return        The string form of the result.
*
******************************************************************************/

/******************************************************************************
*
* name          DllCallBack_IsColumn -- Fetch a handle for a col's table
*
* description   If lpszColumnName names a column, return a handle to its
*               table, otherwise return 0.  This is perhaps a little
*               haphazard semantically, ie., IsColumn() suggests a
*               boolean, however, I want to create as few callback
*               functions as possible.  Doing it this way allows this
*               method to serve both as a boolean test and as a means
*               for the DLL to obtain a handle to the table that owns
*               the column, for half the price.
*
* arg letter    r
*
* prototype     int  FAR PASCAL _export DllCallBack_IsColumn( LPSTR );
*
* arguments     1.  LPSTR lpszColumnName -- the name of the column (any
*                                           case)
*
* return        A table's handle, or 0
*
******************************************************************************/

/******************************************************************************
*
* name          DllCallBack_SetCurrentRow -- Set currency
*
* description   Given a table handle set the currency row of the table.
*
*               The currency row indicates the current value of the
*               column.  A column has 1 and only 1 value at a time which
*               is indicated by currency.  USE WITH CAUTION.
*
* arg letter    s
*
* prototype     void FAR PASCAL _export DllCallBack_SetCurrentRow( int, int );
*
* arguments     1.  int iHandle -- a table's handle
*               2.  int iRow -- the row
*
* return        None
*
******************************************************************************/

/******************************************************************************
*
* name          DllCallBack_GetCurrentRow -- Fetch a table's currency row
*
* description   Given a table handle return the currency row of the
*               table.  A return value of 0 indicates error, ie.,
*               invalid table handle.  Also, a table's currency row
*               should never be 0, the first row is 1.
*
* arg letter    o
*
* prototype     int  FAR PASCAL _export DllCallBack_GetCurrentRow( int );
*
* arguments     1.  int iHandle -- the table's handle
*
* return        The currency row
*
******************************************************************************/

/******************************************************************************
*
* name          DllCallBack_SetLinkRow -- Set a table's currency row
*
* description   Given a table handle set the link row of the table.
*               This is a reserved callback.  DO NOT USE.
*
*               NOTE:  0 is a legal value.  It means the link is not
*               listening.
*
* arg letter    t
*
* prototype     void FAR PASCAL _export DllCallBack_SetLinkRow( int, int );
*
* arguments     1.  int iHandle -- the table's handle
*               2.  int iRow -- the row
*
* return        None
*
******************************************************************************/

/******************************************************************************
*
* name          DllCallBack_GetLastRow -- Get the last row of the table
*
* description   Given a table handle get the last row of the table.
*
*               If the table has a data source, (ie., link), then the
*               last row is the linkRow.  If there is not a data source,
*               then last row is the last physical row in the table.
*
* arg letter    q
*
* prototype     int  FAR PASCAL _export DllCallBack_GetLastRow( int );
*
* arguments     1.  int iHandle -- the table's handle
*
* return        The last row
*
******************************************************************************/

/******************************************************************************
*
* name          DllCallBack_NextCol -- Get name of next column
*
* description   Given a table handle and a column name return the name
*               of the next column.
*
* arg letter    p
*
* prototype     LPSTR FAR PASCAL _export DllCallBack_NextCol( int, LPSTR );
*
* arguments     1.  int iHandle
*               2.  LPSTR lpszColName
*
* return        Name of the next column, or NULL
*
******************************************************************************/

