// Borland ObjectVision -- (C) Copyright 1991 by Borland International

#include <windows.h>
#include <stdio.h>
#include "comb.h"

// ------------------------------------------------------------------- //
//                                                                     //
//   Every DLL has an entry point LibMain and an exit point WEP        //
//                                                                     //
// ------------------------------------------------------------------- //

// Turn off "Parameter never used" warning
#pragma argsused

int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSegment,
                        WORD wHeapSize, LPSTR lpszCmdLine )
{
    // The startup code for the DLL initializes the local heap (if
    // there is one) with a call to LocalInit which locks the data
    // segment.
    if ( wHeapSize != 0 )
        UnlockData( 0 );
    return 1;   // Indicate that the DLL was initialized successfully.
}

// Turn off "Parameter never used" warning
#pragma argsused

int FAR PASCAL WEP ( int bSystemExit )
{
    return 1;
}

// ------------------------------------------------------------------- //
//                                                                     //
//   This sample function is registered and called by the sample OV    //
//   application CHOICE.OVD.                                           //
//                                                                     //
// ------------------------------------------------------------------- //

// Argument template = "FACCF"
LPSTR FAR PASCAL _export ChooseString( BOOL bChoice, LPSTR szTrueString,
                                       LPSTR szFalseString, LPSTR sOvBuffer )
{
    if ( bChoice )
    {
        // ObjectVision strings can be up to 4096 characters long
        if ( lstrlen( szTrueString ) <= 4096 )
        {
            lstrcpy( sOvBuffer, szTrueString );
        }
        else
        {
            *sOvBuffer = '\0';
        }
    }
    else
    {
        if ( lstrlen( szFalseString ) <= 4096 )
        {
            lstrcpy( sOvBuffer, szFalseString );
        }
        else
        {
            *sOvBuffer = '\0';
        }
    }
    return sOvBuffer;
}

// ------------------------------------------------------------------- //
//                                                                     //
//   These simple, sample functions illustrate how to call and         //
//   return other data types.                                          //
//                                                                     //
// ------------------------------------------------------------------- //

// Argument template = "III"
int FAR PASCAL _export iSum( int iInteger1, int iInteger2 )
{
    return( iInteger1 + iInteger2 );
}

// Argument template = "HHH"
unsigned FAR PASCAL _export uSum( unsigned uInteger1, unsigned uInteger2 )
{
    return( uInteger1 + uInteger2 );
}

// Argument template = "JJJ"
unsigned long FAR PASCAL _export ulSum( unsigned long ulInteger1,
                                        unsigned long ulInteger2 )
{
    return( ulInteger1 + ulInteger2 );
}

// Argument template = "IAA"
int FAR PASCAL _export bSum( int iBool1, int iBool2 )
{
    return( iBool1 + iBool2 );
}

// Argument template = "IAII"
int FAR PASCAL _export iIfInt( int iCond, int iTrue, int iFalse )
{
    return iCond ? iTrue : iFalse;
}

// Argument template = "I"
int FAR PASCAL _export NoArgs( void  )
{
    return 42;
}

// Argument template = "BBB"
typedef double far * LPDOUBLE;
LPDOUBLE FAR PASCAL _export fSum( double fArg1, double fArg2 )
{
    static double temp;
    temp = fArg1 + fArg2;
    return (LPDOUBLE)&temp;
}

// Argument template = "CCC"
LPSTR FAR PASCAL _export sSum( LPSTR lpszArg1, LPSTR lpszArg2 )
{
    static char sBuf[200];
    // You are responsible for making sure the buffer doesn't overflow.
    // ObjectVision 2.0 strings can be up to 4096 characters long.
    lstrcpy( sBuf, lpszArg1 ); // Warning: could overflow the buffer
    lstrcat( sBuf, lpszArg2 ); // Warning: could overflow the buffer
    return (LPSTR)sBuf;
}

// Argument template = "CxC"
LPSTR FAR PASCAL _export GetFieldValue( OVCALLBACK_GET lpfnCallBack, LPSTR lpField )
{
    static char sBuf[257];
    char far * lpResult;

    lpResult = (*lpfnCallBack)( lpField );
    if ( lpResult && lstrlen(lpResult) < sizeof(sBuf) )
    {
        lstrcpy( sBuf, lpResult );
    }
    else
    {
        lstrcpy( sBuf, "<Field doesn't exist or result is too long>" );
    }
    return (LPSTR)sBuf;
}

// Argument template = "HwCC"
unsigned FAR PASCAL _export PutFieldValue( OVCALLBACK_PUT lpfnCallBack, LPSTR lpField, LPSTR lpValue )
{
    (*lpfnCallBack)( lpField, lpValue );
    return 0;
}

// Argument template = "HuC" or "HvC"
unsigned FAR PASCAL _export ResetStatus( OVCALLBACK_RESET lpfnCallBack, LPSTR lpField )
{
    (*lpfnCallBack)( lpField );
    return 0;
}


/******************************************************************************
*
* name          SelfRegister -- Register all of the functions of this DLL
*
* arguments     1.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*
* return        Zero
*
* register      @REGISTER("@REGISTER_OVLOOPS","In","","comb.dll",
*                   "SelfRegister",1)
*
******************************************************************************/

int FAR PASCAL _export SelfRegister( OVCALLBACK_EXECUTESTRING lpfnCallBack )
{
    (void)(*lpfnCallBack)(
        "@REGISTER(\"@WHILELOOP\",\"ICCn\",\"\"\"ConditionExpression\"\","
            "\"\"ActionExpression\"\"\",\"comb.dll\",\"iWhileLoop\",1)"
        , 0, 0, 0 );
    (void)(*lpfnCallBack)(
        "@REGISTER(\"@WHILEFIELD\",\"JCCwx\",\"\"\"ConditionField\"\","
            "\"\"EventField\"\"\",\"comb.dll\",\"lWhileField\",1)"
        , 0, 0, 0 );
    (void)(*lpfnCallBack)(
        "@REGISTER(\"@EXECUTE\",\"CCnF\",\"\"\"CommandToExecute\"\"\","
            "\"comb.dll\",\"szExecuteString\",1)"
		  , 0, 0, 0 );
	  (void)(*lpfnCallBack)(
		  "@REGISTER(\"@MessageBeep\",\"I\",\"\","
				"\"user.exe\",\"MessageBeep\",1)"
		  , 0, 0, 0 );
    return 0;
}

/******************************************************************************
*
* name          iWhileLoop -- While function using ExecuteString callback
*
* description   You can use this function to implement an @WHILELOOP in OV.
*               Link error reporting is disabled during both condition and
*               action execution.
*
* arguments     1.  LPSTR szCondition -- the condition expression
*               2.  LPSTR szAction -- the action expression
*               3.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*
* return        Zero (an int)
*
* register      @REGISTER("@WHILELOOP","ICCn",
*                   """ConditionExpression"",""ActionExpression""",
*                   "comb.dll","iWhileLoop",1)
*
******************************************************************************/

int FAR PASCAL _export iWhileLoop(
    LPSTR szCondition,
    LPSTR szAction,
    OVCALLBACK_EXECUTESTRING lpfnCallBack )
{
    char sBuf[10];
    char * szConditionResult;

    szConditionResult = (*lpfnCallBack)( szCondition, sBuf, sizeof(sBuf), 1 );
    while ( szConditionResult && !lstrcmpi(szConditionResult,"Yes") )
    {
        (void)(*lpfnCallBack)( szAction, (LPSTR)0, 0, 1 );
        szConditionResult = (*lpfnCallBack)( szCondition, sBuf,
                                                 sizeof(sBuf), 1 );
    }
    return 0;
}

/******************************************************************************
*
* name          lWhileField --  While function using only Get & Put callbacks
*
* description   You can use this function to implement an @WHILEFIELD in OV.
*
* arguments     1.  LPSTR szConditionField
*               2.  LPSTR szEventField
*               3.  OVCALLBACK_PUT lpfnPutCallBack
*               4.  OVCALLBACK_GET lpfnGetCallBack
*
* return        unsigned long -- the number of times through the loop
*
* register      @REGISTER("@WHILEFIELD","JCCwx","""ConditionField"",
*                   ""EventField""","comb.dll","lWhileField",1)
*
******************************************************************************/

unsigned long FAR PASCAL _export lWhileField(
    LPSTR szConditionField,
    LPSTR szEventField,
    OVCALLBACK_PUT lpfnPutCallBack,
    OVCALLBACK_GET lpfnGetCallBack  )
{
    char far * szCondition;
    char far * szEvent;
    char sNumber[20];
    unsigned long lLoop;

    szCondition = (*lpfnGetCallBack)( szConditionField );
    szEvent = (*lpfnGetCallBack)( szEventField );
    if ( szCondition == 0 || szEvent == 0 )
    {
        // One of the fields doesn't exists. Don't event try because
        // the while would loop forever.
        lLoop = 0;
    }
    else
    {
        lLoop = 0;
        while ( lstrcmpi(szCondition,"No") )
        {
            lLoop++;
			sprintf(sNumber,"%ld",lLoop);
            if ( lLoop == 1 && !lstrcmpi(szEvent,sNumber) )
            {
                lstrcpy( sNumber, "0" ); // To ensure we get a change event
            }
            (*lpfnPutCallBack)( (LPSTR)szEventField, (LPSTR)sNumber );
            szCondition = (*lpfnGetCallBack)( szConditionField );
        }
    }
    return lLoop;
}

/******************************************************************************
*
* name          szExecuteString -- Send a command string to OV for execution
*
* description   Use this function to send a command to OV for execution.
*
* arguments     1.  LPSTR szCommand  -- the command to execute
*               2.  OVCALLBACK_EXECUTESTRING lpfnCallBack -- callback fn
*               3.  LPSTR sAnswerBuffer -- place for the answer
*
* return        LPSTR -- result string
*
* register      @REGISTER("@EXECUTE","CCnF","""CommandToExecute""",
*                   "comb.dll","szExecuteString",1)
*
******************************************************************************/

LPSTR FAR PASCAL _export szExecuteString(
    LPSTR szCommand,
    OVCALLBACK_EXECUTESTRING lpfnCallBack,
    LPSTR sAnswerBuf )
{
    LPSTR szResult;
    szResult = (*lpfnCallBack)( szCommand, sAnswerBuf, 4096, 0 );
    if ( !szResult )
    {
        szResult = ""; // Return something
    }
    return szResult;
}

