*:*****************************************************************************
*:
*: Procedure file: E:\CODE\T\_BRCPRO2.PRG
*:
*:         System: 
*:         Author: 
*:      Copyright (c) 1994, 
*:  Last modified: 09/30/94     13:39
*:
*:  Procs & Fncts: STEP_ON_PROC
*:               : OPENNEWFILE
*:               : WRITENEWFILE
*:               : CLOSENEWFILE
*:
*:          Calls: TESTFILE.PRG
*:               : BRAKEM()           (function  in ?)
*:               : STEP_ON_PROC       (procedure in _BRCPRO2.PRG)
*:
*:    Other Files: &MANS
*:
*:      Documented 09/30/94 at 13:39               FoxDoc  version 2.10f
*:*****************************************************************************
*
*   will break procs/funcs from a file containing them
*   will add a 1..2..3 etc to the end of the proc/func filename if
*   it runs into a duplicate
*
*
*   set up to process an entire directory  see below for
*   changes to do one file, if you want only one file remove
*   the lup_em for..endfor, or put the program to de-proc in
*   its own directory
*
ON KEY LABEL alt-t SET STEP ON
ON KEY LABEL alt-C CANCEL
CLEAR ALL
CLOSE ALL
ERASE testfile.prg
*
*
* mans = SPACE(20)
* @ 2,3 SAY 'file to break up ' GET mans
* READ
*
* mans=GETFILE()
* mans=ALLTRIM(mans)
*
*


=ADIR(brakem,'*.prg')
end_it = ALEN(brakem)/5


   FOR lup_em = 1 TO end_it

   mans = brakem(lup_em,1)
   DO CASE
   CASE PROGRAM() $ mans
      *
      * cant do that
      *
      LOOP
   ENDCASE
   WAIT WINDOW 'Processing '+mans NOWAIT
   CLOSE ALL
   SET STAT ON
   CREATE CURSOR hold_it (textline C(254))
   SELECT 0
   SELECT hold_it
   *
   * need to test for file here
   *
   newfile=''
   begin_written = .F.
   APPEND FROM &mans TYPE SDF
   RENAME &mans TO testfile.prg  && save a backup just in case
   REPLACE ALL textline WITH ALLTRIM(textline)
   GO TOP
   begin_all = 1
   begin_line = ''
   bottom_flag = .F.
   made_a_proc = .F.
   *
   *
   *
   DO WHILE NOT EOF()
      *
      DO CASE
      CASE UPPER(LEFT(textline,5))='PROC ' OR ;
            UPPER(LEFT(textline,10))='PROCEDURE '
         made_a_proc = .T.
         =step_on_proc('PROC ','PROCEDURE ')
      CASE UPPER(LEFT(textline,5))='FUNC ' OR ;
            UPPER(LEFT(textline,09))='FUNCTION '
         made_a_proc = .T.
         =step_on_proc('FUNC ','FUNCTION ')
      ENDCASE
      SKIP
      *
   ENDDO
   DO CASE
   CASE NOT made_a_proc
      RENAME testfile.prg TO &mans
   ENDCASE
   ERASE testfile.prg
   DO CASE
   CASE TYPE('mans')='U' OR EMPTY(mans)
   ENDFOR

*!*****************************************************************************
*!
*!      Procedure: STEP_ON_PROC
*!
*!      Called by: _BRCPRO2.PRG                      
*!
*!          Calls: OPENNEWFILE        (procedure in _BRCPRO2.PRG)
*!               : WRITENEWFILE       (procedure in _BRCPRO2.PRG)
*!               : CLOSENEWFILE       (procedure in _BRCPRO2.PRG)
*!
*!*****************************************************************************
PROCEDURE step_on_proc
   PARAMETER keyword1,keyword2
   keyl1=LEN(keyword1)
   keyl2=LEN(keyword2)
   *
   proc_begin = RECNO()
   oktomakeit=.F.
   pass=1
   filename = ''
   proc_end   = 0
   *
   *  write the beginning of the file
   *
   DO CASE
   CASE NOT begin_written
      DO opennewfile
      SELECT hold_it
      GO 1
      SCAN WHILE RECNO() >=1 AND RECNO() < proc_begin
         DO writenewfile
      ENDSCAN
      DO closenewfile
      RENAME _newfile.txt TO &mans
      GO proc_begin
   ENDCASE
   *
   DO CASE
   CASE NOT bottom_flag
      begin_written = .T.
      begin_line = textline
      SKIP
   ENDCASE
   *
   *  truck along until we find the beginning of next proc
   *
   DO WHILE proc_end = 0 AND NOT EOF()
      DO CASE
      CASE UPPER(LEFT(textline,5))='PROC ' OR ;
            UPPER(LEFT(textline,10))='PROCEDURE '
         proc_end = RECNO() -1
      CASE UPPER(LEFT(textline,5))='FUNC ' OR ;
            UPPER(LEFT(textline,09))='FUNCTION '
         proc_end = RECNO() -1
      ENDCASE
      SKIP
   ENDDO
   DO CASE
   CASE EOF()
      GO BOTTOM
      proc_end = RECNO()
   ENDCASE
   *
   * now have begin and end of it, make up the name
   *
   DO CASE
   CASE UPPER(LEFT(begin_line,keyl1))=keyword1
      filename=STRTRAN(begin_line,keyword1,'')
   CASE UPPER(LEFT(begin_line,keyl2))=keyword2
      filename=STRTRAN(begin_line,keyword2,'')
   OTHERWISE
      WAIT WINDOW 'bad begin line'
      SUSPEND
   ENDCASE
   *
   filename=PADL(ALLTRIM(filename),8,' ')  && length doesnt matter cuz files only looks at valid dosnames
   *
   DO WHILE NOT oktomakeit
      DO CASE
      CASE NOT FILES(filename+'.prg')
         oktomakeit = .T.
      OTHERWISE
         filename=LEFT(filename,LEN(filename)-1)+ALLTRIM(STR(pass))
         pass = pass+1
      ENDCASE
   ENDDO
   filename=ALLTRIM(filename)+'.prg'
   *
   *  filename is now ready
   *
   *****
   *
   * ready to go now
   *
   GO proc_begin
   @ 5,0 SAY 'Writing File '+filename
   =INKEY(.0001)
   DO opennewfile
   SELECT hold_it
   SCAN WHILE RECNO() >=proc_begin AND RECNO() <=proc_end
      DO writenewfile
   ENDSCAN
   DO closenewfile
   RENAME _newfile.txt TO &filename
   GO proc_end
*!*****************************************************************************
*!
*!      Procedure: OPENNEWFILE
*!
*!      Called by: STEP_ON_PROC       (procedure in _BRCPRO2.PRG)
*!
*!    Other Files: _NEWFILE.TXT
*!
*!*****************************************************************************
PROCEDURE opennewfile
   newfile=FCREATE('_newfile.txt')
*!*****************************************************************************
*!
*!      Procedure: WRITENEWFILE
*!
*!      Called by: STEP_ON_PROC       (procedure in _BRCPRO2.PRG)
*!
*!*****************************************************************************
PROCEDURE writenewfile
   =FPUT(newfile,ALLTRIM(hold_it.textline))
*!*****************************************************************************
*!
*!      Procedure: CLOSENEWFILE
*!
*!      Called by: STEP_ON_PROC       (procedure in _BRCPRO2.PRG)
*!
*!*****************************************************************************
PROCEDURE closenewfile
   =FCLOSE(newfile)
*: EOF: _BRCPRO2.PRG
