***
*** Patrick Vogelsang
*** Johnson Controls Network Integration Services
***
*** Function ZIPDIGIT
***
*** Returns the proper Zip Digit given a Zip Code in the form
*** "99999" or "99999-9999". The function take a charcter string
*** and returns a character string. If the passed variable is not a
*** character or is a character but does not conform to the the above
*** rules the function will return th NULL string ""
***
FUNCTION zipdigit
parameters zipcode
private zipdigit, ziplength, x, c_code, zip_sum, x_char, convert
***
***  Private Variables
***
*** zipdigit	C 	Return Values
*** ziplength	N	Length of zipcode
*** x			N	For Loop Counter 
*** c_code		N	The C digit of zipdigit ex. "s123451234Cs"
***	zip_sum		N	Sum of each number in the zipcode
*** x_char		C	The xth Char of zipcode in For Loop
***	convert		L	If zipcode converts properly ie all numbers 
***	

if parameters() = 0  && No Parameters Passed to Function
  zipdigit = ""
  
else  && correct Number of parameters

  if type("zipcode") <> "C"   && Passed variable is not a character
  
    zipdigit = ""
    
  else  && Passed variable is a character
  
    ziplength = len(zipcode)
    
    if ziplength = 5 .or. ziplength = 10  && Correct Zipcode Size
    
      if ziplength = 10  && Remove the "-" from zipcode
        zipcode = left(zipcode,5)+right(zipcode,4)
        ziplength = 9
      endif && ziplength = 10 
      
      convert = .t.
      zip_sum = 0
      for x = 1 to ziplength
      
        x_char = substr(zipcode, x, 1)
        if x_char $ "0123456789"  
          zip_sum = zip_sum + val(x_char)
        else
          convert = .f.
          exit
        endif  && x_char $ "0123456789"
        
      endfor && x = 1 to ziplength
      
      if .not. convert
        zipdigit = ""
        
      else
      
        c_code = 10-mod(zip_sum, 10)
        
        if c_code = 10
          c_code = 0
        endif  && c_code = 10
        
        zipdigit = "s"+zipcode+alltrim(str(c_code))+"s"
        
      endif  && .not. convert
      
    else  && Incorrect Zipcode Size
      zipdigit = ""
      
    endif  && ziplength = 5 .or. ziplength = 10
    
  endif  && type("zipcode") <> "C"
  
endif  && parameters() = 0

return zipdigit      