* * * * * * * * * * * * * * * * * * * * * * * *
*       BARCODE()
*
* This function prints U.S.P.S. barcodes.
* 11/4/91
* Ken LaCapria
*
* syntax:  BARCODE('12345-6789')
* returns null string
*
* Epson 9 pin dot matrix printer compatable.
*
* 11/07/91
*   Changed from 9 pin to 8 pin graphic mode to be epson compatable
*
* This function has been released to the Public Domain on 11/10/91.
* All that I ask is that I get credit for writing the function and that
* should you make any changes to it, that you send me a copy of the
* function with the changes to me so that I can learn more about programming
* techinques.
*
FUNCTION BARCODE
        PARAMETER ZIPCODE
        PRIVATE LONGBAR,SHORTBAR,NB,ZIPLEN,DIGIT,TEMPZIP,ZIPSUM,ZIPDIF,ECDIGIT
        PRIVATE X,Y,ZIPCODE

        IF '-' $ ZIPCODE
                ZIPCODE=STRTRAN(ZIPCODE,'-')
        ENDIF
        ZIPCODE=ALLTRIM(ZIPCODE)
        ZIPSUM=0
        LONGBAR=CHR(255)        && print code for the long bar
        SHORTBAR=CHR(3)         && print code for the short bar
        NB=CHR(0)               && print code for no bar
        DPI=4                   && graphic mode dot per inch paramater = 80 dpi
        NBNUM=3                 && number of dot spaces between bars
        DPERL=(NBNUM+1)*5       && dot per line spec for each digit of the zip
        ZIPLEN=LEN(ZIPCODE)
        FOR X=1 TO ZIPLEN
                ZIPSUM=ZIPSUM+VAL(SUBSTR(ZIPCODE,X,1))
        NEXT
        IF VAL(SUBSTR(STR(ZIPSUM,2,0),-1,1))=0
                ECDIGIT=0
        ELSE
                ECDIGIT=10-VAL(SUBSTR(STR(ZIPSUM,2,0),-1,1))
        ENDIF
        TEMPZIP='F'+ZIPCODE+STR(ECDIGIT,1,0)+'F'

        FOR Y=1 TO LEN(TEMPZIP)
                DIGIT=SUBSTR(TEMPZIP,Y,1)
                IF DIGIT='F'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL/5)+CHR(0)
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF

                IF DIGIT='0'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL)+CHR(0)
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF

                IF DIGIT='1'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL)+CHR(0)
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF

                IF DIGIT='2'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL)+CHR(0)
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF

                IF DIGIT='3'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL)+CHR(0)
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF

                IF DIGIT='4'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL)+CHR(0)
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF

                IF DIGIT='5'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL)+CHR(0)
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF

                IF DIGIT='6'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL)+CHR(0)
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF

                IF DIGIT='7'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL)+CHR(0)
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF

                IF DIGIT='8'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL)+CHR(0)
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF

                IF DIGIT='9'
                        ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL)+CHR(0)
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? LONGBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                        ?? SHORTBAR
                        FOR X=1 TO NBNUM
                                ?? NB
                        NEXT X
                ENDIF
        NEXT

        ?? CHR(27)+CHR(74)+CHR(6)
        ?? CHR(13)
        FOR Y=1 TO ((LEN(ALLTRIM(ZIPCODE))+1)*5)+2
                ?? CHR(27)+'*'+CHR(DPI)+CHR(DPERL/5)+CHR(0)
                ?? SHORTBAR
                FOR X=1 TO NBNUM
                        ?? NB
                NEXT X
        NEXT
        ?? CHR(27)+CHR(106)+CHR(6)
RETURN ''

