* 02/20/93

* Here are two little routines that I use in one of my application
* backup utility.

* The first one checks returns .T. if the floppy is empty
* The single parameter is the drive name ("A:", "B:", etc...)

* The second routine uses a recursive algorithm to completely
* zap all the disk content using the FoxPro DELETE FILE command,
* and the excellent DIRBOSS.BIN module from John M. Bauman
* to remove the subdirectories (available from the FoxForum).
* The two parameters are the drive name and the pathname where
* the delete procedure will begin.

* You can freely use, distribute and modify this code.

* Jose Dubois (72110,3245)

* Here is a way to them:
* IF !diskempty("B:")
*    IF yesno ("Disk in drive B: NOT EMPTY.  Empty disk?")
*       DO zapdisk WITH "B:"
*    ENDIF
* ENDIF



* Function to verify if a removable disk is empty
* Jose Dubois - 02/20/93
FUNCTION diskempty
PARAMETERS z_drv
   z_sum = ADIR(z_dir, z_drv+"\*.*", "D")
   z_empty = (z_sum = 0)
RETURN z_empty




* Procedure to remove all files including sub-directories
* Jose Dubois - 02/20/93

PROCEDURE zapdisk
PARAMETERS z_drv, z_path
PRIVATE ALL LIKE z_*

* You would have to LOAD the DIRBOSS.BIN module prior to this call
* or LOAD it here and RELEASE it at the end of the PROCEDURE.

* Get the directory structure into array <z_dir>
   z_sum = ADIR (z_dir, z_drv + z_path + "\*.*", "D")
         
* Process all directory entries
   FOR z_cnt = 1 TO z_sum
   
      IF SUBSTR(z_dir(z_cnt,5), 5, 1) = "D"      && Sub-directory
         IF !"." $ SUBSTR(z_dir(z_cnt,1),1,2)    && Parent or current
         
            * Build subdirectory delete call for DIRBOSS
            z_deldir = "R" + z_drv + z_path + "\" + z_dir(z_cnt,1)
                       
            * Recursive call for new subdirectory           
            DO zapdisk WITH z_drv, z_path + "\" + z_dir(z_cnt,1)
                          
            * Remove emptied subdirectory
            CALL dirboss WITH z_deldir
         ENDIF
         
      ELSE

         z_delfil = z_drv + z_path + "\" + z_dir(z_cnt,1)
         DELETE FILE &z_delfil
      ENDIF
      
   ENDFOR
   
RETURN

