set talk off					&& Set up environment
set safety off
set color to w+/w,b/w
clear all
clear

public fn,col,row,cal,ope
erase kt.dbf					&& Reduce chance for loading tmp files
erase xts.dbf
erase fn1.dbf

define window cm from 6,9 to 9,42 shadow color w+/bg	&& This is the window for calculation status

define menu mainmenu									&& Define the menu junk
define pad fil of mainmenu prompt ' FILE ' at 0,0
define pad col of mainmenu prompt ' COLUMN '  at 0,8
define pad row of mainmenu prompt ' ROW ' at 0,18
define pad cal of mainmenu prompt ' CALC FIELD ' at 0,25
define pad ope of mainmenu prompt ' OPERATOR ' at 0,39
define pad doi of mainmenu prompt ' DO IT ' at 0,51
define pad qui of mainmenu prompt ' QUIT ' at 0,60

on pad fil of mainmenu activate popup filpop
on pad col of mainmenu activate popup colpop
on pad row of mainmenu activate popup rowpop
on pad cal of mainmenu activate popup calpop
on pad ope of mainmenu activate popup opepop
on pad doi of mainmenu activate popup doipop
on pad qui of mainmenu activate popup quipop

define popup filpop from 1,0 prompt files like *.dbf message "Select File for the Crosstab Operation" shadow
on selection popup filpop do loadfil

define popup colpop from 1,9 prompt structure message "Select CHARACTER Field for the Columns" shadow
on selection popup colpop do loadcol

define popup rowpop from 1,19 prompt structure message "Select CHARACTER or NUMERIC Field for the Rows" shadow
on selection popup rowpop do loadrow

define popup calpop from 1,26 prompt structure message "Select NUMERIC Field to be Calculated" shadow
on selection popup calpop do loadcal

define popup opepop from 1,40 message "Select Operation for the Calculated Field" shadow
define bar 1 of opepop prompt 'SUM    '
define bar 2 of opepop prompt 'AVERAGE'
define bar 3 of opepop prompt 'COUNT  '
on selection popup opepop do loadope

define popup doipop from 1,52 message "Select Crosstab Action" shadow
define bar 1 of doipop prompt 'MAKE CALCULATIONS'
define bar 2 of doipop prompt 'VIEW CALCULATIONS'
define bar 3 of doipop prompt 'SORT CALCULATIONS'
on selection popup doipop do actmenu

define popup quipop from 1,61 message "Get Me Out of Here Now" shadow
define bar 1 of quipop prompt "QUIT THIS DUDE"
on selection popup quipop do chow

clear										&& Let's have a purdy screen
@ 0,69 say " CROSSTAB " color b/w
z = 1
set color to n+/w	
do while z < 24								&& Paint chr(177) as the background
	@ z,0 say replicate(chr(177),80)
	z = z + 1
enddo
set color to w+/bg
@ 15,35 clear to 21,75						&& This is the crosstab status box
@ 15,35,21,75 box
@ 15,52 say " STATUS " color gr+/bg
set color to n+/n
z = 16
do while z < 23								&& Shadow for the status box (right)
	@ z,76 say replicate(chr(177),2)
	z = z + 1
enddo
@ 22,37 say replicate(chr(177),39)			&& Shadow for the status box (bottom)
set color to w+/bg
@ 16,36 say "File:"
@ 17,36 say "Column Field:"
@ 18,36 say "Row Field:"
@ 19,36 say "Calc Field:"
@ 20,36 say "Operator:"
set color to w+/w,b/w

do while .t.
	activate menu mainmenu
enddo

procedure loadfil						&& Load the file selected from popup
	fn = prompt()
	use &fn
	set color to gr+/bg
	@ 16,51 clear to 16,74				&& Clear status area in case filename is shorter than an earlier one
	@ 16,51 say fn
	set color to w+/w,b/w	
return

procedure loadcol						&& The crosstab column is specified here
	col = prompt()
	set color to gr+/bg
	@ 17,51 clear to 17,74
	@ 17,51 say col
	set color to w+/w,b/w
return

procedure loadrow						&& The crosstab row is specified here
	row = prompt()
	set color to gr+/bg
	@ 18,51 clear to 18,74
	@ 18,51 say row
	set color to w+/w,b/w
return

procedure loadcal						&& The calculated field is specified here
	cal = prompt()
	set color to gr+/bg
	@ 19,51 clear to 19,74
	@ 19,51 say cal
	set color to w+/w,b/w
return

procedure loadope						&& The operator we will use on the calculated field is specified here
	ope = prompt()
	set color to gr+/bg
	@ 20,51 clear to 20,74
	@ 20,51 say ope
	set color to w+/w,b/w
return								

procedure actmenu						&& Do it menu
	pbar = bar()
	do case
		case pbar = 1
			do xtact					&& Go make the calculations (xtact procedure)					
		case pbar = 2
			use crosstab				&& Load the created crosstab.dbf file and view it
			browse						&& No fancy browse here... 
			use &fn						&& Use original file again
		case pbar = 3
			use crosstab
			index on -summary to ki		&& Real fast sort in descending order
			browse
			use &fn
	endcase
return

procedure chow							&& Au Revoir
	cancel
return

procedure xtact
	use &fn
	copy structure extended to xts		&& Let's get the structure in case a numeric field is chosen for the rows
	use xts
	replace all field_type with "C" for field_name = col .or. field_name = row		&& Change row/column numeric fields to character
	locate for field_name = row
	store field_len to flr						&& Need to make the width of the row labels wide enough
	locate for field_name = cal
	if upper(ope)="SUM"
		store field_len + 2 to flc				&& A summary record of fields (added together) may not have enough width... let's make it wider
	else	
		store field_len to flc
	endif
	store field_dec to fd						&& Let's be consistent with decimal places of the calc'd field
	create fn1 from xts							&& Don't want to overwrite the original file
	append from &fn

	use fn1
	set fields to &col							&& Get a listing of just the unique fields for the columns
	set unique on
	index on &col to ki
	copy to kt									&& Copy unique fields for the columns to a .dbf
	set unique off
	use kt
	go bottom									&& How many unique fields are there?
	declare fh(recno()+1,1)						&& Make array this big, with an extra space for the summary
	store recno()+1 to nf						&& This is the array location for the summary field
	go top
	copy to array fh							&& Copy the unique column fields to the array
	store "SUMMARY" to fh(nf,1)					&& summary goes to the array too
	copy structure extended to xts				&& Get structure of unique field columns
	use xts										&& Edit the structure
	append from array fh						&& Add the column information to the structure
	go top										&& Edit the first structure field
	replace field_name with cal					&& Let's have the name of the calc'd field in the upper left-hand corner
	replace field_type with "C"					&& Make sure column one is character (because we have a summary record)
	replace field_len with flr							&& Make it wide enough
	replace all field_type with "N" for recno() > 1		&& For all other columns - numeric
	replace all field_len with flc for recno() > 1		&& Make the numeric columns wide enough
	replace all field_dec with fd						&& And the decimal points need to be consistent
	create crosstab from xts					&& Create the empty crosstab file with the appropriate column fields

	use fn1
	set fields to &row							&& Let's get the unique row records
	set unique on
	index on &row to ki
	copy to kt
	set unique off
	use kt
	go bottom									&& How many row records will there be?
	declare rh(recno()+1,nf+1)					&& Create an array large enough
	store recno()+1 to nr						&& And don't forget to make room for a summary record
	go top
	copy to array rh
	store "SUMMARY" to rh(nr,1)					&& Store the summary record to the last array space

	use fn1
	store 1 to x								&& X for horizontal or columns
	store 1 to y								&& Y for vertical or rows
	store 1 to totmade							&& Initialize number of calculations made
	store nr * nf to totcalc					&& Total calculations = number of rows x number of columns
	activate window cm							&& Activate the calculation progress window
	@ 0,0 say "Total calculations to make:"
	@ 1,0 say "Total calculations made:   "
	do while x <= nr											&& Calculate the columns for each row first
	    do while y <= nf
    		@ 0,27 say totcalc picture "#,###" color gr+/bg		&& Provide calculation progress first
        	@ 1,27 say totmade picture "#,###" color gr+/bg
        	if ope <> "COUNT"									&& If count is not the operator than make calcs this way
		        do case
				    case fh(y,1) = "SUMMARY" .and. rh(x,1) <> "SUMMARY"		&& Summary calculations need to be handled differently
    			    	&ope &cal for &row = rh(x,1) to rh(x,y+1)
        			case rh(x,1) = "SUMMARY" .and. fh(y,1) <> "SUMMARY"
        				&ope &cal for &col = fh(y,1) to rh(x,y+1)	
			    	case fh(y,1) = "SUMMARY" .and. rh(x,1) = "SUMMARY"
			 			&ope &cal to rh(x,y+1)
	    			case fh(y,1) <> "SUMMARY" .or. rh(x,1) <> "SUMMARY"						&& This is where much of the calculations are made
	        			&ope &cal for &row = rh(x,1) .and. &col = fh(y,1) to rh(x,y+1)
				endcase
			else
		        do case														&& Count calculations have a different syntax
				    case fh(y,1) = "SUMMARY" .and. rh(x,1) <> "SUMMARY"
    			    	&ope for &row = rh(x,1) to rh(x,y+1)
        			case rh(x,1) = "SUMMARY" .and. fh(y,1) <> "SUMMARY"
        				&ope for &col = fh(y,1) to rh(x,y+1)	
			    	case fh(y,1) = "SUMMARY" .and. rh(x,1) = "SUMMARY"
			 			store reccount() to rh(x,y+1)
	    			case fh(y,1) <> "SUMMARY" .or. rh(x,1) <> "SUMMARY"
	        			&ope for &row = rh(x,1) .and. &col = fh(y,1) to rh(x,y+1)
				endcase
			endif
    	    y = y + 1
        	totmade = totmade + 1				&& Update the progress
	    enddo
    	y = 1
	    x = x + 1
	enddo
	deactivate window cm
	
	use crosstab								&& Fill the crosstab file with the values placed in the arrays above
	append from array rh
	erase kt.dbf								&& Clean up tmp files so they won't be selected
	erase xts.dbf
	erase fn1.dbf
return
