* Program Name: xnet1.prg *
* Created: 11/5 at 7:26 *

* Send User Defined String To Port *
* Command Syntax: DO push_ WITH <string>
proc push
  parameters param_
  call sport with "W"+param_+chr(13)+chr(10)
return

* Initialize COM: Port, Baud Rate
* Command Syntax: DO init_ WITH <commport>,<baud rate>
proc init                                  && procedure to initialize
  parameters cp_,br_
  call orig_0 with "08"+cp_                && select the communications port
  do case
    case br_="300"
      br_="1"
    case br_="1200"
      br_="2"
    case br_="2400"
      br_="3"
  endcase
  call orig_0 with "05"+br_                && select the baud rate
return

* Auto Dial Modem
* Command Syntax: DO dial_ WITH <dial prefix>,<tel number>
proc dial                                   && auto dialer
  parameters dprefix_,tn_
  call sport with "W"+dprefix_+tn_+chr(13)+chr(10)
return

* Enter Termial Mode For Communications
* Command Syntax: DO term_ WITH <duplex>
proc term                                  && procedure for terminal mode
  parameters fhd_
  clear
  statline_='dTERM Telecommunications        (C) 1986 CM Robbins Company/Global Technologies'
  call orig_0 with "122"+statline_+chr(00)
  @ 00,00 say ""
  call orig_0 with "06"+upper(substr(fhd_,1,1))+"dTERM Terminal Mode - Press ESCape to exit..."+chr(13)+chr(10)+chr(00)
return

* Select COM: Port
* Command Syntax: DO port_ WITH <commport>
proc port                                  && procedure for commport
  parameters cp_
  call orig_0 with "08"+cp_
return

* Select BAUD Rate
* Command Syntax: DO baud_ WITH <baud rate>
proc baud                                  && procedure for baud setting
  parameters br_
  do case
    case br_="300"
      br_="1"
    case br_="1200"
      br_="2"
    case br_="2400"
      br_="3"
  endcase
  call orig_0 with "05"+br_
return

* Change Logged Disk Drive
* Command Syntax: DO chdr_ WITH <new drive\directory>
proc chdr                                  && procedure for log to drive
  parameters dr_
  call orig_0 with "03 "+trim(dr_)+chr(00)
return


