*-------------------------------------------------------------------------
* xms_err.prg -- FORCE FAQ XMS error handler
*-------------------------------------------------------------------------
#include xms.hdr
#include undoc.hdr
#include common.hdr
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header: C:\TECH\FAQ\XMS\RCS\xms_err.prg 0.10 1992/05/23 04:24:17 holmesda Exp holmesda $"
   UINT                 xms_errno = &NULL
ENDDEF
*-------------------------------------------------------------------------
* function: xms_set_error()
*
* description: xms_set_error() examines the register values AX and BX,
*    and sets the error code if AX = 0 and the high bit of BL is set.
*-------------------------------------------------------------------------
PROCEDURE xms_set_error
   PARAMETERS VALUE UINT ax, VALUE UINT bx

   if ax = 0
      if and( bx, 0x80 ) = 0x80          && Is the high bit set?
         xms_errno = lobytew( bx )       && grab the low byte value
      else
         xms_errno = 0
      endif
   else
      xms_errno = 0
   endif

ENDPRO
*-------------------------------------------------------------------------
* function: xms_get_error()
*
* description: This function simply returns the value in xms_errno.
*-------------------------------------------------------------------------
FUNCTION UINT xms_get_error

   return xms_errno

ENDPRO
*-- EOF: xms_err.prg -----------------------------------------------------
