*-------------------------------------------------------------------------
* getscr.prg -- FORCE FAQ sample code for the XMS library.
*-------------------------------------------------------------------------
#include fileio.hdr
*-------------------------------------------------------------------------
VARDEF PRIVATE
   CHAR                 RCSid = "$Header:$"
ENDDEF
*-------------------------------------------------------------------------
* function: get_screen()
*
* description: This functions simply reads a file into a dynamically
*    allocated buffer.  It is in its own module because there may be
*    times when you'd want to send an address as the buffer.  Notice
*    that the function declaration does not match the prototype in
*    show.prg.  Thus you could read from a file directly to video
*    memory, simply with a call like:
*
*        get_screen( "help.scr", 0xb8000000, 4000 )
*-------------------------------------------------------------------------
PROCEDURE get_screen
   PARAMETERS CONST CHAR filename, BYTE buffer, VALUE UINT screen_size

   VARDEF
      UINT               f_handle
   ENDDEF

   if .not. fb_open( f_handle, filename, &B_READ )
      ? "Cannot open " + filename
      quit
   endif

   if  fb_read( f_handle, buffer, screen_size ) <> screen_size
      ? "read failed!"
      quit
   endif

   fb_close( f_handle )

ENDPRO
*-- EOF: -----------------------------------------------------------------
