(* xdbase3.inc - Turbo Pascal Definitions for DB3 Records *)

(*  xdbfhdr3.inc = definitions for dbase3 headers and fld defs *)

const

xmaxflds = 128;  (* Maximum number of DB3 Fields in a DBF *)
xdbhsize = 32;   (* Size of DBF Header before Field Definitions *)

type

xflddef3 = array [1..32] of byte;

xflddef = record
     (* Layout of DB3 Field Descriptor Entry *)
             fldname: array [1..11] of char;
             fldtype: char;
             fldlocn: integer; (* excess 7 or 15 x'0f' from recrd start *)
                               (* whatever is displacement of 1st field *)
                               (* Delete Flag field - 1 byte must be    *)
                               (* assumed as 1st true field in Record   *)
             fldgarb: integer; (* reserved - loaded with garbage *)
             fldsize: byte;
             flddec:  byte;
             fldrsv2: array [1..14] of byte;
           end;

xdbfhdr = record
            dbvers:    byte; (* Dbase Version Number, 2 or 3 *)
             (* True Hex values for last yy/mm/dd of change *)
            chgyy:     byte;
            chgmm:     byte;
            chgdd:     byte;

            numrecs:  integer; (* Number of records in DBF *)
            numrecsh: integer; (* high order bytes of 32 bit integer *)
            frstrcd:  integer; (* 0-rel byte locn of 1st record in file *)
                               (* It will point at start of Record's delete *)
                               (* Flag *)
            rcdlgth:  integer; (* Record Length of fixed length DBF Records *)
            resrvd0:  integer;
            resrvd1:  integer;
            resrvd2:  array [1..16] of byte;
            flddef:   xflddef;    (* first field definition *)
            (* 1 32 byte entry for each defined field *)
            (* Last field entry starts with all x'00' *)
            (* 1st DBF Record follows *)
          end;

(* If blockio is used, then physical blocksize is irrelevant to record
   location in file; records are written with no slack space between.
   A ^Z (x'1a') follows the last record. Recommend minimum block of 1024
   bytes  - should otherwise be multiple of 128, programmer can choose *)
(* End of xdbfhdr3 definition *)

(* xndxhdr3.inc - DB3 Index Header and Record Definitions *)

(* DBASE 3 Index File Header - Anchor Block *)

(* observe xxxxh variable names - dB3 is either using or is planning to
   use 32 bit integers *)                                                -

(* All dB3 Index Blocks are 512 bytes *)

type
  xndxhdr  = record
               frstblk:    integer;    (* 1st Index Block/Node - 0 rel *)
               frstbklkh:  integer;    (* filler / may contain junk *)
               nxtalloc:   integer;    (* block number of next to allocate *)
                                       (* 0-rel to start of file *)
               nxtalloch:  integer;    (* filler / may contain junk *)
               fillerxx:   array [1..2] of integer;  (* usually 0's *)
               keylgth:    byte;       (* length of key part of Index/Node *)
               ntrylgth:   byte;   (* dB3 - does not set, dB2 does *)
                                   (* actual value is keylgth + 8 in DB3  *)
               maxents:    integer; (* Maximum number of entries dB3 will *)
                                    (* create in a Node during Update/Create *)
             (* Remaining area includes the
                                   "Index on" Descriptor and garbage *)
             (* Total blocksize is 512 bytes *)
            end;

  xndxrcd  = record
             (* Description applies to both Index Node Entries and to Index *)
             (*  records *)
               DnNode:     integer; (* Next Node "down" - 0 rel file block *)
                                    (*  0 --> real index rcrd *)
               DnNodeH:    integer; (* May be filler or hi-order 16 bits *)
               rcdno:      integer; (* dB3 corresponding DBF Record No.  *)
                                    (* will be 0 if this is Node entry   *)
               rcdnoh:     integer; (* high order 16 bits - 32 bit integer *)
               rcdKey:     array [1..100] of char; (* reserve max allowable *)
                                                   (* key size *)
(* Beware of pure numberic keys: dB3 converts all to 64 bit reals with *)
(* 12 bit exponents and "normalized" 48 bit mantissas *)
(* dB2 creates 32 bit BCD reals *)
(* Both systems do this even when no positions to right of decimal point *)
(* are specified in the database field definition *)
(* None are directly compatible with Turbo, Turbo 8087 or Turbo BCD reals *)

            end;

  xndxblk =   record
     (* Describes Node and Index Record Block  *)
                numents:   byte; (* will contain true number of entries *)
                                 (* in the 512 byte block, if DnNode,   *)
                                 (* is non-zero;                        *)
                                 (* Otherwise it is one less than true  *)
                                 (* number of entries; furthermore, if  *)
                                 (* DnNode of 1st Block Entry is non-zero*)
                                 (* then all entries have non-zero       *)
                                 (* DnNode values, and vice versa *)
                fillerh:   array [1..3]   of byte; (* can include junk *)
                DnNode:    integer; (* DnNode of 1st Block Entry *)
                blkdata:   array [0..505] of byte;
             end;


            end;

  xndxrcd  = record
             (* Description applies to both Index Nod