* WR_FUNCS.PRG   UDF's FOR WR.PRG
*
*
* FLD_NULL()   RETURN T/F BASED ON PRESENCE OF DATA IN FIELD
*
* INPUT: A VARIABLE CONTAINING THE NAME OF A FIELD OR VARIABLE
* OUTPUT: .T. IF FIELD IS 0 (NUM), BLANKS (CHAR), "  /  /  " (DATE)
*         OR .F. (LOGICAL); else RETURN .F. (VALUE PRESENT)
*
function FLD_NULL
parameters mFIELD, mTYPE
private mNULL
mNULL = .F.
do case
   case mTYPE = "N"
      if &mFIELD = 0
         mNULL = .T.
      endif
   case mTYPE = "C"
      if "" = trim(&mFIELD)
         mNULL = .T.
      endif
   case mTYPE = "D"
      if &mFIELD = ctod("  /  /  ")
         mNULL = .T.
      endif
   case mTYPE = "L"
      if &mFIELD = .F.
         mNULL = .T.
      endif
endcase
return (mNULL)
*
* ERROR()  DISPLAY ERROR INFO ON SCREEN AND RETURN TO DOS
*
* INPUT:  VARIABLE 1: NUMERIC, WHICH ERROR DETECTED
*         VARIABLE 2: CHARACTER, THE OFFENDING LINE, VARIABLE, ETC
*
* OUTPUT: NONE - AFTER DISPLAYING ERROR MESSAGES, ISSUES CANCEL
*
function ERROR
parameters ERROR_NBR, LINE
do case
   case ERROR_NBR = 1
      ? "CRITERIA SPECIFICATION FILE "+LINE+" NOT FOUND"
   case ERROR_NBR = 2
      ? "NO WEIGHTED RETRIEVAL OUTPUT FILE SPECIFIED"
   case ERROR_NBR = 3
      ? "OUTPUT FILE MUST BE '.DBF'"
   otherwise
      ? "ERROR NEAR LINE "+ltrim(str(recno()))
endcase
*
do case
   case ERROR_NBR = 4
      ? "UNRECOGNIZED: "+LINE
   case ERROR_NBR = 5
      ? "FIRST KEYWORD MUST BE 'DATA_FILE=' + source database name"
   case ERROR_NBR = 6
      ? "EACH FIELD CRITERIA SET MUST BEGIN WITH 'DBF_FIELD='"
   case ERROR_NBR = 7
      ? "MEMO FIELDS NOT VALID FOR WEIGHTED RETRIEVAL"
   case ERROR_NBR = 8
      ? ""
   case ERROR_NBR = 9
      ? "GOAL_VALU= INVALID WITH FIELDTYPEs 'N' OR 'D'"
   case ERROR_NBR = 10
      ? "RANGE_MIN=,RANGE_MAX= INVALID WITH FIELDTYPEs 'C' OR 'L'"
   case ERROR_NBR = 11
      ? "CAN'T COPY DATABASE ONTO ITSELF; SPECIFY DIFFERENT OUTPUT FILE"
   case ERROR_NBR = 12
      ? "CAN'T FIND INPUT DATABASE: "+LINE
   case ERROR_NBR = 13
      ? "SPECIFY EITHER GOAL_VALU= or RANGE_MIN= & RANGE_MAX= FOR: "+;
        LINE
   case ERROR_NBR = 14
      ? "SPECIFY MATCH_VAL= and/or NOMCH_VAL= FOR: "+LINE
   case ERROR_NBR = 15
      ? "DATABASE FIELD UNDEFINED: "+LINE
endcase
? "RETRIEVAL CANCELLED DUE TO ERROR"
?
cancel
return (.T.)
