FUNCTION WinYN
*-------------------------------------------------------------------------------
*-- Programmer..: PC Magazine
*-- Date........: 08/09/1991
*-- Notes.......: This was supposedly gotten from PC Magazine by someone,
*--               and entered into their machine. (Uploaded to AT-BBS). 
*--               I don't know if they tested it. I made some minor changes, 
*--               since I couldn't get it to work. It's purpose is to popup a 
*--               window with two options for the user, returning a value ... 
*--               it's not well designed, as it uses default color values and 
*--               such. It appears to me that while it works, the folk at PC 
*--               Rag could have spent just a bit more time on it ...
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 08/09/1991 -- modified to make the parameters function
*--                             properly, to make it a bit more efficient,
*--                             and for dUFLP standards -- Ken Mayer
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: WinYN("<cMess>","<cChoice1>","<cChoice2>",<nTop>,<nLeft>,;
*--                     "<cTitle>")
*-- Example.....: if WinYn("Choose:","Yes","No",10,12,"Is this ok?") = "Yes"
*--                  do SOMETHING
*--               endif
*-- Returns.....: cChoice1 or cChoice2
*-- Parameters..: cMess    = Message next to the two choices (may be left
*--                             as a nul (""), in which case you get a
*--                             default message)
*--               cChoice1 = first of two choices (may be left nul, in which
*--                             case the first choice is "Yes")
*--               cChoice2 = second of two choices (may be left nul, in which
*--                             case the second choice is "No")
*--               nTop     = upper row of window -- may be sent as 0 or 99 to
*--                             get default row (11)
*--               nLeft    = left column of window -- no default.
*--               cTitle   = Displayed in row 0 of window -- if nul, there
*--                             will be nothing displayed in that row.
*--------------------------------------------------------------------------

parameters cMess,cChoice1,cChoice2,nTop,nLeft,cTitle

cTalk = set("TALK")   && save this, so we can restore to original setting
set talk off

if cMess = ""                         && set default if needed.
	cMess = "Please Choose:"
endif

if cChoice1 = "" .and. cChoice2 = ""  && set defaults if needed.
	cChoice1 = "Yes"
	cChoice2 = "No"
endif

*-- pad choices and message with spaces
cChoice1 = " &cChoice1 "
cChoice2 = " &cChoice2 "
cMess = " &cMess "

*-- set width of window
nWinWidth = len(cMess)+len(cChoice1)+len(cChoice2)+5

*-- what if the width of the window is less than the width of
*-- the TITLE? If that's the case, let's reset the width to the
*-- width of the title (+2 spaces ... one on each side)
if nWinWidth < len(cTitle)+2 
	nWinWidth = len(cTitle)+2
endif

*-- set top to default if necessary
if nTop = 99 .or. nTop <= 0
	nTop = 11
endif

*-- make window five lines high ...
nBottom = nTop + 5

*-- set right side of window ... (left column + window width ...)
nRight = nLeft + nWinWidth

*-- define and activate window
define window wWinNY from nTop,nLeft to nBottom,nRight panel
activate window wWinNY

*-- define menu with two pads
define menu mMen
define pad pMen1 of mMen prompt cChoice1 at 2,len(cMess)+1
define pad pMen2 of mMen prompt cChoice2 at 2,len(cMess)+len(cChoice1)+1
on selection pad pMen1 of mMen deactivate menu
on selection pad pMen2 of mMen deactivate menu

*-- if the title has anything in it, display it at row 0 (centering it)
if cTitle <> " "
	@0,(nWinWidth-len(cTitle))/2 say cTitle
endif

*-- display the message
@ 2,0 say cMess

*-- activate menu ...
activate menu mMen

*-- Once a choice is made, deactivate the window ...
deactivate window wWinNY

*-- reset Talk to it's previous status ...
set talk &cTalk 

*-- return the trimmed value of the PROMPT (this is MUCH easier than was
*-- previously designed, with a check to see which bar() was chosen, and
*-- then trimming the CHOICE options, and all that ...)
RETURN ltrim(trim(prompt()))

*-- EoF: WinYN()
                                                                                                                 