*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\LIBRARY\CURWPRIN.PRG
*:         System: Utilities Library
*:         Author: Stephen A. Sawyer
*:      Copyright (c) April, 1993, KarCal Company, Inc
*:  Last modified: 04/15/93 at 16:20:15
*:
*:         Set by: DEMOWINP.SPR                      
*:
*:      Documented 17:36:14                                FoxDoc version 3.00a
*:*****************************************************************************
******************************************************
* This function returns the current default printer as determined by the PRNARRAY.PRG procedure
* The information provided is only as current as the information in the public memvars created
* by PRNARRAY.
* The parameters passed to this function determine whether the value returned is of type character or
* type numeric ("N" or "C" pcType), and whether information on the selected printer or port is returned.
* the numeric values are useful in saving the current printer so it can be reset later using the
* SETWPRIN procedure
*****************************************************
PARAMETERS pcReport,pcType
IF PARAMETERS()=0
	WAIT 'Requires parameters "PORT" or "PRINTER"  and character type' WINDOW
	RETURN
ELSE
	IF  ! (pcReport="PORT" OR pcReport="PRINTER") OR ! (pcType="N" OR pcType="C")
		WAIT "Improper parameters passed to CURWIN.PRG" WINDOW
	ENDIF ( ! (pcReport="PORT" OR pcReport="PRINTER") OR ! (pcType="N" OR pcType="C") )
ENDIF ( PARAMETERS()=0 )
IF TYPE("gaWprns[1]")="U"
	WAIT "PRNARRAY must be run before the CURWPRIN function will work" WINDOW
	RETURN
ENDIF ( TYPE("gaWprns[1]")="U" )
PRIVATE lcOldPort,lcOldPrn,lnElement,lnOldPort,lnOldPrn,RetVal

lcOldPrn=LEFT(gcDefWprn,AT(",",gcDefWprn)-1)
lnElement=ASCAN(gaWprns,lcOldPrn)
lnOldPrn=ASUBSCRIPT(gaWprns,lnElement,1)
lcOldPort=SUBSTR(gcDefWprn,RAT(",",gcDefWprn)+1)
FOR i=4 TO 9
	IF gaWprns[lnOldPrn,i]=lcOldPort
		lnOldPort=i-3
		EXIT
	ENDIF ( gaWprns[lnOldPrn,i]=lcOldPort )
ENDFOR ( i )
DO CASE
	CASE pcReport="PORT" AND pcType="N"
		RetVal=lnOldPort
	CASE pcReport="PRINTER" AND pcType="N"
		RetVal=lnOldPrn
	CASE pcReport="PORT" AND pcType="C"
		RetVal=lcOldPort
	CASE pcReport="PRINTER" AND pcType="C"
		RetVal=lcOldPrn
ENDCASE
RETURN RetVal
*: EOF: CURWPRIN.PRG
