*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\LIBRARY\SETWPRIN.PRG
*:         System: Utilities Library
*:         Author: Stephen A. Sawyer
*:      Copyright (c) April, 1993, KarCal Company, Inc
*:  Last modified: 04/15/93 at 16:13:20
*:
*:  Procs & Fncts: PUTPRINT
*:               : PUTPROSTRG()
*:               : GETPORT()
*:
*:         Set by: _QF011HUUF()       (function  in DEMOWINP.SPR)
*:
*:          Calls: PUTPRINT           (procedure in SETWPRIN.PRG)
*:
*:      Documented 17:36:15                                FoxDoc version 3.00a
*:*****************************************************************************
*******************************************************************
* Sets the default printer under FoxPro for Windows.  Requires that
* PRNARRAY be run first, as this array is used by this procedure
* to both determine the existence of the requested printer, the
* requested port, and is passed to the PUTPRINTfunction.
* note that the parameter pcPrinter must match the installed printer
* exactly in order for this procedure to work.  It is recommended that
* if you are including an interactive routine to select printers, that the user
* be presented with picklists or popups built from  the gaWprns array which
* is created by PRNARRAY.PRG   This also allows the developer the opportunity
* to restrict the list of printers available to the user.  For instance, if the user
* is running FP DOS reports, they can be presented with only those printers using the
* Generic/Text Only printer driver.
*
* The included PUTPRINT procedure, PUTPROSTRG and GETPORT functions
* make calles to FOXTOOLS.FLL and are provided courtesy of
* Louise Simmons [MSF T] CIS I.D. 71726,2652
PARAMETERS pcPrinter,pcPort
EXTERNAL ARRAY gaWprns
EXTERNAL ARRAY DEVICE
IF PARAMETERS() < 2
	WAIT "Two parameters required for SETWPRIN" WINDOW
	RETURN
ELSE
	IF TYPE("pcPrinter") # "C" OR TYPE("pcPort") # "C"
		WAIT "Parameters must be of type CHARACTER" WINDOW
		RETURN
	ELSE
		IF RIGHT(pcPort,1) # ":"
			pcPort=pcPort + ":"
		ENDIF ( RIGHT(pcPort,1) # ":" )
	ENDIF ( TYPE("pcPrinter") # "C" OR TYPE("pcPort") # "C" )
ENDIF ( PARAMETERS() < 2 )
IF TYPE("gaWprns[1]")="U"
	WAIT "Run PRNARRAY before using SETWPRIN" WINDOW
	RETURN
ENDIF ( TYPE("gaWprns[1]")="U" )
PRIVATE lcPort,lcPrinter,lnElement,lnPort,lnPrinter,lnSelPort,lnSelPrn,lnWprns
lnElement=ASCAN(gaWprns,pcPrinter)
lnWprns=ALEN(gaWprns,1)
IF lnElement=0
	WAIT "Printer requested not found" WINDOW
	RETURN
ENDIF ( lnElement=0 )
lnSelPrn=ASUBSCRIPT(gaWprns,lnElement,1)
FOR i=4 TO 9
	IF TYPE("gaWprns[lnSelPrn,i]")="L"
		WAIT "Requested port not available for this printer" WINDOW
		RETURN
	ENDIF ( TYPE("gaWprns[lnSelPrn,i]")="L" )
	IF gaWprns(lnSelPrn,i)=pcPort
		lnSelPort=i-3
		EXIT
	ENDIF ( gaWprns(lnSelPrn,i)=pcPort )
ENDFOR ( i )
DO putprint WITH gaWprns,lnWPrns,lnSelPrn,lnSelPort


*!*****************************************************************************
*!
*!      Procedure: PUTPRINT
*!
*!      Called by: SETWPRIN.PRG                      
*!
*!          Calls: GETPORT()          (function  in SETWPRIN.PRG)
*!               : PUTPROSTRG()       (function  in SETWPRIN.PRG)
*!
*!*****************************************************************************
PROCEDURE putprint
	PARAMETER DEVICE, NUMBER, dflt, portnum
	* Take the printer device information in the device array and update WIN.INI
	* with it.
	
	* "Number" is the total number of printers listed in "device."
	* "dflt" is the string to write to the [windows] device= statement to set the
	* default printer, or if dflt is a number, the array row to construct this
	* statement from.  Thus, if you wanted to make the default printer the
	* third one listed in "device," you could either pass a 3 as dflt or you could
	*pass the actual string (something like: HP LaserJets(Level 5),HPPCL5MS,LPT1:)
	* If you pass the string, it must exactly match an entry in the
	* [devices] section of your WIN.INI file.
	*
	* You'll probably want to use GETPRINT to construct the device array.
	*
	IF FILE(SYS(2004)+"FOXTOOLS.FLL")
		SET LIBRARY TO (SYS(2004)+"foxtools.fll") ADDITIVE
	ELSE
		WAIT WINDOW "PUTPRINT requires the FoxTools library."
		RETURN
	ENDIF ( FILE(SYS(2004)+"FOXTOOLS.FLL") )
	
	IF TYPE("dflt") = "N"
		IF PARAMETERS() < 4
			portnum = 1
		ENDIF ( PARAMETERS() < 4 )
		m.strg = DEVICE[m.dflt,1]+","+getport(DEVICE[m.dflt,2],portnum)
	ELSE
		m.strg = m.dflt
	ENDIF ( TYPE("dflt") = "N" )
	
	* Set the default printer
	=putprostrg("windows","device",m.strg)
	
	* Delete all existing device and PrinterPort entries.
	=putprostrg("devices",0,CHR(0))
	=putprostrg("PrinterPort",0,CHR(0))
	
	FOR m.i = 1 TO NUMBER
		=putprostrg("devices",DEVICE[m.i,1],DEVICE[m.i,2])
		=putprostrg("PrinterPorts",DEVICE[m.i,1],DEVICE[m.i,3])
	ENDFOR ( m.i )
	RETURN
	
*!*****************************************************************************
*!
*!       Function: PUTPROSTRG
*!
*!      Called by: PUTPRINT           (procedure in SETWPRIN.PRG)
*!
*!          Calls: REGFN()            (function  in ?)
*!               : CALLFN()           (function  in ?)
*!
*!*****************************************************************************
FUNCTION putprostrg
	PARAMETER SECTION, entry, string
	fn = regfn("WRITEPROFILESTRING","CCC","I")
	RETURN callfn(fn,SECTION,entry,string)
	
*!*****************************************************************************
*!
*!       Function: GETPORT
*!
*!      Called by: PUTPRINT           (procedure in SETWPRIN.PRG)
*!
*!*****************************************************************************
FUNCTION getport
	PARAMETER m.pstrg, m.pnum
	* Get the first "port" from a printer string
	
	* First get the printer driver name (e.g., pscript) and the comma
	m.retstrg = SUBSTR(m.pstrg,1,AT(',',m.pstrg))
	
	* Now get the port designation (e.g., LPT1: or FILE:)
	
	* Check if the port passed is greater than the ports avail.
	IF OCCURS(',',m.pstrg) >= m.pnum
		m.portstrg = SUBSTR(m.pstrg,AT(',',m.pstrg,m.pnum)+1)
	ELSE
		m.portstrg = SUBSTR(m.pstrg,AT(',',m.pstrg,1)+1)
	ENDIF ( OCCURS(',',m.pstrg) >= m.pnum )
	
	IF AT(',',m.portstrg) > 0
		m.portstrg = LEFT(m.portstrg,AT(',',m.portstrg)-1)
	ENDIF ( AT(',',m.portstrg) > 0 )
	
	RETURN m.retstrg + m.portstrg
	
	
*: EOF: SETWPRIN.PRG

