*:*****************************************************************************
*:
*: Procedure file: C:\FOXPRO\PROJECT\LIBRARY\PRNARRAY.PRG
*:         System: Utilities Library
*:         Author: Stephen A. Sawyer
*:      Copyright (c) April, 1993, KarCal Company, Inc
*:  Last modified: 04/15/93 at 15:41:07
*:
*:  Procs & Fncts: GETPRINT
*:               : GETPROSTRG()
*:
*:         Set by: DEMOWINP.SPR                      
*:
*:          Calls: GETPRINT           (procedure in PRNARRAY.PRG)
*:
*:      Documented 17:36:13                                FoxDoc version 3.00a
*:*****************************************************************************
*****************************************************************************
* Creates 2 public memvars, an array (gaWprns), and a character
* type memvar  (gcDefWPrn).  Tha array gaWprns has the following
* structure:
* Col 1:   Printer name
* Col 2:   Parameter for [device] section
* Col 3:   Parameter for [PrinterPort] section
* (includes timeout parameters)
* Cols 4-9 List of ports available for each installed printer
*******************
* this procedure MUST be called before the CURWPRIN
* function which can return specifics about the current printer,
* and must be re-run AFTER re-setting the default printer
* if it is necessary to keep these memvars current.
*
* The included procedure GETPRINT and function GETPROSTRG were provided courtesy of
* Louise Simmons [MSF T] CIS I.D. 71726,2652.  Modification was made to the GETPRINT
* procedure to increase the size of the "device" array to 9 columns
*******************************************************************************
PRIVATE lcOldTalk,LcPortList,lnPortNo,Number

lcOldTalk=SET("TALK")
SET TALK OFF
RELEASE gaWprns
PUBLIC gaWprns[1]
PUBLIC gcDefWPrn
gnWPrns=0
gcDefWPrn=""
DO getprint WITH gaWprns,gnWPrns,gcDefWPrn
FOR i=1 TO ALEN(gaWPrns,1)
	lcPortlist=gaWPrns[i,2]
	lcPortlist=STUFF(lcPortList,1,AT(",",lcPortList),"")
	lnPortNo=0
	DO WHILE LEN(lcPortList) > 0
		lnPortNo=lnPortNo+1
		IF lcPortList="None"
			gaWPrns[i,lnPortNo+3]=lcPortList
		ELSE		
			gaWPrns[i,lnPortNo+3]=LEFT(lcPortList,AT(":",lcPortList))
		ENDIF
		lcPortList=STUFF(lcPortList,1,AT(":",lcPortList),"")
		IF LEFT(lcPortList,1)=","
			lcPortList=STUFF(lcPortList,1,1,"")
		ENDIF ( LEFT(lcPortList,1)="," )
		IF lcPortList = "None"
			lcPortList=""
		ENDIF
	ENDDO ( LEN(lcPortList) > 0 )
ENDFOR ( i )

*!*****************************************************************************
*!
*!      Procedure: GETPRINT
*!
*!      Called by: PRNARRAY.PRG                      
*!
*!          Calls: GETPROSTRG()       (function  in PRNARRAY.PRG)
*!
*!*****************************************************************************
PROCEDURE getprint
	* Query WIN.INI to get data on the installed and default printers.
	
	PARAMETER DEVICE, NUMBER, dfltprnt
	* Usage:
	*    DIMENSION device[1]
	*    numprinters = 0
	*    defaultprnt = ""
	*    DO GETPRINT WITH device, numprinters, defaultprnt
	*
	* The "device" array will be populated with the names
	* and parameters for all installed print devices.
	*
	* The "device" array has this structure:
	* Col 1:   Printer name
	* Col 2:   Parameter for [device] section
	* Col 3:   Parameter for [PrinterPort] section
	* (includes timeout parameters)
	*
	* The contents of "device" might look like this after you call getprint:
	*   Col 1                            Col 2                 Col 3
	*   -----------------------   -------------   ---------------------
	*   Apple LaserWriter II NTX         pscript,LPT2:         pscript,LPT2:,15,90
	*   Generic / Text Only=TTY          fred.prn              fred.prn,15,45
	*   HP LaserJet IIISi                hppcl5a,LPT1:         hppcl5a,LPT1:,15,45
	*   HP LaserJet IIISi PostScript     pscript,LPT2:         pscript,LPT2:,15,90
	*   HP LaserJets(Level 5)            HPPCL5MS,LPT1:        HPPCL5MS,LPT1:,15,45
	*
	* "numprinters" in this case would be 5
	* "defaultprnt" might be this:
	*    HP LaserJet IIISi PostScript,pscript,LPT2:
	
	
	#DEFINE buflen 2048
	PRIVATE m.in_talk, m.dcount, m.retbuf, m.bytes, m.thisdevice
	
	IF PARAMETERS() < 3
		WAIT WINDOW "This procedure requires 3 parameters"
		RETURN
	ENDIF ( PARAMETERS() < 3 )
	
	IF FILE(SYS(2004)+"FOXTOOLS.FLL")
		SET LIBRARY TO (SYS(2004)+"foxtools.fll") ADDITIVE
	ELSE
		WAIT WINDOW "GETPRINT requires the FoxTools library."
		RETURN
	ENDIF ( FILE(SYS(2004)+"FOXTOOLS.FLL") )
	
	* Fill in the first column of the array with installed device names
	m.retbuf = REPLICATE(CHR(0),buflen)
	m.bytes = getprostrg("devices",0,CHR(0),@m.retbuf,buflen)
	m.dcount = 0
	m.retbuf = LEFT(m.retbuf,m.bytes)
	DO WHILE CHR(0) $ m.retbuf
		m.thisdevice = LEFT(m.retbuf,AT(CHR(0),m.retbuf)-1)
		IF LEFT(m.thisdevice,1) <> CHR(0)
			m.dcount = m.dcount + 1
			DIMENSION DEVICE[m.dcount,9]
			DEVICE[m.dcount,1] = m.thisdevice
		ENDIF ( LEFT(m.thisdevice,1) <> CHR(0) )
		m.retbuf = SUBSTR(m.retbuf,AT(CHR(0),m.retbuf)+1)
	ENDDO ( CHR(0) $ m.retbuf )
	
	* Fill in the second and third columns of the device array with the parameters
	* of each installed device from the [devices] section (column 2) and the
	* [PrinterPorts] section (column 3).
	FOR m.j = 1 TO m.dcount
		retbuf = REPLICATE(CHR(0),256)
		m.bytes = getprostrg("devices",DEVICE[m.j,1],CHR(0),@m.retbuf,256)
		m.retbuf = LEFT(m.retbuf,m.bytes)
		DEVICE[m.j,2] = m.retbuf
		
		retbuf = REPLICATE(CHR(0),256)
		m.bytes = getprostrg("PrinterPorts",DEVICE[m.j,1],CHR(0),@m.retbuf,256)
		m.retbuf = LEFT(m.retbuf,m.bytes)
		DEVICE[m.j,3] = m.retbuf
	ENDFOR ( m.j )
	
	* Store the number of installed devices
	m.number = m.dcount
	
	* Now get the default printer
	retbuf = REPLICATE(CHR(0),256)
	m.bytes = getprostrg("windows","device",CHR(0),@m.retbuf,256)
	m.retbuf = LEFT(m.retbuf,m.bytes)
	m.dfltprnt = m.retbuf
	
	SET TALK &lcOldTalk
	
*!*****************************************************************************
*!
*!       Function: GETPROSTRG
*!
*!      Called by: GETPRINT           (procedure in PRNARRAY.PRG)
*!
*!          Calls: REGFN()            (function  in ?)
*!               : CALLFN()           (function  in ?)
*!
*!*****************************************************************************
FUNCTION getprostrg
	PARAMETER SECTION, entry, dflt, buffer, blen
	fn = regfn("GETPROFILESTRING","CCC@CI","I")
	RETURN callfn(fn,SECTION,entry,dflt,@buffer,blen)
	
*: EOF: PRNARRAY.PRG
