*:*********************************************************************
*:        Program: WINFIND.PRG
*:	     Language: FoxPro V98
*:         System: Find that Window and Mouse click Locator
*:         Author: Bill Bates
*:  Last modified: 11/16/89      1:23
*:  Procs & Fncts: MKLIST()
*:               : STAT
*:      Documented 11/16/89 at 01:28               FoxDoc  version 1.2
*:*********************************************************************
* suppose four windows
* Window names stored in an array
SET TALK OFF
SET DISPLAY TO EGA43
CLEAR ALL
CLEAR
CLEAR WINDOW
**

DEFINE WINDOW statuswin FROM 35,2 TO 40,78            && my status window
HIDE WINDOW statuswin
**
**
windno = 4             				&& the number of windows to be defined below
DIMENSION winds(windno+1)   		&& array containing window names + 1
winds(1) = "foo1"
winds(2) = "foo2"
winds(3) = "foo3"
winds(4) = "foo4"
winds(5) = "foo4"       			&& contains the window on top
**
* Define the windows
DEFINE WINDOW &winds(1) FROM 2,1 TO 10,78  TITLE winds(1) FLOAT GROW ZOOM system COLOR SCHEME 8
DEFINE WINDOW &winds(2) FROM 5,5 TO 18,78 TITLE winds(2) FLOAT GROW ZOOM system COLOR SCHEME 8
DEFINE WINDOW &winds(3) FROM 9,10 TO 25,78 TITLE winds(3) FLOAT GROW ZOOM system COLOR SCHEME 8
DEFINE WINDOW &winds(4) FROM 8,1 TO 15,48 TITLE winds(4) FLOAT GROW ZOOM system COLOR SCHEME 8

***
wlist = mklist()   && get the current activation order reading the winds array
***
***
fp = .T.           				&& first pass
DO WHILE .T.
   ACTIVATE WINDOW &wlist      	&&activate the windows in correct order
   IF .NOT. fp
      DO STATUS                 && display stats (what window/row/col mouse clicked)
   ENDIF (.not. fp)
   fp = .F.
   kk=INKEY(999,'mh')      						&& event key
   IF kk=27
      CLEAR WINDOW
      EXIT
   ENDIF (kk=27)
   
   IF mrow() < 0  .OR. mcol()<0             	&& MOUSE SELECTED DIFF WINDOW THAN OLD TOP
      FOR J = windno-1 TO 1 STEP -1     		&& OK Search and rescue the clicked window
         test = winds(J)
         IF mrow(test) > 0  .AND. mcol(test) > 0   && is this the one
            EXIT
         ENDIF (mrow(test) > 0  .AND. mcol(test) > 0   && is this the one)
      ENDFOR
      IF  mrow(test) < 0 .OR. mcol(test) < 0    && OUT OF BOUNDS i CRY?
         DO STATUS
         WAIT 'out of bounds ' WINDOW
      ELSE
         * Now push the new pup on the window stack and remove previous references
         winds(windno+1) = test       			&& this is later pushed into winds(3)
         rep = .F.             					&& to replace leave false until new pup found
         FOR J=1 TO windno
            rep=  winds(J) = test .OR. rep
            IF rep             					&& once found start pushing
               winds(J) = winds(J+1)
            ENDIF (rep             				&& once found start pushing)
         ENDFOR
         * Create a new window activation list
         wlist = mklist()
      ENDIF (mrow(test) < 0 .OR. mcol(test) < 0    && OUT OF BOUNDS i CRY?)
   ENDIF (mrow() < 0  .OR. mcol()<0             	&& MOUSE SELECTED DIFF WINDOW THAN OLD TOP)
ENDDO (.T.)
RETURN
**
**
*!*********************************************************************
*!      Procedure: STAT
*!*********************************************************************
PROCEDURE STATUS
** Display what window got hit and where
PRIVATE awin, aa,bb
awin=WONTOP()
aa=STR(mrow(),2)
bb=STR(mcol(),2)
ACTIVATE WINDOW statuswin
? 'mouse at '+aa+','+bb+' window '+awin
ACTIVATE WINDOW &awin
RETURN

*!*********************************************************************
*!       Function: MKLIST()
*!*********************************************************************
PROCEDURE mklist
** Make a list reading the current activation array
PRIVATE tmplist
tmplist=''
FOR J=1 TO windno
   tmplist=tmplist+TRIM(winds(J))+','
ENDFOR
RETURN LEFT(tmplist,LEN(tmplist)-1)

*: EOF: WINFIND.PRG
