PAGE  61,130
; ....:PROGRAM  DBWIND. ASM  (Windows Without A Net)
; ....:by H. O. Koenig
; ....:April 17, 1987
; ....:version 1.1
;
; ....: A module to be loaded into dbase .prg files
; ....: Opens a window as large or as small as you please !
; .........: receives as parameters <S> & the top left and bottom right row/col
; .........: saves what's under the window and then clears the area. OR
; .........: if given <R> it restores what was trashed before.
;
; ....: Uses Some ROM BIOS routines - some hardware dependent
;
;	A Discourse on the Parameter: (These values are not necessarily
;                                      error-trapped, just recommended.)
;	Char 1: SsRr	Save (open window) or Restore (write from buffer)
;	Char 2: 1...24	Top Row
;	Char 3: 1...78  Left Column
;	Char 4: 2...25  Bottom Row
;	Char 5: 2...80  Right Column
;	Char 6: 1...255 Window Attribute
;	Char 7: 1...255 Border Attribute
;	----->> NOTE:  Because dBase freaks out at a CHR(0), the first of the
;		       256 possible attribute/color byte combinations is un-
;		       available - So, sue me!   Seriously, I regret this and
;		       will address the whole issue of attribute/color at a
;		       later date and version.  FOR NOW, IT'S UP TO YOU TO
;		       KEEP THE ATTRIBUTE BYTES REASONABLE <<< CAUTION !!!!!!
;	Char 8:1...5	Border Character Set
;		1. - Single Line
;		2. - Double Line
;		3. - Single Vertical/Double Horizontal
;		4. - Double Vertical/Single Horizontal
;		5 (or greater). - Use the following Character as the border character
;	Char 9:1...255	(OPTIONAL) The programmer selected character
;			to be used as a border character - any ASCII
;			plus IBM character is possible.  You don't want
;			a border? Use a space <chr(32)> with the same attri
;			-bute as the window attribute.....
;
;       Syntax Suggestions:
;         To OPEN a window on screen:
;           STORE "S"+chr(r1)+chr(c1)+chr(r2)+chr(c2) TO mparm
;           CALL Dbwind mparm
;
;         To CLOSE a window and rewrite what was under it:
;	    STORE "R" to mparm
;           CALL Dbwind with mparm
;====================================================================;
;            Catalogue of jobs in this program
;--------------------------------------------------------------------;
; READPARM		parses the parameter pointed to by BX
; LINSZNUM		checks size of window
; GETBORCH		Selects Border Characters
; GETVIDCH		ascertains video mode and page in memory
; SAVESCR		writes screen to memory buffer,saves cursor postion
; WINDDRAW              Draws window border
; RESTSCR		restores screen,cursor position
; VIDOFFS               calculates address in video meory 
; WRITSCR		writes from ES:SI to Vid Memory during retraces
;====================================================================
; ....: MACROS: Save, Restore, Ngonechk, Zgonechk
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
PUSHON	MACRO	R1,R2,R3,R4,R5,R6,R7,R8
; This macro takes a parameter list and pushes each parameter register,
; in the order given.
;
;	USAGE: SAVE AX,BX,CX....
;
		IRP	x,<R1,R2,R3,R4,R5,R6,R7,R8>
			IFNB <X>
				PUSH  X
			ENDIF
		ENDM
	ENDM
;-----------------------------------------------------------------------
POPOFF	MACRO	R1,R2,R3,R4,R5,R6,R7,R8
; This macro takes a parameter list and pushes each parameter register,
; in the order given.
;
;	USAGE: RESTORE AX,BX,CX....
;
		IRP	x,<R8,R7,R6,R5,R4,R3,R2,R1>
			IFNB <X>
				POP  X
			ENDIF
		ENDM
	ENDM
;-----------------------------------------------------------------------
NGONECHK	MACRO	R1,ONEGOAL,TWOGOAL
;	All this thing does is OR the parameter and
;	jmp to TWOGOAL if it is zero and ONEGOAL if it ain't.
;	kind of a IF(~NOT~ ZERO)THEN...,ELSE
;		Think of it as "Not-zero-Go-ONE CHecK"
;
;	USAGE:	NGONECHK dl,HOWBIG,FINISH
;
			or	r1,r1
			JNZ	ONEGOAL
			JMP	TWOGOAL
		ENDM
;-----------------------------------------------------------------------
ZGONECHK	MACRO	R1,ONEGOAL,TWOGOAL
;	All this thing does is OR the parameter and
;	jmp to TWOGOAL if it ain't zero and ONEGOAL if it is.
;	kind of a IF(ZERO)THEN...,ELSE
;		Think of it as "Zero-Go-ONE CHecK"
;
;	USAGE:	ZGONECHK dl,HOWBIG,FINISH
;
			or	r1,r1
			JZ	ONEGOAL
			JMP	TWOGOAL
		ENDM

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;  Labels for SYMDEB
; data labels
PUBLIC	ADAPTER, BOTROW, CURSPOS, ENABLVAL, IBMKEY, JOBTYPE
PUBLIC	LEFTCOL, LINEBYDF, LINEBYTE, LINEDIFF, LINEMID, LINENUM, LINESIZ
PUBLIC	MODEFLG, RIGHTCOL, SCREENBF, TOPROW, VIDOFFST, VIDPAGE, VIDSEG
PUBLIC  WINDATTR, BORDATTR, BORDCSET, BORDCHAR
;
PUBLIC  LTTPCRNR, VERLN, LTBMCRNR, HORLN, RTBMCRNR, RTTPCRNR
PUBLIC  SLTTPCRNR, SVERLN, SLTBMCRNR, SHORLN, SRTBMCRNR, SRTTPCRNR
PUBLIC  SDLTTPCRNR, SDVERLN, SDLTBMCRNR, SDHORLN, SDRTBMCRNR, SDRTTPCRNR
PUBLIC  DSLTTPCRNR, DSVERLN, DSLTBMCRNR, DSHORLN, DSRTBMCRNR, DSRTTPCRNR
; code labels
PUBLIC	DOIT, FINISH, GOHAID, HOWBIG, LNSZGOOF, LNSZEXIT, MAIN
PUBLIC	NEXT, OPENMAIN, RCHCK, RDPMGOOF, RDPMEXIT, RESTORE1, RESTORE2
PUBLIC	RESTORIT, RESTSCR, SAVE1, SAVEIT, STASHR, STASHS
PUBLIC	SCR1, SCR2, WHATELSE, WHATMODE, WTMDEXIT, WSCR1, WSCR2, WSCR3
PUBLIC  GBOR1, GBOR2, GBOR3, GBOR4, GBOREXIT, GBORFILL
PUBLIC  TOPLN, MIDLN, BOTLN, RSKIP, SSKIP, WSKIP
; routine labels
PUBLIC	GETBORCH, GETVIDCH, GITBACK, LINSZNUM
PUBLIC	READPARM, SAVESCR, VIDOFFS, WINDDRAW, WINDER, WRITSCR
;
;
TITLE	DBWIND.BIN
;
PROG	SEGMENT BYTE PUBLIC 'PROG'
	ASSUME  CS:Prog, DS:Prog, ES:Prog;, SS:Prog
;
WINDER	PROC	FAR
MAIN:	JMP  DOIT
;
; --------------- various bytes and words ---------------
notice		db  'dbWIND'	; authorship notice
notice1		db  ' 1987 by Harold O. Koenig. '
notice2		db  ' of Clerical Services, Inc.'
notice3		db  ' Scottsville, VA 24590'
notice4		db  ' released to Public Domain'

;---------------- Parameter slots
 jobtype		db  '?'
toprow		db  '?'	
leftcol		db  '?'	
botrow		db  '?'
rightcol	db  '?'
windattr	db  '?'		; text attribute (default normal)
bordattr	db  '?'		; border attribute (default inverse)
bordcset	db  '?'		; what type of border
bordchar	db  '?'		; what border character
;
IBMkey		db  'IBM'	; EGA BIOS marker
adapter		db  0		; 0=MGA, 1 = CGA, 2 = EGA
modeflg		db  7		; mode holder flag, assuming monochrome
vidpage		db  '?'		; current video page
vidseg		dw  0B000H	; default video segemnt (monochrome)
vidoffst	dw  '?'		; video offset holder
linenum		db  '?'		; number of lines in window
linesiz		db  '?'		; length in characters of line
linemid		dw  '?'		; line length minus edges (WORD! for 
				;    loop control . . .
linediff	dw  '?'		; width of screen minus line length
linebyte	dw  '?'		; bytes per line
linebydf	dw  '?'		; bytes per line leftovers
;
curspos		dw  '?'		; cursor position holder
enablval	db  2CH,28H,2DH,29H	; Values to enable CGA display
		db  2AH, 2EH,1EH
;--------------------------------------------------------------------;
; 	- graphics characters - double-line is default
;The Scheme is:
; The window opener refers to the top six variables in this list.
; To avoid the proliferation of window drawing routines, the GETBORCH
;  routine checks what the border specifications are and
;  either:
;     moves another set of boxdrawing characters into the variables
;     or fills the variables with the programmer's selected character
;        (for -no border- the programmer could send a chr(32))
;--------------------------------------------------------------------;
; -			- slots for box characters -
lttpcrnr	db  201		; double left top corner
verln		db  186		; double vertical line
ltbmcrnr	db  200		; double left bottom corner
horln		db  205		; double horizontal line
rtbmcrnr	db  188		; double right bottom corner
rttpcrnr	db  187		; double right top corner
; -			- double line -
dlttpcrnr	db  201		; double left top corner
dverln		db  186		; double vertical line
dltbmcrnr	db  200		; double left bottom corner
dhorln		db  205		; double horizontal line
drtbmcrnr	db  188		; double right bottom corner
drttpcrnr	db  187		; double right top corner
; -                     - single-line -
slttpcrnr	db  218		; single left top corner
sverln		db  179		; single vertical line
sltbmcrnr	db  192		; single left bottom corner
shorln		db  196		; single horizontal line
srtbmcrnr	db  217		; single right bottom corner
srttpcrnr	db  191		; single right top corner
; -                     - single-ver/double-hor -
sdlttpcrnr	db  213		; single/ver left top corner
sdverln		db  179		; single vertical line
sdltbmcrnr	db  212		; single/ver left bottom corner
sdhorln		db  205		; double horizontal line
sdrtbmcrnr	db  190		; single/ver right bottom corner
sdrttpcrnr	db  184		; single/ver right top corner
; -                     - Double-ver/Single-hor -
dslttpcrnr	db  214		; double/ver left top corner
dsverln		db  186		; double vertical line
dsltbmcrnr	db  211		; double/ver left bottom corner
dshorln		db  196		; single horizontal line
dsrtbmcrnr	db  189		; double/ver right bottom corner
dsrttpcrnr	db  183		; double/ver right top corner
blank		db  ' '
;
screenbf	dw  2000 dup('?')	; windmax = 80 char * 25 lines = 2000
;==================== This is the Program Right Here ========================
DOIT:					; Save everything in sight!	     
	PUSHON  AX,BX,CX,DX,DS,SI,DI,SS	; Macro pusher
NEXT:
	CALL  ReadParm			; read [BX] and Store what you find
	ZGONECHK  DL,RChck,Finish	; Any goofs?
RCHCK:
	ZGONECHK  DH,HowBig,GitBack	; Was 'R' passed as parameter?
HOWBIG:
	CALL	LinSzNum		; if not,figure out size of window
	ZGONECHK  DL,GoHaid,Finish	; check for errors
GOHAID:
	CALL	GetBorCh		; Select Border characters.
	CALL	GetVidCh		; get video mode and page number
	CALL	VidOffs			; get video addresses
; - - - - - - - Save what underlies the window then open window - - - - - - 
SAVEIT:
	CALL  SaveScr			; just save the screen.
	CALL  WindDraw			; Write the Box to Video memory
	JMP Finish
;
;---Here's where you go if it's a restore call! - - - - - - - - - - - - - -
GITBACK:
;--------------------------------------------------------------------;
;  Presumably, you only come to GITBACK if you have already opened   ;
;  a window.  -- TO open a window, you have to establish video mode, ;
;  video segment, and the rest of it....                             ;
;  But for GITBACK a lot of this info is already stored in variables ;
;--------------------------------------------------------------------;

; - - - - - -  Close the window and Restore what was there before  - - - - 
;
RESTORIT:
	CALL  RestScr
FINISH:
	POPOFF  AX,BX,CX,DX,DS,SI,DI,SS	; Macro popper
	RET
;**************
WINDER	ENDP	
;============== This is the END OF the Program Right Here ================
; - now come all the (not so) little sub-routines -
;
;--------------------------------------------------------------------;
;	READPARM                                                     ;
; reads [BX] and stores what it finds there                          ;
;     Uses Al exclusively (almost) but                               ;
;     Leaves DH  set if Job is a restore                             ;
;            DH  reset if job is a save                              ;
;     Leaves DL set if an error has occurred                         ;
;            DL is reset if all is copacetic                         ;
;                                                                    ;
;	1 - Jobtype,R or S	2 - TopRow                           ;
;	3 - LeftCol		4 - BottomRow                        ;
;       5 - RightCol		6 - BorderAttribute                  ;
;	7 - Window Attribute	8 - BorderCharacterSet               ;
;       9 - BorderCharacter (optional)                               ;
;--------------------------------------------------------------------;
;************dropped BX from pushes and pops
READPARM	PROC	NEAR
	PUSHON  ax
	xor  dx,dx			; clear error flag
	mov  al,Byte Ptr [bx]		; first parameter is job type.
	and  al,05Fh			; make it capital.
	mov  Byte Ptr CS:jobtype,al	; store job type.
	cmp  al,'R'			; is it one
	JE  STASHR			; of the two
	cmp  al,'S'			; acceptable letters?
	JE  STASHS			; if so save it and continue,
	JMP  RDPMGOOF			; otherwise there's a boo-boo.
STASHR:	inc  dh				; Set DH
	JMP  RDPMEXIT			; git outta here
;
;--------------------------------------------------------------------;
; Get corners from BX:0000 to 'variable' slots
;        We subtract 1 from each parameter because dBase freaks out
;          if asked to deal with a chr(0) 
; Get attributes, Border Character Set, and, maybe, border character.
;--------------------------------------------------------------------;
STASHS:
	mov  al,Byte Ptr [bx+1]		; get top row
	sub  al,1
	mov  Byte Ptr CS:toprow,al	
	mov  al,Byte Ptr [bx+2]		; get left column
	sub  al,1
	mov  Byte Ptr CS:leftcol,al
	mov  al,Byte Ptr [bx+3]		; get bottom row
	sub  al,1
	mov  Byte Ptr CS:botrow,al
	mov  al,Byte Ptr [bx+4]		; get right column
	sub  al,1
	mov  Byte Ptr CS:rightcol,al
	mov  al,Byte Ptr [bx+5]         ; get window attribute
	mov  Byte Ptr CS:windattr,al	
	mov  al,Byte Ptr [bx+6]         ; get border attribute
	mov  Byte Ptr CS:bordattr,al
	mov  al,Byte Ptr [bx+7]         ; get border character set
	mov  Byte Ptr CS:bordcset,al
	mov  al,Byte Ptr [bx+8]		; get border character
	mov  Byte Ptr CS:bordchar,al
	JMP	RDPMEXIT
RDPMGOOF:
	inc	dl			; set error flag	
RDPMEXIT:
	POPOFF  ax
	RET
READPARM	ENDP
;
;--------------------------------------------------------------------;
;             Line Size and Number  (linsznum)                       ;
;              Assures that window parameters are                    ;
;               within range AND                                     ;
;              Stores line length and size in variables              ;
;              Sets DL if error in window size                       ;
;--------------------------------------------------------------------;
LINSZNUM	PROC	NEAR
	PUSHON	ax,bx,cx
	xor  dl,dl			; clear dl for error flag
	mov  al,Byte Ptr CS:botrow	; bigger number in al
	mov  bl,Byte Ptr CS:toprow	; if bottom row not
	sub  al,bl			; greater than top then
	JNG  LNSZGOOF  			; there's an error - and...
	cmp  al,24			; gotta be less than 26
	JG  LNSZGOOF
	cmp  al,1			; and more than 1
	JLE  LNSZGOOF
	inc  al
	mov  Byte Ptr CS:linenum,al	; otherwise, store this number
	mov  al,Byte Ptr CS:rightcol	; get the columns
	mov  bl,Byte Ptr CS:leftcol
	sub  al,bl			; if left is bigger than right
	JNG  LNSZGOOF  			; it was a mistake, besides..
	cmp  al,79			; gotta be less than 81
	JG  LNSZGOOF
	cmp  al,1			; and more than 1
	JLE  LNSZGOOF
        inc  al
	mov  Byte Ptr CS:linesiz,al	; otherwise save this, too
	PUSH  ax
	sub  al,2			; calculate linewidth 
	xor  ah,ah
	mov  Word Ptr CS:linemid,ax 	; minus edges...
	POP  ax
	mov  cl,80			; get line length in cl
	sub  cl,al			; line left overs
	xor  ch,ch			; byte to word in CX
	mov  Word Ptr CS:linediff,cx	; store this too
	shl  cl,1			; bytes left over
	mov  Word Ptr CS:linebydf,cx	; line difference in bytes
	shl  al,1			; get bytes per line (size * 2)
	xor  ah,ah
	mov  Word Ptr CS:linebyte,ax	; and store that
	JMP  LNSZEXIT
LNSZGOOF:
	mov  dl,1			;if error, then set flag in dl
LNSZEXIT:
	POPOFF  ax,bx,cx
	RET
LINSZNUM	ENDP
;-------------END of Routine to Figure some parameters
;
;--------------------------------------------------------------------;
;            GETBORCH                                                ;
;     Routine to Select Characters for Border                        ;
;--------------------------------------------------------------------;
GETBORCH	PROC	NEAR
	PUSHON  AX,CX,DX,DS,ES,DI,SI,BP
	push  cs			; Make sure the little pointers 
	push  cs			; are all pointing at the same thing.
	pop  ds
	pop  es
;
	Mov  Al, Byte Ptr CS:BordCSet	; Get the selection
		;whatever happens, we're going to do it six times....
	Mov  cx,6			; number of characters
		; and we're going to aim at the Left Top Corner slot ...
	mov  di, offset cs:lttpcrnr	; now destination is set up
;
	Cmp  al,5			; Do they want their own character?
	JL  GBOR1			; if > = 5, they do. otherwise, jump
	mov  al,Byte Ptr CS:Bordchar	; point at the chosen character
	rep  stosb			; move it to the variables
	JMP  GBOREXIT			; and exit
;
GBOR1: 
	cmp  al,1			; They want single?
        JNZ  GBOR2
	mov  si, offset slttpcrnr
	JMP  GBORFILL			; and quit
GBOR2:  CMP  al,2			; do they want double lines?
	JNZ  GBOR3			; 
	mov  si, offset dlttpcrnr
	JMP  GBORFILL			; 
;
GBOR3:	CMP  al,3			; they want Single Vert
	JNZ  GBOR4			; double hor?
	mov  si, offset sdlttpcrnr
	JMP  GBORFILL			; and quit
;
GBOR4:					; if it gets here, double vert-
	mov  si, offset dslttpcrnr	; and single hor
GBORFILL:
	rep  movsb			; move it
GBOREXIT:
	POPOFF  AX,CX,DX,DS,ES,DI,SI,BP
	RET
GETBORCH	ENDP
;-------------END of Routine to Get border character
;
;--------------------------------------------------------------------;
;-------------Routine to Get Video Characteristics                   ;
;            GETVIDCH  - uses int 10h function 15 to                 ;
;        ascertain video page and mode, etc.                         ;
;--------------------------------------------------------------------;
GETVIDCH	PROC	NEAR
	PUSHON	AX,BX
	xor  ax,ax			; set up for DOS call
	mov  ah,15			; to get mode and page
	int  10H			; do it
	mov  Byte Ptr CS:modeflg,al	; store results
	mov  Byte Ptr CS:vidpage,bh
WHATMODE:
	cmp  al,7			; is the mode monochrome?
	JE   WHATELSE			; if so, skip following
	mov  Word Ptr CS:vidseg,0B800h	; else,if CGA then goose vid address
	mov  Byte Ptr CS:adapter,1	; and set adapter flag
WHATELSE:				; (default vidseg was B000H)
				;checking for EGA
	mov  ax,0C000h			; point ES at EGA Bios segment
	mov  es,ax
	mov  di,1Eh			; point DI where signature is
	lea  si,CS:IBMKEY		; point SI at string
	mov  cx,3			; three letters to look for
	cld				; go the right way
	repe cmpsb			; check those suckers
	JNE  WTMDEXIT			; if not equal, go on
	mov  Byte Ptr CS:adapter,2	; adapter = 2 if EGA
WTMDEXIT:
	POPOFF  AX,BX
	RET
GETVIDCH	ENDP
;-------------END of Routine to Get Video Characteristics
;
;--------------------------------------------------------------------;
;                 VIDOFFS - calculates address in video memory       ;
;             Routine to calculate VIDeo OFFSet                      ;
;             Puts Value in variable 'vidoffst'                      ;
;--------------------------------------------------------------------;
VIDOFFS	PROC	NEAR
	PUSHON	AX,BX,DX,DI
	mov  dh, Byte Ptr CS:toprow
	mov  dl, Byte Ptr CS:leftcol
	xor  bh,bh			; clear out top byte
	mov  bl, Byte Ptr CS:vidpage	; so we can use number of pages
	xor  ah,ah			; clean out top byte
	mov  al,160			; 80 char/line * 2 bytes/char
	mul  dh				; gets us to the row
	shl  dl,1			; # of cols times 2
	xor  dh,dh			; clear out top byte
	add  ax,dx			; so we can add to ax
	mov  di,ax			; and move to destination index
	mov  ax,1000h			; a video page = 4000 and change
	mul  bx				; times the number of pages
	add  di,ax			; total address
	mov  Word PTR CS:vidoffst,di	; hold it
	POPOFF  AX,BX,DX,DI
	RET
VIDOFFS	ENDP
;-------------END of Routine to calculate VIDeo OFFSet
;
;-------------Routine to Save Screen to memory
;--------------------------------------------------------------------;
;                 SAVESCR - saves what's under coming window         ;
;                 On Entry                                           ;
;                  ES:DI  has address of storage buffer             ;
;                  IF CGA is not disabled, you gonna get snow!       ;
;                  You need to know the video offset                 ;
;                 video segment set by Getvidch                      ;
;--------------------------------------------------------------------;
SAVESCR	PROC	NEAR
	push	cs
	pop	es
	mov  di,OFFSET screenbf		; aim at buffer
; Find and save cursor position
	mov  ah,3			; funct. 3 reads cursor postion
	int  10h			; get row into DH, col into DL
	mov  Word Ptr CS:curspos,dx	; store it
	push  di			; save dest index, make room 
	mov  di,Word Ptr CS:vidoffst	; for starting address in DI.
; Let SI point to video and DI to buffer
	mov  si,di			; move it to Source Index
	pop  di				; and get destination back
	push  ds			; save ds
	mov  ds,WORD Ptr CS:vidseg	; aim DS at video memory
; Set up outer loop (number of lines)
	xor  ch,ch
	mov  cl,Byte Ptr CS:linenum	; how many times to do this?
	cld				; FROM (S)ource TO (D)est.
	mov  dx,3DAh			; DX points at Status Register
Save1:	push  cx			; save counter
; inner loop
	xor  ch,ch
	mov  cl,Byte Ptr CS:linesiz	; counter for line length
	cmp  CS:adapter,1		; is this a CGA?
	JNZ  SSKIP			; if not, take a shortcut!
; - - - - - - - - - - - - - - - - - - - - - - - - - -
;	Sub-Routine to read memory during retraces only
; - - - - - - - - - - - - - - - - - - - - - - - - - -
SCR1:	in  AL, DX			; Get status
	rcr  AL,1			; If retracing, sets carry flag
	JB  SCR1			; wait for no retrace
	cli				; Hold the interrupts!
SCR2:	in  Al, DX			; Get status
	rcr AL,1			; as above
	JNB  SCR2			; Waiting for retrace for safe read
sskip:	lodsw				; gets word into AX
	sti				; enable interrupts
	stosw				; from AX to Destination
	LOOP SCR1			; Do it for next word

; end of inner loop
;
	add  si,Word Ptr CS:linebydf	; point at next line
	pop  cx				; get counter
	LOOP  SAVE1			; do it agin!
; end of outer loop
;
	pop  ds				; restore ds
	RET
SAVESCR	ENDP
;-------------END of Routine to Save screen to memory
;
;--------------------------------------------------------------------;
;	WRITSCR writes from DS:SI to ES:DI during retraces           ;
;       Expects Source and destination to be established             ;
;       uses AX,DX, and BP                                           ;
;          AH has attribute pointed at by ES:SI                      ;
;          AL has character                                          ;
;--------------------------------------------------------------------;
WRITSCR	PROC	NEAR
	push	BX
	mov  dx, 3DAH		; point at status register
WSCR1:	lodsb			; get a byte from ES:SI
			; now AX has attribute and character
	cmp  CS:adapter,1	; is this CGA?
	jnz wskip		; if not, take a shortcut
	mov  bx,ax		; park it in BX
	mov  AH,1001b		; bits number 3 and 0 signal retraces
				;  so this will mask for them
WSCR2:	in  al, dx		; read status
	rcr  al, 1		; if bit zero is set, this sets carry flag
	JB  WSCR2		; wait for no retrace
	CLI			; if no retrace, hold the interrupts!
WSCR3:  In  al,dx		; check status again
	and  al,ah		; anything set?
	JZ  WSCR3		; wait till something is set.
	mov  ax,bx		; get the word back from BX
wskip:	STOSW			; send it to destination (video memory)
	STI			; enable interrupts
	POP    BX
	RET
WRITSCR	ENDP
;-------------END of Routine to write to video memory
;
;--------------------------------------------------------------------;
;     WINDDRAW                                                       ;
;             Routine to open Window  - is a mess                    ;
;                                                                    ;
;                  ES:DI points at exact spot in video memory        ;  
;--------------------------------------------------------------------;
WINDDRAW	PROC	NEAR
	PUSHON	AX,ES, DS, DI
	push  cs
	pop  ds
	mov  es,Word Ptr CS:vidseg		
	mov  di,Word Ptr CS:vidoffst
	cld
;--Write top line border to screen memory--
	mov  si,offset CS:lttpcrnr		; point at left top corner
	mov  ah,Byte Ptr CS:bordattr		; get border attribute
	CALL  WRITSCR				; move it!
	mov  cx,Word Ptr CS:linemid		; figure top line
TOPLN:
	mov si,offset CS:horln			; horizontal line character
	CALL  WRITSCR				; move it!
	LOOP TOPLN
	mov  si, offset CS:rttpcrnr		; get right top corner
	CALL  WRITSCR				; move it!
;
;------------- do body of window
;
	add  di,Word Ptr CS:linebydf		; GET TO NEXT LINE
	mov  cl,Byte Ptr CS:linenum		; get number of lines
	sub  cl,2				; less top and bottom lines
	xor  ch,ch				; byte to word in CX
OPENMAIN:
	PUSH  cx				; save it
	mov  si,offset CS:verln			; do left side
	CALL  WRITSCR				; move it!
	mov  ah,Byte Ptr CS:windattr		; window attribute
	mov  cx,Word Ptr CS:linemid		; get line width
midln:
	mov  si, offset CS:blank		; blank character
	CALL  WRITSCR				; move it!
	LOOP  MIDLN
;
	mov si, offset CS:verln			; right side
	mov  ah,Byte Ptr CS:bordattr		; in border attribute
	CALL  WRITSCR				; move it!
	add  di,Word Ptr CS:linebydf		; point at next line
	POP  cx					; retrieve counter
	loop  OPENMAIN
;
; -----do bottom
;
	mov  si,offset CS:ltbmcrnr	; get left bottom corner
	CALL  WRITSCR			; move it!
;
	mov  cx,Word Ptr CS:linemid
BOTLN:
	mov  si, offset CS:horln	; horizontal line character
	CALL  WRITSCR			; move it!
	LOOP  BOTLN
;
	mov  si,offset CS:rtbmcrnr	; get right bottom corner
	CALL  WRITSCR			; move it!
	POPOFF  AX, ES, DS, DI
	RET
WINDDRAW	ENDP
;-------------END of Routine to Draw Window
;
;--------------------------------------------------------------------;
;        RESTSCR restores screen from memory                         ;
;-------------Routine to Restore Screen from memory                  ;
;                                                                    ;
;                                                                    ;
;--------------------------------------------------------------------;
RESTSCR	PROC	NEAR
	push  cs
	pop  ds
	mov  si,OFFSET screenbf		; aim from buffer
	mov  di,Word Ptr CS:vidoffst
	push  es
	mov  es,Word Ptr CS:vidseg
	mov  cl,Byte Ptr CS:linenum
	xor  ch,ch			; byte to word
	cld
	push  BX
restore1:
	push	cx			; save line counter
	mov  dx, 3DAh
	xor	ch,ch			; byte in CL to word in CX
	mov	cl,Byte Ptr CS:linesiz	; words per line
restore2:
rscr1:	Lodsw
	cmp  CS:adapter,1		; is this a CGA?
        jnz  rskip			; if not, then just write the sucker!
	mov  bx,ax
	mov  ah,1001b
rscr2:  in  al,dx
	rcr  al,1
	JB  RSCR2
	CLI				; hold the interrupts	
rscr3:  in  al,dx
	and  al,ah
	JZ  RSCR3
	mov  ax,bx
rskip:	STOSW
	STI
	LOOP  RESTORE2
	add	di,Word Ptr CS:linebydf ; point at next line
	pop	cx
	LOOP	RESTORE1
	pop   BX
	pop  es
;Get cursor back where it was
	mov	dx,Word Ptr CS:curspos	; get info back
	xor	al,al
	mov	bh,Byte Ptr CS:vidpage
	mov	ah,2
	int	10H
	RET
RESTSCR	ENDP
;-------------END of Routine to Restore screen from memory
; Fun, huh?
PROG	ENDS
END	MAIN
